/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.wizards;

import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.SelectTracesOperation;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfNavigatorContentProvider;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfNavigatorLabelProvider;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.wizards.Messages;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class SelectTracesWizardPage
extends WizardPage {
    private final TmfProjectElement fProject;
    private final @NonNull TmfExperimentElement fExperiment;
    private @NonNull Map<String, TmfTraceElement> fPreviousTraces;
    private CheckboxTreeViewer fCheckboxTreeViewer;
    private TmfNavigatorContentProvider fContentProvider;
    private TmfNavigatorLabelProvider fLabelProvider;
    private Button fTimeRangeSelectionButton;
    private Text fStartTimeRange;
    private Text fEndTimeRange;
    private ITmfTimestamp fStartTimestamp;
    private ITmfTimestamp fEndTimestamp;
    private static final TmfTimestampFormat TIMESTAMP_FORMAT = new TmfTimestampFormat("yyyy-MM-dd HH:mm:ss.SSS SSS SSS");
    private static final int COLUMN_WIDTH = 200;
    private static final int BUTTON_SPACING = 4;

    protected SelectTracesWizardPage(TmfProjectElement project, @NonNull TmfExperimentElement experiment) {
        super("");
        this.setTitle(Messages.SelectTracesWizardPage_WindowTitle);
        this.setDescription(Messages.SelectTracesWizardPage_Description);
        this.fProject = project;
        this.fExperiment = experiment;
        this.fPreviousTraces = new HashMap<String, TmfTraceElement>();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)container);
        new FilteredTree(container, 2818, new PatternFilter(), true){

            protected TreeViewer doCreateTreeViewer(Composite aparent, int style) {
                return SelectTracesWizardPage.this.doCreateTreeViewer(aparent);
            }
        };
        Composite buttonComposite = new Composite(container, 0);
        FillLayout layout = new FillLayout(512);
        layout.spacing = 4;
        buttonComposite.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        buttonComposite.setLayoutData((Object)gd);
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setText(org.eclipse.tracecompass.internal.tmf.ui.project.dialogs.Messages.Dialog_SelectAll);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectTracesWizardPage.this.setAllChecked(true);
            }
        });
        Button deselectAllButton = new Button(buttonComposite, 8);
        deselectAllButton.setText(org.eclipse.tracecompass.internal.tmf.ui.project.dialogs.Messages.Dialog_DeselectAll);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectTracesWizardPage.this.setAllChecked(false);
            }
        });
        this.createTimeRangeSelection(container);
    }

    private void createTimeRangeSelection(Composite parent) {
        Composite timeRangeSelectionComposite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(2, false);
        compositeLayout.marginWidth = 0;
        timeRangeSelectionComposite.setLayout((Layout)compositeLayout);
        timeRangeSelectionComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fTimeRangeSelectionButton = new Button(timeRangeSelectionComposite, 32);
        this.fTimeRangeSelectionButton.setText(String.valueOf(Messages.SelectTracesWizardPage_TimeRangeOptionButton) + " (" + TIMESTAMP_FORMAT.toPattern() + ")");
        this.fTimeRangeSelectionButton.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        final Label startTimeLabel = new Label(timeRangeSelectionComposite, 0);
        startTimeLabel.setText(Messages.SelectTracesWizardPage_StartTime);
        startTimeLabel.setEnabled(false);
        this.fStartTimeRange = new Text(timeRangeSelectionComposite, 2048);
        this.fStartTimeRange.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fStartTimeRange.setEnabled(false);
        final Label endTimeLabel = new Label(timeRangeSelectionComposite, 0);
        endTimeLabel.setText(Messages.SelectTracesWizardPage_EndTime);
        endTimeLabel.setEnabled(false);
        this.fEndTimeRange = new Text(timeRangeSelectionComposite, 2048);
        this.fEndTimeRange.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fEndTimeRange.setEnabled(false);
        this.fTimeRangeSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                startTimeLabel.setEnabled(SelectTracesWizardPage.this.fTimeRangeSelectionButton.getSelection());
                SelectTracesWizardPage.this.fStartTimeRange.setEnabled(SelectTracesWizardPage.this.fTimeRangeSelectionButton.getSelection());
                endTimeLabel.setEnabled(SelectTracesWizardPage.this.fTimeRangeSelectionButton.getSelection());
                SelectTracesWizardPage.this.fEndTimeRange.setEnabled(SelectTracesWizardPage.this.fTimeRangeSelectionButton.getSelection());
            }
        });
        FocusListener focusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                SelectTracesWizardPage.this.validateTimeRange();
            }

            public void focusGained(FocusEvent e) {
                SelectTracesWizardPage.this.setErrorMessage(null);
                SelectTracesWizardPage.this.setPageComplete(true);
            }
        };
        this.fStartTimeRange.addFocusListener(focusListener);
        this.fEndTimeRange.addFocusListener(focusListener);
    }

    private TreeViewer doCreateTreeViewer(Composite parent) {
        this.fCheckboxTreeViewer = new CheckboxTreeViewer(parent, 2048);
        this.fContentProvider = new TmfNavigatorContentProvider(){

            @Override
            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            @Override
            public synchronized Object[] getChildren(Object parentElement) {
                if (parentElement instanceof TmfTraceFolder) {
                    Object[] children = super.getChildren(parentElement);
                    ArrayList<TmfProjectModelElement> filteredChildren = new ArrayList<TmfProjectModelElement>();
                    Object[] objectArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        if (child instanceof TmfTraceElement) {
                            TmfTraceElement traceElement = (TmfTraceElement)child;
                            String traceType = traceElement.getTraceType();
                            if (traceType != null && TmfTraceType.getTraceType((String)traceType) != null) {
                                filteredChildren.add(traceElement);
                            }
                        } else if (child instanceof TmfTraceFolder) {
                            filteredChildren.add((TmfTraceFolder)child);
                        }
                        ++n2;
                    }
                    return filteredChildren.toArray();
                }
                return null;
            }

            @Override
            public boolean hasChildren(Object element) {
                Object[] children = this.getChildren(element);
                return children != null && children.length > 0;
            }
        };
        this.fCheckboxTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fLabelProvider = new TmfNavigatorLabelProvider();
        this.fCheckboxTreeViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fCheckboxTreeViewer.setComparator(new ViewerComparator());
        Tree tree = this.fCheckboxTreeViewer.getTree();
        GridData gd = new GridData(4, 4, true, true);
        tree.setLayoutData((Object)gd);
        tree.setHeaderVisible(true);
        TreeViewerColumn column = new TreeViewerColumn((TreeViewer)this.fCheckboxTreeViewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setText(Messages.SelectTracesWizardPage_TraceColumnHeader);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return SelectTracesWizardPage.this.fLabelProvider.getText(element);
            }

            public Image getImage(Object element) {
                return SelectTracesWizardPage.this.fLabelProvider.getImage(element);
            }
        });
        this.fPreviousTraces.clear();
        for (ITmfProjectModelElement child : this.fExperiment.getChildren()) {
            if (!(child instanceof TmfTraceElement)) continue;
            TmfTraceElement trace = (TmfTraceElement)child;
            String name = trace.getElementPath();
            this.fPreviousTraces.put(name, trace);
        }
        Set<String> keys = this.fPreviousTraces.keySet();
        TmfTraceFolder traceFolder = this.fProject.getTracesFolder();
        this.fCheckboxTreeViewer.setInput((Object)traceFolder);
        this.setCheckedAlreadyIncludedTraces(keys, this.fContentProvider.getElements(this.fCheckboxTreeViewer.getInput()));
        this.fCheckboxTreeViewer.addCheckStateListener(event -> {
            Object element = event.getElement();
            this.setSubtreeChecked(element, event.getChecked());
            this.maintainCheckIntegrity(element);
        });
        this.fCheckboxTreeViewer.setUseHashlookup(true);
        return this.fCheckboxTreeViewer;
    }

    private void maintainCheckIntegrity(Object element) {
        Object parentElement = this.fContentProvider.getParent(element);
        boolean allChecked = true;
        boolean oneChecked = false;
        boolean oneGrayed = false;
        if (parentElement != null) {
            if (this.fContentProvider.getChildren(parentElement) != null) {
                Object[] objectArray = this.fContentProvider.getChildren(parentElement);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    boolean checked = this.fCheckboxTreeViewer.getChecked(child);
                    oneChecked |= checked;
                    allChecked &= checked;
                    oneGrayed |= this.fCheckboxTreeViewer.getGrayed(child);
                    ++n2;
                }
            }
            if (oneGrayed || oneChecked && !allChecked) {
                this.fCheckboxTreeViewer.setGrayChecked(parentElement, true);
            } else {
                this.fCheckboxTreeViewer.setGrayed(parentElement, false);
                this.fCheckboxTreeViewer.setChecked(parentElement, allChecked);
            }
            this.maintainCheckIntegrity(parentElement);
        }
    }

    private void setCheckedAlreadyIncludedTraces(Set<String> alreadyIncludedTraces, Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] children;
            TmfTraceElement trace;
            String elementPath;
            Object element = objectArray[n2];
            if (element instanceof TmfTraceElement && alreadyIncludedTraces.contains(elementPath = (trace = (TmfTraceElement)element).getElementPath())) {
                this.fCheckboxTreeViewer.setChecked(element, true);
                this.maintainCheckIntegrity(element);
            }
            if ((children = this.fContentProvider.getChildren(element)) != null) {
                this.setCheckedAlreadyIncludedTraces(alreadyIncludedTraces, children);
            }
            ++n2;
        }
    }

    private void setAllChecked(boolean checked) {
        Object[] objectArray = this.fContentProvider.getChildren(this.fCheckboxTreeViewer.getInput());
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.setSubtreeChecked(element, checked);
            ++n2;
        }
    }

    private void setSubtreeChecked(Object element, boolean checked) {
        Object[] children;
        this.fCheckboxTreeViewer.setChecked(element, checked);
        if (checked) {
            this.fCheckboxTreeViewer.setGrayed(element, false);
        }
        if ((children = this.fContentProvider.getChildren(element)) != null) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.setSubtreeChecked(child, checked);
                ++n2;
            }
        }
    }

    public boolean performFinish() {
        final SelectTracesOperation operation = this.fTimeRangeSelectionButton.getSelection() && this.validateTimeRange() ? new SelectTracesOperation(this.fExperiment, this.getSelection(), this.fPreviousTraces, this.fStartTimestamp, this.fEndTimestamp) : new SelectTracesOperation(this.fExperiment, this.getSelection(), this.fPreviousTraces);
        IStatus status = Status.OK_STATUS;
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor pm) throws CoreException {
                            operation.run(pm);
                        }
                    };
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    try {
                        try {
                            workspace.run(workspaceRunnable, (ISchedulingRule)workspace.getRoot(), 1, monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            status = operation.getStatus();
        }
        catch (InvocationTargetException e) {
            status = new Status(4, "org.eclipse.tracecompass.tmf.ui", Messages.SelectTracesWizardPage_SelectionError, (Throwable)e);
        }
        catch (InterruptedException e) {
            status = Status.CANCEL_STATUS;
            Thread.currentThread().interrupt();
        }
        if (!status.isOK()) {
            if (status.getSeverity() == 8) {
                this.setMessage(Messages.SelectTracesWizardPage_SelectionOperationCancelled);
                this.setErrorMessage(null);
            } else {
                if (status.getException() != null) {
                    MessageDialog.open((int)1, (Shell)this.getContainer().getShell(), (String)Messages.SelectTracesWizardPage_InternalErrorTitle, (String)(String.valueOf(status.getMessage()) + ": " + status.getException()), (int)0x10000000);
                }
                this.setMessage(null);
                this.setErrorMessage(Messages.SelectTracesWizardPage_SelectionError);
            }
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean validateTimeRange() {
        boolean validTimeRange;
        boolean bl = validTimeRange = this.parseTimeRange() && this.fStartTimestamp.compareTo(this.fEndTimestamp) <= 0;
        if (validTimeRange) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(Messages.SelectTracesWizardPage_TimeRangeErrorMessage);
        }
        this.setPageComplete(validTimeRange);
        return validTimeRange;
    }

    private boolean parseTimeRange() {
        try {
            long startTimeValue = TIMESTAMP_FORMAT.parseValue(this.fStartTimeRange.getText());
            long endTimeValue = TIMESTAMP_FORMAT.parseValue(this.fEndTimeRange.getText());
            this.fStartTimestamp = TmfTimestamp.fromNanos((long)startTimeValue);
            this.fEndTimestamp = TmfTimestamp.fromNanos((long)endTimeValue);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    private @NonNull TmfTraceElement[] getSelection() {
        Object[] selection;
        ArrayList<TmfTraceElement> traces = new ArrayList<TmfTraceElement>();
        Object[] objectArray = selection = this.fCheckboxTreeViewer.getCheckedElements();
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object sel = objectArray[n2];
            if (sel instanceof TmfTraceElement) {
                traces.add((TmfTraceElement)sel);
            }
            ++n2;
        }
        return traces.toArray(new TmfTraceElement[0]);
    }
}

