/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.ui.swtbot.tests;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.internal.lttng2.ust.ui.views.memusage.UstMemoryUsageView;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.XYDataProviderBaseTest;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXAxisChartViewer;
import org.eclipse.ui.IViewPart;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.swtchart.Chart;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.LineStyle;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class MemoryUsageViewTest
extends XYDataProviderBaseTest {
    private static final int EXPECTED_NUM_SERIES = 4;
    private static final RGB RED = new RGB(255, 0, 0);
    private static final RGB GREEN_BLUE = new RGB(0, 255, 255);
    private static final RGB GREEN = new RGB(0, 255, 0);
    private static final RGB MAGENTA = new RGB(255, 0, 255);
    private static final @NonNull String TITLE = "Relative Kernel Memory Usage";
    private static final @NonNull String FIRST_SERIES_NAME = "memory:10611";
    private static final @NonNull String SECOND_SERIES_NAME = "memory:10618";
    private static final @NonNull String THIRD_SERIES_NAME = "memory:10604";
    private static final @NonNull String FOURTH_SERIES_NAME = "memory:10613";

    @Test
    public void testOpenMemoryUsage() {
        ISeries[] series;
        SWTBotView viewBot = fBot.viewById("org.eclipse.linuxtools.lttng2.ust.memoryusage");
        viewBot.setFocus();
        Matcher matcher = WidgetOfType.widgetOfType(Chart.class);
        Chart chart = (Chart)viewBot.bot().widget(matcher);
        this.checkAllEntries();
        fBot.waitUntil(ConditionHelpers.numberOfSeries((Chart)chart, (int)4));
        ISeriesSet seriesSet = chart.getSeriesSet();
        ISeries[] iSeriesArray = series = seriesSet.getSeries();
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries serie = iSeriesArray[n2];
            Assert.assertTrue((boolean)(serie instanceof ILineSeries));
            ++n2;
        }
    }

    @Test
    public void testMemoryUsage() {
        IViewPart viewPart = this.getSWTBotView().getViewReference().getView(true);
        Assert.assertTrue((boolean)(viewPart instanceof UstMemoryUsageView));
        TmfCommonXAxisChartViewer chartViewer = (TmfCommonXAxisChartViewer)MemoryUsageViewTest.getChartViewer((IViewPart)viewPart);
        Assert.assertNotNull((Object)chartViewer);
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        Chart chart = this.getChart();
        Assert.assertNotNull((Object)chart);
        this.checkAllEntries();
        SWTBotUtils.waitUntil(c -> c.getSeriesSet().getSeries().length > 3, (Object)chart, (String)"No data available");
        chartViewer.setNbPoints(50);
        SWTBotUtils.waitUntil(json -> this.isChartDataValid(chart, (String)json, new String[]{FIRST_SERIES_NAME, SECOND_SERIES_NAME, THIRD_SERIES_NAME, FOURTH_SERIES_NAME}), (Object)"resources/memory-res50.json", (String)"Chart data is not valid");
        this.verifyChartStyle();
    }

    private void verifyChartStyle() {
        this.verifySeriesStyle(FIRST_SERIES_NAME, ISeries.SeriesType.LINE, RED, LineStyle.SOLID, false);
        this.verifySeriesStyle(SECOND_SERIES_NAME, ISeries.SeriesType.LINE, MAGENTA, LineStyle.SOLID, false);
        this.verifySeriesStyle(THIRD_SERIES_NAME, ISeries.SeriesType.LINE, GREEN, LineStyle.SOLID, false);
        this.verifySeriesStyle(FOURTH_SERIES_NAME, ISeries.SeriesType.LINE, GREEN_BLUE, LineStyle.SOLID, false);
    }

    private void checkAllEntries() {
        SWTBot bot = this.getSWTBotView().bot();
        SWTBotUtils.waitUntil(b -> b.tree().visibleRowCount() == 5, (Object)bot, (String)("Incorrect number of tree entries, expected 5, was " + bot.tree().visibleRowCount()));
        SWTBotTreeItem[] sWTBotTreeItemArray = bot.tree().getAllItems();
        int n = sWTBotTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem entry = sWTBotTreeItemArray[n2];
            entry.check();
            ++n2;
        }
    }

    protected @NonNull String getMainSeriesName() {
        return FIRST_SERIES_NAME;
    }

    protected @NonNull String getTitle() {
        return TITLE;
    }

    protected String getViewID() {
        return "org.eclipse.linuxtools.lttng2.ust.memoryusage";
    }

    protected ITmfTrace getTestTrace() {
        return CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.MEMORY_ANALYSIS);
    }

    protected void disposeTestTrace() {
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)CtfTestTrace.MEMORY_ANALYSIS);
    }
}

