/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.model.xy;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.model.TmfXyResponseFactory;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.internal.tmf.core.model.tree.TmfTreeCompositeDataProvider;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ISeriesModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfCommonXAxisModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class TmfTreeXYCompositeDataProvider<M extends ITmfTreeDataModel, P extends ITmfTreeXYDataProvider<M>>
extends TmfTreeCompositeDataProvider<M, P>
implements ITmfTreeXYDataProvider<M> {
    private final String fTitle;

    public TmfTreeXYCompositeDataProvider(List<P> providers, String title, String id) {
        super(providers, id);
        this.fTitle = title;
    }

    public static @Nullable ITmfTreeXYDataProvider<ITmfTreeDataModel> create(Collection<ITmfTrace> traces, String title, String id) {
        return TmfTreeXYCompositeDataProvider.create(traces, title, id, null);
    }

    public static @Nullable ITmfTreeXYDataProvider<ITmfTreeDataModel> create(Collection<ITmfTrace> traces, String title, String id, @Nullable String secondaryId) {
        String providerId = secondaryId == null ? id : String.valueOf(id) + ':' + secondaryId;
        ArrayList<@NonNull ITmfTreeXYDataProvider> providers = new ArrayList<ITmfTreeXYDataProvider>();
        for (ITmfTrace child : traces) {
            ITmfTreeXYDataProvider provider = DataProviderManager.getInstance().getDataProvider(child, providerId, ITmfTreeXYDataProvider.class);
            if (provider == null) continue;
            providers.add(provider);
        }
        if (providers.isEmpty()) {
            return null;
        }
        if (providers.size() == 1) {
            return (ITmfTreeXYDataProvider)providers.get(0);
        }
        return new TmfTreeXYCompositeDataProvider(providers, title, providerId);
    }

    @Override
    public TmfModelResponse<ITmfXyModel> fetchXY(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        List providers = this.getProviders();
        Collection<TmfModelResponse<ITmfXyModel>> responses = this.getXyResponses(fetchParameters, monitor, providers);
        if (monitor != null && monitor.isCanceled()) {
            return TmfXyResponseFactory.createCancelledResponse(CommonStatusMessage.TASK_CANCELLED);
        }
        String failedMsg = TmfTreeXYCompositeDataProvider.handleFailedStatus(responses);
        if (failedMsg != null) {
            return TmfXyResponseFactory.createFailedResponse(failedMsg);
        }
        boolean allCommon = Iterables.all(providers, ITmfCommonXAxisModel.class::isInstance);
        boolean isComplete = Iterables.all(responses, response -> response.getStatus() == ITmfResponse.Status.COMPLETED);
        if (allCommon) {
            ImmutableMap.Builder series = ImmutableMap.builder();
            responses.forEach(response -> {
                ITmfCommonXAxisModel model = (ITmfCommonXAxisModel)response.getModel();
                if (model != null) {
                    series.putAll(model.getYData());
                }
            });
            TimeQueryFilter filter = FetchParametersUtils.createTimeQuery(fetchParameters);
            if (filter == null) {
                return TmfXyResponseFactory.createFailedResponse(CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
            }
            return TmfXyResponseFactory.create(this.fTitle, filter.getTimesRequested(), (Map<String, IYModel>)series.build(), isComplete);
        }
        ImmutableMap.Builder series = ImmutableMap.builder();
        responses.forEach(response -> {
            ITmfXyModel model = (ITmfXyModel)response.getModel();
            if (model != null) {
                series.putAll(model.getData());
            }
        });
        return TmfXyResponseFactory.create(this.fTitle, (Map<String, ISeriesModel>)series.build(), isComplete);
    }

    private static @Nullable String handleFailedStatus(Collection<TmfModelResponse<ITmfXyModel>> responses) {
        if (Iterables.any(responses, response -> response.getStatus() == ITmfResponse.Status.FAILED)) {
            return responses.stream().map(TmfModelResponse::getStatusMessage).collect(Collectors.joining("\n"));
        }
        return null;
    }

    private Collection<TmfModelResponse<ITmfXyModel>> getXyResponses(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor, List<P> providers) {
        ArrayList<TmfModelResponse<ITmfXyModel>> responses = new ArrayList<TmfModelResponse<ITmfXyModel>>();
        for (ITmfTreeXYDataProvider dataProvider : providers) {
            TmfModelResponse<ITmfXyModel> response = dataProvider.fetchXY(fetchParameters, monitor);
            responses.add(response);
            if (monitor == null || !monitor.isCanceled()) continue;
            return responses;
        }
        return responses;
    }
}

