/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.model.SeriesModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ISeriesModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfCommonXAxisModel;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;

public class TmfCommonXAxisModel
implements ITmfCommonXAxisModel {
    @SerializedName(value="title")
    private final String fTitle;
    @SerializedName(value="xValues")
    private final long[] fXValues;
    @SerializedName(value="series")
    private final Map<String, IYModel> fYSeries;
    private final transient Map<String, ISeriesModel> fSeries;

    public TmfCommonXAxisModel(String title, long[] xValues, Map<String, IYModel> ySeries) {
        this.fTitle = title;
        this.fXValues = Arrays.copyOf(xValues, xValues.length);
        this.fYSeries = ImmutableMap.copyOf(ySeries);
        this.fSeries = Maps.transformValues(this.fYSeries, model -> new SeriesModel(model.getId(), model.getName(), this.fXValues, model.getData()));
    }

    @Override
    public long[] getXValues() {
        return this.fXValues;
    }

    @Override
    public @Nullable String getTitle() {
        return this.fTitle;
    }

    @Override
    public @NonNull Map<String, IYModel> getYData() {
        return this.fYSeries;
    }

    @Override
    public boolean hasCommonXAxis() {
        return true;
    }

    @Override
    public Map<String, ISeriesModel> getData() {
        return this.fSeries;
    }
}

