/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density2;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density2.AbstractSegmentStoreDensityViewer;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density2.BaseMouseProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.AxisRange;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.IAxis;

public class MouseDragZoomProvider
extends BaseMouseProvider
implements MouseListener,
MouseMoveListener,
ICustomPaintListener {
    private double fStartCoordinate;
    private double fEndCoordinate;
    private boolean fIsUpdate;

    public MouseDragZoomProvider(AbstractSegmentStoreDensityViewer densityViewer) {
        super(densityViewer);
    }

    public void mouseDoubleClick(@Nullable MouseEvent e) {
    }

    public void mouseDown(@Nullable MouseEvent e) {
        if (e != null && e.button == 3) {
            IAxis xAxis = this.getXAxis();
            this.fEndCoordinate = this.fStartCoordinate = xAxis.getDataCoordinate(e.x);
            this.fIsUpdate = true;
        }
    }

    public void mouseUp(@Nullable MouseEvent e) {
        if (this.fIsUpdate && this.fStartCoordinate != this.fEndCoordinate) {
            if (this.fStartCoordinate > this.fEndCoordinate) {
                double tmp = this.fStartCoordinate;
                this.fStartCoordinate = this.fEndCoordinate;
                this.fEndCoordinate = tmp;
            }
            AxisRange range = new AxisRange(this.fStartCoordinate, this.fEndCoordinate);
            this.getDensityViewer().zoom(range);
        }
        if (this.fIsUpdate) {
            this.redraw();
        }
        this.fIsUpdate = false;
    }

    public void mouseMove(@Nullable MouseEvent e) {
        if (e != null && this.fIsUpdate) {
            IAxis xAxis = this.getXAxis();
            this.fEndCoordinate = xAxis.getDataCoordinate(e.x);
            this.redraw();
        }
    }

    public void paintControl(@Nullable PaintEvent e) {
        if (e != null && this.fIsUpdate && this.fStartCoordinate != this.fEndCoordinate) {
            IAxis xAxis = this.getXAxis();
            int startX = xAxis.getPixelCoordinate(this.fStartCoordinate);
            int endX = xAxis.getPixelCoordinate(this.fEndCoordinate);
            e.gc.setBackground(e.gc.getDevice().getSystemColor(34));
            if (this.fStartCoordinate < this.fEndCoordinate) {
                e.gc.fillRectangle(startX, 0, endX - startX, e.height);
            } else {
                e.gc.fillRectangle(endX, 0, startX - endX, e.height);
            }
            e.gc.drawLine(startX, 0, startX, e.height);
            e.gc.drawLine(endX, 0, endX, e.height);
        }
    }

    public boolean drawBehindSeries() {
        return true;
    }
}

