/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.internal.tmf.ui.util.StylePropertiesUtils;
import org.eclipse.tracecompass.tmf.ui.colors.ColorUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;

public class StateItem {
    public static final String UNDEFINED_STATE_NAME = "Undefined";
    private static final String UNDEFINED_COLOR_VALUE = "#000000";
    private final Map<String, Object> fOriginalStyleMap;
    private final Map<String, Object> fStyleMap;

    public StateItem(Map<String, Object> style) {
        HashMap<String, Object> styleMap = new HashMap<String, Object>();
        styleMap.putAll(style);
        this.fStyleMap = StylePropertiesUtils.updateEventStyleProperties(styleMap);
        this.fOriginalStyleMap = ImmutableMap.copyOf(this.fStyleMap);
    }

    public StateItem(RGB stateColor, String stateString) {
        HashMap<String, Object> styleMap = new HashMap<String, Object>();
        String hexColor = ColorUtils.toHexColor(stateColor.red, stateColor.green, stateColor.blue);
        styleMap.put("background-color", hexColor);
        styleMap.put("color", hexColor);
        styleMap.put("style-name", stateString);
        this.fStyleMap = styleMap;
        this.fOriginalStyleMap = ImmutableMap.copyOf(styleMap);
    }

    public RGB getStateColor() {
        String rgb = (String)this.fStyleMap.getOrDefault("background-color", this.fStyleMap.getOrDefault("color", UNDEFINED_COLOR_VALUE));
        return ColorUtils.fromHexColor(rgb);
    }

    public void setStateColor(RGB stateColor) {
        if (stateColor != null) {
            String hexColor = ColorUtils.toHexColor(stateColor.red, stateColor.green, stateColor.blue);
            this.fStyleMap.put("background-color", hexColor);
            this.fStyleMap.put("color", hexColor);
        }
    }

    public float getStateHeightFactor() {
        Object itemType = this.fStyleMap.get(ITimeEventStyleStrings.itemTypeProperty());
        float defaultStateWidth = ITimeEventStyleStrings.linkType().equals(itemType) ? 0.1f : 1.0f;
        return ((Float)this.fStyleMap.getOrDefault("height", Float.valueOf(defaultStateWidth))).floatValue();
    }

    public String getStateString() {
        return String.valueOf(this.fStyleMap.getOrDefault("style-name", UNDEFINED_STATE_NAME));
    }

    public void reset() {
        this.fStyleMap.clear();
        this.fStyleMap.putAll(this.fOriginalStyleMap);
    }

    public void setStateString(String stateString) {
        this.fStyleMap.put("style-name", stateString);
    }

    public Map<String, Object> getStyleMap() {
        return this.fStyleMap;
    }
}

