/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.handlers;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.tracecompass.tmf.core.io.ResourceUtil;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTracesFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteTraceFolderElementHandler
extends AbstractHandler {
    private IStructuredSelection fSelection = null;

    public boolean isEnabled() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return false;
        }
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ISelection selection = selectionProvider.getSelection();
        this.fSelection = null;
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
            for (Object element : this.fSelection) {
                if (element instanceof TmfTraceElement || element instanceof TmfTraceFolder) continue;
                return false;
            }
        }
        return !selection.isEmpty();
    }

    private static DeleteType getDeleteType(IStructuredSelection selection) {
        DeleteType deleteType = DeleteType.DELETE_GENERIC;
        for (Object element : selection) {
            if (element instanceof TmfTracesFolder) {
                if (deleteType == DeleteType.DELETE_GENERIC) {
                    deleteType = DeleteType.CLEAR_TRACES_FOLDER;
                    continue;
                }
                if (deleteType == DeleteType.CLEAR_TRACES_FOLDER) continue;
                return DeleteType.DELETE_GENERIC;
            }
            if (element instanceof TmfTraceFolder) {
                if (deleteType == DeleteType.DELETE_GENERIC) {
                    deleteType = DeleteType.DELETE_TRACE_FOLDERS;
                    continue;
                }
                if (deleteType == DeleteType.DELETE_TRACE_FOLDERS) continue;
                return DeleteType.DELETE_GENERIC;
            }
            if (!(element instanceof TmfTraceElement)) continue;
            if (deleteType == DeleteType.DELETE_GENERIC) {
                deleteType = DeleteType.DELETE_TRACES;
                continue;
            }
            if (deleteType == DeleteType.DELETE_TRACES) continue;
            return DeleteType.DELETE_GENERIC;
        }
        return deleteType;
    }

    private static String getTitle(DeleteType deleteType) {
        switch (deleteType) {
            case DELETE_TRACE_FOLDERS: 
            case DELETE_TRACES: 
            case DELETE_GENERIC: {
                return Messages.DeleteDialog_Title;
            }
            case CLEAR_TRACES_FOLDER: {
                return Messages.ClearDialog_Title;
            }
        }
        throw new IllegalArgumentException();
    }

    private static String getMessage(DeleteType deleteType) {
        switch (deleteType) {
            case DELETE_GENERIC: {
                return Messages.DeleteTraceHandlerGeneric_Message;
            }
            case DELETE_TRACES: {
                return Messages.DeleteTraceHandler_Message;
            }
            case CLEAR_TRACES_FOLDER: {
                return Messages.DeleteFolderHandlerClear_Message;
            }
            case DELETE_TRACE_FOLDERS: {
                return Messages.DeleteFolderHandler_Message;
            }
        }
        throw new IllegalArgumentException();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        this.fSelection = (IStructuredSelection)selection;
        DeleteType deleteType = DeleteTraceFolderElementHandler.getDeleteType(this.fSelection);
        Shell shell = window.getShell();
        MessageDialog dialog = new MessageDialog(shell, DeleteTraceFolderElementHandler.getTitle(deleteType), null, DeleteTraceFolderElementHandler.getMessage(deleteType), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
        if (dialog.open() != 0) {
            return null;
        }
        IRunnableWithProgress operation = monitor -> {
            IProject project;
            LinkedHashMultimap tracesToDelete = LinkedHashMultimap.create();
            LinkedHashMultimap resourcesToDelete = LinkedHashMultimap.create();
            LinkedHashMultimap foldersToCreate = LinkedHashMultimap.create();
            for (Object element : this.fSelection.toList()) {
                IResource resource;
                if (element instanceof TmfTraceElement) {
                    TmfTraceElement tmfTraceElement = ((TmfTraceElement)element).getElementUnderTraceFolder();
                    tracesToDelete.put((Object)tmfTraceElement.getProject().getResource(), (Object)tmfTraceElement);
                    resource = tmfTraceElement.getResource();
                    resourcesToDelete.put((Object)resource.getProject(), (Object)resource);
                    continue;
                }
                if (element instanceof TmfTracesFolder) {
                    TmfTracesFolder tmfTracesFolder = (TmfTracesFolder)element;
                    tracesToDelete.putAll((Object)tmfTracesFolder.getProject().getResource(), tmfTracesFolder.getTraces());
                    resource = tmfTracesFolder.getResource();
                    project = resource.getProject();
                    resourcesToDelete.put((Object)project, (Object)resource);
                    foldersToCreate.put((Object)project, (Object)resource);
                    TmfExperimentFolder experimentsFolder = tmfTracesFolder.getProject().getExperimentsFolder();
                    if (experimentsFolder == null) continue;
                    resource = experimentsFolder.getResource();
                    resourcesToDelete.put((Object)project, (Object)resource);
                    foldersToCreate.put((Object)project, (Object)resource);
                    continue;
                }
                if (!(element instanceof TmfTraceFolder)) continue;
                TmfTraceFolder tmfTraceFolder = (TmfTraceFolder)element;
                tracesToDelete.putAll((Object)tmfTraceFolder.getProject().getResource(), tmfTraceFolder.getTraces());
                resource = tmfTraceFolder.getResource();
                resourcesToDelete.put((Object)resource.getProject(), (Object)resource);
            }
            Iterator iterator = resourcesToDelete.values().iterator();
            block3: while (iterator.hasNext()) {
                IResource resource = (IResource)iterator.next();
                for (IResource iResource : resourcesToDelete.get((Object)resource.getProject())) {
                    if (!iResource.getFullPath().isPrefixOf(resource.getFullPath()) || iResource.equals((Object)resource)) continue;
                    iterator.remove();
                    continue block3;
                }
            }
            monitor.setTaskName(Messages.CloseTraces_TaskName);
            tracesToDelete.values().forEach(traceElement -> Display.getDefault().syncExec(traceElement::closeEditors));
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)(tracesToDelete.size() + resourcesToDelete.size() + foldersToCreate.size()));
            subMon.setTaskName(Messages.DeleteTraceHandlerGeneric_TaskName);
            for (Map.Entry entry : resourcesToDelete.asMap().entrySet()) {
                project = (IProject)entry.getKey();
                try {
                    ResourcesPlugin.getWorkspace().run(arg_0 -> DeleteTraceFolderElementHandler.lambda$3(entry, subMon, (Multimap)tracesToDelete, project, (Multimap)foldersToCreate, arg_0), (ISchedulingRule)project, 1, null);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, operation);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException e) {
            TraceUtils.displayErrorMsg(Messages.DeleteTraceHandlerGeneric_Error, e.getTargetException().toString(), e.getTargetException());
        }
        return null;
    }

    private static /* synthetic */ void lambda$3(Map.Entry entry, SubMonitor subMonitor, Multimap multimap, IProject iProject, Multimap multimap2, IProgressMonitor mon) throws CoreException {
        for (IResource resource : (Collection)entry.getValue()) {
            ResourceUtil.deleteResource((IResource)resource, (IProgressMonitor)subMonitor.split(1));
        }
        for (TmfTraceElement traceElement : multimap.get((Object)iProject)) {
            traceElement.delete((IProgressMonitor)subMonitor.split(1), false, false);
        }
        for (IFolder folder : multimap2.get((Object)iProject)) {
            TraceUtils.createFolder(folder, (IProgressMonitor)subMonitor.split(1));
        }
        subMonitor.subTask("");
    }

    private static enum DeleteType {
        DELETE_TRACE_FOLDERS,
        DELETE_TRACES,
        DELETE_GENERIC,
        CLEAR_TRACES_FOLDER;

    }
}

