/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree;

import java.nio.ByteBuffer;

public final class HTVarInt {
    private static final int OFFSET = 3;
    private static final long BYTE_MASK = 255L;
    private static final long SHORT_MASK = 65535L;
    private static final long INT_MASK = 0xFFFFFFFFL;

    private HTVarInt() {
    }

    public static int getEncodedLengthLong(long val) {
        long encodedVal = val + 3L;
        int numberOfLeadingZeros = Long.numberOfLeadingZeros(encodedVal);
        int maxBytes = 8;
        return maxBytes - numberOfLeadingZeros / 8 + 1;
    }

    public static void writeLong(ByteBuffer buffer, long val) {
        int remainingBytes = HTVarInt.getEncodedLengthLong(val) - 1;
        long value = val + 3L;
        buffer.put((byte)remainingBytes);
        if (remainingBytes == 8) {
            buffer.putLong(value);
            return;
        }
        if (remainingBytes >= 4) {
            buffer.putInt((int)(value & 0xFFFFFFFFL));
            value >>= 32;
            remainingBytes -= 4;
        }
        if (remainingBytes >= 2) {
            buffer.putShort((short)(value & 0xFFFFL));
            value >>= 16;
            remainingBytes -= 2;
        }
        if (remainingBytes >= 1) {
            buffer.put((byte)(value & 0xFFL));
        }
    }

    public static long readLong(ByteBuffer buffer) {
        int remainingBytes = buffer.get();
        int sizeLastInsert = 0;
        long retVal = 0L;
        if (remainingBytes == 8) {
            return buffer.getLong() - 3L;
        }
        if (remainingBytes >= 4) {
            retVal += Integer.toUnsignedLong(buffer.getInt());
            sizeLastInsert += 32;
            remainingBytes -= 4;
        }
        if (remainingBytes >= 2) {
            short s = buffer.getShort();
            retVal += Short.toUnsignedLong(s) << sizeLastInsert;
            sizeLastInsert += 16;
            remainingBytes -= 2;
        }
        if (remainingBytes >= 1) {
            byte by = buffer.get();
            retVal = (Byte.toUnsignedLong(by) << sizeLastInsert) + retVal;
        }
        return retVal - 3L;
    }
}

