/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.virtualtable;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.ui.widgets.virtualtable.IDoubleClickListener;
import org.eclipse.tracecompass.tmf.ui.widgets.virtualtable.TooltipProvider;
import org.eclipse.ui.PlatformUI;

public class TmfVirtualTable
extends Composite {
    private Table fTable;
    private int fTableRows = 0;
    private int fFullyVisibleRows = 0;
    private int fFrozenRowCount = 0;
    private int fTableTopEventRank = 0;
    private int fSelectedEventRank = -1;
    private int fSelectedBeginRank = -1;
    private boolean fPendingSelection = false;
    private int fTableItemCount = 0;
    private Slider fSlider;
    private SliderThrottler fSliderThrottler;
    private int fLinuxItemHeight = 0;
    private TooltipProvider tooltipProvider = null;
    private IDoubleClickListener doubleClickListener = null;
    private boolean fResetTopIndex = false;
    private ControlAdapter fResizeListener;

    public TmfVirtualTable(Composite parent, int style) {
        super(parent, style & 0xFFFFFEFF & 0xFFFFFDFF & 0xFFFFFFFB & 0xFFFFFFFD & 0xFFFEFFFF & 0xFFFF7FFF & 0xFFFFFFDF);
        this.createTable(style & 0x18126);
        this.createSlider(style & 0x200);
        this.setTabList(new Control[]{this.fTable});
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        GridData tableGridData = new GridData(4, 4, true, true);
        this.fTable.setLayoutData((Object)tableGridData);
        GridData sliderGridData = new GridData(4, 4, false, true);
        this.fSlider.setLayoutData((Object)sliderGridData);
        this.fTable.addMouseWheelListener(event -> {
            int latestFirstRowOffset;
            if (this.fTableItemCount <= this.fFullyVisibleRows || event.count == 0) {
                return;
            }
            this.fTableTopEventRank -= event.count;
            if (this.fTableTopEventRank < 0) {
                this.fTableTopEventRank = 0;
            }
            if (this.fTableTopEventRank > (latestFirstRowOffset = this.fTableItemCount - this.fFullyVisibleRows)) {
                this.fTableTopEventRank = latestFirstRowOffset;
            }
            this.fSlider.setSelection(this.fTableTopEventRank);
            this.refreshTable();
        });
        this.fTable.addListener(37, event -> {
            boolean bl = event.doit = false;
        });
        this.fResizeListener = new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                int tableHeight = Math.max(0, ((TmfVirtualTable)TmfVirtualTable.this).fTable.getClientArea().height - TmfVirtualTable.this.fTable.getHeaderHeight());
                TmfVirtualTable.this.fFullyVisibleRows = tableHeight / TmfVirtualTable.this.getItemHeight();
                if (TmfVirtualTable.this.fTableItemCount > 0) {
                    TmfVirtualTable.this.fSlider.setThumb(Math.max(1, Math.min(TmfVirtualTable.this.fTableRows, TmfVirtualTable.this.fFullyVisibleRows)));
                }
            }
        };
        this.fTable.addControlListener((ControlListener)this.fResizeListener);
        String TOOLTIP_DATA_KEY = "_TABLEITEM";
        final Listener labelListener = event -> {
            Label label = (Label)event.widget;
            Shell shell = label.getShell();
            switch (event.type) {
                case 3: {
                    Event e = new Event();
                    e.item = (TableItem)label.getData("_TABLEITEM");
                    this.fTable.setSelection(new TableItem[]{(TableItem)e.item});
                    this.fTable.notifyListeners(13, e);
                    shell.dispose();
                    this.fTable.setFocus();
                    break;
                }
                case 7: 
                case 37: {
                    shell.dispose();
                    break;
                }
            }
        };
        Listener tableListener = new Listener(){
            Shell tip = null;
            Label label = null;

            public void handleEvent(Event event) {
                block0 : switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        TableItem item = TmfVirtualTable.this.fTable.getItem(new Point(event.x, event.y));
                        if (item == null) break;
                        int i = 0;
                        while (i < TmfVirtualTable.this.fTable.getColumnCount()) {
                            Rectangle bounds = item.getBounds(i);
                            if (bounds.contains(event.x, event.y)) {
                                if (this.tip != null && !this.tip.isDisposed()) {
                                    this.tip.dispose();
                                }
                                if (TmfVirtualTable.this.tooltipProvider == null) {
                                    return;
                                }
                                String tooltipText = TmfVirtualTable.this.tooltipProvider.getTooltip(i, item.getData());
                                if (tooltipText == null) {
                                    return;
                                }
                                this.tip = new Shell(TmfVirtualTable.this.fTable.getShell(), 540676);
                                this.tip.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(29));
                                FillLayout layout = new FillLayout();
                                layout.marginWidth = 2;
                                this.tip.setLayout((Layout)layout);
                                this.label = new Label((Composite)this.tip, 64);
                                this.label.setForeground(PlatformUI.getWorkbench().getDisplay().getSystemColor(28));
                                this.label.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(29));
                                this.label.setData("_TABLEITEM", (Object)item);
                                this.label.setText(tooltipText);
                                this.label.addListener(7, labelListener);
                                this.label.addListener(3, labelListener);
                                this.label.addListener(37, labelListener);
                                Point size = this.tip.computeSize(-1, -1);
                                Point pt = TmfVirtualTable.this.fTable.toDisplay(bounds.x, bounds.y);
                                this.tip.setBounds(pt.x, pt.y, size.x, size.y);
                                this.tip.setVisible(true);
                                break block0;
                            }
                            ++i;
                        }
                        break;
                    }
                }
            }
        };
        this.fTable.addListener(12, tableListener);
        this.fTable.addListener(1, tableListener);
        this.fTable.addListener(5, tableListener);
        this.fTable.addListener(32, tableListener);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                TmfVirtualTable.this.resize();
                if (TmfVirtualTable.this.fTableItemCount > 0) {
                    TmfVirtualTable.this.fSlider.setThumb(Math.max(1, Math.min(TmfVirtualTable.this.fTableRows, TmfVirtualTable.this.fFullyVisibleRows)));
                }
            }
        });
        this.refresh();
    }

    private void createTable(int style) {
        this.fTable = new Table((Composite)this, style | 0x10);
        this.fTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.item == null) {
                    TmfVirtualTable.this.refreshSelection();
                }
            }
        });
        this.fTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TmfVirtualTable.this.handleTableMouseEvent(e);
            }
        });
        this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                TmfVirtualTable.this.handleTableKeyEvent(event);
            }
        });
        this.fTable.addListener(8, event -> {
            TableItem item;
            if (this.doubleClickListener != null && (item = this.fTable.getItem(new Point(event.x, event.y))) != null) {
                int i = 0;
                while (i < this.fTable.getColumnCount()) {
                    Rectangle bounds = item.getBounds(i);
                    if (bounds.contains(event.x, event.y)) {
                        this.doubleClickListener.handleDoubleClick(this, item, i);
                        break;
                    }
                    ++i;
                }
            }
        });
        this.fTable.addPaintListener(e -> {
            if (this.fTable.getTopIndex() != 0 || this.fResetTopIndex) {
                this.fTable.setTopIndex(0);
            }
            this.fResetTopIndex = false;
        });
    }

    private void handleTableMouseEvent(MouseEvent event) {
        TableItem item = this.fTable.getItem(new Point(event.x, event.y));
        if (item == null) {
            return;
        }
        int selectedRow = this.indexOf(item);
        if (event.button == 1 || event.button == 3 && (selectedRow < Math.min(this.fSelectedBeginRank, this.fSelectedEventRank) || selectedRow > Math.max(this.fSelectedBeginRank, this.fSelectedEventRank))) {
            this.fSelectedEventRank = selectedRow >= 0 ? selectedRow : -1;
            if ((event.stateMask & 0x20000) == 0 || (this.fTable.getStyle() & 2) == 0 || this.fSelectedBeginRank == -1) {
                this.fSelectedBeginRank = this.fSelectedEventRank;
            }
        }
        this.refreshSelection();
        if (selectedRow >= this.fFullyVisibleRows) {
            this.fResetTopIndex = true;
        }
    }

    private void handleTableKeyEvent(KeyEvent event) {
        int lastEventRank = this.fTableItemCount - 1;
        int lastPageTopEntryRank = Math.max(0, this.fTableItemCount - this.fFullyVisibleRows);
        int previousSelectedEventRank = this.fSelectedEventRank;
        int previousSelectedBeginRank = this.fSelectedBeginRank;
        boolean needsRefresh = false;
        switch (event.keyCode) {
            case 0x1000002: {
                event.doit = false;
                if (this.fSelectedEventRank >= lastEventRank) break;
                ++this.fSelectedEventRank;
                int selectedRow = this.fSelectedEventRank - this.fTableTopEventRank;
                if (selectedRow == this.fFullyVisibleRows) {
                    ++this.fTableTopEventRank;
                    needsRefresh = true;
                    break;
                }
                if (selectedRow >= this.fFrozenRowCount && selectedRow <= this.fFullyVisibleRows) break;
                this.fTableTopEventRank = Math.max(0, Math.min(this.fSelectedEventRank - this.fFrozenRowCount, lastPageTopEntryRank));
                needsRefresh = true;
                break;
            }
            case 0x1000001: {
                event.doit = false;
                if (this.fSelectedEventRank <= 0) break;
                --this.fSelectedEventRank;
                int selectedRow = this.fSelectedEventRank - this.fTableTopEventRank;
                if (selectedRow == this.fFrozenRowCount - 1 && this.fTableTopEventRank > 0) {
                    --this.fTableTopEventRank;
                    needsRefresh = true;
                    break;
                }
                if (selectedRow >= this.fFrozenRowCount && selectedRow <= this.fFullyVisibleRows) break;
                this.fTableTopEventRank = Math.max(0, Math.min(this.fSelectedEventRank - this.fFrozenRowCount, lastPageTopEntryRank));
                needsRefresh = true;
                break;
            }
            case 0x1000008: {
                event.doit = false;
                this.fTableTopEventRank = lastPageTopEntryRank;
                this.fSelectedEventRank = lastEventRank;
                needsRefresh = true;
                break;
            }
            case 0x1000007: {
                event.doit = false;
                this.fSelectedEventRank = this.fFrozenRowCount;
                this.fTableTopEventRank = 0;
                needsRefresh = true;
                break;
            }
            case 0x1000006: {
                int selectedRow;
                event.doit = false;
                if (this.fSelectedEventRank >= lastEventRank) break;
                this.fSelectedEventRank += this.fFullyVisibleRows;
                if (this.fSelectedEventRank > lastEventRank) {
                    this.fSelectedEventRank = lastEventRank;
                }
                if ((selectedRow = this.fSelectedEventRank - this.fTableTopEventRank) > this.fFullyVisibleRows + this.fFrozenRowCount - 1 && selectedRow < 2 * this.fFullyVisibleRows) {
                    this.fTableTopEventRank += this.fFullyVisibleRows;
                    if (this.fTableTopEventRank > lastPageTopEntryRank) {
                        this.fTableTopEventRank = lastPageTopEntryRank;
                    }
                    needsRefresh = true;
                    break;
                }
                if (selectedRow >= this.fFrozenRowCount && selectedRow < 2 * this.fFullyVisibleRows) break;
                this.fTableTopEventRank = Math.max(0, Math.min(this.fSelectedEventRank - this.fFrozenRowCount, lastPageTopEntryRank));
                needsRefresh = true;
                break;
            }
            case 0x1000005: {
                int selectedRow;
                event.doit = false;
                if (this.fSelectedEventRank <= 0) break;
                this.fSelectedEventRank -= this.fFullyVisibleRows;
                if (this.fSelectedEventRank < this.fFrozenRowCount) {
                    this.fSelectedEventRank = this.fFrozenRowCount;
                }
                if ((selectedRow = this.fSelectedEventRank - this.fTableTopEventRank) < this.fFrozenRowCount && selectedRow > -this.fFullyVisibleRows) {
                    this.fTableTopEventRank -= this.fFullyVisibleRows;
                    if (this.fTableTopEventRank < 0) {
                        this.fTableTopEventRank = 0;
                    }
                    needsRefresh = true;
                    break;
                }
                if (selectedRow > -this.fFullyVisibleRows && selectedRow < this.fFullyVisibleRows) break;
                this.fTableTopEventRank = Math.max(0, Math.min(this.fSelectedEventRank - this.fFrozenRowCount, lastPageTopEntryRank));
                needsRefresh = true;
                break;
            }
            default: {
                return;
            }
        }
        if ((event.stateMask & 0x20000) == 0 || (this.fTable.getStyle() & 2) == 0 || this.fSelectedBeginRank == -1) {
            this.fSelectedBeginRank = this.fSelectedEventRank;
        }
        boolean done = true;
        if (needsRefresh) {
            done = this.refreshTable();
        } else {
            this.refreshSelection();
        }
        if (this.fFullyVisibleRows < this.fTableItemCount) {
            this.fSlider.setSelection(this.fTableTopEventRank);
        }
        if (this.fSelectedEventRank != previousSelectedEventRank || this.fSelectedBeginRank != previousSelectedBeginRank) {
            if (done) {
                Event e = new Event();
                e.item = this.fTable.getItem(this.fSelectedEventRank - this.fTableTopEventRank);
                this.fTable.notifyListeners(13, e);
            } else {
                this.fPendingSelection = true;
            }
        }
    }

    private boolean setDataItem(int index, TableItem item) {
        if (index != -1) {
            Event event = new Event();
            event.item = item;
            event.index = index < this.fFrozenRowCount ? index : index + this.fTableTopEventRank;
            event.doit = true;
            this.fTable.notifyListeners(36, event);
            return event.doit;
        }
        return true;
    }

    private void createSlider(int style) {
        this.fSlider = new Slider((Composite)this, 524800);
        this.fSlider.setMinimum(0);
        this.fSlider.setMaximum(0);
        if ((style & 0x200) == 0) {
            this.fSlider.setVisible(false);
        }
        this.fSlider.addListener(13, event -> {
            switch (event.detail) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000005: 
                case 0x1000006: 
                case 0x1000007: 
                case 0x1000008: {
                    this.fTableTopEventRank = this.fSlider.getSelection();
                    this.refreshTable();
                    break;
                }
                case 0: 
                case 1: {
                    this.fTableTopEventRank = this.fSlider.getSelection();
                    if (this.fSliderThrottler != null) break;
                    this.fSliderThrottler = new SliderThrottler();
                    this.fSliderThrottler.start();
                    break;
                }
            }
        });
        this.fSlider.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (TmfVirtualTable.this.fSliderThrottler != null) {
                    TmfVirtualTable.this.fSliderThrottler.interrupt();
                    TmfVirtualTable.this.fSliderThrottler = null;
                }
                TmfVirtualTable.this.fTableTopEventRank = TmfVirtualTable.this.fSlider.getSelection();
                TmfVirtualTable.this.refreshTable();
            }
        });
        this.fSlider.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                TmfVirtualTable.this.fTable.setFocus();
            }
        });
    }

    public TableColumn newTableColumn(int style) {
        TableColumn column = new TableColumn(this.fTable, style);
        column.addControlListener((ControlListener)this.fResizeListener);
        return column;
    }

    public void setHeaderVisible(boolean b) {
        this.fTable.setHeaderVisible(b);
    }

    public void setLinesVisible(boolean b) {
        this.fTable.setLinesVisible(b);
    }

    public TableItem[] getSelection() {
        return this.fTable.getSelection();
    }

    public void addListener(int eventType, Listener listener) {
        this.fTable.addListener(eventType, listener);
    }

    public void addKeyListener(KeyListener listener) {
        this.fTable.addKeyListener(listener);
    }

    public void addMouseListener(MouseListener listener) {
        this.fTable.addMouseListener(listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.fTable.addSelectionListener(listener);
    }

    public void setMenu(Menu menu) {
        this.fTable.setMenu(menu);
    }

    public Menu getMenu() {
        return this.fTable.getMenu();
    }

    public void clearAll() {
        this.setItemCount(0);
    }

    public void setItemCount(int nbItems) {
        int nb = Math.max(0, nbItems);
        if (nb != this.fTableItemCount) {
            this.fTableItemCount = nb;
            this.fTable.remove(this.fTableItemCount, this.fTable.getItemCount() - 1);
            this.fSlider.setMaximum(nb);
            this.resize();
            int tableHeight = Math.max(0, this.fTable.getClientArea().height - this.fTable.getHeaderHeight());
            this.fFullyVisibleRows = tableHeight / this.getItemHeight();
            if (this.fTableItemCount > 0) {
                this.fSlider.setThumb(Math.max(1, Math.min(this.fTableRows, this.fFullyVisibleRows)));
            }
        }
    }

    public int getItemCount() {
        return this.fTableItemCount;
    }

    public int getItemHeight() {
        if (this.fLinuxItemHeight >= 0 && System.getProperty("os.name").contains("Linux")) {
            int itemHeight;
            if (this.fLinuxItemHeight != 0) {
                return this.fLinuxItemHeight;
            }
            if (this.fTable.getItemCount() > 1 && (itemHeight = this.fTable.getItem((int)1).getBounds().y - this.fTable.getItem((int)0).getBounds().y) > 0) {
                this.fLinuxItemHeight = itemHeight;
                return this.fLinuxItemHeight;
            }
        } else {
            this.fLinuxItemHeight = -1;
        }
        return this.fTable.getItemHeight();
    }

    public int getHeaderHeight() {
        return this.fTable.getHeaderHeight();
    }

    public int getTopIndex() {
        return this.fTableTopEventRank + this.fFrozenRowCount;
    }

    public void setTopIndex(int index) {
        if (this.fTableItemCount > 0) {
            int i = Math.min(index, this.fTableItemCount - 1);
            i = Math.max(i, this.fFrozenRowCount);
            this.fTableTopEventRank = i - this.fFrozenRowCount;
            if (this.fFullyVisibleRows < this.fTableItemCount) {
                this.fSlider.setSelection(this.fTableTopEventRank);
            }
            this.refreshTable();
        }
    }

    public ScrollBar getHorizontalBar() {
        return this.fTable.getHorizontalBar();
    }

    public ScrollBar getVerticalBar() {
        return this.fTable.getVerticalBar();
    }

    public int indexOf(TableItem ti) {
        int index = this.fTable.indexOf(ti);
        if (index < this.fFrozenRowCount) {
            return index;
        }
        return index - this.fFrozenRowCount + this.getTopIndex();
    }

    public TableColumn[] getColumns() {
        return this.fTable.getColumns();
    }

    public int[] getColumnOrder() {
        return this.fTable.getColumnOrder();
    }

    public void setColumnOrder(int[] order) {
        this.fTable.setColumnOrder(order);
    }

    public TableItem getItem(Point point) {
        return this.fTable.getItem(point);
    }

    public TableColumn getColumn(Point point) {
        Point p;
        Rectangle clientArea = this.fTable.getClientArea();
        if (!clientArea.contains(p = new Point(clientArea.x + point.x, clientArea.y + point.y))) {
            return null;
        }
        int x = 0;
        int[] nArray = this.fTable.getColumnOrder();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            TableColumn column = this.fTable.getColumn(i);
            int width = column.getWidth();
            if (p.x < (x += width) && width > 0) {
                return column;
            }
            ++n2;
        }
        return null;
    }

    private void resize() {
        int tableHeight = Math.max(0, this.getSize().y - this.fTable.getHeaderHeight());
        int itemHeight = this.getItemHeight();
        this.fTableRows = Math.min((tableHeight + itemHeight - 1) / itemHeight, this.fTableItemCount);
        if (this.fTableTopEventRank + this.fFullyVisibleRows > this.fTableItemCount) {
            this.fTableTopEventRank = Math.max(0, this.fTableItemCount - this.fFullyVisibleRows);
            this.refreshTable();
        } else if (this.fTableRows > this.fTable.getItemCount() || this.fTableItemCount < this.fTable.getItemCount()) {
            this.refreshTable();
        }
    }

    public boolean setFocus() {
        boolean isVisible = this.isVisible();
        if (isVisible) {
            this.fTable.setFocus();
        }
        return isVisible;
    }

    public void refresh() {
        boolean done = this.refreshTable();
        if (!done) {
            return;
        }
        if (this.fPendingSelection) {
            this.fPendingSelection = false;
            TableItem item = null;
            if (this.fSelectedEventRank >= 0 && this.fSelectedEventRank < this.fFrozenRowCount) {
                item = this.fTable.getItem(this.fSelectedEventRank);
            } else if (this.fSelectedEventRank >= this.fTableTopEventRank + this.fFrozenRowCount && this.fSelectedEventRank - this.fTableTopEventRank < this.fTable.getItemCount()) {
                item = this.fTable.getItem(this.fSelectedEventRank - this.fTableTopEventRank);
            }
            if (item != null) {
                Event e = new Event();
                e.item = item;
                this.fTable.notifyListeners(13, e);
            }
        }
    }

    public int removeAll() {
        this.setItemCount(0);
        this.fSlider.setMaximum(0);
        this.fTable.removeAll();
        this.fSelectedBeginRank = this.fSelectedEventRank = -1;
        return 0;
    }

    private boolean refreshTable() {
        boolean done = true;
        int i = 0;
        while (i < this.fTableRows) {
            if (i + this.fTableTopEventRank < this.fTableItemCount) {
                TableItem tableItem = i < this.fTable.getItemCount() ? this.fTable.getItem(i) : new TableItem(this.fTable, 0);
                done &= this.setDataItem(i, tableItem);
            } else if (this.fTable.getItemCount() > this.fTableItemCount - this.fTableTopEventRank) {
                this.fTable.remove(this.fTableItemCount - this.fTableTopEventRank);
            }
            ++i;
        }
        if (done) {
            this.refreshSelection();
        } else {
            this.fTable.deselectAll();
        }
        return done;
    }

    private void refreshSelection() {
        int lastRowOffset = this.fTableTopEventRank + this.fTableRows - 1;
        int startRank = Math.min(this.fSelectedBeginRank, this.fSelectedEventRank);
        int endRank = Math.max(this.fSelectedBeginRank, this.fSelectedEventRank);
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        if (startRank < this.fFrozenRowCount) {
            start = startRank;
        } else if (startRank < this.fTableTopEventRank + this.fFrozenRowCount) {
            start = this.fFrozenRowCount;
        } else if (startRank <= lastRowOffset) {
            start = startRank - this.fTableTopEventRank;
        }
        end = endRank < this.fFrozenRowCount ? endRank : (endRank < this.fTableTopEventRank + this.fFrozenRowCount ? this.fFrozenRowCount - 1 : (endRank <= lastRowOffset ? endRank - this.fTableTopEventRank : this.fTableRows - 1));
        if (start <= end) {
            this.fTable.setSelection(start, end);
            this.fTable.setTopIndex(0);
            if (startRank == this.fSelectedEventRank) {
                this.fTable.select(start);
            } else {
                this.fTable.select(end);
            }
        } else {
            if (SWT.getPlatform().equals("gtk") && this.fTableRows > 0) {
                this.fTable.setRedraw(false);
                if (start < Integer.MAX_VALUE) {
                    this.fTable.setSelection(0);
                } else {
                    this.fTable.setSelection(this.fTableRows - 1);
                    this.fTable.setTopIndex(0);
                }
                this.fTable.setRedraw(true);
            }
            this.fTable.deselectAll();
        }
    }

    public void setSelection(int index) {
        this.setSelectionRange(index, index);
    }

    public void setSelectionRange(int beginIndex, int endIndex) {
        if (this.fTableItemCount > 0) {
            int begin = Math.max(Math.min(beginIndex, this.fTableItemCount - 1), 0);
            int end = Math.max(Math.min(endIndex, this.fTableItemCount - 1), 0);
            int selection = this.fSelectedBeginRank != begin ? begin : end;
            this.fSelectedBeginRank = begin;
            this.fSelectedEventRank = end;
            if (selection < this.fTableTopEventRank + this.fFrozenRowCount && selection >= this.fFrozenRowCount || selection >= this.fTableTopEventRank + this.fFullyVisibleRows) {
                int lastPageTopEntryRank = Math.max(0, this.fTableItemCount - this.fFullyVisibleRows);
                this.fTableTopEventRank = Math.max(0, Math.min(lastPageTopEntryRank, selection - this.fFrozenRowCount - this.fFullyVisibleRows / 2));
            }
            if (this.fFullyVisibleRows < this.fTableItemCount) {
                this.fSlider.setSelection(this.fTableTopEventRank);
            }
            this.refreshTable();
        }
    }

    public int getSelectionIndex() {
        return this.fSelectedEventRank;
    }

    public int[] getSelectionIndices() {
        if (this.fSelectedEventRank < 0 || this.fSelectedBeginRank < 0) {
            return new int[0];
        }
        if (this.fSelectedEventRank == this.fSelectedBeginRank) {
            return new int[]{this.fSelectedEventRank};
        }
        return new int[]{this.fSelectedBeginRank, this.fSelectedEventRank};
    }

    public void setFrozenRowCount(int count) {
        this.fFrozenRowCount = count;
        this.refreshTable();
    }

    public TableEditor createTableEditor() {
        return new TableEditor(this.fTable);
    }

    public Control createTableEditorControl(Class<? extends Control> control) {
        try {
            return control.getConstructor(Composite.class, Integer.TYPE).newInstance(this.fTable, 0);
        }
        catch (Exception e) {
            Activator.getDefault().logError("Error creating table editor control", e);
            return null;
        }
    }

    public TooltipProvider getTooltipProvider() {
        return this.tooltipProvider;
    }

    public void setTooltipProvider(TooltipProvider tooltipProvider) {
        this.tooltipProvider = tooltipProvider;
    }

    public IDoubleClickListener getDoubleClickListener() {
        return this.doubleClickListener;
    }

    public void setDoubleClickListener(IDoubleClickListener doubleClickListener) {
        this.doubleClickListener = doubleClickListener;
    }

    private class SliderThrottler
    extends Thread {
        private static final long DELAY = 400L;
        private static final long POLLING_INTERVAL = 10L;

        private SliderThrottler() {
        }

        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < 400L) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Display.getDefault().asyncExec(() -> {
                if (TmfVirtualTable.this.fSliderThrottler != this) {
                    return;
                }
                TmfVirtualTable.this.fSliderThrottler = null;
                if (this.isInterrupted() || TmfVirtualTable.this.fTable.isDisposed()) {
                    return;
                }
                TmfVirtualTable.this.refreshTable();
            });
        }
    }
}

