/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.script.ScriptEngine;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenEventHandler;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenMappingGroup;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfAttributePool;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class DataDrivenStateProvider
extends AbstractTmfStateProvider
implements IAnalysisDataContainer {
    private final List<DataDrivenEventHandler> fEventHandlers;
    private final Map<String, DataDrivenMappingGroup> fMappingGroups = new HashMap<String, DataDrivenMappingGroup>();
    private Map<String, ScriptEngine> fScriptengine = new HashMap<String, ScriptEngine>();
    private final String fId;
    private final int fVersion;
    private final Map<Integer, TmfAttributePool> fAttributePools = new HashMap<Integer, TmfAttributePool>();

    public DataDrivenStateProvider(ITmfTrace trace, String providerId, int version, List<DataDrivenEventHandler> eventHandlers, Collection<DataDrivenMappingGroup> mappingGroups) {
        super(trace, providerId);
        this.fEventHandlers = eventHandlers;
        mappingGroups.forEach(mg -> {
            DataDrivenMappingGroup dataDrivenMappingGroup = this.fMappingGroups.put(mg.getId(), (DataDrivenMappingGroup)mg);
        });
        this.fId = providerId;
        this.fVersion = version;
    }

    public int getVersion() {
        return this.fVersion;
    }

    public ITmfStateProvider getNewInstance() {
        return new DataDrivenStateProvider(this.getTrace(), this.fId, this.fVersion, this.fEventHandlers, this.fMappingGroups.values());
    }

    protected void eventHandle(ITmfEvent event) {
        this.fEventHandlers.forEach(handler -> handler.handleEvent(event, DataDrivenScenarioInfo.DUMMY_SCENARIO, this));
    }

    @Override
    public ITmfStateSystem getStateSystem() {
        ITmfStateSystem ss = this.getAssignedStateSystem();
        if (ss == null) {
            throw new NullPointerException("The state system should not be requested at this point, it is null");
        }
        return ss;
    }

    @Override
    public @Nullable TmfAttributePool getAttributePool(int startNodeQuark) {
        ITmfStateSystem ss = this.getStateSystem();
        if (!(ss instanceof ITmfStateSystemBuilder)) {
            throw new IllegalStateException("The state system hasn't been initialized yet");
        }
        TmfAttributePool pool = this.fAttributePools.get(startNodeQuark);
        if (pool == null) {
            pool = new TmfAttributePool((ITmfStateSystemBuilder)ss, Integer.valueOf(startNodeQuark), TmfAttributePool.QueueType.PRIORITY);
            this.fAttributePools.put(startNodeQuark, pool);
        }
        return pool;
    }

    @Override
    public DataDrivenMappingGroup getMappingGroup(String id) {
        return Objects.requireNonNull(this.fMappingGroups.get(id));
    }

    @Override
    public void addFutureState(long time, @Nullable Object state, int quark, ITmfStateProvider.FutureEventType type) {
        this.addFutureEvent(time, state, quark, type);
    }

    @Override
    public void setScriptengine(String name, ScriptEngine engine) {
        this.fScriptengine.put(name, engine);
    }

    @Override
    public @Nullable ScriptEngine getScriptEngine(String name) {
        return this.fScriptengine.get(name);
    }

    @Override
    public boolean isReadOnlyContainer() {
        return false;
    }
}

