/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableExecution;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUtil;
import org.eclipse.core.runtime.CoreException;

public class ExecCompoundStatement
implements ICPPExecution {
    private ICPPExecution[] executions;

    private ExecCompoundStatement(ICPPExecution[] executions) {
        this.executions = executions;
    }

    public ExecCompoundStatement(IASTStatement[] statements) {
        this(ExecCompoundStatement.createExecutionsFromStatements(statements));
    }

    private static ICPPExecution[] createExecutionsFromStatements(IASTStatement[] statements) {
        ICPPExecution[] executions = new ICPPExecution[statements.length];
        int i = 0;
        while (i < executions.length) {
            executions[i] = EvalUtil.getExecutionFromStatement(statements[i]);
            ++i;
        }
        return executions;
    }

    @Override
    public ICPPExecution instantiate(InstantiationContext context, int maxDepth) {
        ICPPExecution[] newExecutions = new ICPPExecution[this.executions.length];
        int i = 0;
        while (i < this.executions.length) {
            if (this.executions[i] != null) {
                newExecutions[i] = this.executions[i].instantiate(context, maxDepth);
            }
            ++i;
        }
        return new ExecCompoundStatement(newExecutions);
    }

    @Override
    public ICPPExecution executeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPExecution[] iCPPExecutionArray = this.executions;
        int n = this.executions.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPExecution result;
            ICPPExecution execution = iCPPExecutionArray[n2];
            if (execution != null && (result = EvalUtil.executeStatement(execution, record, context)) != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)1);
        buffer.putInt(this.executions.length);
        ICPPExecution[] iCPPExecutionArray = this.executions;
        int n = this.executions.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPExecution execution = iCPPExecutionArray[n2];
            buffer.marshalExecution(execution, includeValue);
            ++n2;
        }
    }

    public static ISerializableExecution unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        int len = buffer.getInt();
        ICPPExecution[] executions = new ICPPExecution[len];
        int i = 0;
        while (i < executions.length) {
            executions[i] = (ICPPExecution)buffer.unmarshalExecution();
            ++i;
        }
        return new ExecCompoundStatement(executions);
    }
}

