/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.parsers.custom;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.xml.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlInputAttribute;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlInputElement;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.Messages;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CustomXmlTraceDefinition
extends CustomTraceDefinition {
    public static final String CUSTOM_XML_CATEGORY = "Custom XML";
    protected static final String CUSTOM_XML_TRACE_DEFINITIONS_DEFAULT_FILE_NAME = "custom_xml_default_parsers.xml";
    protected static final String CUSTOM_XML_TRACE_DEFINITIONS_FILE_NAME = "custom_xml_parsers.xml";
    protected static final String CUSTOM_XML_TRACE_DEFINITIONS_DEFAULT_PATH_NAME = String.valueOf(Platform.getInstallLocation().getURL().getPath()) + "templates/org.eclipse.linuxtools.tmf.core/" + "custom_xml_default_parsers.xml";
    protected static final String CUSTOM_XML_TRACE_DEFINITIONS_PATH_NAME = Activator.getDefault().getStateLocation().addTrailingSeparator().append("custom_xml_parsers.xml").toString();
    private static final String CUSTOM_XML_TRACE_DEFINITIONS_PATH_NAME_LEGACY_UI = Activator.getDefault().getStateLocation().removeLastSegments(1).addTrailingSeparator().append("org.eclipse.linuxtools.tmf.ui").append("custom_xml_parsers.xml").toString();
    private static final String CUSTOM_XML_TRACE_DEFINITIONS_PATH_NAME_LEGACY_CORE = Activator.getDefault().getStateLocation().removeLastSegments(1).addTrailingSeparator().append("org.eclipse.linuxtools.tmf.core").append("custom_xml_parsers.xml").toString();
    private static final String CUSTOM_XML_TRACE_DEFINITION_ROOT_ELEMENT = Messages.CustomXmlTraceDefinition_definitionRootElement;
    private static final String DEFINITION_ELEMENT = Messages.CustomXmlTraceDefinition_definition;
    private static final String CATEGORY_ATTRIBUTE = Messages.CustomXmlTraceDefinition_category;
    private static final String TAG_ATTRIBUTE = Messages.CustomXmlTraceDefinition_tag;
    private static final String NAME_ATTRIBUTE = Messages.CustomXmlTraceDefinition_name;
    private static final String LOG_ENTRY_ATTRIBUTE = Messages.CustomXmlTraceDefinition_logEntry;
    private static final String EVENT_TYPE_ATTRIBUTE = Messages.CustomXmlTraceDefinition_eventType;
    private static final String TIME_STAMP_OUTPUT_FORMAT_ELEMENT = Messages.CustomXmlTraceDefinition_timestampOutputFormat;
    private static final String INPUT_ELEMENT_ELEMENT = Messages.CustomXmlTraceDefinition_inputElement;
    private static final String ATTRIBUTE_ELEMENT = Messages.CustomXmlTraceDefinition_attribute;
    private static final String INPUT_DATA_ELEMENT = Messages.CustomXmlTraceDefinition_inputData;
    private static final String ACTION_ATTRIBUTE = Messages.CustomXmlTraceDefinition_action;
    private static final String FORMAT_ATTRIBUTE = Messages.CustomXmlTraceDefinition_format;
    private static final String OUTPUT_COLUMN_ELEMENT = Messages.CustomXmlTraceDefinition_outputColumn;
    private static final String TRACE_CONTENT_TYPE_ATTRIBUTE_VALUE = "xml";
    public CustomXmlInputElement rootInputElement;

    public CustomXmlTraceDefinition() {
        this(CUSTOM_XML_CATEGORY, "", null, new ArrayList<CustomTraceDefinition.OutputColumn>(), "");
    }

    public CustomXmlTraceDefinition(String category, String traceType, CustomXmlInputElement rootElement, List<CustomTraceDefinition.OutputColumn> outputs, String timeStampOutputFormat) {
        this.categoryName = category;
        this.definitionName = traceType;
        this.rootInputElement = rootElement;
        this.outputs = outputs;
        this.timeStampOutputFormat = timeStampOutputFormat;
    }

    @Override
    public void save() {
        this.save(CUSTOM_XML_TRACE_DEFINITIONS_PATH_NAME);
    }

    @Override
    public void save(String path) {
        try {
            Element root;
            Element oldDefinitionElement;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(CustomXmlTraceDefinition.createEmptyEntityResolver());
            db.setErrorHandler(CustomXmlTraceDefinition.createErrorHandler());
            Document doc = null;
            File file = new File(path);
            if (file.canRead()) {
                doc = db.parse(file);
                if (!doc.getDocumentElement().getNodeName().equals(CUSTOM_XML_TRACE_DEFINITION_ROOT_ELEMENT)) {
                    Activator.logError(String.format("Error saving CustomXmlTraceDefinition: path=%s is not a valid custom parser file", path));
                    return;
                }
            } else {
                doc = db.newDocument();
                Element node = doc.createElement(CUSTOM_XML_TRACE_DEFINITION_ROOT_ELEMENT);
                doc.appendChild(node);
            }
            if ((oldDefinitionElement = CustomXmlTraceDefinition.findDefinitionElement(root = doc.getDocumentElement(), this.categoryName, this.definitionName)) != null) {
                root.removeChild(oldDefinitionElement);
            }
            Element definitionElement = doc.createElement(DEFINITION_ELEMENT);
            root.appendChild(definitionElement);
            definitionElement.setAttribute(CATEGORY_ATTRIBUTE, this.categoryName);
            definitionElement.setAttribute(NAME_ATTRIBUTE, this.definitionName);
            if (this.timeStampOutputFormat != null && !this.timeStampOutputFormat.isEmpty()) {
                Element formatElement = doc.createElement(TIME_STAMP_OUTPUT_FORMAT_ELEMENT);
                definitionElement.appendChild(formatElement);
                formatElement.appendChild(doc.createTextNode(this.timeStampOutputFormat));
            }
            if (this.rootInputElement != null) {
                definitionElement.appendChild(this.createInputElementElement(this.rootInputElement, doc));
            }
            if (this.outputs != null) {
                for (CustomTraceDefinition.OutputColumn output : this.outputs) {
                    Element outputColumnElement = doc.createElement(OUTPUT_COLUMN_ELEMENT);
                    definitionElement.appendChild(outputColumnElement);
                    outputColumnElement.setAttribute(TAG_ATTRIBUTE, output.tag.name());
                    outputColumnElement.setAttribute(NAME_ATTRIBUTE, output.name);
                }
            }
            Transformer transformer = XmlUtils.newSecureTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            Throwable throwable = null;
            Object var14_16 = null;
            try (FileWriter writer = new FileWriter(file);){
                writer.write(xmlString);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            TmfTraceType.addCustomTraceType(CustomXmlTrace.class, this.categoryName, this.definitionName);
        }
        catch (IOException | ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError | SAXException e) {
            Activator.logError("Error saving CustomXmlTraceDefinition: path=" + path, e);
        }
    }

    private Element createInputElementElement(CustomXmlInputElement inputElement, Document doc) {
        Element inputElementElement = doc.createElement(INPUT_ELEMENT_ELEMENT);
        inputElementElement.setAttribute(NAME_ATTRIBUTE, inputElement.getElementName());
        if (inputElement.isLogEntry()) {
            inputElementElement.setAttribute(LOG_ENTRY_ATTRIBUTE, Boolean.toString(inputElement.isLogEntry()));
        }
        if (inputElement.getEventType() != null) {
            inputElementElement.setAttribute(EVENT_TYPE_ATTRIBUTE, inputElement.getEventType());
        }
        if (inputElement.getParentElement() != null) {
            Element inputDataElement = doc.createElement(INPUT_DATA_ELEMENT);
            inputElementElement.appendChild(inputDataElement);
            inputDataElement.setAttribute(TAG_ATTRIBUTE, inputElement.getInputTag().name());
            inputDataElement.setAttribute(NAME_ATTRIBUTE, inputElement.getInputName());
            inputDataElement.setAttribute(ACTION_ATTRIBUTE, Integer.toString(inputElement.getInputAction()));
            String inputFormat = inputElement.getInputFormat();
            if (inputFormat != null && !inputFormat.isEmpty()) {
                inputDataElement.setAttribute(FORMAT_ATTRIBUTE, inputFormat);
            }
        }
        if (inputElement.getAttributes() != null) {
            for (CustomXmlInputAttribute attribute : inputElement.getAttributes()) {
                Element inputAttributeElement = doc.createElement(ATTRIBUTE_ELEMENT);
                inputElementElement.appendChild(inputAttributeElement);
                inputAttributeElement.setAttribute(NAME_ATTRIBUTE, attribute.getAttributeName());
                Element inputDataElement = doc.createElement(INPUT_DATA_ELEMENT);
                inputAttributeElement.appendChild(inputDataElement);
                inputDataElement.setAttribute(TAG_ATTRIBUTE, attribute.getInputTag().name());
                inputDataElement.setAttribute(NAME_ATTRIBUTE, attribute.getInputName());
                inputDataElement.setAttribute(ACTION_ATTRIBUTE, Integer.toString(attribute.getInputAction()));
                String inputFormat = attribute.getInputFormat();
                if (inputFormat == null || inputFormat.isEmpty()) continue;
                inputDataElement.setAttribute(FORMAT_ATTRIBUTE, inputFormat);
            }
        }
        if (inputElement.getChildElements() != null) {
            for (CustomXmlInputElement childInputElement : inputElement.getChildElements()) {
                inputElementElement.appendChild(this.createInputElementElement(childInputElement, doc));
            }
        }
        return inputElementElement;
    }

    public static CustomXmlTraceDefinition[] loadAll() {
        return CustomXmlTraceDefinition.loadAll(true);
    }

    public static CustomXmlTraceDefinition[] loadAll(boolean includeDefaults) {
        File defaultFile = new File(CUSTOM_XML_TRACE_DEFINITIONS_PATH_NAME);
        File legacyFileUI = new File(CUSTOM_XML_TRACE_DEFINITIONS_PATH_NAME_LEGACY_UI);
        File legacyFileCore = new File(CUSTOM_XML_TRACE_DEFINITIONS_PATH_NAME_LEGACY_CORE);
        if (!defaultFile.exists()) {
            if (legacyFileCore.exists()) {
                CustomXmlTraceDefinition.transferDefinitions(CUSTOM_XML_TRACE_DEFINITIONS_PATH_NAME_LEGACY_CORE);
            } else if (legacyFileUI.exists()) {
                CustomXmlTraceDefinition.transferDefinitions(CUSTOM_XML_TRACE_DEFINITIONS_PATH_NAME_LEGACY_UI);
            }
        }
        TreeSet<CustomXmlTraceDefinition> defs = new TreeSet<CustomXmlTraceDefinition>(Comparator.comparing(CustomTraceDefinition::getCategoryName).thenComparing(CustomTraceDefinition::getDefinitionName));
        defs.addAll(Arrays.asList(CustomXmlTraceDefinition.loadAll(CUSTOM_XML_TRACE_DEFINITIONS_PATH_NAME)));
        if (includeDefaults) {
            defs.addAll(Arrays.asList(CustomXmlTraceDefinition.loadAll(CUSTOM_XML_TRACE_DEFINITIONS_DEFAULT_PATH_NAME)));
            Collection<String> paths = CustomXmlTraceDefinition.getExtensionDefinitionsPaths(TRACE_CONTENT_TYPE_ATTRIBUTE_VALUE);
            for (String customTraceDefinitionPath : paths) {
                defs.addAll(Arrays.asList(CustomXmlTraceDefinition.loadAll(customTraceDefinitionPath)));
            }
        }
        return defs.toArray(new CustomXmlTraceDefinition[0]);
    }

    private static void transferDefinitions(String defFile) {
        CustomXmlTraceDefinition[] oldDefs;
        CustomXmlTraceDefinition[] customXmlTraceDefinitionArray = oldDefs = CustomXmlTraceDefinition.loadAll(defFile);
        int n = oldDefs.length;
        int n2 = 0;
        while (n2 < n) {
            CustomXmlTraceDefinition def = customXmlTraceDefinitionArray[n2];
            def.save();
            ++n2;
        }
    }

    public static CustomXmlTraceDefinition[] loadAll(String path) {
        File file = new File(path);
        if (!file.canRead()) {
            return new CustomXmlTraceDefinition[0];
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                return CustomXmlTraceDefinition.loadAll(fis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.logError("Error loading all in CustomXmlTraceDefinition: path=" + path, e);
            return new CustomXmlTraceDefinition[0];
        }
    }

    public static CustomXmlTraceDefinition[] loadAll(InputStream stream) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(CustomXmlTraceDefinition.createEmptyEntityResolver());
            db.setErrorHandler(CustomXmlTraceDefinition.createErrorHandler());
            Document doc = db.parse(stream);
            Element root = doc.getDocumentElement();
            if (!root.getNodeName().equals(CUSTOM_XML_TRACE_DEFINITION_ROOT_ELEMENT)) {
                return new CustomXmlTraceDefinition[0];
            }
            ArrayList<CustomXmlTraceDefinition> defList = new ArrayList<CustomXmlTraceDefinition>();
            NodeList nodeList = root.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                CustomXmlTraceDefinition def;
                Node node = nodeList.item(i);
                if (node instanceof Element && node.getNodeName().equals(DEFINITION_ELEMENT) && (def = CustomXmlTraceDefinition.extractDefinition((Element)node)) != null) {
                    defList.add(def);
                }
                ++i;
            }
            return defList.toArray(new CustomXmlTraceDefinition[0]);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Activator.logError("Error loading all in CustomXmlTraceDefinition: path=" + stream, e);
            return new CustomXmlTraceDefinition[0];
        }
    }

    public static CustomXmlTraceDefinition load(String categoryName, String definitionName) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            EntityResolver resolver = (publicId, systemId) -> {
                String empty = "";
                ByteArrayInputStream bais = new ByteArrayInputStream(empty.getBytes());
                return new InputSource(bais);
            };
            db.setEntityResolver(resolver);
            db.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException saxparseexception) throws SAXException {
                }

                @Override
                public void warning(SAXParseException saxparseexception) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException saxparseexception) throws SAXException {
                    throw saxparseexception;
                }
            });
            CustomXmlTraceDefinition value = CustomXmlTraceDefinition.lookupXmlDefinition(categoryName, definitionName, db, CUSTOM_XML_TRACE_DEFINITIONS_PATH_NAME);
            if (value == null) {
                value = CustomXmlTraceDefinition.lookupXmlDefinition(categoryName, definitionName, db, CUSTOM_XML_TRACE_DEFINITIONS_DEFAULT_PATH_NAME);
            }
            return value;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Activator.logError("Error loading CustomXmlTraceDefinition: definitionName=" + definitionName, e);
            return null;
        }
    }

    private static CustomXmlTraceDefinition lookupXmlDefinition(String categoryName, String definitionName, DocumentBuilder db, String source) throws SAXException, IOException {
        File file = new File(source);
        if (!file.exists()) {
            return null;
        }
        Document doc = db.parse(file);
        Element root = doc.getDocumentElement();
        if (!root.getNodeName().equals(CUSTOM_XML_TRACE_DEFINITION_ROOT_ELEMENT)) {
            return null;
        }
        Element definitionElement = CustomXmlTraceDefinition.findDefinitionElement(root, categoryName, definitionName);
        if (definitionElement != null) {
            return CustomXmlTraceDefinition.extractDefinition(definitionElement);
        }
        return null;
    }

    private static Element findDefinitionElement(Element root, String categoryName, String definitionName) {
        NodeList nodeList = root.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node instanceof Element && node.getNodeName().equals(DEFINITION_ELEMENT)) {
                Element element = (Element)node;
                String categoryAttribute = element.getAttribute(CATEGORY_ATTRIBUTE);
                if (categoryAttribute.isEmpty()) {
                    categoryAttribute = CUSTOM_XML_CATEGORY;
                }
                String nameAttribute = element.getAttribute(NAME_ATTRIBUTE);
                if (categoryName.equals(categoryAttribute) && definitionName.equals(nameAttribute)) {
                    return element;
                }
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CustomXmlTraceDefinition extractDefinition(Element definitionElement) {
        CustomXmlTraceDefinition def = new CustomXmlTraceDefinition();
        def.categoryName = definitionElement.getAttribute(CATEGORY_ATTRIBUTE);
        if (def.categoryName.isEmpty()) {
            def.categoryName = CUSTOM_XML_CATEGORY;
        }
        def.definitionName = definitionElement.getAttribute(NAME_ATTRIBUTE);
        if (def.definitionName.isEmpty()) {
            return null;
        }
        NodeList nodeList = definitionElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals(TIME_STAMP_OUTPUT_FORMAT_ELEMENT)) {
                Element formatElement = (Element)node;
                def.timeStampOutputFormat = formatElement.getTextContent();
            } else if (nodeName.equals(INPUT_ELEMENT_ELEMENT)) {
                CustomXmlInputElement inputElement = CustomXmlTraceDefinition.extractInputElement((Element)node);
                if (inputElement != null) {
                    if (def.rootInputElement != null) return null;
                    def.rootInputElement = inputElement;
                }
            } else if (nodeName.equals(OUTPUT_COLUMN_ELEMENT)) {
                Element outputColumnElement = (Element)node;
                Map.Entry<@NonNull CustomTraceDefinition.Tag, @NonNull String> entry = CustomXmlTraceDefinition.extractTagAndName(outputColumnElement, TAG_ATTRIBUTE, NAME_ATTRIBUTE);
                CustomTraceDefinition.OutputColumn outputColumn = new CustomTraceDefinition.OutputColumn(entry.getKey(), entry.getValue());
                def.outputs.add(outputColumn);
            }
            ++i;
        }
        return def;
    }

    private static CustomXmlInputElement extractInputElement(Element inputElementElement) {
        CustomXmlInputElement inputElement = new CustomXmlInputElement();
        inputElement.setElementName(inputElementElement.getAttribute(NAME_ATTRIBUTE));
        inputElement.setLogEntry(Boolean.toString(true).equals(inputElementElement.getAttribute(LOG_ENTRY_ATTRIBUTE)));
        String eventType = inputElementElement.getAttribute(EVENT_TYPE_ATTRIBUTE);
        inputElement.setEventType(eventType.isEmpty() ? null : eventType);
        NodeList nodeList = inputElementElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Element childInputElementElement;
            CustomXmlInputElement childInputElement;
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals(INPUT_DATA_ELEMENT)) {
                Element inputDataElement = (Element)node;
                Map.Entry<@NonNull CustomTraceDefinition.Tag, @NonNull String> entry = CustomXmlTraceDefinition.extractTagAndName(inputDataElement, TAG_ATTRIBUTE, NAME_ATTRIBUTE);
                inputElement.setInputTag(entry.getKey());
                inputElement.setInputName(entry.getValue());
                inputElement.setInputAction(Integer.parseInt(inputDataElement.getAttribute(ACTION_ATTRIBUTE)));
                inputElement.setInputFormat(inputDataElement.getAttribute(FORMAT_ATTRIBUTE));
            } else if (nodeName.equals(ATTRIBUTE_ELEMENT)) {
                Element attributeElement = (Element)node;
                String attributeName = attributeElement.getAttribute(NAME_ATTRIBUTE);
                NodeList attributeNodeList = attributeElement.getChildNodes();
                int j = 0;
                while (j < attributeNodeList.getLength()) {
                    Node attributeNode = attributeNodeList.item(j);
                    String attributeNodeName = attributeNode.getNodeName();
                    if (attributeNodeName.equals(INPUT_DATA_ELEMENT)) {
                        Element inputDataElement = (Element)attributeNode;
                        Map.Entry<@NonNull CustomTraceDefinition.Tag, @NonNull String> entry = CustomXmlTraceDefinition.extractTagAndName(inputDataElement, TAG_ATTRIBUTE, NAME_ATTRIBUTE);
                        int action = Integer.parseInt(inputDataElement.getAttribute(ACTION_ATTRIBUTE));
                        String format = inputDataElement.getAttribute(FORMAT_ATTRIBUTE);
                        inputElement.addAttribute(new CustomXmlInputAttribute(attributeName, entry.getKey(), entry.getValue(), action, format));
                        break;
                    }
                    ++j;
                }
            } else if (nodeName.equals(INPUT_ELEMENT_ELEMENT) && (childInputElement = CustomXmlTraceDefinition.extractInputElement(childInputElementElement = (Element)node)) != null) {
                inputElement.addChild(childInputElement);
            }
            ++i;
        }
        return inputElement;
    }

    public static void delete(String categoryName, String definitionName) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            EntityResolver resolver = (publicId, systemId) -> {
                String empty = "";
                ByteArrayInputStream bais = new ByteArrayInputStream(empty.getBytes());
                return new InputSource(bais);
            };
            db.setEntityResolver(resolver);
            db.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException saxparseexception) throws SAXException {
                }

                @Override
                public void warning(SAXParseException saxparseexception) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException saxparseexception) throws SAXException {
                    throw saxparseexception;
                }
            });
            File file = new File(CUSTOM_XML_TRACE_DEFINITIONS_PATH_NAME);
            Document doc = db.parse(file);
            Element root = doc.getDocumentElement();
            if (!root.getNodeName().equals(CUSTOM_XML_TRACE_DEFINITION_ROOT_ELEMENT)) {
                return;
            }
            Element definitionElement = CustomXmlTraceDefinition.findDefinitionElement(root, categoryName, definitionName);
            if (definitionElement != null) {
                root.removeChild(definitionElement);
            }
            Transformer transformer = XmlUtils.newSecureTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            Throwable throwable = null;
            Object var14_16 = null;
            try (FileWriter writer = new FileWriter(file);){
                writer.write(xmlString);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            TmfTraceType.removeCustomTraceType(CustomXmlTrace.class, categoryName, definitionName);
            TmfTraceType.addCustomTraceType(CustomXmlTrace.class, categoryName, definitionName);
        }
        catch (IOException | ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError | SAXException e) {
            Activator.logError("Error deleteing CustomXmlTraceDefinition: definitionName=" + definitionName, e);
        }
    }
}

