/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.histogram;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tracecompass.internal.tmf.ui.views.histogram.HistogramTimeAdapter;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTimestampFormatUpdateSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimePreferences;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampDelta;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentSignal;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfAbstractToolTipHandler;
import org.eclipse.tracecompass.tmf.ui.views.FormatTimeUtils;
import org.eclipse.tracecompass.tmf.ui.views.ITmfTimeAligned;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramBucket;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramDataModel;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramScaledData;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramView;
import org.eclipse.tracecompass.tmf.ui.views.histogram.IHistogramModelListener;
import org.eclipse.tracecompass.tmf.ui.views.histogram.Messages;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.ITimeDataProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphScale;

public abstract class Histogram
implements ControlListener,
PaintListener,
KeyListener,
MouseListener,
MouseMoveListener,
MouseTrackListener,
IHistogramModelListener {
    private static final int TIME_SCALE_HEIGHT = 27;
    private final Color fSelectionForegroundColor = Display.getCurrent().getSystemColor(9);
    private final Color fSelectionBackgroundColor = Display.getCurrent().getSystemColor(22);
    private final Color[] fHistoBarColors = new Color[]{new Color((Device)Display.getDefault(), 90, 90, 255), new Color((Device)Display.getDefault(), 0, 240, 0), new Color((Device)Display.getDefault(), 255, 0, 0), new Color((Device)Display.getDefault(), 0, 255, 255), new Color((Device)Display.getDefault(), 255, 80, 255), new Color((Device)Display.getDefault(), 200, 200, 0), new Color((Device)Display.getDefault(), 200, 150, 0), new Color((Device)Display.getDefault(), 150, 255, 150), new Color((Device)Display.getDefault(), 200, 80, 80), new Color((Device)Display.getDefault(), 30, 150, 150), new Color((Device)Display.getDefault(), 200, 200, 255), new Color((Device)Display.getDefault(), 0, 120, 0), new Color((Device)Display.getDefault(), 255, 150, 150), new Color((Device)Display.getDefault(), 140, 80, 140), new Color((Device)Display.getDefault(), 150, 100, 50), new Color((Device)Display.getDefault(), 255, 80, 80), new Color((Device)Display.getDefault(), 200, 200, 200), new Color((Device)Display.getDefault(), 255, 200, 80), new Color((Device)Display.getDefault(), 255, 255, 80), new Color((Device)Display.getDefault(), 255, 200, 200), new Color((Device)Display.getDefault(), 255, 200, 255), new Color((Device)Display.getDefault(), 255, 255, 200), new Color((Device)Display.getDefault(), 200, 255, 255)};
    private final Color fTimeRangeColor = new Color((Device)Display.getCurrent(), 255, 128, 0);
    private final Color fLostEventColor = new Color((Device)Display.getCurrent(), 208, 62, 120);
    protected static final int DRAG_NONE = 0;
    protected static final int DRAG_SELECTION = 1;
    protected static final int DRAG_RANGE = 2;
    protected static final int DRAG_ZOOM = 3;
    protected TmfView fParentView;
    private Composite fComposite;
    private Font fFont;
    private Label fMaxNbEventsLabel;
    protected Canvas fCanvas;
    protected final @NonNull HistogramDataModel fDataModel;
    protected HistogramScaledData fScaledData;
    protected long fCurrentEventTime = 0L;
    private long fSelectionBegin = 0L;
    private long fSelectionEnd = 0L;
    protected int fDragState = 0;
    protected int fDragButton = 0;
    private int fOffset = 0;
    static boolean showTraces = true;
    private boolean fSendTimeAlignSignals = false;
    private IStatusLineManager fStatusLineManager;
    private TimeGraphScale fTimeLineScale;
    private TimeGraphColorScheme fColorScheme;
    private TmfAbstractToolTipHandler fToolTipHandler = new TmfAbstractToolTipHandler(){

        @Override
        protected void fill(Control control, MouseEvent event, Point pt) {
            if ((Histogram.this.fDataModel.getNbEvents() != 0L || Histogram.this.fDataModel.getStartTime() < Histogram.this.fDataModel.getEndTime()) && Histogram.this.fScaledData != null && event.x >= 0 && event.x - Histogram.this.fOffset < Histogram.this.fScaledData.fWidth) {
                this.fillTooltip(event.x - Histogram.this.fOffset);
            }
            Histogram.this.fCanvas.setToolTipText(null);
        }

        private void fillTooltip(int index) {
            long startTime = Histogram.this.fScaledData.getBucketStartTime(index);
            if (startTime < 0L) {
                startTime = 0L;
            }
            long endTime = Histogram.this.fScaledData.getBucketEndTime(index);
            int nbEvents = index >= 0 ? Histogram.this.fScaledData.fData[index].getNbEvents() : 0;
            int selectionBeginBucket = Math.min(Histogram.this.fScaledData.fSelectionBeginBucket, Histogram.this.fScaledData.fSelectionEndBucket);
            int selectionEndBucket = Math.max(Histogram.this.fScaledData.fSelectionBeginBucket, Histogram.this.fScaledData.fSelectionEndBucket);
            if (selectionBeginBucket <= index && index <= selectionEndBucket && Histogram.this.fSelectionBegin != Histogram.this.fSelectionEnd) {
                long start = Math.abs(Histogram.this.fSelectionEnd - Histogram.this.fSelectionBegin);
                TmfTimestampDelta delta = new TmfTimestampDelta(start, -9);
                this.addItem(null, Messages.Histogram_selectionSpanToolTip, delta.toString());
            }
            this.addItem(null, TmfAbstractToolTipHandler.ToolTipString.fromString(Messages.Histogram_bucketRangeToolTip), TmfAbstractToolTipHandler.ToolTipString.fromTimestamp(NLS.bind((String)Messages.Histogram_timeRange, (Object)TmfTimestamp.fromNanos((long)startTime).toString(), (Object)TmfTimestamp.fromNanos((long)endTime).toString()), startTime));
            this.addItem(null, Messages.Histogram_eventCountToolTip, Long.toString(nbEvents));
            if (!HistogramScaledData.hideLostEvents) {
                int nbLostEvents = index >= 0 ? Histogram.this.fScaledData.fLostEventsData[index] : 0;
                this.addItem(null, Messages.Histogram_lostEventCountToolTip, Long.toString(nbLostEvents));
            }
        }
    };
    protected final String IMAGE_KEY = "double-buffer-image";

    public Histogram(TmfView view, Composite parent) {
        this(view, parent, false);
    }

    public Histogram(TmfView view, Composite parent, boolean sendTimeAlignSignals) {
        this.fParentView = view;
        this.fSendTimeAlignSignals = sendTimeAlignSignals;
        this.fColorScheme = new TimeGraphColorScheme();
        this.fDataModel = new HistogramDataModel();
        this.fDataModel.addHistogramListener(this);
        this.fComposite = this.createWidget(parent);
        this.clear();
        this.fCanvas.addControlListener((ControlListener)this);
        this.fCanvas.addPaintListener((PaintListener)this);
        this.fCanvas.addKeyListener((KeyListener)this);
        this.fCanvas.addMouseListener((MouseListener)this);
        this.fCanvas.addMouseTrackListener((MouseTrackListener)this);
        this.fCanvas.addMouseMoveListener((MouseMoveListener)this);
        this.fToolTipHandler.activateHoverHelp((Control)this.fCanvas);
        TmfSignalManager.register((Object)this);
    }

    public void dispose() {
        TmfSignalManager.deregister((Object)this);
        this.fLostEventColor.dispose();
        Color[] colorArray = this.fHistoBarColors;
        int n = this.fHistoBarColors.length;
        int n2 = 0;
        while (n2 < n) {
            Color c = colorArray[n2];
            c.dispose();
            ++n2;
        }
        this.fTimeRangeColor.dispose();
        this.fFont.dispose();
        this.fDataModel.removeHistogramListener(this);
        this.fDataModel.dispose();
    }

    private Composite createWidget(Composite parent) {
        this.fFont = Histogram.adjustFont(parent);
        Composite composite = new Composite(parent, 4);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.fMaxNbEventsLabel = new Label(composite, 131072);
        this.fMaxNbEventsLabel.setFont(this.fFont);
        this.fMaxNbEventsLabel.setText("0");
        this.fMaxNbEventsLabel.setLayoutData((Object)GridDataFactory.fillDefaults().align(131072, 128).create());
        Composite canvasComposite = new Composite(composite, 2048);
        canvasComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        canvasComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(1, 1).create());
        this.fCanvas = new Canvas(canvasComposite, 0x20000000);
        this.fCanvas.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.fCanvas.addDisposeListener(e -> {
            Object image = this.fCanvas.getData("double-buffer-image");
            if (image instanceof Image) {
                ((Image)image).dispose();
            }
        });
        this.fTimeLineScale = new TimeGraphScale(canvasComposite, this.fColorScheme, 1024);
        this.fTimeLineScale.setLayoutData(GridDataFactory.fillDefaults().grab(true, false).create());
        this.fTimeLineScale.setHeight(27);
        this.fTimeLineScale.setTimeProvider(new HistogramTimeAdapter(this.fDataModel));
        this.updateTimeFormat();
        return composite;
    }

    private static Font adjustFont(Composite composite) {
        int fontSizeAdjustment = -2;
        Font font = composite.getFont();
        FontData fontData = font.getFontData()[0];
        return new Font(font.getDevice(), fontData.getName(), fontData.getHeight() + -2, fontData.getStyle());
    }

    public void setStatusLineManager(IStatusLineManager statusLineManager) {
        if (this.fStatusLineManager != null && statusLineManager == null) {
            this.fStatusLineManager.setMessage("");
        }
        this.fStatusLineManager = statusLineManager;
    }

    public long getStartTime() {
        return this.fDataModel.getFirstBucketTime();
    }

    public long getEndTime() {
        return this.fDataModel.getEndTime();
    }

    public long getTimeLimit() {
        return this.fDataModel.getTimeLimit();
    }

    public HistogramDataModel getDataModel() {
        return this.fDataModel;
    }

    void setMaxNbEvents(long maxNbEvents) {
        this.fMaxNbEventsLabel.setText(Long.toString(maxNbEvents));
        this.fMaxNbEventsLabel.getParent().layout();
        this.fCanvas.redraw();
    }

    public boolean showTraces() {
        return showTraces && this.fDataModel.getNbTraces() < this.getMaxNbTraces();
    }

    public int getMaxNbTraces() {
        return this.fHistoBarColors.length;
    }

    public Color getTraceColor(int traceIndex) {
        return this.fHistoBarColors[traceIndex % this.fHistoBarColors.length];
    }

    public void updateTimeRange(long startTime, long endTime) {
        if (this.fDragState == 0) {
            ((HistogramView)this.fParentView).updateTimeRange(startTime, endTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.fDataModel.clear();
        if (this.fDragState == 1) {
            this.updateSelectionTime();
        }
        this.fDragState = 0;
        this.fDragButton = 0;
        HistogramDataModel histogramDataModel = this.fDataModel;
        synchronized (histogramDataModel) {
            this.fScaledData = null;
        }
    }

    public void setSelection(long beginTime, long endTime) {
        this.fSelectionBegin = beginTime > 0L ? beginTime : 0L;
        this.fSelectionEnd = endTime > 0L ? endTime : 0L;
        this.fDataModel.setSelectionNotifyListeners(beginTime, endTime);
    }

    public synchronized long getTimestamp(int offset) {
        HistogramScaledData scaledData = this.fScaledData;
        if (scaledData != null) {
            return scaledData.fFirstBucketTime + Math.round(scaledData.fBucketDuration * (double)offset);
        }
        return 0L;
    }

    public synchronized int getOffset(long timestamp) {
        if (timestamp < this.fDataModel.getFirstBucketTime() || timestamp > this.fDataModel.getEndTime()) {
            return -1;
        }
        return (int)((double)(timestamp - this.fDataModel.getFirstBucketTime()) / this.fScaledData.fBucketDuration);
    }

    protected void setOffset(int offset) {
        this.fOffset = offset;
    }

    protected void moveCursor(int keyCode) {
        switch (keyCode) {
            case 0x1000007: {
                this.fScaledData.fSelectionBeginBucket = 0;
                break;
            }
            case 0x1000008: {
                this.fScaledData.fSelectionBeginBucket = this.fScaledData.fWidth - 1;
                break;
            }
            case 0x1000004: {
                long prevStartTime = this.getTimestamp(this.fScaledData.fSelectionBeginBucket);
                int index = Math.max(0, Math.min(this.fScaledData.fWidth - 1, this.fScaledData.fSelectionBeginBucket + 1));
                while (index < this.fScaledData.fWidth && (this.fScaledData.fData[index].isEmpty() || prevStartTime == this.getTimestamp(index))) {
                    prevStartTime = this.getTimestamp(index);
                    ++index;
                }
                if (index >= this.fScaledData.fWidth) {
                    index = this.fScaledData.fWidth - 1;
                }
                this.fScaledData.fSelectionBeginBucket = index;
                break;
            }
            case 0x1000003: {
                long prevEndTime = this.getTimestamp(this.fScaledData.fSelectionBeginBucket + 1);
                int index = Math.max(0, Math.min(this.fScaledData.fWidth - 1, this.fScaledData.fSelectionBeginBucket - 1));
                while (index >= 0 && (this.fScaledData.fData[index].isEmpty() || prevEndTime == this.getTimestamp(index + 1))) {
                    prevEndTime = this.getTimestamp(index + 1);
                    --index;
                }
                if (index <= 0) {
                    index = 0;
                }
                this.fScaledData.fSelectionBeginBucket = index;
                break;
            }
            default: {
                return;
            }
        }
        this.fScaledData.fSelectionEndBucket = this.fScaledData.fSelectionBeginBucket;
        this.fSelectionEnd = this.fSelectionBegin = this.getTimestamp(this.fScaledData.fSelectionBeginBucket);
        this.updateSelectionTime();
    }

    @Override
    public void modelUpdated() {
        if (!this.fCanvas.isDisposed() && this.fCanvas.getDisplay() != null) {
            this.fCanvas.getDisplay().asyncExec(() -> {
                if (!this.fCanvas.isDisposed()) {
                    int canvasWidth = this.fCanvas.getBounds().width;
                    int canvasHeight = this.fCanvas.getBounds().height;
                    if (canvasWidth <= 0 || canvasHeight <= 0) {
                        return;
                    }
                    this.fDataModel.setSelection(this.fSelectionBegin, this.fSelectionEnd);
                    this.fScaledData = this.fDataModel.scaleTo(canvasWidth, canvasHeight, 1);
                    HistogramDataModel histogramDataModel = this.fDataModel;
                    synchronized (histogramDataModel) {
                        if (this.fScaledData != null) {
                            this.fCanvas.redraw();
                            HistogramTimeAdapter adapter = (HistogramTimeAdapter)this.fTimeLineScale.getTimeProvider();
                            adapter.setTimeSpace(canvasWidth);
                            long maxNbEvents = HistogramScaledData.hideLostEvents ? this.fScaledData.fMaxValue : this.fScaledData.fMaxCombinedValue;
                            String old = this.fMaxNbEventsLabel.getText();
                            this.fMaxNbEventsLabel.setText(Long.toString(maxNbEvents));
                            GridData gd = (GridData)this.fMaxNbEventsLabel.getLayoutData();
                            gd.widthHint = Math.max(gd.widthHint, this.fMaxNbEventsLabel.computeSize((int)-1, (int)-1).x);
                            this.fMaxNbEventsLabel.getParent().layout();
                            if (old.length() < this.fMaxNbEventsLabel.getText().length() && this.fSendTimeAlignSignals && this.fParentView instanceof ITmfTimeAligned) {
                                TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimeViewAlignmentSignal(this, ((ITmfTimeAligned)((Object)this.fParentView)).getTimeViewAlignmentInfo(), true));
                            }
                        }
                        this.fTimeLineScale.redraw();
                    }
                }
            });
        }
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        this.fCanvas.addMouseWheelListener(listener);
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        this.fCanvas.removeMouseWheelListener(listener);
    }

    public void addKeyListener(KeyListener listener) {
        this.fCanvas.addKeyListener(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.fCanvas.removeKeyListener(listener);
    }

    private void updateSelectionTime() {
        if (this.fSelectionBegin > this.fSelectionEnd) {
            long end = this.fSelectionBegin;
            this.fSelectionBegin = this.fSelectionEnd;
            this.fSelectionEnd = end;
        }
        ((HistogramView)this.fParentView).updateSelectionTime(this.fSelectionBegin, this.fSelectionEnd);
    }

    public void paintControl(PaintEvent event) {
        int canvasWidth = this.fCanvas.getBounds().width;
        int canvasHeight = this.fCanvas.getBounds().height;
        if (canvasWidth <= 0 || canvasHeight <= 0) {
            return;
        }
        Image image = (Image)this.fCanvas.getData("double-buffer-image");
        if (image == null || image.getBounds().width != canvasWidth || image.getBounds().height != canvasHeight) {
            if (image != null) {
                image.dispose();
            }
            image = new Image((Device)event.display, canvasWidth, canvasHeight);
            this.fCanvas.setData("double-buffer-image", (Object)image);
        }
        GC imageGC = new GC((Drawable)image);
        this.formatImage(imageGC, image);
        event.gc.drawImage(image, 0, 0);
        imageGC.dispose();
        this.fTimeLineScale.redraw();
    }

    private void formatImage(GC imageGC, Image image) {
        if (this.fScaledData == null) {
            return;
        }
        HistogramScaledData scaledData = new HistogramScaledData(this.fScaledData);
        try {
            int endBucket;
            int height = image.getBounds().height;
            imageGC.setBackground(this.fTimeLineScale.getColorScheme().getColor(32));
            imageGC.fillRectangle(0, 0, image.getBounds().width + 1, image.getBounds().height + 1);
            int limit = scaledData.fWidth;
            double factor = HistogramScaledData.hideLostEvents ? scaledData.fScalingFactor : scaledData.fScalingFactorCombined;
            boolean showTracesColors = this.showTraces();
            int i = 0;
            while (i < limit) {
                HistogramBucket hb = scaledData.fData[i];
                int totalNbEvents = hb.getNbEvents();
                int value = (int)Math.ceil((double)totalNbEvents * factor);
                int x = i + this.fOffset;
                if (!HistogramScaledData.hideLostEvents) {
                    imageGC.setForeground(this.fLostEventColor);
                    int lostEventValue = (int)Math.ceil((double)scaledData.fLostEventsData[i] * factor);
                    if (lostEventValue != 0) {
                        imageGC.drawLine(x, height - value - lostEventValue, x, height - value);
                    }
                }
                if (!hb.isEmpty()) {
                    if (showTracesColors) {
                        int traceIndex = 0;
                        while (traceIndex < hb.getNbTraces()) {
                            int nbEventsForTrace = hb.getNbEvent(traceIndex);
                            if (nbEventsForTrace > 0) {
                                Color c = this.fHistoBarColors[traceIndex % this.fHistoBarColors.length];
                                imageGC.setForeground(c);
                                imageGC.drawLine(x, height - value, x, height);
                                value = (int)Math.ceil((double)(totalNbEvents -= nbEventsForTrace) * scaledData.fScalingFactor);
                            }
                            ++traceIndex;
                        }
                    } else {
                        Color c = this.fHistoBarColors[0];
                        imageGC.setForeground(c);
                        imageGC.drawLine(x, height - value, x, height);
                    }
                }
                ++i;
            }
            int alpha = imageGC.getAlpha();
            imageGC.setAlpha(100);
            imageGC.setForeground(this.fSelectionForegroundColor);
            imageGC.setBackground(this.fSelectionBackgroundColor);
            int beginBucket = scaledData.fSelectionBeginBucket + this.fOffset;
            if (beginBucket >= 0 && beginBucket < limit) {
                imageGC.drawLine(beginBucket, 0, beginBucket, height);
            }
            if ((endBucket = scaledData.fSelectionEndBucket + this.fOffset) >= 0 && endBucket < limit && endBucket != beginBucket) {
                imageGC.drawLine(endBucket, 0, endBucket, height);
            }
            if (Math.abs(endBucket - beginBucket) > 1) {
                if (endBucket > beginBucket) {
                    imageGC.fillRectangle(beginBucket + 1, 0, endBucket - beginBucket - 1, height);
                } else {
                    imageGC.fillRectangle(endBucket + 1, 0, beginBucket - endBucket - 1, height);
                }
            }
            imageGC.setAlpha(alpha);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void drawTimeRangeWindow(GC imageGC, long rangeStartTime, long rangeDuration) {
        if (this.fScaledData == null) {
            return;
        }
        double bucketSpan = this.fScaledData.fBucketDuration;
        long startTime = Math.min(rangeStartTime, rangeStartTime + rangeDuration);
        double rangeWidth = (double)Math.abs(rangeDuration) / bucketSpan;
        int left = (int)((double)(startTime - this.fDataModel.getFirstBucketTime()) / bucketSpan);
        int right = (int)((double)left + rangeWidth);
        int center = (left + right) / 2;
        int height = this.fCanvas.getSize().y;
        int arc = Math.min(15, (int)rangeWidth);
        imageGC.setForeground(this.fTimeRangeColor);
        imageGC.setLineWidth(1);
        imageGC.setLineStyle(1);
        imageGC.drawRoundRectangle(left, 0, (int)rangeWidth, height - 1, arc, arc);
        imageGC.setBackground(this.fTimeRangeColor);
        imageGC.setAlpha(35);
        imageGC.fillRoundRectangle(left + 1, 1, (int)rangeWidth - 1, height - 2, arc, arc);
        imageGC.setAlpha(255);
        imageGC.setForeground(this.fTimeRangeColor);
        imageGC.setLineWidth(1);
        imageGC.setLineStyle(1);
        int chHalfWidth = (rangeWidth < 60.0 ? (int)(rangeWidth * 2.0 / 3.0) : 40) / 2;
        imageGC.drawLine(center - chHalfWidth, height / 2, center + chHalfWidth, height / 2);
        imageGC.drawLine(center, height / 2 - chHalfWidth, center, height / 2 + chHalfWidth);
    }

    public int getPointAreaOffset() {
        Point absCanvas = this.fCanvas.toDisplay(0, 0);
        Point viewPoint = this.fComposite.getParent().toDisplay(0, 0);
        return absCanvas.x - viewPoint.x;
    }

    public int getPointAreaWidth() {
        if (!this.fCanvas.isDisposed()) {
            return this.fCanvas.getBounds().width;
        }
        return 0;
    }

    public void keyPressed(KeyEvent event) {
        this.moveCursor(event.keyCode);
    }

    public void keyReleased(KeyEvent event) {
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseDown(MouseEvent event) {
        if (this.fScaledData != null && event.button == 1 && this.fDragState == 0 && (this.fDataModel.getNbEvents() != 0L || this.fDataModel.getStartTime() < this.fDataModel.getEndTime())) {
            this.fDragState = 1;
            this.fDragButton = event.button;
            if ((event.stateMask & SWT.MODIFIER_MASK) == 131072) {
                if (Math.abs(event.x - this.fScaledData.fSelectionBeginBucket) < Math.abs(event.x - this.fScaledData.fSelectionEndBucket)) {
                    this.fScaledData.fSelectionBeginBucket = this.fScaledData.fSelectionEndBucket;
                    this.fSelectionBegin = this.fSelectionEnd;
                }
                this.fSelectionEnd = this.getTimestamp(event.x);
                this.fScaledData.fSelectionEndBucket = event.x;
            } else {
                this.fSelectionBegin = Math.min(this.getTimestamp(event.x), this.getEndTime());
                this.fScaledData.fSelectionBeginBucket = event.x;
                this.fSelectionEnd = this.fSelectionBegin;
                this.fScaledData.fSelectionEndBucket = this.fScaledData.fSelectionBeginBucket;
            }
            this.updateStatusLine(this.fSelectionBegin, this.fSelectionEnd, this.getTimestamp(event.x));
            this.fCanvas.redraw();
            this.fTimeLineScale.redraw();
        }
    }

    public void mouseUp(MouseEvent event) {
        if (this.fDragState == 1 && event.button == this.fDragButton) {
            this.fDragState = 0;
            this.fDragButton = 0;
            this.updateSelectionTime();
        }
        this.updateStatusLine(this.fSelectionBegin, this.fSelectionEnd, this.getTimestamp(event.x));
    }

    public void mouseMove(MouseEvent event) {
        if (this.fDragState == 1 && (this.fDataModel.getNbEvents() != 0L || this.fDataModel.getStartTime() < this.fDataModel.getEndTime())) {
            this.fSelectionEnd = Math.max(this.getStartTime(), Math.min(this.getEndTime(), this.getTimestamp(event.x)));
            this.fScaledData.fSelectionEndBucket = Math.max(0, Math.min(this.fScaledData.fWidth - 1, event.x));
            this.fCanvas.redraw();
            this.fTimeLineScale.redraw();
        }
        this.updateStatusLine(this.fSelectionBegin, this.fSelectionEnd, this.getTimestamp(event.x));
    }

    public void mouseEnter(MouseEvent event) {
        this.updateStatusLine(this.fSelectionBegin, this.fSelectionEnd, this.getTimestamp(event.x));
    }

    public void mouseExit(MouseEvent event) {
        this.updateStatusLine(this.fSelectionBegin, this.fSelectionEnd, -1L);
    }

    public void mouseHover(MouseEvent event) {
    }

    private void updateStatusLine(long startTime, long endTime, long cursorTime) {
        ITimeDataProvider timeProvider = this.fTimeLineScale.getTimeProvider();
        if (timeProvider.getTime0() == timeProvider.getTime1()) {
            return;
        }
        FormatTimeUtils.TimeFormat timeFormat = timeProvider.getTimeFormat().convert();
        boolean isCalendar = timeFormat == FormatTimeUtils.TimeFormat.CALENDAR;
        StringBuilder message = new StringBuilder();
        String spaces = "     ";
        if (cursorTime >= 0L) {
            message.append("T: ");
            if (isCalendar) {
                message.append(String.valueOf(FormatTimeUtils.formatDate(cursorTime)) + ' ');
            }
            message.append(FormatTimeUtils.formatTime(cursorTime, timeFormat, FormatTimeUtils.Resolution.NANOSEC));
            message.append(spaces);
        }
        if (startTime == endTime) {
            message.append("T1: ");
            if (isCalendar) {
                message.append(String.valueOf(FormatTimeUtils.formatDate(startTime)) + ' ');
            }
            message.append(FormatTimeUtils.formatTime(startTime, timeFormat, FormatTimeUtils.Resolution.NANOSEC));
        } else {
            message.append("T1: ");
            if (isCalendar) {
                message.append(String.valueOf(FormatTimeUtils.formatDate(startTime)) + ' ');
            }
            message.append(FormatTimeUtils.formatTime(startTime, timeFormat, FormatTimeUtils.Resolution.NANOSEC));
            message.append(spaces);
            message.append("T2: ");
            if (isCalendar) {
                message.append(String.valueOf(FormatTimeUtils.formatDate(endTime)) + ' ');
            }
            message.append(FormatTimeUtils.formatTime(endTime, timeFormat, FormatTimeUtils.Resolution.NANOSEC));
            message.append(spaces);
            message.append("\u0394: " + FormatTimeUtils.formatDelta(endTime - startTime, timeFormat, FormatTimeUtils.Resolution.NANOSEC));
        }
        this.fStatusLineManager.setMessage(message.toString());
    }

    public void controlMoved(ControlEvent event) {
        this.fDataModel.complete();
    }

    public void controlResized(ControlEvent event) {
        this.fDataModel.complete();
    }

    @TmfSignalHandler
    public void timestampFormatUpdated(TmfTimestampFormatUpdateSignal signal) {
        this.updateTimeFormat();
        this.fTimeLineScale.redraw();
        this.fComposite.layout();
    }

    private void updateTimeFormat() {
        HistogramTimeAdapter timeProvider = (HistogramTimeAdapter)this.fTimeLineScale.getTimeProvider();
        String datime = (String)TmfTimePreferences.getPreferenceMap().get("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime");
        if ("TTT".equals(datime)) {
            timeProvider.setTimeFormat(FormatTimeUtils.TimeFormat.RELATIVE);
        } else {
            timeProvider.setTimeFormat(FormatTimeUtils.TimeFormat.CALENDAR);
        }
    }
}

