/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.registry.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.InvalidRegistryObjectException;

public class ExtensionPointTracker {
    private static final Listener NULL_LISTENER = new Listener(){

        public void added(IExtension extension) {
        }

        public void removed(IExtension extension) {
        }
    };
    private final IExtensionRegistry registry;
    private final String extensionPointId;
    final String namespace;
    final String simpleIdentifier;
    private final Set extensionCache = new HashSet();
    protected final Listener listener;
    private final RegistryChangeListener registryChangeListener = new RegistryChangeListener();
    private boolean closed = true;

    public ExtensionPointTracker(IExtensionRegistry registry, String extensionPointId, Listener listener) {
        this.registry = registry;
        this.extensionPointId = extensionPointId;
        Listener listener2 = this.listener = listener != null ? listener : NULL_LISTENER;
        if (extensionPointId == null || -1 == extensionPointId.indexOf(46)) {
            throw new IllegalArgumentException("Unexpected Extension Point Identifier: " + extensionPointId);
        }
        int lastDotIndex = extensionPointId.lastIndexOf(46);
        this.namespace = extensionPointId.substring(0, lastDotIndex);
        this.simpleIdentifier = extensionPointId.substring(lastDotIndex + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        IExtension[] extensions = null;
        ExtensionPointTracker extensionPointTracker = this;
        synchronized (extensionPointTracker) {
            if (!this.closed) {
                return;
            }
            this.registry.addRegistryChangeListener((IRegistryChangeListener)this.registryChangeListener, this.namespace);
            try {
                IExtensionPoint point = this.registry.getExtensionPoint(this.extensionPointId);
                if (point != null) {
                    extensions = point.getExtensions();
                    this.extensionCache.addAll(Arrays.asList(extensions));
                }
                this.closed = false;
            }
            catch (InvalidRegistryObjectException e) {
                this.registry.removeRegistryChangeListener((IRegistryChangeListener)this.registryChangeListener);
                throw e;
            }
        }
        if (extensions != null) {
            int i = 0;
            while (i < extensions.length) {
                this.listener.added(extensions[i]);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        IExtension[] extensions = null;
        ExtensionPointTracker extensionPointTracker = this;
        synchronized (extensionPointTracker) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.registry.removeRegistryChangeListener((IRegistryChangeListener)this.registryChangeListener);
            extensions = this.getExtensions();
            this.extensionCache.clear();
        }
        int i = 0;
        while (i < extensions.length) {
            this.listener.removed(extensions[i]);
            ++i;
        }
    }

    synchronized boolean removeExtension(IExtension extension) {
        if (this.closed) {
            return false;
        }
        return this.extensionCache.remove(extension);
    }

    synchronized boolean addExtension(IExtension extension) {
        if (this.closed) {
            return false;
        }
        return this.extensionCache.add(extension);
    }

    public synchronized IExtension[] getExtensions() {
        return this.extensionCache.toArray(new IExtension[this.extensionCache.size()]);
    }

    public static interface Listener {
        public void added(IExtension var1);

        public void removed(IExtension var1);
    }

    class RegistryChangeListener
    implements IRegistryChangeListener {
        RegistryChangeListener() {
        }

        public void registryChanged(IRegistryChangeEvent event) {
            IExtensionDelta[] deltas = event.getExtensionDeltas(ExtensionPointTracker.this.namespace, ExtensionPointTracker.this.simpleIdentifier);
            int i = 0;
            while (i < deltas.length) {
                IExtensionDelta delta = deltas[i];
                IExtension extension = delta.getExtension();
                switch (delta.getKind()) {
                    case 1: {
                        if (!ExtensionPointTracker.this.addExtension(extension)) break;
                        ExtensionPointTracker.this.listener.added(extension);
                        break;
                    }
                    case 2: {
                        if (!ExtensionPointTracker.this.removeExtension(extension)) break;
                        ExtensionPointTracker.this.listener.removed(extension);
                    }
                }
                ++i;
            }
        }
    }
}

