/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.parser.c;

import java.util.Map;
import org.eclipse.cdt.core.dom.parser.GNUScannerExtensionConfiguration;
import org.eclipse.cdt.core.parser.GCCKeywords;
import org.eclipse.cdt.core.parser.IScannerInfo;

public class GCCScannerExtensionConfiguration
extends GNUScannerExtensionConfiguration {
    private static final int VERSION_4_2 = GCCScannerExtensionConfiguration.version(4, 2);
    private static final int VERSION_4_7 = GCCScannerExtensionConfiguration.version(4, 7);
    private static GCCScannerExtensionConfiguration CONFIG = new GCCScannerExtensionConfiguration();
    private static GCCScannerExtensionConfiguration CONFIG_4_2 = new GCCScannerExtensionConfiguration(VERSION_4_2);
    private static GCCScannerExtensionConfiguration CONFIG_4_7 = new GCCScannerExtensionConfiguration(VERSION_4_7);

    public static GCCScannerExtensionConfiguration getInstance() {
        return CONFIG;
    }

    public static GCCScannerExtensionConfiguration getInstance(IScannerInfo info) {
        if (info != null) {
            try {
                Map<String, String> definedSymbols = info.getDefinedSymbols();
                int major = Integer.valueOf(definedSymbols.get("__GNUC__"));
                int minor = Integer.valueOf(definedSymbols.get("__GNUC_MINOR__"));
                int version = GCCScannerExtensionConfiguration.version(major, minor);
                if (version >= VERSION_4_7) {
                    return CONFIG_4_7;
                }
                if (version >= VERSION_4_2) {
                    return CONFIG_4_2;
                }
            }
            catch (Exception exception) {}
        }
        return CONFIG;
    }

    public GCCScannerExtensionConfiguration() {
        this(0);
    }

    public GCCScannerExtensionConfiguration(int version) {
        this.addMacro("__null", "(void *)0");
        this.addMacro("__builtin_offsetof(T,m)", "((size_t) &((T *)0)->m)");
        if (version >= VERSION_4_2) {
            this.addKeyword(GCCKeywords.cp_decimal32, 179);
            this.addKeyword(GCCKeywords.cp_decimal64, 180);
            this.addKeyword(GCCKeywords.cp_decimal128, 181);
        }
        if (version >= VERSION_4_7) {
            this.addKeyword(GCCKeywords.cp__float128, 176);
            this.addKeyword(GCCKeywords.cp__int128, 175);
        }
    }

    @Override
    public boolean supportMinAndMaxOperators() {
        return false;
    }
}

