/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser;

import java.io.File;
import java.io.IOException;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ICodeReaderCache;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.internal.core.parser.CodeReaderLRUCache;
import org.eclipse.cdt.internal.core.parser.InternalParserUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

@Deprecated
public class CodeReaderCache
implements ICodeReaderCache {
    public static final String CODE_READER_BUFFER = "org.eclipse.cdt.core.codeReaderCache";
    public static final int DEFAULT_CACHE_SIZE_IN_MB = 64;
    public static final String DEFAULT_CACHE_SIZE_IN_MB_STRING = String.valueOf(64);
    private static final int MB_TO_KB_FACTOR = 1024;
    private CodeReaderLRUCache cache = null;
    private final IResourceChangeListener listener = new UpdateCodeReaderCacheListener(this);

    public CodeReaderCache(int size) {
        this.cache = new CodeReaderLRUCache(size * 1024);
    }

    protected void finalize() throws Throwable {
        this.flush();
        super.finalize();
    }

    @Override
    public synchronized CodeReader get(String key) {
        CodeReader result = null;
        if (this.cache.getSpaceLimit() > 0) {
            result = this.cache.get(key);
        }
        if (result != null) {
            return result;
        }
        File jfile = new File(key);
        if (!jfile.exists()) {
            return null;
        }
        try {
            IResource file = ParserUtil.getResourceForFilename(key);
            if (file instanceof IFile) {
                key = InternalParserUtil.normalizePath(key, (IFile)file);
                result = InternalParserUtil.createWorkspaceFileReader(key, (IFile)file, this.cache);
            }
            result = InternalParserUtil.createExternalFileReader(key, this.cache);
            if (this.cache.getSpaceLimit() > 0) {
                this.put(result);
            }
            return result;
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {
        }
        catch (IllegalStateException illegalStateException) {}
        return null;
    }

    @Override
    public CodeReader get(String key, IIndexFileLocation ifl) throws CoreException, IOException {
        CodeReader result = null;
        if (this.cache.getSpaceLimit() > 0) {
            result = this.cache.get(key);
        }
        if (result != null) {
            return result;
        }
        result = InternalParserUtil.createCodeReader(ifl, this.cache);
        if (this.cache.getSpaceLimit() > 0) {
            this.put(result);
        }
        return result;
    }

    private synchronized CodeReader put(CodeReader value) {
        if (value == null) {
            return null;
        }
        if (this.cache.isEmpty() && ResourcesPlugin.getWorkspace() != null) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.listener);
        }
        return this.cache.put(String.valueOf(value.filename), value);
    }

    public void setCacheSize(int size) {
        this.cache.setSpaceLimit(size * 1024);
    }

    @Override
    public synchronized CodeReader remove(String key) {
        CodeReader removed = this.cache.remove(key);
        if (this.cache.isEmpty() && ResourcesPlugin.getWorkspace() != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
        }
        return removed;
    }

    @Override
    public int getCurrentSpace() {
        return this.cache.getCurrentSpace();
    }

    @Override
    public void flush() {
        this.cache.flush();
        if (ResourcesPlugin.getWorkspace() != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
        }
    }

    private class UpdateCodeReaderCacheListener
    implements IResourceChangeListener {
        ICodeReaderCache c = null;

        public UpdateCodeReaderCacheListener(ICodeReaderCache cache) {
            this.c = cache;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (this.c instanceof CodeReaderCache) {
                new RemoveCacheJob(this.c, event).schedule();
            }
        }

        private class RemoveCacheJob
        extends Job {
            private static final String REMOVE_CACHE = "Remove Cache";
            ICodeReaderCache cache1;
            IResourceChangeEvent event;

            public RemoveCacheJob(ICodeReaderCache cache, IResourceChangeEvent event) {
                super(REMOVE_CACHE);
                this.cache1 = null;
                this.event = null;
                this.cache1 = cache;
                this.event = event;
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (this.event.getSource() instanceof IWorkspace && this.event.getDelta() != null) {
                    this.removeKeys(this.event.getDelta().getAffectedChildren());
                }
                this.event = null;
                return Status.OK_STATUS;
            }

            private void removeKeys(IResourceDelta[] deltas) {
                IResourceDelta[] iResourceDeltaArray = deltas;
                int n = deltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta delta = iResourceDeltaArray[n2];
                    if (delta.getResource().getType() == 4 || delta.getResource().getType() == 2) {
                        this.removeKeys(delta.getAffectedChildren());
                    } else if (delta.getResource() instanceof IFile && ((IFile)delta.getResource()).getLocation() != null) {
                        this.removeKey(((IFile)delta.getResource()).getLocation().toOSString());
                    }
                    ++n2;
                }
            }

            private void removeKey(String key) {
                if (key != null && this.cache1 != null) {
                    this.cache1.remove(key);
                }
            }
        }
    }
}

