/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.internal.core.dom.parser.SizeofCalculator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public abstract class ArithmeticConversion {
    private static final int DOMAIN_FLAGS = 48;

    protected abstract IBasicType createBasicType(IBasicType.Kind var1, int var2);

    public final IType convertOperandTypes(int operator, IType op1, IType op2) {
        op1 = SemanticUtil.getNestedType(op1, 1);
        op2 = SemanticUtil.getNestedType(op2, 1);
        if (!this.isArithmeticOrUnscopedEnum(op1) || !this.isArithmeticOrUnscopedEnum(op2)) {
            return null;
        }
        switch (operator) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 32: 
            case 33: {
                return this.convert(op1, op2);
            }
            case 6: 
            case 7: {
                return this.promote(op1, this.getDomain(op1));
            }
        }
        return null;
    }

    public final IType promoteType(IType type) {
        if (!this.isIntegralOrUnscopedEnum(type)) {
            return null;
        }
        return this.promote(type, this.getDomain(type));
    }

    private boolean isArithmeticOrUnscopedEnum(IType op1) {
        if (op1 instanceof IBasicType) {
            IBasicType.Kind kind = ((IBasicType)op1).getKind();
            switch (kind) {
                case eUnspecified: 
                case eVoid: 
                case eNullPtr: {
                    return false;
                }
            }
            return true;
        }
        if (op1 instanceof IEnumeration) {
            return !(op1 instanceof ICPPEnumeration) || !((ICPPEnumeration)op1).isScoped();
        }
        return false;
    }

    private boolean isIntegralOrUnscopedEnum(IType op1) {
        if (op1 instanceof IEnumeration) {
            return true;
        }
        if (op1 instanceof IBasicType) {
            IBasicType.Kind kind = ((IBasicType)op1).getKind();
            switch (kind) {
                case eChar: 
                case eWChar: 
                case eInt: 
                case eBoolean: 
                case eChar16: 
                case eChar32: 
                case eInt128: {
                    return true;
                }
                case eUnspecified: 
                case eVoid: 
                case eFloat: 
                case eDouble: 
                case eNullPtr: 
                case eFloat128: 
                case eDecimal32: 
                case eDecimal64: 
                case eDecimal128: {
                    return false;
                }
            }
        }
        return false;
    }

    private final IType convert(IType type1, IType type2) {
        IBasicType signedType;
        IBasicType unsignedType;
        IBasicType btype2;
        Domain domain = this.getDomain(type1, type2);
        if (this.isLongDouble(type1)) {
            return this.adjustDomain((IBasicType)type1, domain);
        }
        if (this.isLongDouble(type2)) {
            return this.adjustDomain((IBasicType)type2, domain);
        }
        if (ArithmeticConversion.isDouble(type1)) {
            return this.adjustDomain((IBasicType)type1, domain);
        }
        if (ArithmeticConversion.isDouble(type2)) {
            return this.adjustDomain((IBasicType)type2, domain);
        }
        if (ArithmeticConversion.isFloat(type1)) {
            return this.adjustDomain((IBasicType)type1, domain);
        }
        if (ArithmeticConversion.isFloat(type2)) {
            return this.adjustDomain((IBasicType)type2, domain);
        }
        IBasicType btype1 = this.promote(type1, domain);
        if (btype1.isSameType(btype2 = this.promote(type2, domain))) {
            return btype1;
        }
        if (btype1.isUnsigned() == btype2.isUnsigned()) {
            return this.getIntegerRank(btype1).ordinal() >= this.getIntegerRank(btype2).ordinal() ? btype1 : btype2;
        }
        if (btype1.isUnsigned()) {
            unsignedType = btype1;
            signedType = btype2;
        } else {
            unsignedType = btype2;
            signedType = btype1;
        }
        Rank signedRank = this.getIntegerRank(signedType);
        Rank unsignedRank = this.getIntegerRank(unsignedType);
        if (unsignedRank.ordinal() >= signedRank.ordinal()) {
            return unsignedType;
        }
        if (signedRank.ordinal() > unsignedRank.ordinal()) {
            return signedType;
        }
        return this.createBasicType(signedType.getKind(), this.changeModifier(signedType.getModifiers(), 4, 8));
    }

    private IBasicType promote(IType type, Domain domain) {
        if (type instanceof IEnumeration) {
            IType fixedType = null;
            if (type instanceof ICPPEnumeration) {
                fixedType = ((ICPPEnumeration)type).getFixedType();
            }
            if (fixedType == null) {
                return this.createBasicType(IBasicType.Kind.eInt, domain.getModifier() | ArithmeticConversion.getEnumIntTypeModifiers((IEnumeration)type));
            }
            type = fixedType;
        }
        if (type instanceof IBasicType) {
            IBasicType bt = (IBasicType)type;
            IBasicType.Kind kind = bt.getKind();
            switch (kind) {
                case eChar: 
                case eWChar: 
                case eBoolean: 
                case eChar16: {
                    return this.createBasicType(IBasicType.Kind.eInt, domain.getModifier());
                }
                case eChar32: {
                    return this.createBasicType(IBasicType.Kind.eInt, domain.getModifier() | 8);
                }
                case eInt: {
                    if (bt.isShort()) {
                        return this.createBasicType(IBasicType.Kind.eInt, domain.getModifier());
                    }
                    return this.adjustDomain(bt, domain);
                }
                case eInt128: {
                    return this.createBasicType(IBasicType.Kind.eInt128, domain.getModifier() | 8);
                }
                case eUnspecified: 
                case eVoid: 
                case eFloat: 
                case eDouble: 
                case eNullPtr: 
                case eFloat128: 
                case eDecimal32: 
                case eDecimal64: 
                case eDecimal128: {
                    assert (false);
                    break;
                }
            }
        }
        return this.createBasicType(IBasicType.Kind.eInt, domain.getModifier());
    }

    private Domain getDomain(IType type1, IType type2) {
        Domain d2;
        Domain d1 = this.getDomain(type1);
        if (d1 == (d2 = this.getDomain(type2))) {
            return d1;
        }
        return Domain.eComplex;
    }

    private Domain getDomain(IType type) {
        if (type instanceof IBasicType) {
            IBasicType bt = (IBasicType)type;
            if (bt.isComplex()) {
                return Domain.eComplex;
            }
            if (bt.isImaginary()) {
                return Domain.eImaginary;
            }
        }
        return Domain.eReal;
    }

    private IBasicType adjustDomain(IBasicType t, Domain d) {
        Domain myDomain = this.getDomain(t);
        if (myDomain == d) {
            return t;
        }
        return this.createBasicType(t.getKind(), this.changeModifier(t.getModifiers(), 48, d.getModifier()));
    }

    private int changeModifier(int modifiers, int remove, int add) {
        return modifiers & ~remove | add;
    }

    private Rank getIntegerRank(IBasicType type) {
        if (type.getKind() == IBasicType.Kind.eInt128) {
            return Rank.eLongLong;
        }
        assert (type.getKind() == IBasicType.Kind.eInt);
        if (type.isLongLong()) {
            return Rank.eLongLong;
        }
        if (type.isLong()) {
            return Rank.eLong;
        }
        return Rank.eInt;
    }

    private boolean isLongDouble(IType type) {
        if (type instanceof IBasicType) {
            IBasicType bt = (IBasicType)type;
            return bt.isLong() && bt.getKind() == IBasicType.Kind.eDouble || bt.getKind() == IBasicType.Kind.eFloat128 || bt.getKind() == IBasicType.Kind.eDecimal128;
        }
        return false;
    }

    private static boolean isDouble(IType type) {
        if (type instanceof IBasicType) {
            IBasicType bt = (IBasicType)type;
            return bt.getKind() == IBasicType.Kind.eDouble || bt.getKind() == IBasicType.Kind.eDecimal64;
        }
        return false;
    }

    private static boolean isFloat(IType type) {
        if (type instanceof IBasicType) {
            IBasicType bt = (IBasicType)type;
            return bt.getKind() == IBasicType.Kind.eFloat || bt.getKind() == IBasicType.Kind.eDecimal32;
        }
        return false;
    }

    public static int getEnumIntTypeModifiers(IEnumeration enumeration) {
        long minValue = enumeration.getMinValue();
        long maxValue = enumeration.getMaxValue();
        if (minValue >= Integer.MIN_VALUE && maxValue <= Integer.MAX_VALUE) {
            return 0;
        }
        if (minValue >= 0L && maxValue <= 0xFFFFFFFFL) {
            return 8;
        }
        if (minValue >= Long.MIN_VALUE && maxValue <= Long.MAX_VALUE) {
            return 1;
        }
        return 9;
    }

    public static boolean fitsIntoType(IBasicType basicTarget, long n) {
        IBasicType.Kind kind = basicTarget.getKind();
        switch (kind) {
            case eInt: {
                if (!basicTarget.isUnsigned()) {
                    if (basicTarget.isShort()) {
                        return -32768L <= n && n <= 32767L;
                    }
                    if (basicTarget.isLong() || basicTarget.isLongLong()) {
                        return true;
                    }
                    return Integer.MIN_VALUE <= n && n <= Integer.MAX_VALUE;
                }
                if (n < 0L) {
                    return false;
                }
                if (basicTarget.isShort()) {
                    return n < 65536L;
                }
                if (basicTarget.isLong() || basicTarget.isLongLong()) {
                    return true;
                }
                return n < 0x100000000L;
            }
            case eFloat: {
                float f = n;
                return (long)f == n;
            }
            case eDouble: {
                double d = n;
                return (long)d == n;
            }
        }
        return false;
    }

    private static long getApproximateSize(IBasicType type) {
        switch (type.getKind()) {
            case eChar: {
                return 1L;
            }
            case eWChar: {
                return 2L;
            }
            case eInt: {
                return type.isShort() ? 2 : (type.isLong() ? 6 : (type.isLongLong() ? 8 : 4));
            }
            case eBoolean: {
                return 1L;
            }
            case eChar16: {
                return 2L;
            }
            case eChar32: {
                return 4L;
            }
            case eInt128: {
                return 16L;
            }
        }
        return 0L;
    }

    public static boolean fitsIntoType(IBasicType target, IBasicType source, IASTNode point) {
        long sizeofTarget;
        if (target.getKind() == IBasicType.Kind.eBoolean && source.getKind() != IBasicType.Kind.eBoolean) {
            return false;
        }
        if (source.getKind() == IBasicType.Kind.eBoolean) {
            return true;
        }
        if (!source.isUnsigned() && target.isUnsigned()) {
            return false;
        }
        SizeofCalculator.SizeAndAlignment sourceSizeAndAlignment = SizeofCalculator.getSizeAndAlignment(source, point);
        SizeofCalculator.SizeAndAlignment targetSizeAndAlignment = SizeofCalculator.getSizeAndAlignment(target, point);
        long sizeofSource = sourceSizeAndAlignment == null ? ArithmeticConversion.getApproximateSize(source) : sourceSizeAndAlignment.size;
        long l = sizeofTarget = targetSizeAndAlignment == null ? ArithmeticConversion.getApproximateSize(target) : targetSizeAndAlignment.size;
        if (sizeofSource == sizeofTarget) {
            return target.isUnsigned() == source.isUnsigned();
        }
        return sizeofSource < sizeofTarget;
    }

    private static enum Domain {
        eReal(0),
        eImaginary(32),
        eComplex(16);

        private final int fModifier;

        private Domain(int modifier) {
            this.fModifier = modifier;
        }

        int getModifier() {
            return this.fModifier;
        }
    }

    private static enum Rank {
        eInt,
        eLong,
        eLongLong;

    }
}

