/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameterPackType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPClassSpecializationScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class AbstractCPPClassSpecializationScope
implements ICPPClassSpecializationScope {
    private final ICPPClassSpecialization specialClass;
    private volatile ICPPBase[] fBases;
    private volatile ICPPMethod[] ownInheritedConstructors;
    private final ThreadLocal<Boolean> fComputingBases = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public AbstractCPPClassSpecializationScope(ICPPClassSpecialization specialization) {
        this.specialClass = specialization;
    }

    @Override
    public ICPPClassType getOriginalClassType() {
        return this.specialClass.getSpecializedBinding();
    }

    @Override
    public final IBinding getBinding(IASTName name, boolean resolve) {
        return this.getBinding(name, resolve, IIndexFileSet.EMPTY);
    }

    @Override
    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefix) {
        return this.getBindings(new IScope.ScopeLookupData(name, resolve, prefix));
    }

    @Override
    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) {
        IBinding[] bindings;
        char[] c = name.getLookupKey();
        if (CharArrayUtils.equals(c, this.specialClass.getNameCharArray()) && !CPPClassScope.shallReturnConstructors(name, false)) {
            return this.specialClass;
        }
        ICPPClassType specialized = this.specialClass.getSpecializedBinding();
        IScope classScope = specialized.getCompositeScope();
        IBinding[] iBindingArray = bindings = classScope != null ? classScope.getBindings(new IScope.ScopeLookupData(name, resolve, false)) : null;
        if (bindings == null) {
            return null;
        }
        Object[] specs = IBinding.EMPTY_BINDING_ARRAY;
        IBinding[] iBindingArray2 = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding = iBindingArray2[n2];
            specs = ArrayUtil.append(specs, this.specialClass.specializeMember(binding, name));
            ++n2;
        }
        specs = ArrayUtil.trim(specs);
        return CPPSemantics.resolveAmbiguities(name, specs);
    }

    @Override
    @Deprecated
    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) {
        return this.getBindings(new IScope.ScopeLookupData(name, resolve, prefixLookup));
    }

    @Override
    public final IBinding[] getBindings(IScope.ScopeLookupData lookup) {
        ICPPClassType specialized = this.specialClass.getSpecializedBinding();
        IScope classScope = specialized.getCompositeScope();
        if (classScope == null) {
            return IBinding.EMPTY_BINDING_ARRAY;
        }
        IBinding[] bindings = classScope.getBindings(lookup);
        IBinding[] result = IBinding.EMPTY_BINDING_ARRAY;
        int n = 0;
        IBinding[] iBindingArray = bindings;
        int n2 = bindings.length;
        int n3 = 0;
        while (n3 < n2) {
            IBinding binding = iBindingArray[n3];
            binding = binding == specialized || binding instanceof ICPPClassType && AbstractCPPClassSpecializationScope.areSameTypesModuloPartialSpecialization(specialized, (IType)((Object)binding)) ? this.specialClass : this.specialClass.specializeMember(binding, lookup.getLookupPoint());
            if (binding != null) {
                result = ArrayUtil.appendAt(result, n++, binding);
            }
            ++n3;
        }
        return ArrayUtil.trim(result, n);
    }

    private static boolean areSameTypesModuloPartialSpecialization(IType type1, IType type2) {
        while (type1 instanceof ICPPClassTemplatePartialSpecialization) {
            type1 = ((ICPPClassTemplatePartialSpecialization)type1).getPrimaryClassTemplate();
        }
        while (type2 instanceof ICPPClassTemplatePartialSpecialization) {
            type2 = ((ICPPClassTemplatePartialSpecialization)type2).getPrimaryClassTemplate();
        }
        return type1.isSameType(type2);
    }

    @Override
    public ICPPClassSpecialization getClassType() {
        return this.specialClass;
    }

    @Override
    public ICPPBase[] getBases(IASTNode point) {
        block16: {
            if (this.fBases == null) {
                if (this.fComputingBases.get().booleanValue()) {
                    return ICPPBase.EMPTY_BASE_ARRAY;
                }
                this.fComputingBases.set(true);
                try {
                    ICPPBase[] result = ICPPBase.EMPTY_BASE_ARRAY;
                    ICPPBase[] bases = ClassTypeHelper.getBases(this.specialClass.getSpecializedBinding(), point);
                    if (bases.length == 0) {
                        this.fBases = bases;
                        break block16;
                    }
                    ICPPTemplateParameterMap tpmap = this.specialClass.getTemplateParameterMap();
                    ICPPBase[] iCPPBaseArray = bases;
                    int n = bases.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICPPBase base = iCPPBaseArray[n2];
                        IBinding origClass = base.getBaseClass();
                        if (origClass instanceof ICPPTemplateParameter && ((ICPPTemplateParameter)origClass).isParameterPack()) {
                            IType[] specClasses = CPPTemplates.instantiateTypes(new IType[]{new CPPParameterPackType((IType)((Object)origClass))}, tpmap, -1, this.specialClass, point);
                            if (specClasses.length == 1 && specClasses[0] instanceof ICPPParameterPackType) {
                                result = ArrayUtil.append(result, base);
                            } else {
                                IType[] iTypeArray = specClasses;
                                int n3 = specClasses.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IType specClass = iTypeArray[n4];
                                    ICPPBase specBase = base.clone();
                                    if ((specClass = SemanticUtil.getUltimateType(specClass, false)) instanceof IBinding && !(specClass instanceof IProblemBinding)) {
                                        specBase.setBaseClass((IBinding)((Object)specClass));
                                        result = ArrayUtil.append(result, specBase);
                                    }
                                    ++n4;
                                }
                            }
                        } else if (origClass instanceof IType) {
                            ICPPBase specBase = base.clone();
                            ICPPClassSpecialization specializationContext = this.specialClass;
                            if (this.specialClass.getOwner() instanceof ICPPClassSpecialization) {
                                specializationContext = (ICPPClassSpecialization)this.specialClass.getOwner();
                            }
                            IType specClass = CPPTemplates.instantiateType((IType)((Object)origClass), tpmap, -1, specializationContext, point);
                            if ((specClass = SemanticUtil.getUltimateType(specClass, false)) instanceof IBinding && !(specClass instanceof IProblemBinding)) {
                                specBase.setBaseClass((IBinding)((Object)specClass));
                            }
                            result = ArrayUtil.append(result, specBase);
                        }
                        ++n2;
                    }
                    result = ArrayUtil.trim(result);
                    this.fBases = result;
                    ICPPBase[] iCPPBaseArray2 = result;
                    return iCPPBaseArray2;
                }
                finally {
                    this.fComputingBases.set(false);
                }
            }
        }
        return this.fBases;
    }

    private <T extends IBinding> T[] specializeMembers(T[] array, IASTNode point) {
        if (array == null || array.length == 0) {
            return array;
        }
        IBinding[] newArray = (IBinding[])array.clone();
        int i = 0;
        while (i < newArray.length) {
            IBinding specializedMember;
            newArray[i] = specializedMember = this.specialClass.specializeMember((IBinding)array[i], point);
            ++i;
        }
        return newArray;
    }

    @Override
    public ICPPField[] getDeclaredFields(IASTNode point) {
        IBinding[] fields = ClassTypeHelper.getDeclaredFields(this.specialClass.getSpecializedBinding(), point);
        return (ICPPField[])this.specializeMembers(fields, point);
    }

    @Override
    public ICPPMethod[] getImplicitMethods() {
        CCorePlugin.log(new Exception("Unsafe method call. Instantiation of dependent expressions may not work."));
        return this.getImplicitMethods(null);
    }

    @Override
    public ICPPMethod[] getImplicitMethods(IASTNode point) {
        ICPPClassType origClass = this.specialClass.getSpecializedBinding();
        IBinding[] methods = ClassTypeHelper.getImplicitMethods(origClass, point);
        ICPPMethod[] specializedMembers = (ICPPMethod[])this.specializeMembers(methods, point);
        Object[] inheritedConstructors = this.getOwnInheritedConstructors(point);
        return ArrayUtil.addAll(specializedMembers, inheritedConstructors);
    }

    @Override
    public IName getScopeName() {
        if (this.specialClass instanceof ICPPInternalBinding) {
            return (IASTName)((ICPPInternalBinding)((Object)this.specialClass)).getDefinition();
        }
        return null;
    }

    @Override
    public ICPPConstructor[] getConstructors() {
        CCorePlugin.log(new Exception("Unsafe method call. Instantiation of dependent expressions may not work."));
        return this.getConstructors(null);
    }

    @Override
    public ICPPConstructor[] getConstructors(IASTNode point) {
        IBinding[] ctors = ClassTypeHelper.getConstructors(this.specialClass.getSpecializedBinding(), point);
        ICPPConstructor[] specializedCtors = (ICPPConstructor[])this.specializeMembers(ctors, point);
        Object[] inheritedConstructors = this.getOwnInheritedConstructors(specializedCtors, point);
        return ArrayUtil.addAll(specializedCtors, inheritedConstructors);
    }

    private ICPPMethod[] getOwnInheritedConstructors(ICPPConstructor[] existingConstructors, IASTNode point) {
        if (this.ownInheritedConstructors == null) {
            if (!this.hasInheritedConstructorsSources(point)) {
                return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
            }
            IType[][] existingConstructorParamTypes = new IType[existingConstructors.length][];
            int i = 0;
            while (i < existingConstructors.length) {
                ICPPParameter[] params = existingConstructors[i].getParameters();
                IType[] types = new IType[params.length];
                int j = 0;
                while (j < params.length) {
                    types[j] = params[j].getType();
                    ++j;
                }
                existingConstructorParamTypes[i] = types;
                ++i;
            }
            ICPPMethod[] constructors = CPPClassScope.createInheritedConsructors(this, this.specialClass.getNameCharArray(), this.getBases(point), existingConstructorParamTypes, point);
            this.ownInheritedConstructors = constructors;
        }
        return this.ownInheritedConstructors;
    }

    private ICPPMethod[] getOwnInheritedConstructors(IASTNode point) {
        if (this.ownInheritedConstructors != null) {
            return this.ownInheritedConstructors;
        }
        IBinding[] ctors = ClassTypeHelper.getConstructors(this.specialClass.getSpecializedBinding(), point);
        ICPPConstructor[] specializedCtors = (ICPPConstructor[])this.specializeMembers(ctors, point);
        return this.getOwnInheritedConstructors(specializedCtors, point);
    }

    private boolean hasInheritedConstructorsSources(IASTNode point) {
        ICPPBase[] iCPPBaseArray = this.getBases(point);
        int n = iCPPBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPBase base = iCPPBaseArray[n2];
            if (base.isInheritedConstructorsSource()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public ICPPMethod[] getDeclaredMethods(IASTNode point) {
        IBinding[] bindings = ClassTypeHelper.getDeclaredMethods(this.specialClass.getSpecializedBinding(), point);
        return (ICPPMethod[])this.specializeMembers(bindings, point);
    }

    @Override
    public ICPPClassType[] getNestedClasses(IASTNode point) {
        IBinding[] bindings = ClassTypeHelper.getNestedClasses(this.specialClass.getSpecializedBinding(), point);
        return (ICPPClassType[])this.specializeMembers(bindings, point);
    }

    @Override
    public IBinding[] getFriends(IASTNode point) {
        IBinding[] friends = ClassTypeHelper.getFriends(this.specialClass.getSpecializedBinding(), point);
        return this.specializeMembers(friends, point);
    }

    @Override
    public IScope getParent() throws DOMException {
        IBinding binding = this.specialClass.getOwner();
        if (binding instanceof ICPPClassType) {
            return ((ICPPClassType)binding).getCompositeScope();
        }
        if (binding instanceof ICPPNamespace) {
            return ((ICPPNamespace)binding).getNamespaceScope();
        }
        return this.getOriginalClassType().getScope();
    }

    @Override
    public IBinding[] find(String name) {
        return CPPSemantics.findBindings((IScope)this, name, false);
    }

    @Override
    public EScopeKind getKind() {
        return EScopeKind.eClassType;
    }

    public String toString() {
        IName name = this.getScopeName();
        return name != null ? name.toString() : String.valueOf(this.specialClass);
    }

    public boolean equals(Object other) {
        if (other instanceof ICPPClassSpecializationScope) {
            return this.getClassType().equals(((ICPPClassSpecializationScope)other).getClassType());
        }
        return false;
    }

    public int hashCode() {
        return this.specialClass.hashCode();
    }
}

