/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLiteralExpression;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPArrayType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPQualifierType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.parser.scanner.ExpressionEvaluator;

public class CPPASTLiteralExpression
extends ASTNode
implements ICPPASTLiteralExpression {
    private static final EvalFixed EVAL_TRUE = new EvalFixed(CPPBasicType.BOOLEAN, IASTExpression.ValueCategory.PRVALUE, Value.create(1L));
    private static final EvalFixed EVAL_FALSE = new EvalFixed(CPPBasicType.BOOLEAN, IASTExpression.ValueCategory.PRVALUE, Value.create(0L));
    private static final EvalFixed EVAL_NULL_PTR = new EvalFixed(CPPBasicType.NULL_PTR, IASTExpression.ValueCategory.PRVALUE, Value.create(0L));
    public static final CPPASTLiteralExpression INT_ZERO = new CPPASTLiteralExpression(0, new char[]{'0'});
    private int fKind;
    private char[] fValue = CharArrayUtils.EMPTY;
    private int fStringLiteralSize = -1;
    private ICPPEvaluation fEvaluation;

    public CPPASTLiteralExpression() {
    }

    public CPPASTLiteralExpression(int kind, char[] value) {
        this.fKind = kind;
        this.fValue = value;
    }

    @Override
    public CPPASTLiteralExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTLiteralExpression copy(IASTNode.CopyStyle style) {
        CPPASTLiteralExpression copy = new CPPASTLiteralExpression(this.fKind, this.fValue == null ? null : (char[])this.fValue.clone());
        return this.copy(copy, style);
    }

    @Override
    public int getKind() {
        return this.fKind;
    }

    @Override
    public void setKind(int value) {
        this.assertNotFrozen();
        this.fKind = value;
    }

    @Override
    public char[] getValue() {
        return this.fValue;
    }

    @Override
    public void setValue(char[] value) {
        this.assertNotFrozen();
        this.fValue = value;
    }

    @Override
    public String toString() {
        return new String(this.fValue);
    }

    @Override
    public IASTImplicitDestructorName[] getImplicitDestructorNames() {
        return IASTImplicitDestructorName.EMPTY_NAME_ARRAY;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    private int computeStringLiteralSize() {
        int start = 0;
        int end = this.fValue.length - 1;
        boolean isRaw = false;
        if (this.fValue[0] == 'L' || this.fValue[0] == 'u' || this.fValue[0] == 'U') {
            ++start;
        }
        if (this.fValue[start] == 'R') {
            ++start;
            isRaw = true;
        }
        if (this.fValue[start] != '\"' || this.fValue[end] != '\"') {
            return 0;
        }
        ++start;
        --end;
        if (isRaw) {
            while (this.fValue[start] != '(' && start <= end) {
                ++start;
                --end;
            }
            if (this.fValue[start] != '(' || this.fValue[end] != ')') {
                return 0;
            }
            return end - start + 1 + 1;
        }
        int length = 0;
        boolean escaping = false;
        while (start <= end) {
            if (escaping) {
                escaping = false;
                ++length;
            } else if (this.fValue[start] == '\\') {
                escaping = true;
            } else {
                ++length;
            }
            ++start;
        }
        return length + 1;
    }

    private IValue getStringLiteralSize() {
        if (this.fStringLiteralSize == -1) {
            this.fStringLiteralSize = this.computeStringLiteralSize();
        }
        return Value.create(this.fStringLiteralSize);
    }

    private IBasicType.Kind getCharType() {
        switch (this.getValue()[0]) {
            case 'L': {
                return IBasicType.Kind.eWChar;
            }
            case 'u': {
                return IBasicType.Kind.eChar16;
            }
            case 'U': {
                return IBasicType.Kind.eChar32;
            }
        }
        return IBasicType.Kind.eChar;
    }

    private IType classifyTypeOfFloatLiteral() {
        char[] lit = this.getValue();
        int len = lit.length;
        IBasicType.Kind kind = IBasicType.Kind.eDouble;
        int flags = 0;
        if (len > 0) {
            switch (lit[len - 1]) {
                case 'F': 
                case 'f': {
                    kind = IBasicType.Kind.eFloat;
                    break;
                }
                case 'L': 
                case 'l': {
                    flags |= 1;
                }
            }
        }
        return new CPPBasicType(kind, flags, this);
    }

    private IType classifyTypeOfIntLiteral() {
        int makelong = 0;
        boolean unsigned = false;
        char[] lit = this.getValue();
        int i = lit.length - 1;
        while (i >= 0) {
            char c = lit[i];
            if (!(c > 'f' && c <= 'z' || c > 'F' && c <= 'Z')) break;
            switch (c) {
                case 'U': 
                case 'u': {
                    unsigned = true;
                    break;
                }
                case 'L': 
                case 'l': {
                    ++makelong;
                }
            }
            --i;
        }
        int flags = 0;
        if (unsigned) {
            flags |= 8;
        }
        if (makelong > 1) {
            flags |= 0x40;
        } else if (makelong == 1) {
            flags |= 1;
        }
        return new CPPBasicType(IBasicType.Kind.eInt, flags, this);
    }

    @Override
    @Deprecated
    public void setValue(String value) {
        this.assertNotFrozen();
        this.fValue = value.toCharArray();
    }

    @Deprecated
    public CPPASTLiteralExpression(int kind, String value) {
        this(kind, value.toCharArray());
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEvaluation == null) {
            this.fEvaluation = this.createEvaluation();
        }
        return this.fEvaluation;
    }

    private ICPPEvaluation createEvaluation() {
        switch (this.fKind) {
            case 4: {
                IScope scope = CPPVisitor.getContainingScope(this);
                IType type = CPPVisitor.getImpliedObjectType(scope);
                if (type == null) {
                    return EvalFixed.INCOMPLETE;
                }
                return new EvalFixed(new CPPPointerType(type), IASTExpression.ValueCategory.PRVALUE, Value.UNKNOWN);
            }
            case 5: {
                return EVAL_TRUE;
            }
            case 6: {
                return EVAL_FALSE;
            }
            case 2: {
                return new EvalFixed(new CPPBasicType(this.getCharType(), 0, this), IASTExpression.ValueCategory.PRVALUE, this.createCharValue());
            }
            case 1: {
                return new EvalFixed(this.classifyTypeOfFloatLiteral(), IASTExpression.ValueCategory.PRVALUE, Value.UNKNOWN);
            }
            case 0: {
                return new EvalFixed(this.classifyTypeOfIntLiteral(), IASTExpression.ValueCategory.PRVALUE, this.createIntValue());
            }
            case 3: {
                IType type = new CPPBasicType(this.getCharType(), 0, this);
                type = new CPPQualifierType(type, true, false);
                return new EvalFixed(new CPPArrayType(type, this.getStringLiteralSize()), IASTExpression.ValueCategory.LVALUE, Value.UNKNOWN);
            }
            case 7: {
                return EVAL_NULL_PTR;
            }
        }
        return EvalFixed.INCOMPLETE;
    }

    private IValue createCharValue() {
        try {
            char[] image = this.getValue();
            if (image.length > 1 && image[0] == 'L') {
                return Value.create(ExpressionEvaluator.getChar(image, 2));
            }
            return Value.create(ExpressionEvaluator.getChar(image, 1));
        }
        catch (ExpressionEvaluator.EvalException evalException) {
            return Value.UNKNOWN;
        }
    }

    private IValue createIntValue() {
        try {
            return Value.create(ExpressionEvaluator.getNumber(this.getValue()));
        }
        catch (ExpressionEvaluator.EvalException evalException) {
            return Value.UNKNOWN;
        }
    }

    @Override
    public IType getExpressionType() {
        return this.getEvaluation().getTypeOrFunctionSet(this);
    }

    @Override
    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.getKind() == 3 ? IASTExpression.ValueCategory.LVALUE : IASTExpression.ValueCategory.PRVALUE;
    }
}

