/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.ui.preferences;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionControlService;
import org.eclipse.remote.core.IRemoteConnectionHostService;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.core.preferences.Preferences;
import org.eclipse.remote.internal.ui.RemoteUIPlugin;
import org.eclipse.remote.internal.ui.messages.Messages;
import org.eclipse.remote.ui.IRemoteUIConnectionService;
import org.eclipse.remote.ui.IRemoteUIConnectionWizard;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ConnectionsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final String[] fTableColumnHeaders = new String[]{Messages.ConnectionsPreferencePage_Status, Messages.ConnectionsPreferencePage_Connection_Name, Messages.ConnectionsPreferencePage_Host, Messages.ConnectionsPreferencePage_User};
    private final ColumnLayoutData[] fTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(15), new ColumnWeightData(35), new ColumnWeightData(30), new ColumnWeightData(20)};
    private Combo fServicesCombo;
    private Button fAddButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private Button fOpenButton;
    private Button fCloseButton;
    private Table fConnectionTable;
    private TableViewer fConnectionViewer;
    private EventHandler fEventHandler;
    private String[] fServiceIDs;
    private boolean fIsDirty;
    private IRemoteConnection fSelectedConnection;
    private IRemoteConnectionType fConnectionType;
    private IRemoteUIConnectionService fUIConnectionManager;
    private final Map<String, IRemoteConnection> fWorkingCopies = new HashMap<String, IRemoteConnection>();
    private static final String DEFAULT_CONNECTION_NAME = "Remote Host";

    public ConnectionsPreferencePage() {
    }

    public ConnectionsPreferencePage(String title) {
        super(title);
    }

    public ConnectionsPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    private void addConnection() {
        IRemoteUIConnectionWizard wizard;
        if (this.fIsDirty) {
            MessageDialog dialog = new MessageDialog(this.getShell(), Messages.ConnectionsPreferencePage_Confirm_Actions, null, Messages.ConnectionsPreferencePage_There_are_unsaved_changes, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            if (dialog.open() == 1) {
                return;
            }
            this.performOk();
        }
        if ((wizard = this.fUIConnectionManager.getConnectionWizard(this.getShell())) != null) {
            wizard.setConnectionName(this.initialConnectionName());
            wizard.setInvalidConnectionNames(this.invalidConnectionNames());
            IRemoteConnectionWorkingCopy conn = wizard.open();
            if (conn != null) {
                this.fWorkingCopies.put(conn.getName(), (IRemoteConnection)conn);
                this.fConnectionViewer.refresh();
                this.fIsDirty = true;
            }
        }
    }

    protected Control createContents(Composite parent) {
        return this.createWidgets(parent);
    }

    private Control createWidgets(Composite parent) {
        this.fEventHandler = new EventHandler();
        Composite selectComp = new Composite(parent, 0);
        selectComp.setLayout((Layout)new GridLayout(2, false));
        selectComp.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        Label label = new Label(selectComp, 0);
        label.setText(Messages.ConnectionsPreferencePage_Remote_Services);
        label.setLayoutData((Object)new GridData());
        this.fServicesCombo = new Combo(selectComp, 8);
        label.setLayoutData((Object)new GridData());
        IRemoteServicesManager manager = RemoteUIPlugin.getService(IRemoteServicesManager.class);
        List services = manager.getRemoteConnectionTypes();
        String[] names = new String[services.size()];
        this.fServiceIDs = new String[services.size()];
        int i = 0;
        for (IRemoteConnectionType s : services) {
            names[i] = s.getName();
            this.fServiceIDs[i] = s.getId();
            ++i;
        }
        this.fServicesCombo.addSelectionListener((SelectionListener)this.fEventHandler);
        this.fServicesCombo.setItems(names);
        Composite preferencePane = new Composite(parent, 0);
        preferencePane.setLayout((Layout)new GridLayout(2, false));
        this.fConnectionTable = new Table(preferencePane, 67586);
        GridData data = new GridData(1808);
        data.widthHint = 425;
        data.heightHint = this.fConnectionTable.getItemHeight();
        data.horizontalSpan = 1;
        this.fConnectionTable.setLayoutData((Object)data);
        this.fConnectionTable.setFont(parent.getFont());
        this.fConnectionTable.addSelectionListener((SelectionListener)this.fEventHandler);
        this.fConnectionTable.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                IRemoteConnection original;
                if (ConnectionsPreferencePage.this.fSelectedConnection != null && (original = ConnectionsPreferencePage.this.getOriginalIfClean(ConnectionsPreferencePage.this.fSelectedConnection)).isOpen()) {
                    ConnectionsPreferencePage.this.editConnection();
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        TableLayout tableLayout = new TableLayout();
        this.fConnectionTable.setLayout((Layout)tableLayout);
        this.fConnectionTable.setHeaderVisible(true);
        this.fConnectionTable.setLinesVisible(true);
        int i2 = 0;
        while (i2 < this.fTableColumnHeaders.length) {
            tableLayout.addColumnData(this.fTableColumnLayouts[i2]);
            TableColumn column = new TableColumn(this.fConnectionTable, 0, i2);
            column.setResizable(this.fTableColumnLayouts[i2].resizable);
            column.setText(this.fTableColumnHeaders[i2]);
            ++i2;
        }
        this.fConnectionViewer = new TableViewer(this.fConnectionTable);
        this.fConnectionViewer.setContentProvider((IContentProvider)new ConnectionContentProvider());
        this.fConnectionViewer.setLabelProvider((IBaseLabelProvider)new ConnectionLabelProvider());
        this.fConnectionViewer.setComparator(new ViewerComparator());
        this.fConnectionViewer.setInput((Object)this);
        Composite buttonPane = new Composite(preferencePane, 0);
        buttonPane.setLayout((Layout)new GridLayout(1, false));
        buttonPane.setLayoutData((Object)new GridData(1040));
        buttonPane.setFont(preferencePane.getFont());
        this.fAddButton = new Button(buttonPane, 8);
        this.setButtonLayoutData(this.fAddButton);
        this.fAddButton.setText(Messages.ConnectionsPreferencePage_Add);
        this.fAddButton.addSelectionListener((SelectionListener)this.fEventHandler);
        this.fEditButton = new Button(buttonPane, 8);
        this.setButtonLayoutData(this.fEditButton);
        this.fEditButton.setText(Messages.ConnectionsPreferencePage_Edit);
        this.fEditButton.addSelectionListener((SelectionListener)this.fEventHandler);
        this.fEditButton.setEnabled(false);
        this.fRemoveButton = new Button(buttonPane, 8);
        this.setButtonLayoutData(this.fRemoveButton);
        this.fRemoveButton.setText(Messages.ConnectionsPreferencePage_Remove);
        this.fRemoveButton.addSelectionListener((SelectionListener)this.fEventHandler);
        this.fRemoveButton.setEnabled(false);
        this.fOpenButton = new Button(buttonPane, 8);
        this.setButtonLayoutData(this.fOpenButton);
        this.fOpenButton.setText(Messages.ConnectionsPreferencePage_Open);
        this.fOpenButton.addSelectionListener((SelectionListener)this.fEventHandler);
        this.fOpenButton.setEnabled(false);
        this.fCloseButton = new Button(buttonPane, 8);
        this.setButtonLayoutData(this.fCloseButton);
        this.fCloseButton.setText(Messages.ConnectionsPreferencePage_Close);
        this.fCloseButton.addSelectionListener((SelectionListener)this.fEventHandler);
        this.fCloseButton.setEnabled(false);
        String id = Preferences.getString((String)"connectionTypeId");
        if ("".equals(id)) {
            id = this.fServiceIDs[0];
        }
        int i3 = 0;
        while (i3 < this.fServiceIDs.length) {
            if (id.equals(this.fServiceIDs[i3])) {
                this.fServicesCombo.select(i3);
            }
            ++i3;
        }
        this.selectServices(id);
        return preferencePane;
    }

    private void editConnection() {
        if (this.fSelectedConnection != null) {
            IRemoteConnectionWorkingCopy copy = this.fSelectedConnection instanceof IRemoteConnectionWorkingCopy ? (IRemoteConnectionWorkingCopy)this.fSelectedConnection : this.fSelectedConnection.getWorkingCopy();
            IRemoteUIConnectionWizard wizard = this.fUIConnectionManager.getConnectionWizard(this.getShell());
            if (wizard != null) {
                wizard.setConnection(copy);
                wizard.setInvalidConnectionNames(this.invalidConnectionNames());
                IRemoteConnectionWorkingCopy conn = wizard.open();
                if (conn != null && conn.isDirty()) {
                    this.fWorkingCopies.put(copy.getName(), (IRemoteConnection)copy);
                    this.fConnectionViewer.refresh();
                    this.fIsDirty = true;
                }
            }
        }
    }

    public void init(IWorkbench workbench) {
    }

    private String initialConnectionName() {
        String name = DEFAULT_CONNECTION_NAME;
        int count = 2;
        while (this.fWorkingCopies.containsKey(name)) {
            name = "Remote Host " + count++;
        }
        return name;
    }

    private void initWorkingConnections() {
        this.fWorkingCopies.clear();
        for (IRemoteConnection conn : this.fConnectionType.getConnections()) {
            this.fWorkingCopies.put(conn.getName(), conn);
        }
    }

    private Set<String> invalidConnectionNames() {
        return this.fWorkingCopies.keySet();
    }

    protected void performDefaults() {
        this.initWorkingConnections();
        this.fIsDirty = false;
        this.fConnectionViewer.refresh();
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.fIsDirty) {
            this.updateConnections();
            this.fIsDirty = false;
        }
        return super.performOk();
    }

    private void removeConnections() {
        TableItem[] items = this.fConnectionTable.getSelection();
        if (items.length > 0) {
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                this.fWorkingCopies.remove(((IRemoteConnection)item.getData()).getName());
                ++n2;
            }
            this.fConnectionViewer.refresh();
            this.fIsDirty = true;
            this.fConnectionTable.deselectAll();
            this.fSelectedConnection = null;
        }
        this.updateEnablement();
    }

    private void selectConnection() {
        TableItem[] selection = this.fConnectionTable.getSelection();
        this.fSelectedConnection = selection.length > 0 ? (IRemoteConnection)selection[0].getData() : null;
        this.updateEnablement();
    }

    private void selectServices(String id) {
        IRemoteServicesManager manager = RemoteUIPlugin.getService(IRemoteServicesManager.class);
        this.fConnectionType = manager.getConnectionType(id);
        if (this.fConnectionType != null) {
            this.fUIConnectionManager = (IRemoteUIConnectionService)this.fConnectionType.getService(IRemoteUIConnectionService.class);
            this.initWorkingConnections();
            this.fConnectionViewer.refresh();
            this.fAddButton.setEnabled(this.fConnectionType.canAdd());
        }
        this.fIsDirty = false;
    }

    private void toggleConnection() {
        TableItem[] items = this.fConnectionTable.getSelection();
        if (items.length > 0) {
            IRemoteConnection conn = this.getOriginalIfClean((IRemoteConnection)items[0].getData());
            if (conn.hasService(IRemoteConnectionControlService.class) && conn.isOpen()) {
                conn.close();
            } else {
                IRemoteUIConnectionService mgr;
                IRemoteConnectionWorkingCopy wc;
                if (conn instanceof IRemoteConnectionWorkingCopy && (wc = (IRemoteConnectionWorkingCopy)conn).isDirty()) {
                    MessageDialog dialog = new MessageDialog(this.getShell(), Messages.ConnectionsPreferencePage_Confirm_Actions, null, Messages.ConnectionsPreferencePage_This_connection_contains_unsaved_changes, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                    if (dialog.open() == 1) {
                        return;
                    }
                    try {
                        conn = wc.save();
                    }
                    catch (RemoteConnectionException e) {
                        RemoteUIPlugin.log(e);
                    }
                    this.fWorkingCopies.put(conn.getName(), conn);
                }
                if ((mgr = (IRemoteUIConnectionService)conn.getConnectionType().getService(IRemoteUIConnectionService.class)) != null) {
                    mgr.openConnectionWithProgress(this.getShell(), null, conn);
                }
            }
            this.fConnectionViewer.refresh();
            this.updateEnablement();
        }
    }

    private void updateConnections() {
        for (IRemoteConnection conn : this.fConnectionType.getConnections()) {
            if (this.fWorkingCopies.containsKey(conn.getName()) || conn.hasService(IRemoteConnectionControlService.class) && conn.isOpen()) continue;
            try {
                this.fConnectionType.removeConnection(conn);
            }
            catch (RemoteConnectionException remoteConnectionException) {}
        }
        for (IRemoteConnection conn : this.fWorkingCopies.values()) {
            IRemoteConnectionWorkingCopy wc;
            if (!(conn instanceof IRemoteConnectionWorkingCopy) || !(wc = (IRemoteConnectionWorkingCopy)conn).isDirty()) continue;
            try {
                wc.save();
            }
            catch (RemoteConnectionException e) {
                RemoteUIPlugin.log(e);
            }
        }
        this.initWorkingConnections();
    }

    private void updateEnablement() {
        this.fEditButton.setEnabled(false);
        this.fRemoveButton.setEnabled(false);
        this.fOpenButton.setEnabled(false);
        this.fCloseButton.setEnabled(false);
        if (this.fSelectedConnection != null) {
            IRemoteConnection conn = this.getOriginalIfClean(this.fSelectedConnection);
            if (conn.hasService(IRemoteConnectionControlService.class)) {
                if (!conn.isOpen()) {
                    this.fEditButton.setEnabled(conn.getConnectionType().canEdit());
                    this.fRemoveButton.setEnabled(conn.getConnectionType().canRemove());
                    this.fOpenButton.setEnabled(true);
                } else {
                    this.fCloseButton.setEnabled(true);
                }
            } else {
                this.fEditButton.setEnabled(conn.getConnectionType().canEdit());
            }
        }
    }

    private IRemoteConnection getOriginalIfClean(IRemoteConnection conn) {
        IRemoteConnectionWorkingCopy wc;
        if (conn instanceof IRemoteConnectionWorkingCopy && !(wc = (IRemoteConnectionWorkingCopy)conn).isDirty()) {
            return wc.getOriginal();
        }
        return conn;
    }

    private class ConnectionContentProvider
    implements IStructuredContentProvider {
        private ConnectionContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return ConnectionsPreferencePage.this.fWorkingCopies.values().toArray(new IRemoteConnection[ConnectionsPreferencePage.this.fWorkingCopies.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ConnectionLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        private ConnectionLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IRemoteConnection connection = ConnectionsPreferencePage.this.getOriginalIfClean((IRemoteConnection)element);
            switch (columnIndex) {
                case 0: {
                    return connection.isOpen() ? Messages.ConnectionsPreferencePage_open : Messages.ConnectionsPreferencePage_closed;
                }
                case 1: {
                    return connection.getName();
                }
                case 2: {
                    if (!connection.hasService(IRemoteConnectionHostService.class)) break;
                    return ((IRemoteConnectionHostService)connection.getService(IRemoteConnectionHostService.class)).getHostname();
                }
                case 3: {
                    if (!connection.hasService(IRemoteConnectionHostService.class)) break;
                    return ((IRemoteConnectionHostService)connection.getService(IRemoteConnectionHostService.class)).getUsername();
                }
            }
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            IRemoteConnection connection = (IRemoteConnection)element;
            return connection.getName();
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class EventHandler
    extends SelectionAdapter {
        private EventHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == ConnectionsPreferencePage.this.fAddButton) {
                ConnectionsPreferencePage.this.addConnection();
            } else if (source == ConnectionsPreferencePage.this.fEditButton) {
                ConnectionsPreferencePage.this.editConnection();
            } else if (source == ConnectionsPreferencePage.this.fRemoveButton) {
                ConnectionsPreferencePage.this.removeConnections();
            } else if (source == ConnectionsPreferencePage.this.fOpenButton) {
                ConnectionsPreferencePage.this.toggleConnection();
            } else if (source == ConnectionsPreferencePage.this.fCloseButton) {
                ConnectionsPreferencePage.this.toggleConnection();
            } else if (source == ConnectionsPreferencePage.this.fConnectionTable) {
                ConnectionsPreferencePage.this.selectConnection();
            } else if (source == ConnectionsPreferencePage.this.fServicesCombo) {
                String id = ConnectionsPreferencePage.this.fServiceIDs[ConnectionsPreferencePage.this.fServicesCombo.getSelectionIndex()];
                ConnectionsPreferencePage.this.selectServices(id);
            }
        }
    }
}

