/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.trace;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.KernelTidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.ThreadPriorityAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.trace.layout.Lttng26EventLayout;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.trace.layout.LttngEventLayout;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.trace.layout.PerfEventLayout;
import org.eclipse.tracecompass.lttng2.kernel.core.trace.Messages;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTraceValidationStatus;

public class LttngKernelTrace
extends CtfTmfTrace
implements IKernelTrace {
    @NonNull
    private static final Collection<ITmfEventAspect> LTTNG_KERNEL_ASPECTS;
    private static final int CONFIDENCE = 100;
    private OriginTracer fOriginTracer = null;

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll((Iterable)CtfTmfTrace.CTF_ASPECTS);
        builder.add((Object)KernelTidAspect.INSTANCE);
        builder.add((Object)ThreadPriorityAspect.INSTANCE);
        LTTNG_KERNEL_ASPECTS = (Collection)NonNullUtils.checkNotNull((Object)builder.build());
    }

    @NonNull
    public IKernelAnalysisEventLayout getKernelEventLayout() {
        OriginTracer tracer = this.fOriginTracer;
        if (tracer == null) {
            throw new IllegalStateException("Cannot get the layout of a non-initialized trace!");
        }
        return tracer.fLayout;
    }

    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> eventType) throws TmfTraceException {
        super.initTrace(resource, path, eventType);
        Map traceEnv = this.getEnvironment();
        String tracerName = (String)traceEnv.get("tracer_name");
        String tracerMajor = (String)traceEnv.get("tracer_major");
        String tracerMinor = (String)traceEnv.get("tracer_minor");
        this.fOriginTracer = "\"perf\"".equals(tracerName) ? OriginTracer.PERF : ("\"lttng-modules\"".equals(tracerName) && tracerMajor != null && Integer.valueOf(tracerMajor) >= 2 && tracerMinor != null && Integer.valueOf(tracerMinor) >= 6 ? OriginTracer.LTTNG26 : OriginTracer.LTTNG);
    }

    public IStatus validate(IProject project, String path) {
        IStatus status = super.validate(project, path);
        if (status instanceof CtfTraceValidationStatus) {
            Map environment = ((CtfTraceValidationStatus)status).getEnvironment();
            String domain = (String)environment.get("domain");
            if (domain == null || !domain.equals("\"kernel\"")) {
                return new Status(4, "org.eclipse.tracecompass.lttng2.kernel.core", Messages.LttngKernelTrace_DomainError);
            }
            return new TraceValidationStatus(100, "org.eclipse.tracecompass.lttng2.kernel.core");
        }
        return status;
    }

    public Iterable<ITmfEventAspect> getEventAspects() {
        return LTTNG_KERNEL_ASPECTS;
    }

    private static enum OriginTracer {
        LTTNG(LttngEventLayout.getInstance()),
        LTTNG26(Lttng26EventLayout.getInstance()),
        PERF(PerfEventLayout.getInstance());

        @NonNull
        private final IKernelAnalysisEventLayout fLayout;

        private OriginTracer(IKernelAnalysisEventLayout layout) {
            this.fLayout = layout;
        }
    }
}

