/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.parsers.custom;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.core.parsers.custom.CustomEventAspects;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomEventContent;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTraceContext;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlEvent;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlEventType;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlInputAttribute;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlInputElement;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTraceContext;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.tracecompass.tmf.core.parsers.custom.Messages;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfPersistentlyIndexable;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.TmfBTreeTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CustomXmlTrace
extends TmfTrace
implements ITmfPersistentlyIndexable {
    private static final TmfLongLocation NULL_LOCATION = new TmfLongLocation(-1L);
    private static final int DEFAULT_CACHE_SIZE = 100;
    private static final int MAX_LINES = 100;
    private static final int CONFIDENCE = 100;
    private final CustomXmlTraceDefinition fDefinition;
    private final CustomXmlEventType fEventType;
    private final CustomXmlInputElement fRecordInputElement;
    private BufferedRandomAccessFile fFile;
    private final String fTraceTypeId;
    private static final char SEPARATOR = ':';
    private static final String CUSTOM_XML_TRACE_TYPE_PREFIX = "custom.xml.trace:";
    private static final String LINUX_TOOLS_CUSTOM_XML_TRACE_TYPE_PREFIX = "org.eclipse.linuxtools.tmf.core.parsers.custom.CustomXmlTrace:";
    private static final String EARLY_TRACE_COMPASS_CUSTOM_XML_TRACE_TYPE_PREFIX = "org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTrace:";
    private static int fCheckpointSize = -1;

    public CustomXmlTrace(CustomXmlTraceDefinition definition) {
        this.fDefinition = definition;
        this.fEventType = new CustomXmlEventType(this.fDefinition);
        this.fRecordInputElement = this.getRecordInputElement(this.fDefinition.rootInputElement);
        this.fTraceTypeId = CustomXmlTrace.buildTraceTypeId(definition.categoryName, definition.definitionName);
        this.setCacheSize(100);
    }

    public CustomXmlTrace(IResource resource, CustomXmlTraceDefinition definition, String path, int pageSize) throws TmfTraceException {
        this(definition);
        this.setCacheSize(pageSize > 0 ? pageSize : 100);
        this.initTrace(resource, path, CustomXmlEvent.class);
    }

    @Override
    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> eventType) throws TmfTraceException {
        super.initTrace(resource, path, eventType);
        try {
            this.fFile = new BufferedRandomAccessFile(this.getPath(), "r");
        }
        catch (IOException e) {
            throw new TmfTraceException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        if (this.fFile != null) {
            try {
                try {
                    this.fFile.close();
                }
                catch (IOException iOException) {
                    this.fFile = null;
                }
            }
            finally {
                this.fFile = null;
            }
        }
    }

    @Override
    public ITmfTraceIndexer getIndexer() {
        return super.getIndexer();
    }

    @Override
    public Iterable<ITmfEventAspect> getEventAspects() {
        return CustomEventAspects.generateAspects(this.fDefinition);
    }

    @Override
    public synchronized TmfContext seekEvent(ITmfLocation location) {
        CustomXmlTraceContext context = new CustomXmlTraceContext(NULL_LOCATION, -1L);
        if (NULL_LOCATION.equals(location) || this.fFile == null) {
            return context;
        }
        try {
            if (location == null) {
                this.fFile.seek(0L);
            } else if (location.getLocationInfo() instanceof Long) {
                this.fFile.seek((Long)location.getLocationInfo());
            }
            long rawPos = this.fFile.getFilePointer();
            String line = this.fFile.getNextLine();
            while (line != null) {
                int idx = CustomXmlTrace.indexOfElement(this.fRecordInputElement.getElementName(), line, 0);
                if (idx != -1) {
                    context.setLocation(new TmfLongLocation(rawPos + (long)idx));
                    return context;
                }
                rawPos = this.fFile.getFilePointer();
                line = this.fFile.getNextLine();
            }
            return context;
        }
        catch (IOException e) {
            Activator.logError("Error seeking event. File: " + this.getPath(), e);
            return context;
        }
    }

    @Override
    public synchronized TmfContext seekEvent(double ratio) {
        if (this.fFile == null) {
            return new CustomTxtTraceContext(NULL_LOCATION, -1L);
        }
        try {
            long pos = Math.round(ratio * (double)this.fFile.length());
            while (pos > 0L) {
                this.fFile.seek(pos - 1L);
                if (this.fFile.read() == 10) break;
                --pos;
            }
            TmfLongLocation location = new TmfLongLocation(pos);
            TmfContext context = this.seekEvent(location);
            context.setRank(-1L);
            return context;
        }
        catch (IOException e) {
            Activator.logError("Error seeking event. File: " + this.getPath(), e);
            return new CustomXmlTraceContext(NULL_LOCATION, -1L);
        }
    }

    @Override
    public synchronized double getLocationRatio(ITmfLocation location) {
        if (this.fFile == null) {
            return 0.0;
        }
        try {
            if (location.getLocationInfo() instanceof Long) {
                return ((Long)location.getLocationInfo()).doubleValue() / (double)this.fFile.length();
            }
        }
        catch (IOException e) {
            Activator.logError("Error getting location ration. File: " + this.getPath(), e);
        }
        return 0.0;
    }

    @Override
    public ITmfLocation getCurrentLocation() {
        return null;
    }

    @Override
    public synchronized CustomXmlEvent parseEvent(ITmfContext tmfContext) {
        TmfContext context = this.seekEvent(tmfContext.getLocation());
        return this.parse(context);
    }

    @Override
    public synchronized CustomXmlEvent getNext(ITmfContext context) {
        TmfContext savedContext = new TmfContext(context.getLocation(), context.getRank());
        CustomXmlEvent event = this.parse(context);
        if (event != null) {
            this.updateAttributes(savedContext, event.getTimestamp());
            context.increaseRank();
        }
        return event;
    }

    private synchronized CustomXmlEvent parse(ITmfContext tmfContext) {
        if (this.fFile == null) {
            return null;
        }
        if (!(tmfContext instanceof CustomXmlTraceContext)) {
            return null;
        }
        CustomXmlTraceContext context = (CustomXmlTraceContext)tmfContext;
        if (context.getLocation() == null || !(context.getLocation().getLocationInfo() instanceof Long) || NULL_LOCATION.equals(context.getLocation())) {
            return null;
        }
        CustomXmlEvent event = null;
        try {
            if (this.fFile.getFilePointer() != (Long)context.getLocation().getLocationInfo() + 1L) {
                this.fFile.seek((Long)context.getLocation().getLocationInfo() + 1L);
            }
            StringBuffer elementBuffer = new StringBuffer("<");
            this.readElement(elementBuffer, this.fFile);
            Element element = this.parseElementBuffer(elementBuffer);
            event = this.extractEvent(element, this.fRecordInputElement);
            ((StringBuffer)event.getContent().getValue()).append(elementBuffer);
            long rawPos = this.fFile.getFilePointer();
            String line = this.fFile.getNextLine();
            while (line != null) {
                int idx = CustomXmlTrace.indexOfElement(this.fRecordInputElement.getElementName(), line, 0);
                if (idx != -1) {
                    context.setLocation(new TmfLongLocation(rawPos + (long)idx));
                    return event;
                }
                rawPos = this.fFile.getFilePointer();
                line = this.fFile.getNextLine();
            }
        }
        catch (IOException e) {
            Activator.logError("Error parsing event. File: " + this.getPath(), e);
        }
        context.setLocation(NULL_LOCATION);
        return event;
    }

    private Element parseElementBuffer(StringBuffer elementBuffer) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            EntityResolver resolver = new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    String empty = "";
                    ByteArrayInputStream bais = new ByteArrayInputStream("".getBytes());
                    return new InputSource(bais);
                }
            };
            db.setEntityResolver(resolver);
            db.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException saxparseexception) throws SAXException {
                }

                @Override
                public void warning(SAXParseException saxparseexception) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException saxparseexception) throws SAXException {
                    throw saxparseexception;
                }
            });
            Document doc = db.parse(new ByteArrayInputStream(elementBuffer.toString().getBytes()));
            return doc.getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            Activator.logError("Error parsing element buffer. File:" + this.getPath(), e);
        }
        catch (SAXException e) {
            Activator.logError("Error parsing element buffer. File:" + this.getPath(), e);
        }
        catch (IOException e) {
            Activator.logError("Error parsing element buffer. File: " + this.getPath(), e);
        }
        return null;
    }

    private static int indexOfElement(String elementName, String line, int fromIndex) {
        char c;
        String recordElementStart = String.valueOf('<') + elementName;
        int index = line.indexOf(recordElementStart, fromIndex);
        if (index == -1) {
            return index;
        }
        int nextCharIndex = index + recordElementStart.length();
        if (nextCharIndex < line.length() && Character.isLetterOrDigit(c = line.charAt(nextCharIndex))) {
            return CustomXmlTrace.indexOfElement(elementName, line, nextCharIndex);
        }
        return index;
    }

    private void readElement(StringBuffer buffer, RandomAccessFile raFile) {
        try {
            int i;
            int numRead = 0;
            boolean startTagClosed = false;
            while ((i = raFile.read()) != -1) {
                ++numRead;
                char c = (char)i;
                buffer.append(c);
                if (c == '\"') {
                    CustomXmlTrace.readQuote(buffer, raFile, '\"');
                    continue;
                }
                if (c == '\'') {
                    CustomXmlTrace.readQuote(buffer, raFile, '\'');
                    continue;
                }
                if (c == '<') {
                    this.readElement(buffer, raFile);
                    continue;
                }
                if (c == '/' && numRead == 1) break;
                if (c == '-' && numRead == 3 && buffer.substring(buffer.length() - 3, buffer.length() - 1).equals("!-")) {
                    CustomXmlTrace.readComment(buffer, raFile);
                    continue;
                }
                if (i != 62) continue;
                if (buffer.charAt(buffer.length() - 2) == '/' || startTagClosed) break;
                startTagClosed = true;
            }
            return;
        }
        catch (IOException e) {
            return;
        }
    }

    private static void readQuote(StringBuffer buffer, RandomAccessFile raFile, char eq) {
        try {
            int i;
            while ((i = raFile.read()) != -1) {
                char c = (char)i;
                buffer.append(c);
                if (c == eq) break;
            }
            return;
        }
        catch (IOException e) {
            return;
        }
    }

    private static void readComment(StringBuffer buffer, RandomAccessFile raFile) {
        try {
            int i;
            int numRead = 0;
            while ((i = raFile.read()) != -1) {
                char c = (char)i;
                buffer.append(c);
                if (c == '>' && ++numRead >= 2 && buffer.substring(buffer.length() - 3, buffer.length() - 1).equals("--")) break;
            }
            return;
        }
        catch (IOException e) {
            return;
        }
    }

    public static StringBuffer parseElement(Element parentElement, StringBuffer buffer) {
        NodeList nodeList = parentElement.getChildNodes();
        String separator = null;
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                if (separator == null) {
                    separator = " | ";
                } else {
                    buffer.append(separator);
                }
                Element element = (Element)node;
                if (!element.hasChildNodes()) {
                    buffer.append(element.getNodeName());
                } else if (element.getChildNodes().getLength() == 1 && element.getFirstChild().getNodeType() == 3) {
                    buffer.append(String.valueOf(element.getNodeName()) + ":" + element.getFirstChild().getNodeValue().trim());
                } else {
                    buffer.append(element.getNodeName());
                    buffer.append(" [ ");
                    CustomXmlTrace.parseElement(element, buffer);
                    buffer.append(" ]");
                }
            } else if (nodeType == 3 && !node.getNodeValue().trim().isEmpty()) {
                buffer.append(node.getNodeValue().trim());
            }
            ++i;
        }
        return buffer;
    }

    public CustomXmlInputElement getRecordInputElement(CustomXmlInputElement inputElement) {
        if (inputElement.isLogEntry()) {
            return inputElement;
        }
        if (inputElement.getChildElements() != null) {
            for (CustomXmlInputElement childInputElement : inputElement.getChildElements()) {
                CustomXmlInputElement recordInputElement = this.getRecordInputElement(childInputElement);
                if (recordInputElement == null) continue;
                return recordInputElement;
            }
        }
        return null;
    }

    public CustomXmlEvent extractEvent(Element element, CustomXmlInputElement inputElement) {
        CustomXmlEvent event = new CustomXmlEvent(this.fDefinition, (ITmfTrace)this, TmfTimestamp.ZERO, (TmfEventType)this.fEventType);
        event.setContent(new CustomEventContent(event, new StringBuffer()));
        this.parseElement(element, event, inputElement);
        return event;
    }

    private void parseElement(Element element, CustomXmlEvent event, CustomXmlInputElement inputElement) {
        if (inputElement.getInputName() != null && !inputElement.getInputName().equals(CustomXmlTraceDefinition.TAG_IGNORE)) {
            event.parseInput(CustomXmlTrace.parseElement(element, new StringBuffer()).toString(), inputElement.getInputName(), inputElement.getInputAction(), inputElement.getInputFormat());
        }
        if (inputElement.getAttributes() != null) {
            for (CustomXmlInputAttribute attribute : inputElement.getAttributes()) {
                event.parseInput(element.getAttribute(attribute.getAttributeName()), attribute.getInputName(), attribute.getInputAction(), attribute.getInputFormat());
            }
        }
        NodeList childNodes = element.getChildNodes();
        if (inputElement.getChildElements() != null) {
            int i = 0;
            while (i < childNodes.getLength()) {
                Node node = childNodes.item(i);
                if (node instanceof Element) {
                    for (CustomXmlInputElement child : inputElement.getChildElements()) {
                        if (!node.getNodeName().equals(child.getElementName())) continue;
                        this.parseElement((Element)node, event, child);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    public CustomTraceDefinition getDefinition() {
        return this.fDefinition;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IStatus validate(IProject project, String path) {
        File file = new File(path);
        if (!file.exists()) return new Status(4, "org.eclipse.tracecompass.tmf.core", String.valueOf(Messages.CustomTrace_FileNotFound) + ": " + path);
        if (!file.isFile()) return new Status(4, "org.eclipse.tracecompass.tmf.core", String.valueOf(Messages.CustomTrace_FileNotFound) + ": " + path);
        if (!file.canRead()) {
            return new Status(4, "org.eclipse.tracecompass.tmf.core", String.valueOf(Messages.CustomTrace_FileNotFound) + ": " + path);
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                TraceValidationStatus traceValidationStatus;
                BufferedRandomAccessFile rafile = new BufferedRandomAccessFile(path, "r");
                try {
                    int lineCount = 0;
                    long rawPos = 0L;
                    String line = rafile.getNextLine();
                    while (line != null) {
                        if (lineCount++ >= 100) {
                            return new TraceValidationStatus(0, "org.eclipse.tracecompass.tmf.core");
                        }
                        int idx = CustomXmlTrace.indexOfElement(this.fRecordInputElement.getElementName(), line, 0);
                        if (idx != -1) {
                            rafile.seek(rawPos + (long)idx + 1L);
                            StringBuffer elementBuffer = new StringBuffer("<");
                            this.readElement(elementBuffer, rafile);
                            Element element = this.parseElementBuffer(elementBuffer);
                            if (element != null) {
                                rafile.close();
                                traceValidationStatus = new TraceValidationStatus(100, "org.eclipse.tracecompass.tmf.core");
                                return traceValidationStatus;
                            }
                        }
                        rawPos = rafile.getFilePointer();
                        line = rafile.getNextLine();
                    }
                    return new TraceValidationStatus(0, "org.eclipse.tracecompass.tmf.core");
                }
                finally {
                    if (rafile == null) return traceValidationStatus;
                    rafile.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.tracecompass.tmf.core", "IOException validating file: " + path, (Throwable)e);
        }
    }

    @Override
    public synchronized int getCheckpointSize() {
        if (fCheckpointSize == -1) {
            TmfCheckpoint c = new TmfCheckpoint(TmfTimestamp.ZERO, (ITmfLocation)new TmfLongLocation(0L), 0L);
            ByteBuffer b = ByteBuffer.allocate(1024);
            b.clear();
            c.serialize(b);
            fCheckpointSize = b.position();
        }
        return fCheckpointSize;
    }

    @Override
    public ITmfLocation restoreLocation(ByteBuffer bufferIn) {
        return new TmfLongLocation(bufferIn);
    }

    @Override
    protected ITmfTraceIndexer createIndexer(int interval) {
        return new TmfBTreeTraceIndexer(this, interval);
    }

    @Override
    public String getTraceTypeId() {
        return this.fTraceTypeId;
    }

    @NonNull
    public static String buildTraceTypeId(String category, String definitionName) {
        return CUSTOM_XML_TRACE_TYPE_PREFIX + category + ':' + definitionName;
    }

    public static boolean isCustomTraceTypeId(@NonNull String traceTypeId) {
        return traceTypeId.startsWith(CUSTOM_XML_TRACE_TYPE_PREFIX);
    }

    @NonNull
    public static String buildCompatibilityTraceTypeId(@NonNull String traceTypeId) {
        if (traceTypeId.startsWith(EARLY_TRACE_COMPASS_CUSTOM_XML_TRACE_TYPE_PREFIX)) {
            return CUSTOM_XML_TRACE_TYPE_PREFIX + traceTypeId.substring(EARLY_TRACE_COMPASS_CUSTOM_XML_TRACE_TYPE_PREFIX.length());
        }
        int index = traceTypeId.lastIndexOf(58);
        if (index != -1 && traceTypeId.startsWith(LINUX_TOOLS_CUSTOM_XML_TRACE_TYPE_PREFIX)) {
            String definitionName;
            String string = definitionName = index < traceTypeId.length() ? traceTypeId.substring(index + 1) : "";
            if (traceTypeId.contains(String.valueOf(CustomXmlTrace.class.getSimpleName()) + ':') && traceTypeId.indexOf(58) == index) {
                return CustomXmlTrace.buildTraceTypeId("Custom XML", definitionName);
            }
            return CUSTOM_XML_TRACE_TYPE_PREFIX + traceTypeId.substring(LINUX_TOOLS_CUSTOM_XML_TRACE_TYPE_PREFIX.length());
        }
        return traceTypeId;
    }
}

