/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.trace;

import java.util.HashSet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

@NonNullByDefault
public final class TmfTraceUtils {
    private TmfTraceUtils() {
    }

    @Nullable
    public static <T extends IAnalysisModule> T getAnalysisModuleOfClass(ITmfTrace trace, Class<T> moduleClass, String id) {
        Iterable<IAnalysisModule> modules = TmfTraceUtils.getAnalysisModulesOfClass(trace, moduleClass);
        for (IAnalysisModule module : modules) {
            if (!id.equals(module.getId())) continue;
            return (T)module;
        }
        return null;
    }

    public static <T> Iterable<T> getAnalysisModulesOfClass(ITmfTrace trace, Class<T> moduleClass) {
        Iterable<IAnalysisModule> analysisModules = trace.getAnalysisModules();
        HashSet<T> modules = new HashSet<T>();
        for (IAnalysisModule module : analysisModules) {
            if (!moduleClass.isAssignableFrom(module.getClass())) continue;
            modules.add(moduleClass.cast(module));
        }
        return modules;
    }

    @Nullable
    public static <T extends ITmfEventAspect> Object resolveEventAspectOfClassForEvent(ITmfTrace trace, Class<T> aspectClass, ITmfEvent event) {
        Iterable<ITmfEventAspect> aspects = trace.getEventAspects();
        for (ITmfEventAspect aspect : aspects) {
            Object obj;
            if (!aspectClass.isAssignableFrom(aspect.getClass()) || (obj = aspect.resolve(event)) == null) continue;
            return obj;
        }
        return null;
    }
}

