/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.trace;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.CTFCallsite;
import org.eclipse.tracecompass.ctf.core.event.CTFClock;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.CTFTraceReader;
import org.eclipse.tracecompass.ctf.core.trace.Metadata;
import org.eclipse.tracecompass.internal.tmf.ctf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.ctf.core.trace.iterator.CtfIterator;
import org.eclipse.tracecompass.internal.tmf.ctf.core.trace.iterator.CtfIteratorManager;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfNanoTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceProperties;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceWithPreDefinedEvents;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfPersistentlyIndexable;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.TmfBTreeTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.ctf.core.CtfConstants;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfLocation;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfLocationInfo;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfTmfContext;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEventType;
import org.eclipse.tracecompass.tmf.ctf.core.event.aspect.CtfChannelAspect;
import org.eclipse.tracecompass.tmf.ctf.core.event.aspect.CtfCpuAspect;
import org.eclipse.tracecompass.tmf.ctf.core.event.lookup.CtfTmfCallsite;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTraceValidationStatus;
import org.eclipse.tracecompass.tmf.ctf.core.trace.Messages;

public class CtfTmfTrace
extends TmfTrace
implements ITmfTraceProperties,
ITmfPersistentlyIndexable,
ITmfTraceWithPreDefinedEvents,
AutoCloseable {
    protected static final int DEFAULT_CACHE_SIZE = 50000;
    @NonNull
    protected static final Collection<ITmfEventAspect> CTF_ASPECTS = (Collection)NonNullUtils.checkNotNull((Object)ImmutableList.of((Object)ITmfEventAspect.BaseAspects.TIMESTAMP, (Object)new CtfChannelAspect(), (Object)((Object)new CtfCpuAspect()), (Object)ITmfEventAspect.BaseAspects.EVENT_TYPE, (Object)ITmfEventAspect.BaseAspects.CONTENTS));
    private static final String CLOCK_HOST_PROPERTY = "uuid";
    private static final int CONFIDENCE = 10;
    private static final int MIN_CONFIDENCE = 1;
    private final Map<String, CtfTmfEventType> fContainedEventTypes = Collections.synchronizedMap(new HashMap());
    private final CtfIteratorManager fIteratorManager = new CtfIteratorManager(this);
    private CTFTrace fTrace;
    private static int fCheckpointSize = -1;

    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> eventType) throws TmfTraceException {
        this.setCacheSize();
        super.initTrace(resource, path, eventType);
        try {
            this.fTrace = new CTFTrace(path);
            CtfTmfContext ctx = (CtfTmfContext)this.seekEvent(0L);
            CtfTmfEvent event = this.getNext(ctx);
            if (ctx.getLocation().equals((Object)CtfIterator.NULL_LOCATION) || ctx.getCurrentEvent() == null) {
                this.setStartTime(TmfTimestamp.BIG_BANG);
            } else {
                ITmfTimestamp curTime = event.getTimestamp();
                this.setStartTime(curTime);
                this.setEndTime(curTime);
            }
            Throwable throwable = null;
            Object var7_9 = null;
            try (CtfIterator iter = this.fIteratorManager.getIterator(ctx);){
                for (IEventDeclaration ied : iter.getEventDeclarations()) {
                    CtfTmfEventType ctfTmfEventType = this.fContainedEventTypes.get(ied.getName());
                    if (ctfTmfEventType != null) continue;
                    ArrayList<TmfEventField> content = new ArrayList<TmfEventField>();
                    for (String fieldName : ied.getFields().getFieldsList()) {
                        content.add(new TmfEventField(fieldName, null, null));
                    }
                    TmfEventField contentTree = new TmfEventField(":root:", null, content.toArray(new ITmfEventField[content.size()]));
                    ctfTmfEventType = new CtfTmfEventType(ied.getName(), (ITmfEventField)contentTree);
                    this.fContainedEventTypes.put(ctfTmfEventType.getName(), ctfTmfEventType);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CTFException e) {
            throw new TmfTraceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.dispose();
    }

    public synchronized void dispose() {
        this.fIteratorManager.dispose();
        if (this.fTrace != null) {
            this.fTrace = null;
        }
        super.dispose();
    }

    public IStatus validate(IProject project, String path) {
        boolean isMetadataFile = false;
        try {
            isMetadataFile = Metadata.preValidate((String)path);
        }
        catch (CTFException e) {
            return new Status(4, "org.eclipse.tracecompass.tmf.ctf.core", String.valueOf(Messages.CtfTmfTrace_ReadingError) + ": " + e.toString(), (Throwable)e);
        }
        if (isMetadataFile) {
            try {
                CTFTrace trace = new CTFTrace(path);
                if (!trace.majorIsSet()) {
                    if (isMetadataFile) {
                        return new TraceValidationStatus(1, 2, "org.eclipse.tracecompass.tmf.ctf.core", Messages.CtfTmfTrace_MajorNotSet, null);
                    }
                    return new Status(4, "org.eclipse.tracecompass.tmf.ctf.core", Messages.CtfTmfTrace_MajorNotSet);
                }
                Throwable throwable = null;
                Object var6_8 = null;
                try {
                    CTFTraceReader ctfTraceReader = new CTFTraceReader(trace);
                    if (ctfTraceReader != null) {
                        ctfTraceReader.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return new CtfTraceValidationStatus(10, "org.eclipse.tracecompass.tmf.ctf.core", trace.getEnvironment());
            }
            catch (BufferOverflowException | CTFException e) {
                return new TraceValidationStatus(1, 2, "org.eclipse.tracecompass.tmf.ctf.core", String.valueOf(Messages.CtfTmfTrace_ReadingError) + ": " + e.toString(), e);
            }
        }
        return new Status(4, "org.eclipse.tracecompass.tmf.ctf.core", Messages.CtfTmfTrace_ReadingError);
    }

    public Iterable<ITmfEventAspect> getEventAspects() {
        return CTF_ASPECTS;
    }

    public ITmfLocation getCurrentLocation() {
        return null;
    }

    public double getLocationRatio(ITmfLocation location) {
        CtfLocation curLocation = (CtfLocation)location;
        CtfTmfContext context = new CtfTmfContext(this);
        context.setLocation((ITmfLocation)curLocation);
        context.seek(curLocation.getLocationInfo());
        CtfLocationInfo currentTime = (CtfLocationInfo)context.getLocation().getLocationInfo();
        long startTime = this.fIteratorManager.getIterator(context).getStartTime();
        long endTime = this.fIteratorManager.getIterator(context).getEndTime();
        return ((double)currentTime.getTimestamp() - (double)startTime) / (double)(endTime - startTime);
    }

    public synchronized ITmfContext seekEvent(ITmfLocation location) {
        CtfLocation currentLocation = (CtfLocation)location;
        CtfTmfContext context = new CtfTmfContext(this);
        if (this.fTrace == null) {
            context.setLocation(null);
            context.setRank(-1L);
            return context;
        }
        if (currentLocation == null) {
            currentLocation = new CtfLocation(new CtfLocationInfo(0L, 0L));
            context.setRank(0L);
        }
        if (currentLocation.getLocationInfo() == CtfLocation.INVALID_LOCATION) {
            currentLocation = new CtfLocation(this.fTrace.getCurrentEndTime() + 1L, 0L);
        }
        context.setLocation((ITmfLocation)currentLocation);
        if (location == null) {
            long timestamp = this.fIteratorManager.getIterator(context).getCurrentTimestamp();
            currentLocation = new CtfLocation(timestamp, 0L);
        }
        if (context.getRank() != 0L) {
            context.setRank(-1L);
        }
        return context;
    }

    public synchronized ITmfContext seekEvent(double ratio) {
        CtfTmfContext context = new CtfTmfContext(this);
        if (this.fTrace == null) {
            context.setLocation(null);
            context.setRank(-1L);
            return context;
        }
        long end = this.fTrace.getCurrentEndTime();
        long start = this.fTrace.getCurrentStartTime();
        long diff = end - start;
        long ratioTs = Math.round((double)diff * ratio) + start;
        context.seek(ratioTs);
        context.setRank(-1L);
        return context;
    }

    public synchronized CtfTmfEvent getNext(ITmfContext context) {
        if (this.fTrace == null) {
            return null;
        }
        CtfTmfEvent event = null;
        if (context instanceof CtfTmfContext) {
            if (context.getLocation() == null || CtfLocation.INVALID_LOCATION.equals(context.getLocation().getLocationInfo())) {
                return null;
            }
            CtfTmfContext ctfContext = (CtfTmfContext)context;
            event = ctfContext.getCurrentEvent();
            if (event != null) {
                this.updateAttributes(context, event.getTimestamp());
                ctfContext.advance();
                ctfContext.increaseRank();
            }
        }
        return event;
    }

    public String getHostId() {
        String clockHost;
        CTFClock clock = this.fTrace.getClock();
        if (clock != null && (clockHost = (String)clock.getProperty(CLOCK_HOST_PROPERTY)) != null) {
            return clockHost;
        }
        return super.getHostId();
    }

    @Nullable
    public CtfTmfCallsite getCallsite(String eventName) {
        CTFCallsite callsite = this.fTrace.getCallsite(eventName);
        if (callsite != null) {
            return new CtfTmfCallsite(callsite);
        }
        return null;
    }

    @Nullable
    public CtfTmfCallsite getCallsite(String eventName, long ip) {
        CTFCallsite calliste = this.fTrace.getCallsite(eventName, ip);
        if (calliste != null) {
            return new CtfTmfCallsite(calliste);
        }
        return null;
    }

    public Map<String, String> getEnvironment() {
        return this.fTrace.getEnvironment();
    }

    public Map<String, String> getTraceProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(this.fTrace.getEnvironment());
        properties.put(Messages.CtfTmfTrace_HostID, this.getHostId());
        return properties;
    }

    public long getOffset() {
        if (this.fTrace != null) {
            return this.fTrace.getOffset();
        }
        return 0L;
    }

    public long timestampCyclesToNanos(long cycles) {
        return this.fTrace.timestampCyclesToNanos(cycles);
    }

    public long timestampNanoToCycles(long nanos) {
        return this.fTrace.timestampNanoToCycles(nanos);
    }

    public Set<CtfTmfEventType> getContainedEventTypes() {
        return ImmutableSet.copyOf(this.fContainedEventTypes.values());
    }

    public void registerEventType(CtfTmfEventType eventType) {
        this.fContainedEventTypes.put(eventType.getName(), eventType);
    }

    public CtfTmfEvent parseEvent(ITmfContext context) {
        CtfTmfEvent event = null;
        if (context instanceof CtfTmfContext) {
            ITmfContext tmpContext = this.seekEvent(context.getLocation());
            event = this.getNext(tmpContext);
        }
        return event;
    }

    protected void setCacheSize() {
        this.setCacheSize(50000);
    }

    public ITmfContext createIterator() {
        try {
            return new CtfIterator(this.fTrace, this);
        }
        catch (CTFException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return null;
        }
    }

    public ITmfContext createIterator(CtfLocationInfo ctfLocationData, long rank) {
        try {
            return new CtfIterator(this.fTrace, this, ctfLocationData, rank);
        }
        catch (CTFException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return null;
        }
    }

    public ITmfContext createIteratorFromContext(CtfTmfContext context) {
        return this.fIteratorManager.getIterator(context);
    }

    public void disposeContext(CtfTmfContext context) {
        this.fIteratorManager.removeIterator(context);
    }

    @NonNull
    public TmfNanoTimestamp createTimestamp(long ts) {
        return new TmfNanoTimestamp(this.getTimestampTransform().transform(ts));
    }

    public synchronized int getCheckpointSize() {
        if (fCheckpointSize == -1) {
            TmfCheckpoint c = new TmfCheckpoint((ITmfTimestamp)new TmfNanoTimestamp(0L), (ITmfLocation)new CtfLocation(0L, 0L), 0L);
            ByteBuffer b = ByteBuffer.allocate(1024);
            b.clear();
            c.serialize(b);
            fCheckpointSize = b.position();
        }
        return fCheckpointSize;
    }

    protected ITmfTraceIndexer createIndexer(int interval) {
        return new TmfBTreeTraceIndexer((ITmfTrace)this, interval);
    }

    public ITmfLocation restoreLocation(ByteBuffer bufferIn) {
        return new CtfLocation(bufferIn);
    }

    public boolean isComplete() {
        if (this.getResource() == null) {
            return true;
        }
        String host = null;
        String port = null;
        String sessionName = null;
        try {
            host = this.getResource().getPersistentProperty(CtfConstants.LIVE_HOST);
            port = this.getResource().getPersistentProperty(CtfConstants.LIVE_PORT);
            sessionName = this.getResource().getPersistentProperty(CtfConstants.LIVE_SESSION_NAME);
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return true;
        }
        return host == null || port == null || sessionName == null;
    }

    public void setComplete(boolean isComplete) {
        super.setComplete(isComplete);
        try {
            if (isComplete) {
                this.getResource().setPersistentProperty(CtfConstants.LIVE_HOST, null);
                this.getResource().setPersistentProperty(CtfConstants.LIVE_PORT, null);
                this.getResource().setPersistentProperty(CtfConstants.LIVE_SESSION_NAME, null);
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }
}

