/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.remote.core.proxy;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionHostService;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.tracecompass.internal.tmf.remote.core.Activator;
import org.eclipse.tracecompass.internal.tmf.remote.core.messages.Messages;
import org.eclipse.tracecompass.tmf.remote.core.proxy.IConnectionFactory;

@NonNullByDefault
public class TmfRemoteConnectionFactory {
    public static final String LOCAL_CONNECTION_NAME = "Local";
    private static final Map<String, IConnectionFactory> CONNECTION_FACTORIES = new HashMap<String, IConnectionFactory>();
    private static final DefaultConnectionFactory DEFAULT_CONNECTION_FACTORY = new DefaultConnectionFactory();

    static {
        IRemoteServicesManager manager = TmfRemoteConnectionFactory.getService(IRemoteServicesManager.class);
        if (manager != null) {
            CONNECTION_FACTORIES.put(manager.getLocalConnectionType().getId(), new LocalConnectionFactory());
        }
    }

    public static void registerConnectionFactory(String connectionTypeId, IConnectionFactory factory) {
        CONNECTION_FACTORIES.put(connectionTypeId, factory);
    }

    public static IRemoteConnection createConnection(URI hostUri, String hostName) throws RemoteConnectionException {
        IRemoteConnectionType connectionType = TmfRemoteConnectionFactory.getConnectionType(hostUri);
        IConnectionFactory connectionFactory = CONNECTION_FACTORIES.get(connectionType.getId());
        if (connectionFactory == null) {
            connectionFactory = DEFAULT_CONNECTION_FACTORY;
        }
        return connectionFactory.createConnection(hostUri, hostName);
    }

    private static IRemoteConnectionType getConnectionType(URI hostUri) throws RemoteConnectionException {
        IRemoteServicesManager manager = TmfRemoteConnectionFactory.getService(IRemoteServicesManager.class);
        if (manager == null) {
            throw new RemoteConnectionException(MessageFormat.format(Messages.RemoteConnection_ConnectionError, hostUri));
        }
        IRemoteConnectionType connectionType = manager.getConnectionType(hostUri);
        if (connectionType == null) {
            throw new RemoteConnectionException(MessageFormat.format(Messages.RemoteConnection_ConnectionError, hostUri));
        }
        return connectionType;
    }

    @Nullable
    public static <T> T getService(Class<T> service) {
        return Activator.getService(service);
    }

    @Nullable
    public static IRemoteConnection getRemoteConnection(final String remoteServicesId, final String name) {
        IRemoteServicesManager manager = Activator.getService(IRemoteServicesManager.class);
        if (manager == null) {
            return null;
        }
        FluentIterable connections = FluentIterable.from((Iterable)manager.getAllRemoteConnections());
        Optional ret = connections.firstMatch((Predicate)new Predicate<IRemoteConnection>(){

            public boolean apply(@Nullable IRemoteConnection input) {
                return input != null && input.getConnectionType().getId().equals(remoteServicesId.toString()) && input.getName().equals(name.toString());
            }
        });
        return (IRemoteConnection)ret.orNull();
    }

    @Nullable
    public static IRemoteConnection getLocalConnection() {
        IRemoteServicesManager manager = Activator.getService(IRemoteServicesManager.class);
        if (manager != null) {
            IRemoteConnectionType type = manager.getLocalConnectionType();
            return type.getConnection(LOCAL_CONNECTION_NAME);
        }
        return null;
    }

    public static class DefaultConnectionFactory
    implements IConnectionFactory {
        @Override
        public IRemoteConnection createConnection(URI hostUri, String hostName) throws RemoteConnectionException {
            IRemoteConnectionType connectionType = TmfRemoteConnectionFactory.getConnectionType(hostUri);
            IRemoteConnection connection = null;
            for (IRemoteConnection conn : connectionType.getConnections()) {
                IRemoteConnectionHostService hostService;
                if (!conn.getName().equals(hostName) || (hostService = (IRemoteConnectionHostService)conn.getService(IRemoteConnectionHostService.class)) == null) continue;
                if (hostService.getHostname().equals(hostUri.getHost()) && (hostUri.getPort() == -1 || hostService.getPort() == hostUri.getPort())) {
                    connection = conn;
                    break;
                }
                throw new RemoteConnectionException(MessageFormat.format(Messages.RemoteConnection_DuplicateConnectionError, hostName, hostService.getHostname(), hostService.getPort()));
            }
            if (connection == null) {
                String user;
                IRemoteConnectionHostService hostService;
                IRemoteConnectionWorkingCopy wc = null;
                wc = connectionType.newConnection(hostName);
                if (wc == null) {
                    throw new RemoteConnectionException(MessageFormat.format(Messages.RemoteConnection_ConnectionError, hostUri));
                }
                if (wc.hasService(IRemoteConnectionHostService.class)) {
                    hostService = (IRemoteConnectionHostService)wc.getService(IRemoteConnectionHostService.class);
                    hostService.setHostname(hostUri.getHost());
                    hostService.setPort(hostUri.getPort());
                    user = hostUri.getUserInfo();
                    if (user == null) {
                        user = System.getProperty("user.name");
                    }
                } else {
                    throw new RemoteConnectionException(MessageFormat.format(Messages.RemoteConnection_ConnectionError, hostUri));
                }
                hostService.setUsername(user);
                hostService.setUsePassword(true);
                try {
                    connection = wc.save();
                }
                catch (RemoteConnectionException e) {
                    throw new RemoteConnectionException(MessageFormat.format(Messages.RemoteConnection_ConnectionError, hostUri), (Throwable)e);
                }
            }
            if (connection == null) {
                throw new RemoteConnectionException(MessageFormat.format(Messages.RemoteConnection_ConnectionError, hostUri));
            }
            return connection;
        }
    }

    public static class LocalConnectionFactory
    implements IConnectionFactory {
        @Override
        public IRemoteConnection createConnection(URI hostUri, String hostName) throws RemoteConnectionException {
            IRemoteConnection connection = TmfRemoteConnectionFactory.getLocalConnection();
            if (connection == null) {
                throw new RemoteConnectionException(MessageFormat.format(Messages.RemoteConnection_ConnectionError, hostUri));
            }
            return connection;
        }
    }
}

