/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportConfirmation;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportConflictHandler;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.Messages;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.util.Pair;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.dialogs.WizardResourceImportPage;
import org.eclipse.ui.ide.dialogs.ResourceTreeAndListGroup;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.dialogs.IElementFilter;
import org.eclipse.ui.internal.wizards.datatransfer.ArchiveFileManipulations;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarFile;
import org.eclipse.ui.internal.wizards.datatransfer.TarLeveledStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerComparator;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class ImportTraceWizardPage
extends WizardResourceImportPage {
    private static final String IMPORT_WIZARD_PAGE_NAME = "ImportTraceWizardPage";
    private static final String IMPORT_WIZARD_ROOT_DIRECTORY_ID = ".import_root_directory_id";
    private static final String IMPORT_WIZARD_ARCHIVE_FILE_NAME_ID = ".import_archive_file_name_id";
    private static final String IMPORT_WIZARD_IMPORT_UNRECOGNIZED_ID = ".import_unrecognized_traces_id";
    private static final String IMPORT_WIZARD_PRESERVE_FOLDERS_ID = ".import_preserve_folders_id";
    private static final String IMPORT_WIZARD_IMPORT_FROM_DIRECTORY_ID = ".import_from_directory";
    private static final String[] FILE_IMPORT_MASK = new String[]{"*.jar;*.zip;*.tar;*.tar.gz;*.tgz", "*.*"};
    private static final String TRACE_IMPORT_TEMP_FOLDER = ".traceImport";
    public static final String TRACE_TYPE_AUTO_DETECT = Messages.ImportTraceWizard_AutoDetection;
    public static final int OPTION_PRESERVE_FOLDER_STRUCTURE = 2;
    public static final int OPTION_CREATE_LINKS_IN_WORKSPACE = 4;
    public static final int OPTION_IMPORT_UNRECOGNIZED_TRACES = 8;
    public static final int OPTION_OVERWRITE_EXISTING_RESOURCES = 16;
    private IFolder fTargetFolder;
    private TmfTraceFolder fTraceFolderElement;
    private Boolean fIsDestinationChanged = false;
    private final Object fSyncObject = new Object();
    private Combo fTraceTypes;
    private Button fImportUnrecognizedButton;
    private Button fOverwriteExistingResourcesCheckbox;
    private Button fCreateLinksInWorkspaceButton;
    private Button fPreserveFolderStructureButton;
    private boolean entryChanged = false;
    private Button fImportFromDirectoryRadio;
    private Button fImportFromArchiveRadio;
    private Boolean fPreviousCreateLinksValue = true;
    protected Combo fArchiveNameField;
    protected Button fArchiveBrowseButton;
    protected Combo directoryNameField;
    protected Button directoryBrowseButton;
    private ResourceTreeAndListGroup fSelectionGroup;
    private TraceFileSystemElement fSelectionGroupRoot;

    protected ImportTraceWizardPage(String name, IStructuredSelection selection) {
        super(name, selection);
        TmfProjectElement projectElement2;
        IProject project;
        this.setTitle(Messages.ImportTraceWizard_FileSystemTitle);
        this.setDescription(Messages.ImportTraceWizard_ImportTrace);
        IFolder traceFolder = null;
        Object element = selection.getFirstElement();
        if (element instanceof TmfTraceFolder) {
            this.fTraceFolderElement = (TmfTraceFolder)element;
            traceFolder = this.fTraceFolderElement.getResource();
        } else if (element instanceof IProject) {
            project = (IProject)element;
            try {
                if (project.hasNature("org.eclipse.linuxtools.tmf.project.nature")) {
                    projectElement2 = TmfProjectRegistry.getProject(project, true);
                    this.fTraceFolderElement = projectElement2.getTracesFolder();
                    traceFolder = project.getFolder("Traces");
                }
            }
            catch (CoreException projectElement2) {
                // empty catch block
            }
        }
        if (traceFolder == null) {
            project = TmfProjectRegistry.createProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME, null, (IProgressMonitor)new NullProgressMonitor());
            projectElement2 = TmfProjectRegistry.getProject(project, true);
            this.fTraceFolderElement = projectElement2.getTracesFolder();
            traceFolder = project.getFolder("Traces");
        }
        if (traceFolder != null) {
            this.fTargetFolder = traceFolder;
            String path = traceFolder.getFullPath().toString();
            this.setContainerFieldValue(path);
        }
    }

    public ImportTraceWizardPage(IStructuredSelection selection) {
        this(IMPORT_WIZARD_PAGE_NAME, selection);
    }

    protected void createFileSelectionGroup(Composite parent) {
        this.fSelectionGroup = new ResourceTreeAndListGroup(parent, (Object)new FileSystemElement("Dummy", null, true), this.getFolderProvider(), (ILabelProvider)new WorkbenchLabelProvider(), (IStructuredContentProvider)this.getFileProvider(), (ILabelProvider)new WorkbenchLabelProvider(), 0, DialogUtil.inRegularFontMode((Composite)parent));
        ICheckStateListener listener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ImportTraceWizardPage.this.updateWidgetEnablements();
            }
        };
        WorkbenchViewerComparator comparator = new WorkbenchViewerComparator();
        this.fSelectionGroup.setTreeComparator((ViewerComparator)comparator);
        this.fSelectionGroup.setListComparator((ViewerComparator)comparator);
        this.fSelectionGroup.addCheckStateListener(listener);
    }

    protected void createSourceGroup(Composite parent) {
        this.createSourceSelectionGroup(parent);
        this.createFileSelectionGroup(parent);
        this.createTraceTypeGroup(parent);
        this.validateSourceGroup();
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object object) {
                if (object instanceof TraceFileSystemElement) {
                    TraceFileSystemElement element = (TraceFileSystemElement)((Object)object);
                    return element.getFiles().getChildren((Object)element);
                }
                return new Object[0];
            }
        };
    }

    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof TraceFileSystemElement) {
                    TraceFileSystemElement element = (TraceFileSystemElement)((Object)o);
                    return element.getFolders().getChildren();
                }
                return new Object[0];
            }

            public boolean hasChildren(Object o) {
                if (o instanceof TraceFileSystemElement) {
                    TraceFileSystemElement element = (TraceFileSystemElement)((Object)o);
                    if (element.isPopulated()) {
                        return this.getChildren((Object)element).length > 0;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected void createSourceSelectionGroup(Composite parent) {
        Composite sourceGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        sourceGroup.setLayout((Layout)layout);
        sourceGroup.setLayoutData((Object)new GridData(768));
        this.fImportFromDirectoryRadio = new Button(sourceGroup, 16);
        this.fImportFromDirectoryRadio.setText(Messages.ImportTraceWizard_DirectoryLocation);
        this.directoryNameField = this.createPathSelectionCombo(sourceGroup);
        this.createDirectoryBrowseButton(sourceGroup);
        this.fImportFromArchiveRadio = new Button(sourceGroup, 16);
        this.fImportFromArchiveRadio.setText(Messages.ImportTraceWizard_ArchiveLocation);
        this.fArchiveNameField = this.createPathSelectionCombo(sourceGroup);
        this.createArchiveBrowseButton(sourceGroup);
        this.fImportFromDirectoryRadio.setSelection(true);
        this.fArchiveNameField.setEnabled(false);
        this.fArchiveBrowseButton.setEnabled(false);
        this.fImportFromDirectoryRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPage.this.directoryRadioSelected();
            }
        });
        this.fImportFromArchiveRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPage.this.archiveRadioSelected();
            }
        });
    }

    protected void setFileSelectionGroupChecked(boolean checked) {
        if (this.fSelectionGroup != null) {
            this.fSelectionGroup.setAllSelections(checked);
        }
    }

    protected Combo createPathSelectionCombo(Composite parent) {
        Combo pathSelectionCombo = new Combo(parent, 2048);
        GridData layoutData = new GridData(768);
        layoutData.widthHint = new PixelConverter((Control)pathSelectionCombo).convertWidthInCharsToPixels(25);
        pathSelectionCombo.setLayoutData((Object)layoutData);
        TraverseListener traverseListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    ImportTraceWizardPage.this.entryChanged = false;
                    ImportTraceWizardPage.this.updateFromSourceField();
                }
            }
        };
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (ImportTraceWizardPage.this.entryChanged) {
                    ImportTraceWizardPage.this.entryChanged = false;
                    ImportTraceWizardPage.this.updateFromSourceField();
                }
            }
        };
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPage.this.entryChanged = false;
                ImportTraceWizardPage.this.updateFromSourceField();
            }
        };
        ModifyListener modifyListner = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportTraceWizardPage.this.entryChanged = true;
            }
        };
        pathSelectionCombo.addModifyListener(modifyListner);
        pathSelectionCombo.addTraverseListener(traverseListener);
        pathSelectionCombo.addFocusListener((FocusListener)focusAdapter);
        pathSelectionCombo.addSelectionListener((SelectionListener)selectionAdapter);
        return pathSelectionCombo;
    }

    protected void createDirectoryBrowseButton(Composite parent) {
        this.directoryBrowseButton = this.createPathSelectionBrowseButton(parent);
        this.directoryBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPage.this.handleSourceDirectoryBrowseButtonPressed();
            }
        });
    }

    protected void createArchiveBrowseButton(Composite parent) {
        this.fArchiveBrowseButton = this.createPathSelectionBrowseButton(parent);
        this.fArchiveBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPage.this.handleArchiveBrowseButtonPressed(FILE_IMPORT_MASK);
            }
        });
    }

    protected Button createPathSelectionBrowseButton(Composite parent) {
        Button pathSelectionBrowseButton = new Button(parent, 8);
        pathSelectionBrowseButton.setText(Messages.ImportTraceWizard_BrowseButton);
        this.setButtonLayoutData(pathSelectionBrowseButton);
        return pathSelectionBrowseButton;
    }

    private void archiveRadioSelected() {
        if (!this.isImportFromDirectory()) {
            this.directoryNameField.setEnabled(false);
            this.directoryBrowseButton.setEnabled(false);
            this.fArchiveNameField.setEnabled(true);
            this.fArchiveBrowseButton.setEnabled(true);
            this.updateFromSourceField();
            this.fArchiveNameField.setFocus();
            if (this.fCreateLinksInWorkspaceButton != null) {
                this.fPreviousCreateLinksValue = this.fCreateLinksInWorkspaceButton.getSelection();
                this.fCreateLinksInWorkspaceButton.setSelection(false);
                this.fCreateLinksInWorkspaceButton.setEnabled(false);
            }
        }
    }

    private void directoryRadioSelected() {
        if (this.isImportFromDirectory()) {
            this.directoryNameField.setEnabled(true);
            this.directoryBrowseButton.setEnabled(true);
            this.fArchiveNameField.setEnabled(false);
            this.fArchiveBrowseButton.setEnabled(false);
            this.updateFromSourceField();
            this.directoryNameField.setFocus();
            if (this.fCreateLinksInWorkspaceButton != null) {
                this.fCreateLinksInWorkspaceButton.setSelection(this.fPreviousCreateLinksValue.booleanValue());
                this.fCreateLinksInWorkspaceButton.setEnabled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        if (event.widget == this.directoryBrowseButton) {
            this.handleSourceDirectoryBrowseButtonPressed();
        }
        Object object = this.fSyncObject;
        synchronized (object) {
            if (!this.fIsDestinationChanged.booleanValue()) {
                event.display.asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = ImportTraceWizardPage.this.fSyncObject;
                        synchronized (object) {
                            ImportTraceWizardPage.this.fIsDestinationChanged = true;
                            String path = ImportTraceWizardPage.this.fTargetFolder.getFullPath().toString();
                            ImportTraceWizardPage.this.setContainerFieldValue(path);
                        }
                    }
                });
            } else {
                this.fIsDestinationChanged = false;
            }
        }
        super.handleEvent(event);
    }

    protected void handleContainerBrowseButtonPressed() {
    }

    protected void handleSourceDirectoryBrowseButtonPressed() {
        String currentSource = this.directoryNameField.getText();
        DirectoryDialog dialog = new DirectoryDialog(this.directoryNameField.getShell(), 0x10002000);
        dialog.setText(Messages.ImportTraceWizard_SelectTraceDirectoryTitle);
        dialog.setMessage(Messages.ImportTraceWizard_SelectTraceDirectoryMessage);
        dialog.setFilterPath(ImportTraceWizardPage.getSourceDirectoryName(currentSource));
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            if (ImportTraceWizardPage.getSourceDirectory(selectedDirectory) == null || selectedDirectory.equals(currentSource)) {
                return;
            }
            this.setErrorMessage(null);
            this.setSourcePath(selectedDirectory);
        }
    }

    protected void handleArchiveBrowseButtonPressed(String[] extensions) {
        String selectedArchive;
        File path;
        FileDialog dialog = new FileDialog(this.fArchiveNameField.getShell(), 0x10000000);
        dialog.setFilterExtensions(extensions);
        dialog.setText(Messages.ImportTraceWizard_SelectTraceArchiveTitle);
        String fileName = this.fArchiveNameField.getText().trim();
        if (!fileName.isEmpty() && (path = new File(fileName).getParentFile()) != null && path.exists()) {
            dialog.setFilterPath(path.toString());
        }
        if ((selectedArchive = dialog.open()) != null) {
            this.setErrorMessage(null);
            this.setSourcePath(selectedArchive);
            this.updateWidgetEnablements();
        }
    }

    private File getSourceDirectory() {
        if (this.directoryNameField == null) {
            return null;
        }
        return ImportTraceWizardPage.getSourceDirectory(this.directoryNameField.getText());
    }

    private File getSourceArchiveFile() {
        if (this.fArchiveNameField == null) {
            return null;
        }
        return ImportTraceWizardPage.getSourceArchiveFile(this.fArchiveNameField.getText());
    }

    private String getSourceContainerPath() {
        File sourceDirectory;
        if (this.isImportFromDirectory() && (sourceDirectory = this.getSourceDirectory()) != null) {
            return sourceDirectory.getAbsolutePath();
        }
        File sourceArchiveFile = this.getSourceArchiveFile();
        if (sourceArchiveFile != null) {
            return sourceArchiveFile.getParent();
        }
        return null;
    }

    private static File getSourceDirectory(String path) {
        File sourceDirectory = new File(ImportTraceWizardPage.getSourceDirectoryName(path));
        if (!sourceDirectory.exists() || !sourceDirectory.isDirectory()) {
            return null;
        }
        return sourceDirectory;
    }

    private static File getSourceArchiveFile(String path) {
        File sourceArchiveFile = new File(path);
        if (!sourceArchiveFile.exists() || sourceArchiveFile.isDirectory()) {
            return null;
        }
        return sourceArchiveFile;
    }

    private static String getSourceDirectoryName(String sourceName) {
        Path result = new Path(sourceName.trim());
        result = result.getDevice() != null && result.segmentCount() == 0 ? result.addTrailingSeparator() : result.removeTrailingSeparator();
        return result.toOSString();
    }

    private void updateFromSourceField() {
        this.setSourcePath(this.getSourceField().getText());
        this.updateWidgetEnablements();
    }

    private Combo getSourceField() {
        if (this.directoryNameField == null) {
            return this.fArchiveNameField;
        }
        return this.directoryNameField.isEnabled() ? this.directoryNameField : this.fArchiveNameField;
    }

    protected void setSourcePath(String path) {
        Combo sourceField = this.getSourceField();
        if (sourceField == null) {
            return;
        }
        if (path.length() > 0) {
            String[] currentItems = sourceField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                sourceField.setItems(newItems);
                selectionIndex = oldLength;
            }
            sourceField.select(selectionIndex);
        }
        this.resetSelection();
    }

    private void resetSelection() {
        if (this.fSelectionGroupRoot != null) {
            this.disposeSelectionGroupRoot();
        }
        this.fSelectionGroupRoot = this.getFileSystemTree();
        this.fSelectionGroup.setRoot((Object)this.fSelectionGroupRoot);
    }

    private void disposeSelectionGroupRoot() {
        if (this.fSelectionGroupRoot != null && this.fSelectionGroupRoot.getProvider() != null) {
            FileSystemObjectImportStructureProvider provider = this.fSelectionGroupRoot.getProvider();
            provider.dispose();
            this.fSelectionGroupRoot = null;
        }
    }

    private TraceFileSystemElement getFileSystemTree() {
        Pair<IFileSystemObject, FileSystemObjectImportStructureProvider> rootObjectAndProvider = this.getRootObjectAndProvider(this.getSourceFile());
        if (rootObjectAndProvider == null) {
            return null;
        }
        return this.selectFiles((IFileSystemObject)rootObjectAndProvider.getFirst(), (FileSystemObjectImportStructureProvider)rootObjectAndProvider.getSecond());
    }

    private Pair<IFileSystemObject, FileSystemObjectImportStructureProvider> getRootObjectAndProvider(File sourceFile) {
        if (sourceFile == null) {
            return null;
        }
        IFileSystemObject rootElement = null;
        FileSystemObjectImportStructureProvider importStructureProvider = null;
        if (!ImportTraceWizardPage.isArchiveFile(sourceFile)) {
            importStructureProvider = new FileSystemObjectImportStructureProvider((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null, null, null);
            rootElement = importStructureProvider.getIFileSystemObject(sourceFile);
        } else {
            FileSystemObjectLeveledImportStructureProvider leveledImportStructureProvider = null;
            String archivePath = sourceFile.getAbsolutePath();
            if (ImportTraceWizardPage.isTarFile(archivePath)) {
                if (this.ensureTarSourceIsValid(archivePath)) {
                    TarFile tarFile = ImportTraceWizardPage.getSpecifiedTarSourceFile(archivePath);
                    leveledImportStructureProvider = new FileSystemObjectLeveledImportStructureProvider((ILeveledImportStructureProvider)new TarLeveledStructureProvider(tarFile), archivePath);
                }
            } else if (this.ensureZipSourceIsValid(archivePath)) {
                ZipFile zipFile = ImportTraceWizardPage.getSpecifiedZipSourceFile(archivePath);
                leveledImportStructureProvider = new FileSystemObjectLeveledImportStructureProvider((ILeveledImportStructureProvider)new ZipLeveledStructureProvider(zipFile), archivePath);
            }
            if (leveledImportStructureProvider == null) {
                return null;
            }
            rootElement = leveledImportStructureProvider.getRoot();
            importStructureProvider = leveledImportStructureProvider;
        }
        if (rootElement == null) {
            return null;
        }
        return new Pair((Object)rootElement, (Object)importStructureProvider);
    }

    private boolean ensureZipSourceIsValid(String archivePath) {
        ZipFile specifiedFile = ImportTraceWizardPage.getSpecifiedZipSourceFile(archivePath);
        if (specifiedFile == null) {
            return false;
        }
        return ArchiveFileManipulations.closeZipFile((ZipFile)specifiedFile, (Shell)this.getShell());
    }

    private boolean ensureTarSourceIsValid(String archivePath) {
        TarFile specifiedFile = ImportTraceWizardPage.getSpecifiedTarSourceFile(archivePath);
        if (specifiedFile == null) {
            return false;
        }
        return ArchiveFileManipulations.closeTarFile((TarFile)specifiedFile, (Shell)this.getShell());
    }

    private static ZipFile getSpecifiedZipSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (ZipException zipException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static boolean isTarFile(String fileName) {
        TarFile specifiedTarSourceFile = ImportTraceWizardPage.getSpecifiedTarSourceFile(fileName);
        if (specifiedTarSourceFile != null) {
            try {
                specifiedTarSourceFile.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private static TarFile getSpecifiedTarSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        if (new File(fileName).length() < 512L) {
            return null;
        }
        try {
            return new TarFile(fileName);
        }
        catch (IOException | TarException throwable) {
            return null;
        }
    }

    private TraceFileSystemElement selectFiles(final IFileSystemObject rootFileSystemObject, final FileSystemObjectImportStructureProvider structureProvider) {
        final TraceFileSystemElement[] results = new TraceFileSystemElement[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                results[0] = ImportTraceWizardPage.createRootTraceFileElement(rootFileSystemObject, structureProvider);
            }
        });
        return results[0];
    }

    private static TraceFileSystemElement createRootTraceFileElement(IFileSystemObject element, FileSystemObjectImportStructureProvider provider) {
        boolean isContainer = provider.isFolder(element);
        String elementLabel = provider.getLabel(element);
        TraceFileSystemElement dummyParent = new TraceFileSystemElement("", null, true, provider);
        IFileSystemObject dummyParentFileSystemObject = element;
        Object rawFileSystemObject = element.getRawFileSystemObject();
        if (rawFileSystemObject instanceof File) {
            dummyParentFileSystemObject = provider.getIFileSystemObject(((File)rawFileSystemObject).getParentFile());
        }
        dummyParent.setFileSystemObject(dummyParentFileSystemObject);
        dummyParent.setPopulated();
        TraceFileSystemElement result = new TraceFileSystemElement(elementLabel, dummyParent, isContainer, provider);
        result.setFileSystemObject(element);
        result.getFiles();
        return dummyParent;
    }

    private final void createTraceTypeGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        GridData buttonData = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)buttonData);
        Label typeLabel = new Label(composite, 0);
        typeLabel.setText(Messages.ImportTraceWizard_TraceType);
        typeLabel.setFont(parent.getFont());
        this.fTraceTypes = new Combo(composite, 2056);
        GridData data = new GridData(4, 4, true, false, 2, 1);
        this.fTraceTypes.setLayoutData((Object)data);
        this.fTraceTypes.setFont(parent.getFont());
        String[] availableTraceTypes = TmfTraceType.getAvailableTraceTypes();
        String[] traceTypeList = new String[availableTraceTypes.length + 1];
        traceTypeList[0] = TRACE_TYPE_AUTO_DETECT;
        int i = 0;
        while (i < availableTraceTypes.length) {
            traceTypeList[i + 1] = availableTraceTypes[i];
            ++i;
        }
        this.fTraceTypes.setItems(traceTypeList);
        this.fTraceTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPage.this.updateWidgetEnablements();
                boolean enabled = ImportTraceWizardPage.this.fTraceTypes.getText().equals(TRACE_TYPE_AUTO_DETECT);
                ImportTraceWizardPage.this.fImportUnrecognizedButton.setEnabled(enabled);
            }
        });
        this.fTraceTypes.select(0);
        this.fImportUnrecognizedButton = new Button(composite, 32);
        this.fImportUnrecognizedButton.setSelection(true);
        this.fImportUnrecognizedButton.setText(Messages.ImportTraceWizard_ImportUnrecognized);
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        this.fOverwriteExistingResourcesCheckbox = new Button((Composite)optionsGroup, 32);
        this.fOverwriteExistingResourcesCheckbox.setFont(optionsGroup.getFont());
        this.fOverwriteExistingResourcesCheckbox.setText(Messages.ImportTraceWizard_OverwriteExistingTrace);
        this.fOverwriteExistingResourcesCheckbox.setSelection(false);
        this.fCreateLinksInWorkspaceButton = new Button((Composite)optionsGroup, 32);
        this.fCreateLinksInWorkspaceButton.setFont(optionsGroup.getFont());
        this.fCreateLinksInWorkspaceButton.setText(Messages.ImportTraceWizard_CreateLinksInWorkspace);
        this.fCreateLinksInWorkspaceButton.setSelection(true);
        this.fCreateLinksInWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPage.this.updateWidgetEnablements();
            }
        });
        this.fPreserveFolderStructureButton = new Button((Composite)optionsGroup, 32);
        this.fPreserveFolderStructureButton.setFont(optionsGroup.getFont());
        this.fPreserveFolderStructureButton.setText(Messages.ImportTraceWizard_PreserveFolderStructure);
        this.fPreserveFolderStructureButton.setSelection(true);
        this.updateWidgetEnablements();
    }

    public boolean validateSourceGroup() {
        File source = this.getSourceFile();
        if (source == null) {
            this.setMessage(Messages.ImportTraceWizard_SelectTraceSourceEmpty);
            this.setErrorMessage(null);
            return false;
        }
        if (this.sourceConflictsWithDestination((IPath)new Path(source.getPath()))) {
            this.setMessage(null);
            this.setErrorMessage(this.getSourceConflictMessage());
            return false;
        }
        if (!(this.isImportFromDirectory() || this.ensureTarSourceIsValid(source.getAbsolutePath()) || this.ensureZipSourceIsValid(source.getAbsolutePath()))) {
            this.setMessage(null);
            this.setErrorMessage(Messages.ImportTraceWizard_BadArchiveFormat);
            return false;
        }
        if (this.fSelectionGroup.getCheckedElementCount() == 0) {
            this.setMessage(null);
            this.setErrorMessage(Messages.ImportTraceWizard_SelectTraceNoneSelected);
            return false;
        }
        IContainer container = this.getSpecifiedContainer();
        if (container != null && container.isVirtual()) {
            if (Platform.getPreferencesService().getBoolean("org.eclipse.tracecompass.tmf.ui", "description.disableLinking", false, null)) {
                this.setMessage(null);
                this.setErrorMessage(Messages.ImportTraceWizard_CannotImportFilesUnderAVirtualFolder);
                return false;
            }
            if (this.fCreateLinksInWorkspaceButton == null || !this.fCreateLinksInWorkspaceButton.getSelection()) {
                this.setMessage(null);
                this.setErrorMessage(Messages.ImportTraceWizard_HaveToCreateLinksUnderAVirtualFolder);
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    private File getSourceFile() {
        return this.isImportFromDirectory() ? this.getSourceDirectory() : this.getSourceArchiveFile();
    }

    private boolean isImportFromDirectory() {
        return this.fImportFromDirectoryRadio != null && this.fImportFromDirectoryRadio.getSelection();
    }

    private static boolean isArchiveFile(File sourceFile) {
        String absolutePath = sourceFile.getAbsolutePath();
        return ImportTraceWizardPage.isTarFile(absolutePath) || ArchiveFileManipulations.isZipFile((String)absolutePath);
    }

    protected void restoreWidgetValues() {
        boolean value;
        super.restoreWidgetValues();
        IDialogSettings settings = this.getDialogSettings();
        if (this.fImportUnrecognizedButton != null) {
            value = settings.get(this.getPageStoreKey(IMPORT_WIZARD_IMPORT_UNRECOGNIZED_ID)) == null ? true : settings.getBoolean(this.getPageStoreKey(IMPORT_WIZARD_IMPORT_UNRECOGNIZED_ID));
            this.fImportUnrecognizedButton.setSelection(value);
        }
        if (this.fPreserveFolderStructureButton != null) {
            value = settings.get(this.getPageStoreKey(IMPORT_WIZARD_PRESERVE_FOLDERS_ID)) == null ? true : settings.getBoolean(this.getPageStoreKey(IMPORT_WIZARD_PRESERVE_FOLDERS_ID));
            this.fPreserveFolderStructureButton.setSelection(value);
        }
        value = settings.get(this.getPageStoreKey(IMPORT_WIZARD_IMPORT_FROM_DIRECTORY_ID)) == null ? true : settings.getBoolean(this.getPageStoreKey(IMPORT_WIZARD_IMPORT_FROM_DIRECTORY_ID));
        if (this.directoryNameField != null) {
            ImportTraceWizardPage.restoreComboValues(this.directoryNameField, settings, this.getPageStoreKey(IMPORT_WIZARD_ROOT_DIRECTORY_ID));
        }
        if (this.fArchiveNameField != null) {
            ImportTraceWizardPage.restoreComboValues(this.fArchiveNameField, settings, this.getPageStoreKey(IMPORT_WIZARD_ARCHIVE_FILE_NAME_ID));
        }
        if (this.fImportFromDirectoryRadio != null) {
            this.fImportFromDirectoryRadio.setSelection(value);
            if (value) {
                this.directoryRadioSelected();
            }
        }
        if (this.fImportFromArchiveRadio != null) {
            this.fImportFromArchiveRadio.setSelection(!value);
            if (!value) {
                this.archiveRadioSelected();
            }
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (this.fImportUnrecognizedButton != null) {
            settings.put(this.getPageStoreKey(IMPORT_WIZARD_IMPORT_UNRECOGNIZED_ID), this.fImportUnrecognizedButton.getSelection());
        }
        if (this.fPreserveFolderStructureButton != null) {
            settings.put(this.getPageStoreKey(IMPORT_WIZARD_PRESERVE_FOLDERS_ID), this.fPreserveFolderStructureButton.getSelection());
        }
        settings.put(this.getPageStoreKey(IMPORT_WIZARD_IMPORT_FROM_DIRECTORY_ID), this.isImportFromDirectory());
        if (this.directoryNameField != null) {
            this.saveComboValues(this.directoryNameField, settings, this.getPageStoreKey(IMPORT_WIZARD_ROOT_DIRECTORY_ID));
        }
        if (this.fArchiveNameField != null) {
            this.saveComboValues(this.fArchiveNameField, settings, this.getPageStoreKey(IMPORT_WIZARD_ARCHIVE_FILE_NAME_ID));
        }
    }

    private String getPageStoreKey(String key) {
        return String.valueOf(this.getName()) + key;
    }

    private static void restoreComboValues(Combo combo, IDialogSettings settings, String key) {
        String[] directoryNames = settings.getArray(key);
        if (directoryNames != null && directoryNames.length != 0) {
            int i = 0;
            while (i < directoryNames.length) {
                combo.add(directoryNames[i]);
                ++i;
            }
        }
    }

    private void saveComboValues(Combo combo, IDialogSettings settings, String key) {
        String[] directoryNames = settings.getArray(key);
        if (directoryNames == null) {
            directoryNames = new String[]{};
        }
        String[] items = combo.getItems();
        int i = 0;
        while (i < items.length) {
            directoryNames = this.addToHistory(directoryNames, items[i]);
            ++i;
        }
        settings.put(key, directoryNames);
    }

    public boolean finish() {
        String traceTypeLabel = this.getImportTraceTypeId();
        String traceId = null;
        if (!TRACE_TYPE_AUTO_DETECT.equals(traceTypeLabel)) {
            traceId = TmfTraceType.getTraceTypeId((String)traceTypeLabel);
        }
        this.saveWidgetValues();
        Path baseSourceContainerPath = new Path(this.getSourceContainerPath());
        boolean importFromArchive = this.getSourceArchiveFile() != null;
        int importOptionFlags = this.getImportOptionFlags();
        final TraceValidateAndImportOperation operation = new TraceValidateAndImportOperation(traceId, (IPath)baseSourceContainerPath, this.getContainerFullPath(), importFromArchive, importOptionFlags);
        IStatus status = Status.OK_STATUS;
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    operation.run(monitor);
                    monitor.done();
                }
            });
            status = operation.getStatus();
        }
        catch (InvocationTargetException e) {
            status = new Status(4, "org.eclipse.tracecompass.tmf.ui", Messages.ImportTraceWizard_ImportProblem, (Throwable)e);
        }
        catch (InterruptedException e) {
            status = Status.CANCEL_STATUS;
        }
        if (!status.isOK()) {
            if (status.getSeverity() == 8) {
                this.setMessage(Messages.ImportTraceWizard_ImportOperationCancelled);
                this.setErrorMessage(null);
            } else {
                if (status.getException() != null) {
                    this.displayErrorDialog(String.valueOf(status.getMessage()) + ": " + status.getException());
                }
                this.setMessage(null);
                this.setErrorMessage(Messages.ImportTraceWizard_ImportProblem);
            }
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected String getImportTraceTypeId() {
        return this.fTraceTypes.getText();
    }

    protected int getImportOptionFlags() {
        int flags = 0;
        if (this.fCreateLinksInWorkspaceButton != null && this.fCreateLinksInWorkspaceButton.getSelection()) {
            flags |= 4;
        }
        if (this.fImportUnrecognizedButton != null && this.fImportUnrecognizedButton.getSelection()) {
            flags |= 8;
        }
        if (this.fOverwriteExistingResourcesCheckbox != null && this.fOverwriteExistingResourcesCheckbox.getSelection()) {
            flags |= 0x10;
        }
        if (this.fPreserveFolderStructureButton != null && this.fPreserveFolderStructureButton.getSelection()) {
            flags |= 2;
        }
        return flags;
    }

    public void dispose() {
        super.dispose();
        this.disposeSelectionGroupRoot();
    }

    private static class FileFileSystemObject
    implements IFileSystemObject {
        private File fFileSystemObject;

        private FileFileSystemObject(File fileSystemObject) {
            this.fFileSystemObject = fileSystemObject;
        }

        @Override
        public String getLabel() {
            String name = this.fFileSystemObject.getName();
            if (name.length() == 0) {
                return this.fFileSystemObject.getPath();
            }
            return name;
        }

        @Override
        public String getName() {
            return this.fFileSystemObject.getName();
        }

        @Override
        public String getAbsolutePath(String parentContainerPath) {
            return this.fFileSystemObject.getAbsolutePath();
        }

        @Override
        public boolean exists() {
            return this.fFileSystemObject.exists();
        }

        @Override
        public String getSourceLocation() {
            String sourceLocation = null;
            Object sourceResource = this.fFileSystemObject.isDirectory() ? ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(Path.fromOSString((String)this.fFileSystemObject.getAbsolutePath())) : ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)this.fFileSystemObject.getAbsolutePath()));
            if (sourceResource != null && sourceResource.exists()) {
                try {
                    sourceLocation = sourceResource.getPersistentProperty(TmfCommonConstants.SOURCE_LOCATION);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            if (sourceLocation == null) {
                try {
                    sourceLocation = URIUtil.toUnencodedString((URI)this.fFileSystemObject.getCanonicalFile().toURI());
                }
                catch (IOException e) {
                    sourceLocation = URIUtil.toUnencodedString((URI)this.fFileSystemObject.toURI());
                }
            }
            return sourceLocation;
        }

        @Override
        public Object getRawFileSystemObject() {
            return this.fFileSystemObject;
        }
    }

    private static class FileSystemObjectImportStructureProvider
    implements IImportStructureProvider {
        private IImportStructureProvider fImportProvider;
        private String fArchivePath;

        private FileSystemObjectImportStructureProvider(IImportStructureProvider importStructureProvider, String archivePath) {
            this.fImportProvider = importStructureProvider;
            this.fArchivePath = archivePath;
        }

        public List<IFileSystemObject> getChildren(Object element) {
            List children = this.fImportProvider.getChildren(((IFileSystemObject)element).getRawFileSystemObject());
            ArrayList<IFileSystemObject> adapted = new ArrayList<IFileSystemObject>(children.size());
            for (Object o : children) {
                adapted.add(this.getIFileSystemObject(o));
            }
            return adapted;
        }

        public IFileSystemObject getIFileSystemObject(Object o) {
            if (o == null) {
                return null;
            }
            if (o instanceof File) {
                return new FileFileSystemObject((File)o);
            }
            if (o instanceof TarEntry) {
                return new TarFileSystemObject((TarEntry)o, this.fArchivePath);
            }
            if (o instanceof ZipEntry) {
                return new ZipFileSystemObject((ZipEntry)o, this.fArchivePath);
            }
            throw new IllegalArgumentException("Object type not handled");
        }

        public InputStream getContents(Object element) {
            return this.fImportProvider.getContents(((IFileSystemObject)element).getRawFileSystemObject());
        }

        public String getFullPath(Object element) {
            return this.fImportProvider.getFullPath(((IFileSystemObject)element).getRawFileSystemObject());
        }

        public String getLabel(Object element) {
            return this.fImportProvider.getLabel(((IFileSystemObject)element).getRawFileSystemObject());
        }

        public boolean isFolder(Object element) {
            return this.fImportProvider.isFolder(((IFileSystemObject)element).getRawFileSystemObject());
        }

        public void dispose() {
        }

        /* synthetic */ FileSystemObjectImportStructureProvider(IImportStructureProvider iImportStructureProvider, String string, FileSystemObjectImportStructureProvider fileSystemObjectImportStructureProvider, FileSystemObjectImportStructureProvider fileSystemObjectImportStructureProvider2) {
            this(iImportStructureProvider, string);
        }
    }

    private static class FileSystemObjectLeveledImportStructureProvider
    extends FileSystemObjectImportStructureProvider
    implements ILeveledImportStructureProvider {
        private ILeveledImportStructureProvider fLeveledImportProvider;

        private FileSystemObjectLeveledImportStructureProvider(ILeveledImportStructureProvider importStructureProvider, String archivePath) {
            super((IImportStructureProvider)importStructureProvider, archivePath);
            this.fLeveledImportProvider = importStructureProvider;
        }

        public IFileSystemObject getRoot() {
            return this.getIFileSystemObject(this.fLeveledImportProvider.getRoot());
        }

        public void setStrip(int level) {
            this.fLeveledImportProvider.setStrip(level);
        }

        public int getStrip() {
            return this.fLeveledImportProvider.getStrip();
        }

        public boolean closeArchive() {
            return this.fLeveledImportProvider.closeArchive();
        }

        @Override
        public void dispose() {
            super.dispose();
            this.closeArchive();
        }
    }

    private static interface IFileSystemObject {
        public String getLabel();

        public String getName();

        public String getAbsolutePath(String var1);

        public String getSourceLocation();

        public Object getRawFileSystemObject();

        public boolean exists();
    }

    private class ImportProvider
    implements IImportStructureProvider {
        ImportProvider() {
        }

        public String getLabel(Object element) {
            TraceFileSystemElement resource = (TraceFileSystemElement)((Object)element);
            return resource.getLabel();
        }

        public List getChildren(Object element) {
            TraceFileSystemElement resource = (TraceFileSystemElement)((Object)element);
            Object[] array = resource.getFiles().getChildren();
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < array.length) {
                list.add(array[i]);
                ++i;
            }
            return list;
        }

        public InputStream getContents(Object element) {
            TraceFileSystemElement resource = (TraceFileSystemElement)((Object)element);
            return resource.getProvider().getContents(resource.getFileSystemObject());
        }

        public String getFullPath(Object element) {
            TraceFileSystemElement resource = (TraceFileSystemElement)((Object)element);
            return resource.getProvider().getFullPath(resource.getFileSystemObject());
        }

        public boolean isFolder(Object element) {
            TraceFileSystemElement resource = (TraceFileSystemElement)((Object)element);
            return resource.isDirectory();
        }
    }

    private static class TarFileSystemObject
    implements IFileSystemObject {
        private TarEntry fFileSystemObject;
        private String fArchivePath;

        private TarFileSystemObject(TarEntry fileSystemObject, String archivePath) {
            this.fFileSystemObject = fileSystemObject;
            this.fArchivePath = archivePath;
        }

        @Override
        public String getLabel() {
            return new Path(this.fFileSystemObject.getName()).lastSegment();
        }

        @Override
        public String getName() {
            return this.fFileSystemObject.getName();
        }

        @Override
        public String getAbsolutePath(String parentContainerPath) {
            return new Path(parentContainerPath).append(this.fFileSystemObject.getName()).toOSString();
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public String getSourceLocation() {
            File file = new File(this.fArchivePath);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            URI uri = file.toURI();
            Path entryPath = new Path(this.fFileSystemObject.getName());
            URI jarURI = entryPath.isRoot() ? URIUtil.toJarURI((URI)uri, (IPath)Path.EMPTY) : URIUtil.toJarURI((URI)uri, (IPath)entryPath);
            return URIUtil.toUnencodedString((URI)jarURI);
        }

        @Override
        public Object getRawFileSystemObject() {
            return this.fFileSystemObject;
        }
    }

    private static class TraceFileSystemElement
    extends FileSystemElement {
        private boolean fIsPopulated = false;
        private String fLabel = null;
        private IPath fDestinationContainerPath;
        private FileSystemObjectImportStructureProvider fProvider;
        private String fSourceLocation;

        public TraceFileSystemElement(String name, FileSystemElement parent, boolean isDirectory, FileSystemObjectImportStructureProvider provider) {
            super(name, parent, isDirectory);
            this.fProvider = provider;
        }

        public void setDestinationContainerPath(IPath destinationContainerPath) {
            this.fDestinationContainerPath = destinationContainerPath;
        }

        public void setPopulated() {
            this.fIsPopulated = true;
        }

        public boolean isPopulated() {
            return this.fIsPopulated;
        }

        public AdaptableList getFiles() {
            if (!this.fIsPopulated) {
                this.populateElementChildren();
            }
            return super.getFiles();
        }

        public AdaptableList getFolders() {
            if (!this.fIsPopulated) {
                this.populateElementChildren();
            }
            return super.getFolders();
        }

        public void setLabel(String name) {
            this.fLabel = name;
        }

        public String getLabel() {
            if (this.fLabel == null) {
                return this.getFileSystemObject().getLabel();
            }
            return this.fLabel;
        }

        public IPath getDestinationContainerPath() {
            return this.fDestinationContainerPath;
        }

        private void populateElementChildren() {
            List<IFileSystemObject> allchildren = this.fProvider.getChildren(this.getFileSystemObject());
            IFileSystemObject child2 = null;
            TraceFileSystemElement newelement = null;
            for (IFileSystemObject child2 : allchildren) {
                newelement = new TraceFileSystemElement(this.fProvider.getLabel(child2), this, this.fProvider.isFolder(child2), this.fProvider);
                newelement.setFileSystemObject(child2);
            }
            this.setPopulated();
        }

        public FileSystemObjectImportStructureProvider getProvider() {
            return this.fProvider;
        }

        public IFileSystemObject getFileSystemObject() {
            Object fileSystemObject = super.getFileSystemObject();
            return (IFileSystemObject)fileSystemObject;
        }

        public String getSourceLocation() {
            if (this.fSourceLocation == null) {
                this.fSourceLocation = this.getFileSystemObject().getSourceLocation();
            }
            return this.fSourceLocation;
        }

        public void setSourceLocation(String sourceLocation) {
            this.fSourceLocation = sourceLocation;
        }
    }

    private class TraceValidateAndImportOperation {
        private IStatus fStatus;
        private String fTraceType;
        private IPath fDestinationContainerPath;
        private IPath fBaseSourceContainerPath;
        private boolean fImportFromArchive;
        private int fImportOptionFlags;
        private ImportConflictHandler fConflictHandler;
        private String fCurrentPath;

        private TraceValidateAndImportOperation(String traceId, IPath baseSourceContainerPath, IPath destinationContainerPath, boolean importFromArchive, int importOptionFlags) {
            this.fTraceType = traceId;
            this.fBaseSourceContainerPath = baseSourceContainerPath;
            this.fDestinationContainerPath = destinationContainerPath;
            this.fImportOptionFlags = importOptionFlags;
            this.fImportFromArchive = importFromArchive;
            boolean overwriteExistingResources = (importOptionFlags & 0x10) != 0;
            this.fConflictHandler = overwriteExistingResources ? new ImportConflictHandler(ImportTraceWizardPage.this.getContainer().getShell(), ImportTraceWizardPage.this.fTraceFolderElement, ImportConfirmation.OVERWRITE_ALL) : new ImportConflictHandler(ImportTraceWizardPage.this.getContainer().getShell(), ImportTraceWizardPage.this.fTraceFolderElement, ImportConfirmation.SKIP);
        }

        public void run(IProgressMonitor progressMonitor) {
            try {
                String baseSourceLocation;
                SubProgressMonitor monitor;
                final LinkedList<TraceFileSystemElement> selectedFileSystemElements = new LinkedList<TraceFileSystemElement>();
                IElementFilter passThroughFilter = new IElementFilter(){

                    public void filterElements(Collection elements, IProgressMonitor monitor) {
                        selectedFileSystemElements.addAll(elements);
                    }

                    public void filterElements(Object[] elements, IProgressMonitor monitor) {
                        int i = 0;
                        while (i < elements.length) {
                            selectedFileSystemElements.add((TraceFileSystemElement)((Object)elements[i]));
                            ++i;
                        }
                    }
                };
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)1);
                ImportTraceWizardPage.this.fSelectionGroup.getAllCheckedListItems((org.eclipse.ui.ide.dialogs.IElementFilter)passThroughFilter, (IProgressMonitor)subMonitor);
                ModalContext.checkCanceled((IProgressMonitor)subMonitor);
                IFolder destTempFolder = ImportTraceWizardPage.this.fTargetFolder.getProject().getFolder(ImportTraceWizardPage.TRACE_IMPORT_TEMP_FOLDER);
                if (destTempFolder.exists()) {
                    monitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 1, 4);
                    destTempFolder.delete(true, (IProgressMonitor)monitor);
                }
                monitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 1, 4);
                destTempFolder.create(4096, true, (IProgressMonitor)monitor);
                subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)2);
                if (this.fImportFromArchive) {
                    SubMonitor archiveMonitor = SubMonitor.convert((IProgressMonitor)subMonitor.newChild(1), (int)2);
                    this.extractArchiveContent(selectedFileSystemElements.iterator(), destTempFolder, (IProgressMonitor)archiveMonitor.newChild(1));
                    baseSourceLocation = this.getRootElement((TraceFileSystemElement)((Object)selectedFileSystemElements.get(0))).getSourceLocation();
                    List<TraceFileSystemElement> tempFolderFileSystemElements = this.createElementsForFolder(destTempFolder);
                    this.extractAllArchiveFiles(tempFolderFileSystemElements, destTempFolder, destTempFolder.getLocation(), (IProgressMonitor)archiveMonitor.newChild(1));
                } else {
                    SubMonitor directoryMonitor = SubMonitor.convert((IProgressMonitor)subMonitor.newChild(1), (int)2);
                    this.importFileSystemElements((IProgressMonitor)directoryMonitor.newChild(1), selectedFileSystemElements);
                    this.extractAllArchiveFiles(selectedFileSystemElements, destTempFolder, this.fBaseSourceContainerPath, (IProgressMonitor)directoryMonitor.newChild(1));
                    baseSourceLocation = URIUtil.toUnencodedString((URI)this.fBaseSourceContainerPath.toFile().getCanonicalFile().toURI());
                }
                this.fBaseSourceContainerPath = destTempFolder.getLocation();
                List<TraceFileSystemElement> tempFolderFileSystemElements = this.createElementsForFolder(destTempFolder);
                this.calculateSourceLocations(tempFolderFileSystemElements, baseSourceLocation);
                this.fImportOptionFlags &= 0xFFFFFFFB;
                SubMonitor importTempMonitor = subMonitor.newChild(1);
                this.importFileSystemElements((IProgressMonitor)importTempMonitor, tempFolderFileSystemElements);
                if (destTempFolder.exists()) {
                    destTempFolder.delete(true, progressMonitor);
                }
                this.setStatus(Status.OK_STATUS);
            }
            catch (InterruptedException e) {
                this.setStatus(Status.CANCEL_STATUS);
            }
            catch (Exception e) {
                String errorMessage = String.valueOf(Messages.ImportTraceWizard_ImportProblem) + ": " + (this.fCurrentPath != null ? this.fCurrentPath : "");
                Activator.getDefault().logError(errorMessage, e);
                this.setStatus((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.ui", errorMessage, (Throwable)e));
            }
        }

        private void importFileSystemElements(IProgressMonitor monitor, List<TraceFileSystemElement> fileSystemElements) throws InterruptedException, TmfTraceImportException, CoreException, InvocationTargetException {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)fileSystemElements.size());
            ListIterator<TraceFileSystemElement> fileSystemElementsIter = fileSystemElements.listIterator();
            HashMap<String, TraceFileSystemElement> directoryTraces = new HashMap<String, TraceFileSystemElement>();
            while (fileSystemElementsIter.hasNext()) {
                ModalContext.checkCanceled((IProgressMonitor)monitor);
                this.fCurrentPath = null;
                TraceFileSystemElement element = fileSystemElementsIter.next();
                IFileSystemObject fileSystemObject = element.getFileSystemObject();
                String resourcePath = element.getFileSystemObject().getAbsolutePath(this.fBaseSourceContainerPath.toOSString());
                element.setDestinationContainerPath(this.computeDestinationContainerPath(new Path(resourcePath)));
                this.fCurrentPath = resourcePath;
                SubMonitor sub = subMonitor.newChild(1);
                if (element.isDirectory()) {
                    if (directoryTraces.containsKey(resourcePath) || !this.isDirectoryTrace(element)) continue;
                    directoryTraces.put(resourcePath, element);
                    this.validateAndImportTrace(element, (IProgressMonitor)sub);
                    continue;
                }
                TraceFileSystemElement parentElement = (TraceFileSystemElement)element.getParent();
                String parentPath = parentElement.getFileSystemObject().getAbsolutePath(this.fBaseSourceContainerPath.toOSString());
                parentElement.setDestinationContainerPath(this.computeDestinationContainerPath(new Path(parentPath)));
                this.fCurrentPath = parentPath;
                if (directoryTraces.containsKey(parentPath)) continue;
                if (this.isDirectoryTrace(parentElement)) {
                    directoryTraces.put(parentPath, parentElement);
                    this.validateAndImportTrace(parentElement, (IProgressMonitor)sub);
                    continue;
                }
                boolean validateFile = true;
                TraceFileSystemElement grandParentElement = (TraceFileSystemElement)parentElement.getParent();
                if (grandParentElement != null) {
                    String grandParentPath = grandParentElement.getFileSystemObject().getAbsolutePath(this.fBaseSourceContainerPath.toOSString());
                    grandParentElement.setDestinationContainerPath(this.computeDestinationContainerPath(new Path(parentPath)));
                    this.fCurrentPath = grandParentPath;
                    if (directoryTraces.containsKey(grandParentPath)) {
                        validateFile = false;
                    } else if (this.isDirectoryTrace(grandParentElement)) {
                        directoryTraces.put(grandParentPath, grandParentElement);
                        this.validateAndImportTrace(grandParentElement, (IProgressMonitor)sub);
                        validateFile = false;
                    }
                }
                if (!validateFile || !fileSystemObject.exists()) continue;
                this.validateAndImportTrace(element, (IProgressMonitor)sub);
            }
        }

        private List<TraceFileSystemElement> createElementsForFolder(IFolder folder) {
            FileSystemObjectImportStructureProvider importStructureProvider = new FileSystemObjectImportStructureProvider((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null, null, null);
            IFileSystemObject rootElement = importStructureProvider.getIFileSystemObject(new File(folder.getLocation().toOSString()));
            TraceFileSystemElement createRootElement = ImportTraceWizardPage.createRootTraceFileElement(rootElement, importStructureProvider);
            LinkedList<TraceFileSystemElement> list = new LinkedList<TraceFileSystemElement>();
            this.getAllChildren(list, createRootElement);
            return list;
        }

        private void extractAllArchiveFiles(List<TraceFileSystemElement> fileSystemElements, IFolder destFolder, IPath baseSourceContainerPath, IProgressMonitor progressMonitor) throws InterruptedException, CoreException, InvocationTargetException {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)fileSystemElements.size());
            ListIterator<TraceFileSystemElement> fileSystemElementsIter = fileSystemElements.listIterator();
            while (fileSystemElementsIter.hasNext()) {
                boolean isArchiveFileElement;
                ModalContext.checkCanceled((IProgressMonitor)subMonitor);
                SubMonitor elementProgress = subMonitor.newChild(1);
                TraceFileSystemElement element = fileSystemElementsIter.next();
                File archiveFile = (File)element.getFileSystemObject().getRawFileSystemObject();
                boolean bl = isArchiveFileElement = element.getFileSystemObject() instanceof FileFileSystemObject && ImportTraceWizardPage.isArchiveFile(archiveFile);
                if (!isArchiveFileElement) continue;
                elementProgress = SubMonitor.convert((IProgressMonitor)elementProgress, (int)4);
                IPath relativeToSourceContainer = new Path(element.getFileSystemObject().getAbsolutePath(null)).makeRelativeTo(baseSourceContainerPath);
                IFolder folder = this.safeCreateExtractedFolder(destFolder, relativeToSourceContainer, (IProgressMonitor)elementProgress.newChild(1));
                this.extractArchiveToFolder(archiveFile, folder, (IProgressMonitor)elementProgress.newChild(1));
                IFile fileRes = destFolder.getFile(relativeToSourceContainer);
                fileRes.delete(true, (IProgressMonitor)elementProgress.newChild(1));
                IPath newPath = destFolder.getFullPath().append(relativeToSourceContainer);
                folder.move(newPath, true, (IProgressMonitor)elementProgress.newChild(1));
                folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(newPath);
                FileSystemObjectImportStructureProvider importStructureProvider = new FileSystemObjectImportStructureProvider((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null, null, null);
                IFileSystemObject rootElement = importStructureProvider.getIFileSystemObject(new File(folder.getLocation().toOSString()));
                TraceFileSystemElement newElement = ImportTraceWizardPage.createRootTraceFileElement(rootElement, importStructureProvider);
                ArrayList<TraceFileSystemElement> extractedChildren = new ArrayList<TraceFileSystemElement>();
                this.getAllChildren(extractedChildren, newElement);
                this.extractAllArchiveFiles(extractedChildren, folder, folder.getLocation(), progressMonitor);
            }
        }

        private void extractArchiveToFolder(File sourceFile, IFolder destinationFolder, IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
            Pair rootObjectAndProvider = ImportTraceWizardPage.this.getRootObjectAndProvider(sourceFile);
            TraceFileSystemElement rootElement = ImportTraceWizardPage.createRootTraceFileElement((IFileSystemObject)rootObjectAndProvider.getFirst(), (FileSystemObjectImportStructureProvider)rootObjectAndProvider.getSecond());
            ArrayList<TraceFileSystemElement> fileSystemElements = new ArrayList<TraceFileSystemElement>();
            this.getAllChildren(fileSystemElements, rootElement);
            this.extractArchiveContent(fileSystemElements.listIterator(), destinationFolder, progressMonitor);
            ((FileSystemObjectImportStructureProvider)rootObjectAndProvider.getSecond()).dispose();
        }

        private IFolder safeCreateExtractedFolder(IFolder destinationFolder, IPath relativeContainerRelativePath, IProgressMonitor monitor) throws CoreException {
            IFolder folder;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            String suffix = "";
            int i = 2;
            while (true) {
                IPath fullPath = destinationFolder.getFullPath().append(relativeContainerRelativePath + ".extract" + suffix);
                folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(fullPath);
                if (!folder.exists()) break;
                suffix = "(" + i + ")";
                ++i;
            }
            IFolder extractedFolder = folder;
            subMonitor.worked(1);
            TraceUtils.createFolder(extractedFolder, (IProgressMonitor)subMonitor.newChild(1));
            return extractedFolder;
        }

        private void calculateSourceLocations(List<TraceFileSystemElement> fileSystemElements, String baseSourceLocation) {
            for (TraceFileSystemElement element : fileSystemElements) {
                IPath tempRelative = new Path(element.getFileSystemObject().getAbsolutePath(null)).makeRelativeTo(this.fBaseSourceContainerPath);
                String sourceLocation = String.valueOf(baseSourceLocation) + tempRelative;
                element.setSourceLocation(sourceLocation);
                TraceFileSystemElement parentElement = (TraceFileSystemElement)element.getParent();
                tempRelative = new Path(parentElement.getFileSystemObject().getAbsolutePath(null)).makeRelativeTo(this.fBaseSourceContainerPath);
                sourceLocation = String.valueOf(baseSourceLocation) + tempRelative + '/';
                parentElement.setSourceLocation(sourceLocation);
            }
        }

        private void extractArchiveContent(Iterator<TraceFileSystemElement> fileSystemElementsIter, IFolder tempFolder, IProgressMonitor progressMonitor) throws InterruptedException, InvocationTargetException {
            ArrayList<TraceFileSystemElement> subList = new ArrayList<TraceFileSystemElement>();
            while (fileSystemElementsIter.hasNext()) {
                ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
                TraceFileSystemElement element = fileSystemElementsIter.next();
                if (element.isDirectory()) {
                    Object[] array = element.getFiles().getChildren();
                    int i = 0;
                    while (i < array.length) {
                        subList.add((TraceFileSystemElement)((Object)array[i]));
                        ++i;
                    }
                }
                subList.add(element);
            }
            TraceFileSystemElement root = this.getRootElement((TraceFileSystemElement)((Object)subList.get(0)));
            ImportProvider fileSystemStructureProvider = new ImportProvider();
            IOverwriteQuery myQueryImpl = new IOverwriteQuery(){

                public String queryOverwrite(String file) {
                    return "NOALL";
                }
            };
            progressMonitor.setTaskName(Messages.ImportTraceWizard_ExtractImportOperationTaskName);
            IPath containerPath = tempFolder.getFullPath();
            ImportOperation operation = new ImportOperation(containerPath, (Object)root, (IImportStructureProvider)fileSystemStructureProvider, myQueryImpl, subList);
            operation.setContext(ImportTraceWizardPage.this.getShell());
            operation.setCreateContainerStructure(true);
            operation.setOverwriteResources(false);
            operation.setVirtualFolders(false);
            operation.run((IProgressMonitor)new SubProgressMonitor(progressMonitor, subList.size(), 4));
        }

        private TraceFileSystemElement getRootElement(TraceFileSystemElement element) {
            TraceFileSystemElement root = element;
            while (root.getParent() != null) {
                root = (TraceFileSystemElement)root.getParent();
            }
            return root;
        }

        private void getAllChildren(List<TraceFileSystemElement> result, TraceFileSystemElement rootElement) {
            AdaptableList files = rootElement.getFiles();
            Object[] objectArray = files.getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object file = objectArray[n2];
                result.add((TraceFileSystemElement)((Object)file));
                ++n2;
            }
            AdaptableList folders = rootElement.getFolders();
            Object[] objectArray2 = folders.getChildren();
            int n3 = objectArray2.length;
            n = 0;
            while (n < n3) {
                Object folder = objectArray2[n];
                this.getAllChildren(result, (TraceFileSystemElement)((Object)folder));
                ++n;
            }
        }

        private IPath computeDestinationContainerPath(Path resourcePath) {
            IPath destinationContainerPath = this.fDestinationContainerPath;
            if ((this.fImportOptionFlags & 2) != 0) {
                IPath sourceContainerPath = resourcePath.removeLastSegments(1);
                if (this.fBaseSourceContainerPath.equals((Object)resourcePath)) {
                    sourceContainerPath = resourcePath;
                }
                IPath relativeContainerPath = sourceContainerPath.makeRelativeTo(this.fBaseSourceContainerPath);
                destinationContainerPath = this.fDestinationContainerPath.append(relativeContainerPath);
            }
            return destinationContainerPath;
        }

        private void validateAndImportTrace(TraceFileSystemElement fileSystemElement, IProgressMonitor monitor) throws TmfTraceImportException, CoreException, InvocationTargetException, InterruptedException {
            IResource importedResource;
            boolean isArchiveFileElement;
            String parentContainerPath = this.fBaseSourceContainerPath.toOSString();
            String path = fileSystemElement.getFileSystemObject().getAbsolutePath(parentContainerPath);
            TraceTypeHelper traceTypeHelper = null;
            File file = (File)fileSystemElement.getFileSystemObject().getRawFileSystemObject();
            boolean bl = isArchiveFileElement = fileSystemElement.getFileSystemObject() instanceof FileFileSystemObject && ImportTraceWizardPage.isArchiveFile(file);
            if (isArchiveFileElement) {
                return;
            }
            if (this.fTraceType == null) {
                try {
                    traceTypeHelper = TmfTraceTypeUIUtils.selectTraceType(path, null, null);
                }
                catch (TmfTraceImportException tmfTraceImportException) {
                    // empty catch block
                }
                if (traceTypeHelper == null) {
                    if ((this.fImportOptionFlags & 8) != 0) {
                        this.importResource(fileSystemElement, monitor);
                    }
                    return;
                }
            } else {
                boolean isDirectoryTraceType = TmfTraceType.isDirectoryTraceType((String)this.fTraceType);
                if (fileSystemElement.isDirectory() != isDirectoryTraceType) {
                    return;
                }
                traceTypeHelper = TmfTraceType.getTraceType((String)this.fTraceType);
                if (traceTypeHelper == null) {
                    throw new TmfTraceImportException(Messages.ImportTraceWizard_TraceTypeNotFound);
                }
                if (!traceTypeHelper.validate(path).isOK()) {
                    return;
                }
            }
            if ((importedResource = this.importResource(fileSystemElement, monitor)) != null) {
                TmfTraceTypeUIUtils.setTraceType(importedResource, traceTypeHelper);
            }
        }

        private IResource importResource(TraceFileSystemElement fileSystemElement, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, CoreException {
            boolean createLinksInWorkspace;
            IPath tracePath = this.getInitialDestinationPath(fileSystemElement);
            String newName = this.fConflictHandler.checkAndHandleNameClash(tracePath, monitor);
            if (newName == null) {
                return null;
            }
            fileSystemElement.setLabel(newName);
            ArrayList<TraceFileSystemElement> subList = new ArrayList<TraceFileSystemElement>();
            FileSystemElement parentFolder = fileSystemElement.getParent();
            IPath containerPath = fileSystemElement.getDestinationContainerPath();
            tracePath = containerPath.addTrailingSeparator().append(fileSystemElement.getLabel());
            boolean bl = createLinksInWorkspace = (this.fImportOptionFlags & 4) != 0;
            if (fileSystemElement.isDirectory() && !createLinksInWorkspace) {
                containerPath = tracePath;
                Object[] array = fileSystemElement.getFiles().getChildren();
                int i = 0;
                while (i < array.length) {
                    subList.add((TraceFileSystemElement)((Object)array[i]));
                    ++i;
                }
                parentFolder = fileSystemElement;
            } else {
                subList.add(fileSystemElement);
            }
            ImportProvider fileSystemStructureProvider = new ImportProvider();
            IOverwriteQuery myQueryImpl = new IOverwriteQuery(){

                public String queryOverwrite(String file) {
                    return "NOALL";
                }
            };
            monitor.setTaskName(String.valueOf(Messages.ImportTraceWizard_ImportOperationTaskName) + " " + fileSystemElement.getFileSystemObject().getAbsolutePath(this.fBaseSourceContainerPath.toOSString()));
            ImportOperation operation = new ImportOperation(containerPath, (Object)parentFolder, (IImportStructureProvider)fileSystemStructureProvider, myQueryImpl, subList);
            operation.setContext(ImportTraceWizardPage.this.getShell());
            operation.setCreateContainerStructure(false);
            operation.setOverwriteResources(false);
            operation.setCreateLinks(createLinksInWorkspace);
            operation.setVirtualFolders(false);
            operation.run((IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
            String sourceLocation = fileSystemElement.getSourceLocation();
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(tracePath);
            if (sourceLocation != null) {
                resource.setPersistentProperty(TmfCommonConstants.SOURCE_LOCATION, sourceLocation);
            }
            return resource;
        }

        private boolean isDirectoryTrace(TraceFileSystemElement fileSystemElement) {
            String path = fileSystemElement.getFileSystemObject().getAbsolutePath(this.fBaseSourceContainerPath.toOSString());
            return TmfTraceType.isDirectoryTrace((String)path);
        }

        private IPath getInitialDestinationPath(TraceFileSystemElement fileSystemElement) {
            IPath traceFolderPath = fileSystemElement.getDestinationContainerPath();
            return traceFolderPath.append(fileSystemElement.getFileSystemObject().getLabel());
        }

        protected void setStatus(IStatus status) {
            this.fStatus = status;
        }

        public IStatus getStatus() {
            return this.fStatus;
        }
    }

    private static class ZipFileSystemObject
    implements IFileSystemObject {
        private ZipEntry fFileSystemObject;
        private String fArchivePath;

        private ZipFileSystemObject(ZipEntry fileSystemObject, String archivePath) {
            this.fFileSystemObject = fileSystemObject;
            this.fArchivePath = archivePath;
        }

        @Override
        public String getLabel() {
            return new Path(this.fFileSystemObject.getName()).lastSegment();
        }

        @Override
        public String getName() {
            return this.fFileSystemObject.getName();
        }

        @Override
        public String getAbsolutePath(String parentContainerPath) {
            return new Path(parentContainerPath).append(this.fFileSystemObject.getName()).toOSString();
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public String getSourceLocation() {
            File file = new File(this.fArchivePath);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            URI uri = file.toURI();
            Path entryPath = new Path(this.fFileSystemObject.getName());
            URI jarURI = entryPath.isRoot() ? URIUtil.toJarURI((URI)uri, (IPath)Path.EMPTY) : URIUtil.toJarURI((URI)uri, (IPath)entryPath);
            return URIUtil.toUnencodedString((URI)jarURI);
        }

        @Override
        public Object getRawFileSystemObject() {
            return this.fFileSystemObject;
        }
    }
}

