/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTimestampFormatUpdateSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfTimeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfBaseProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfMouseDragProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfMouseDragZoomProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfMouseSelectionProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfMouseWheelZoomProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfSimpleTooltipProvider;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;

public abstract class TmfXYChartViewer
extends TmfTimeViewer
implements ITmfChartTimeProvider {
    private Chart fSwtChart;
    private TmfBaseProvider fMouseSelectionProvider;
    private TmfBaseProvider fMouseDragZoomProvider;
    private TmfBaseProvider fMouseWheelZoomProvider;
    private TmfBaseProvider fToolTipProvider;
    private TmfBaseProvider fMouseDragProvider;
    private boolean fSendTimeAlignSignals = false;

    public TmfXYChartViewer(Composite parent, String title, String xLabel, String yLabel) {
        super(parent, title);
        this.fSwtChart = new Chart(parent, 0){

            public boolean setFocus() {
                return TmfXYChartViewer.this.fSwtChart.getPlotArea().setFocus();
            }
        };
        this.fSwtChart.getPlotArea().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TmfXYChartViewer.this.fSwtChart.getPlotArea().setFocus();
            }
        });
        IAxis xAxis = this.fSwtChart.getAxisSet().getXAxis(0);
        IAxis yAxis = this.fSwtChart.getAxisSet().getYAxis(0);
        if (title == null) {
            this.fSwtChart.getTitle().setVisible(false);
        } else {
            this.fSwtChart.getTitle().setText(title);
        }
        if (xLabel == null) {
            xAxis.getTitle().setVisible(false);
        } else {
            xAxis.getTitle().setText(xLabel);
        }
        if (yLabel == null) {
            yAxis.getTitle().setVisible(false);
        } else {
            yAxis.getTitle().setText(yLabel);
        }
        this.fMouseSelectionProvider = new TmfMouseSelectionProvider(this);
        this.fMouseDragZoomProvider = new TmfMouseDragZoomProvider(this);
        this.fMouseWheelZoomProvider = new TmfMouseWheelZoomProvider(this);
        this.fToolTipProvider = new TmfSimpleTooltipProvider(this);
        this.fMouseDragProvider = new TmfMouseDragProvider(this);
    }

    protected void setSwtChart(Chart chart) {
        this.fSwtChart = chart;
    }

    protected Chart getSwtChart() {
        return this.fSwtChart;
    }

    public void setSelectionProvider(TmfBaseProvider provider) {
        if (this.fMouseSelectionProvider != null) {
            this.fMouseSelectionProvider.dispose();
        }
        this.fMouseSelectionProvider = provider;
    }

    public void setMouseDragZoomProvider(TmfBaseProvider provider) {
        if (this.fMouseDragZoomProvider != null) {
            this.fMouseDragZoomProvider.dispose();
        }
        this.fMouseDragZoomProvider = provider;
    }

    public void setMouseWheelZoomProvider(TmfBaseProvider provider) {
        if (this.fMouseWheelZoomProvider != null) {
            this.fMouseWheelZoomProvider.dispose();
        }
        this.fMouseWheelZoomProvider = provider;
    }

    public void setTooltipProvider(TmfBaseProvider provider) {
        if (this.fToolTipProvider != null) {
            this.fToolTipProvider.dispose();
        }
        this.fToolTipProvider = provider;
    }

    public void setMouseDrageProvider(TmfBaseProvider provider) {
        if (this.fMouseDragProvider != null) {
            this.fMouseDragProvider.dispose();
        }
        this.fMouseDragProvider = provider;
    }

    @Override
    public long getTimeOffset() {
        return this.getWindowStartTime() - 1L;
    }

    @Override
    public Control getControl() {
        return this.fSwtChart;
    }

    @Override
    public void refresh() {
        this.fSwtChart.redraw();
    }

    public void dispose() {
        super.dispose();
        this.fSwtChart.dispose();
        if (this.fMouseSelectionProvider != null) {
            this.fMouseSelectionProvider.dispose();
        }
        if (this.fMouseDragZoomProvider != null) {
            this.fMouseDragZoomProvider.dispose();
        }
        if (this.fMouseWheelZoomProvider != null) {
            this.fMouseWheelZoomProvider.dispose();
        }
        if (this.fToolTipProvider != null) {
            this.fToolTipProvider.dispose();
        }
        if (this.fMouseDragProvider != null) {
            this.fMouseDragProvider.dispose();
        }
    }

    @Override
    public void loadTrace(ITmfTrace trace) {
        super.loadTrace(trace);
        this.clearContent();
        this.updateContent();
    }

    @Override
    public void reset() {
        super.reset();
        this.clearContent();
    }

    protected abstract void updateContent();

    @Override
    @TmfSignalHandler
    public void selectionRangeUpdated(TmfSelectionRangeUpdatedSignal signal) {
        super.selectionRangeUpdated(signal);
        if (signal.getSource() != this && this.getTrace() != null && this.fMouseSelectionProvider != null) {
            this.fMouseSelectionProvider.refresh();
        }
    }

    @Override
    @TmfSignalHandler
    public void windowRangeUpdated(TmfWindowRangeUpdatedSignal signal) {
        super.windowRangeUpdated(signal);
        this.updateContent();
    }

    @TmfSignalHandler
    public void timestampFormatUpdated(TmfTimestampFormatUpdateSignal signal) {
        this.fSwtChart.getAxisSet().adjustRange();
        this.fSwtChart.redraw();
    }

    protected void clearContent() {
        if (!this.fSwtChart.isDisposed()) {
            ISeriesSet set = this.fSwtChart.getSeriesSet();
            ISeries[] series = set.getSeries();
            int i = 0;
            while (i < series.length) {
                set.deleteSeries(series[i].getId());
                ++i;
            }
            this.fSwtChart.redraw();
        }
    }

    protected static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public int getPointAreaOffset() {
        int pixelCoordinate = 0;
        IAxis[] xAxes = this.getSwtChart().getAxisSet().getXAxes();
        ISeries[] series = this.fSwtChart.getSeriesSet().getSeries();
        if (xAxes.length > 0 && series.length > 0 && series[0].getXSeries() != null && series[0].getXSeries().length > 0) {
            IAxis axis = xAxes[0];
            double[] xSeries = series[0].getXSeries();
            pixelCoordinate = axis.getPixelCoordinate(xSeries[0]);
        }
        return this.getSwtChart().toControl((Point)this.getSwtChart().getPlotArea().toDisplay((int)pixelCoordinate, (int)0)).x;
    }

    public int getPointAreaWidth() {
        IAxis[] xAxes = this.getSwtChart().getAxisSet().getXAxes();
        ISeries[] series = this.fSwtChart.getSeriesSet().getSeries();
        if (xAxes.length > 0 && series.length > 0 && series[0].getXSeries() != null && series[0].getXSeries().length > 0) {
            IAxis axis = xAxes[0];
            double[] xSeries = series[0].getXSeries();
            int x1 = this.getPointAreaOffset();
            int x2 = axis.getPixelCoordinate(xSeries[xSeries.length - 1]);
            x2 = this.getSwtChart().toControl((Point)this.getSwtChart().getPlotArea().toDisplay((int)x2, (int)0)).x;
            int width = x2 - x1;
            return width;
        }
        return this.getSwtChart().getPlotArea().getSize().x;
    }

    public void setSendTimeAlignSignals(boolean sendTimeAlignSignals) {
        this.fSendTimeAlignSignals = sendTimeAlignSignals;
    }

    public boolean isSendTimeAlignSignals() {
        return this.fSendTimeAlignSignals;
    }
}

