/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts;

import java.text.Format;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentSignal;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfChartTimeStampFormat;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartTooltipProvider;
import org.swtchart.IAxisTick;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.LineStyle;
import org.swtchart.Range;

public abstract class TmfCommonXLineChartViewer
extends TmfXYChartViewer {
    private static final double DEFAULT_MAXY = Double.MIN_VALUE;
    private static final double DEFAULT_MINY = Double.MAX_VALUE;
    private static final double RESOLUTION = 1.0;
    private static final int[] LINE_COLORS = new int[]{9, 3, 5, 11, 13, 10, 4, 6, 12, 14, 8, 2, 15};
    private static final LineStyle[] LINE_STYLES = new LineStyle[]{LineStyle.SOLID, LineStyle.DASH, LineStyle.DOT, LineStyle.DASHDOT};
    private final Map<String, double[]> fSeriesValues = new LinkedHashMap<String, double[]>();
    private double[] fXValues;
    private double fResolution;
    private UpdateThread fUpdateThread;

    public TmfCommonXLineChartViewer(Composite parent, String title, String xLabel, String yLabel) {
        super(parent, title, xLabel, yLabel);
        this.setResolution(1.0);
        this.setTooltipProvider(new TmfCommonXLineChartTooltipProvider(this));
    }

    protected void setResolution(double resolution) {
        this.fResolution = resolution;
    }

    @Override
    public void loadTrace(ITmfTrace trace) {
        super.loadTrace(trace);
        this.reinitialize();
    }

    protected void reinitialize() {
        this.fSeriesValues.clear();
        Thread thread = new Thread(){

            @Override
            public void run() {
                TmfCommonXLineChartViewer.this.initializeDataSource();
                TmfCommonXLineChartViewer.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!TmfCommonXLineChartViewer.this.getSwtChart().isDisposed()) {
                            TmfCommonXLineChartViewer.this.clearContent();
                            TmfCommonXLineChartViewer.this.createSeries();
                        }
                    }
                });
            }
        };
        thread.start();
    }

    protected void initializeDataSource() {
    }

    private synchronized void newUpdateThread() {
        this.cancelUpdate();
        int numRequests = (int)((double)this.getSwtChart().getPlotArea().getBounds().width * this.fResolution);
        this.fUpdateThread = new UpdateThread(numRequests);
        this.fUpdateThread.start();
    }

    private synchronized void updateThreadFinished(UpdateThread thread) {
        if (thread == this.fUpdateThread) {
            this.fUpdateThread = null;
        }
    }

    protected synchronized void cancelUpdate() {
        if (this.fUpdateThread != null) {
            this.fUpdateThread.cancel();
        }
    }

    @Override
    protected void updateContent() {
        TmfCommonXLineChartViewer.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TmfCommonXLineChartViewer.this.newUpdateThread();
            }
        });
    }

    protected static final double[] getXAxis(long start, long end, int nb) {
        double[] timestamps = new double[nb];
        long steps = end - start;
        double step = (double)steps / (double)nb;
        double curTime = 1.0;
        int i = 0;
        while (i < nb) {
            timestamps[i] = curTime;
            curTime += step;
            ++i;
        }
        return timestamps;
    }

    protected final void setXAxis(double[] xaxis) {
        this.fXValues = xaxis;
    }

    protected abstract void updateData(long var1, long var3, int var5, IProgressMonitor var6);

    protected void setSeries(String seriesName, double[] seriesValues) {
        if (this.fXValues.length > seriesValues.length) {
            throw new IllegalStateException();
        }
        this.fSeriesValues.put(seriesName, seriesValues);
    }

    protected ILineSeries addSeries(String seriesName) {
        ISeriesSet seriesSet = this.getSwtChart().getSeriesSet();
        int seriesCount = seriesSet.getSeries().length;
        ILineSeries series = (ILineSeries)seriesSet.createSeries(ISeries.SeriesType.LINE, seriesName);
        series.setVisible(true);
        series.enableArea(false);
        series.setLineStyle(LINE_STYLES[seriesCount / LINE_COLORS.length % LINE_STYLES.length]);
        series.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        series.setLineColor(Display.getDefault().getSystemColor(LINE_COLORS[seriesCount % LINE_COLORS.length]));
        return series;
    }

    protected void deleteSeries(String seriesName) {
        ISeries series = this.getSwtChart().getSeriesSet().getSeries(seriesName);
        if (series != null) {
            this.getSwtChart().getSeriesSet().deleteSeries(series.getId());
        }
        this.fSeriesValues.remove(seriesName);
    }

    protected void updateDisplay() {
        Display.getDefault().asyncExec(new Runnable(){
            final TmfChartTimeStampFormat tmfChartTimeStampFormat;
            {
                this.tmfChartTimeStampFormat = new TmfChartTimeStampFormat(TmfCommonXLineChartViewer.this.getTimeOffset());
            }

            @Override
            public void run() {
                if (!TmfCommonXLineChartViewer.this.getSwtChart().isDisposed()) {
                    double maxy = Double.MIN_VALUE;
                    double miny = Double.MAX_VALUE;
                    for (Map.Entry entry : TmfCommonXLineChartViewer.this.fSeriesValues.entrySet()) {
                        ILineSeries series = (ILineSeries)TmfCommonXLineChartViewer.this.getSwtChart().getSeriesSet().getSeries((String)entry.getKey());
                        if (series == null) {
                            series = TmfCommonXLineChartViewer.this.addSeries((String)entry.getKey());
                        }
                        series.setXSeries(TmfCommonXLineChartViewer.this.fXValues);
                        double[] dArray = (double[])entry.getValue();
                        int n = dArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            double value = dArray[n2];
                            maxy = Math.max(maxy, value);
                            miny = Math.min(miny, value);
                            ++n2;
                        }
                        series.setYSeries((double[])entry.getValue());
                    }
                    if (maxy == Double.MIN_VALUE) {
                        maxy = 1.0;
                    }
                    IAxisTick xTick = TmfCommonXLineChartViewer.this.getSwtChart().getAxisSet().getXAxis(0).getTick();
                    xTick.setFormat((Format)this.tmfChartTimeStampFormat);
                    double start = TmfCommonXLineChartViewer.this.fXValues[0];
                    int lastX = TmfCommonXLineChartViewer.this.fXValues.length - 1;
                    double end = start == TmfCommonXLineChartViewer.this.fXValues[lastX] ? start + 1.0 : TmfCommonXLineChartViewer.this.fXValues[lastX];
                    TmfCommonXLineChartViewer.this.getSwtChart().getAxisSet().getXAxis(0).setRange(new Range(start, end));
                    TmfCommonXLineChartViewer.this.getSwtChart().getAxisSet().getXAxis(0).adjustRange();
                    if (maxy > miny) {
                        TmfCommonXLineChartViewer.this.getSwtChart().getAxisSet().getYAxis(0).setRange(new Range(miny, maxy));
                    }
                    TmfCommonXLineChartViewer.this.getSwtChart().redraw();
                    if (TmfCommonXLineChartViewer.this.isSendTimeAlignSignals()) {
                        Point viewPos = TmfCommonXLineChartViewer.this.getParent().getParent().toDisplay(0, 0);
                        int axisPos = ((TmfCommonXLineChartViewer)TmfCommonXLineChartViewer.this).getSwtChart().toDisplay((int)0, (int)0).x + TmfCommonXLineChartViewer.this.getPointAreaOffset();
                        int timeAxisOffset = axisPos - viewPos.x;
                        TmfTimeViewAlignmentInfo timeAlignmentInfo = new TmfTimeViewAlignmentInfo(TmfCommonXLineChartViewer.this.getControl().getShell(), viewPos, timeAxisOffset);
                        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimeViewAlignmentSignal(TmfCommonXLineChartViewer.this, timeAlignmentInfo, true));
                    }
                }
            }
        });
    }

    protected void createSeries() {
    }

    private class UpdateThread
    extends Thread {
        private final IProgressMonitor fMonitor;
        private final int fNumRequests;

        public UpdateThread(int numRequests) {
            super("Line chart update");
            this.fNumRequests = numRequests;
            this.fMonitor = new NullProgressMonitor();
        }

        @Override
        public void run() {
            TmfCommonXLineChartViewer.this.updateData(TmfCommonXLineChartViewer.this.getWindowStartTime(), TmfCommonXLineChartViewer.this.getWindowEndTime(), this.fNumRequests, this.fMonitor);
            TmfCommonXLineChartViewer.this.updateThreadFinished(this);
        }

        public void cancel() {
            this.fMonitor.setCanceled(true);
        }
    }
}

