/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.colors;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.ui.themes.ColorUtil;

public class ColorSetting {
    @Nullable
    private RGB fForegroundRGB;
    @Nullable
    private RGB fBackgroundRGB;
    @NonNull
    private RGB fTickColorRGB;
    @Nullable
    private Color fForegroundColor;
    @Nullable
    private Color fBackgroundColor;
    @Nullable
    private Color fDimmedForegroundColor;
    @Nullable
    private Color fDimmedBackgroundColor;
    @NonNull
    private Color fTickColor;
    @Nullable
    private ITmfFilterTreeNode fFilter;

    public ColorSetting(@Nullable RGB foreground, @Nullable RGB background, @Nullable RGB tickColorRGB, @Nullable ITmfFilterTreeNode filter) {
        this.fForegroundRGB = foreground;
        this.fBackgroundRGB = background;
        this.fTickColorRGB = tickColorRGB != null ? tickColorRGB : (RGB)NonNullUtils.checkNotNull((Object)Display.getDefault().getSystemColor(24).getRGB());
        this.fFilter = filter;
        Display display = Display.getDefault();
        this.fForegroundColor = this.fForegroundRGB != null ? new Color((Device)display, this.fForegroundRGB) : null;
        this.fBackgroundColor = this.fBackgroundRGB != null ? new Color((Device)display, this.fBackgroundRGB) : null;
        this.fDimmedForegroundColor = new Color((Device)display, ColorUtil.blend((RGB)(this.fForegroundRGB != null ? this.fForegroundRGB : display.getSystemColor(24).getRGB()), (RGB)(this.fBackgroundRGB != null ? this.fBackgroundRGB : display.getSystemColor(25).getRGB())));
        this.fDimmedBackgroundColor = this.fBackgroundRGB == null ? null : new Color((Device)display, ColorUtil.blend((RGB)this.fBackgroundRGB, (RGB)display.getSystemColor(25).getRGB()));
        this.fTickColor = new Color((Device)display, this.fTickColorRGB);
    }

    public void dispose() {
        if (this.fForegroundColor != null) {
            this.fForegroundColor.dispose();
        }
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
        }
        if (this.fDimmedForegroundColor != null) {
            this.fDimmedForegroundColor.dispose();
        }
        if (this.fDimmedBackgroundColor != null) {
            this.fDimmedBackgroundColor.dispose();
        }
        this.fTickColor.dispose();
    }

    @Nullable
    public RGB getForegroundRGB() {
        return this.fForegroundRGB;
    }

    public void setForegroundRGB(@Nullable RGB foreground) {
        this.fForegroundRGB = foreground;
        if (this.fForegroundColor != null) {
            this.fForegroundColor.dispose();
        }
        if (this.fDimmedForegroundColor != null) {
            this.fDimmedForegroundColor.dispose();
        }
        Display display = Display.getDefault();
        this.fForegroundColor = this.fForegroundRGB != null ? new Color((Device)display, this.fForegroundRGB) : null;
        this.fDimmedForegroundColor = new Color((Device)display, ColorUtil.blend((RGB)(this.fForegroundRGB != null ? this.fForegroundRGB : display.getSystemColor(24).getRGB()), (RGB)(this.fBackgroundRGB != null ? this.fBackgroundRGB : display.getSystemColor(25).getRGB())));
    }

    @Nullable
    public RGB getBackgroundRGB() {
        return this.fBackgroundRGB;
    }

    public void setBackgroundRGB(@Nullable RGB background) {
        this.fBackgroundRGB = background;
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
        }
        if (this.fDimmedBackgroundColor != null) {
            this.fDimmedBackgroundColor.dispose();
        }
        if (this.fDimmedForegroundColor != null) {
            this.fDimmedForegroundColor.dispose();
        }
        Display display = Display.getDefault();
        this.fBackgroundColor = this.fBackgroundRGB != null ? new Color((Device)display, this.fBackgroundRGB) : null;
        this.fDimmedBackgroundColor = this.fBackgroundRGB == null ? null : new Color((Device)display, ColorUtil.blend((RGB)this.fBackgroundRGB, (RGB)display.getSystemColor(25).getRGB()));
        this.fDimmedForegroundColor = new Color((Device)display, ColorUtil.blend((RGB)(this.fForegroundRGB != null ? this.fForegroundRGB : display.getSystemColor(24).getRGB()), (RGB)(this.fBackgroundRGB != null ? this.fBackgroundRGB : display.getSystemColor(25).getRGB())));
    }

    @NonNull
    public RGB getTickColorRGB() {
        return this.fTickColorRGB;
    }

    public void setTickColorRGB(@NonNull RGB tickColorRGB) {
        this.fTickColorRGB = tickColorRGB;
        this.fTickColor.dispose();
        Display display = Display.getDefault();
        this.fTickColor = new Color((Device)display, this.fTickColorRGB);
    }

    @Nullable
    public ITmfFilterTreeNode getFilter() {
        return this.fFilter;
    }

    public void setFilter(@Nullable ITmfFilterTreeNode filter) {
        this.fFilter = filter;
    }

    @Nullable
    public Color getForegroundColor() {
        return this.fForegroundColor;
    }

    @Nullable
    public Color getBackgroundColor() {
        return this.fBackgroundColor;
    }

    @Nullable
    public Color getDimmedForegroundColor() {
        return this.fDimmedForegroundColor;
    }

    @Nullable
    public Color getDimmedBackgroundColor() {
        return this.fDimmedBackgroundColor;
    }

    public Color getTickColor() {
        return this.fTickColor;
    }
}

