/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.timechart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.signal.TmfEventFilterAppliedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfEventSearchAppliedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.views.ITmfTimeAligned;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.colors.ColorSetting;
import org.eclipse.tracecompass.tmf.ui.views.colors.ColorSettingsManager;
import org.eclipse.tracecompass.tmf.ui.views.colors.IColorSettingsListener;
import org.eclipse.tracecompass.tmf.ui.views.timechart.TimeChartAnalysisEntry;
import org.eclipse.tracecompass.tmf.ui.views.timechart.TimeChartAnalysisProvider;
import org.eclipse.tracecompass.tmf.ui.views.timechart.TimeChartDecorationProvider;
import org.eclipse.tracecompass.tmf.ui.views.timechart.TimeChartEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphRangeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphSelectionListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphTimeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphRangeUpdateEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphSelectionEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class TimeChartView
extends TmfView
implements ITimeGraphRangeListener,
ITimeGraphSelectionListener,
ITimeGraphTimeListener,
IColorSettingsListener,
IResourceChangeListener,
ITmfTimeAligned {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.timechart";
    private static final int TIMESTAMP_SCALE = -9;
    private final int fDisplayWidth;
    private TimeGraphViewer fViewer;
    private final ArrayList<TimeChartAnalysisEntry> fTimeAnalysisEntries = new ArrayList();
    private final Map<ITmfTrace, TimeChartDecorationProvider> fDecorationProviders = new HashMap<ITmfTrace, TimeChartDecorationProvider>();
    private final ArrayList<DecorateThread> fDecorateThreads = new ArrayList();
    private long fStartTime = 0L;
    private long fStopTime = Long.MAX_VALUE;
    private boolean fRefreshBusy = false;
    private boolean fRefreshPending = false;
    private boolean fRedrawBusy = false;
    private boolean fRedrawPending = false;
    private final Object fSyncObj = new Object();
    private ITimeGraphPresentationProvider fPresentationProvider;

    public TimeChartView() {
        super("Time Chart");
        this.fDisplayWidth = Display.getDefault().getBounds().width;
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.fViewer = new TimeGraphViewer(parent, 0);
        this.fPresentationProvider = new TimeChartAnalysisProvider();
        this.fViewer.setTimeGraphProvider(this.fPresentationProvider);
        this.fViewer.setTimeFormat(Utils.TimeFormat.CALENDAR);
        this.fViewer.addTimeListener(this);
        this.fViewer.addRangeListener(this);
        this.fViewer.addSelectionListener(this);
        this.fViewer.setMinimumItemWidth(1);
        IStatusLineManager statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.getTimeGraphControl().setStatusLineManager(statusLineManager);
        for (ITmfTrace trace : TmfTraceManager.getInstance().getOpenedTraces()) {
            IFile bookmarksFile = TmfTraceManager.getInstance().getTraceEditorFile(trace);
            TimeChartAnalysisEntry timeAnalysisEntry = new TimeChartAnalysisEntry(trace, this.fDisplayWidth * 2);
            this.fTimeAnalysisEntries.add(timeAnalysisEntry);
            this.fDecorationProviders.put(trace, new TimeChartDecorationProvider(bookmarksFile));
            ProcessTraceThread thread = new ProcessTraceThread(timeAnalysisEntry);
            thread.start();
        }
        this.fViewer.setInput(this.fTimeAnalysisEntries.toArray(new TimeChartAnalysisEntry[0]));
        ColorSettingsManager.addColorSettingsListener(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    @Override
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        for (DecorateThread thread : this.fDecorateThreads) {
            thread.cancel();
        }
        ColorSettingsManager.removeColorSettingsListener(this);
        super.dispose();
    }

    public void setFocus() {
        this.fViewer.setFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTraceEntry(TimeChartAnalysisEntry timeAnalysisEntry, long stopRank, long startTime, long stopTime) {
        ITmfTrace trace = timeAnalysisEntry.getTrace();
        TimeChartDecorationProvider decorationProvider = this.fDecorationProviders.get(trace);
        if (decorationProvider == null) {
            return;
        }
        ITmfContext context = null;
        boolean done = false;
        while (!done) {
            TimeChartAnalysisEntry timeChartAnalysisEntry = timeAnalysisEntry;
            synchronized (timeChartAnalysisEntry) {
                if (timeAnalysisEntry.getLastRank() >= trace.getNbEvents()) {
                    done = true;
                    break;
                }
                if (context == null || context.getRank() != timeAnalysisEntry.getLastRank()) {
                    if (context != null) {
                        context.dispose();
                    }
                    context = timeAnalysisEntry.getLastRank() != -1L ? trace.seekEvent(timeAnalysisEntry.getLastRank()) : trace.seekEvent(0L);
                }
                do {
                    long rank = context.getRank();
                    ITmfEvent event = trace.getNext(context);
                    if (event == null) {
                        done = true;
                        break;
                    }
                    TimeChartEvent timeEvent = new TimeChartEvent(timeAnalysisEntry, event, rank, decorationProvider);
                    if (timeEvent.getTime() >= startTime && timeEvent.getTime() <= stopTime) {
                        timeAnalysisEntry.addTraceEvent(timeEvent);
                    }
                    if (context.getRank() != trace.getNbEvents() && context.getRank() != stopRank) continue;
                    done = true;
                    break;
                } while (context.getRank() % (long)trace.getCacheSize() != 1L);
                timeAnalysisEntry.setLastRank(context.getRank());
            }
            this.redrawViewer(true);
        }
        if (context != null) {
            context.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshViewer() {
        Object object = this.fSyncObj;
        synchronized (object) {
            if (this.fRefreshBusy) {
                this.fRefreshPending = true;
                return;
            }
            this.fRefreshBusy = true;
        }
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (TimeChartView.this.fViewer.getControl().isDisposed()) {
                    return;
                }
                TimeChartView.this.fViewer.setInput(TimeChartView.this.fTimeAnalysisEntries.toArray(new TimeChartAnalysisEntry[0]));
                TimeChartView.this.fViewer.resetStartFinishTime();
                Object object = TimeChartView.this.fSyncObj;
                synchronized (object) {
                    TimeChartView.this.fRefreshBusy = false;
                    if (TimeChartView.this.fRefreshPending) {
                        TimeChartView.this.fRefreshPending = false;
                        TimeChartView.this.refreshViewer();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redrawViewer(boolean resetTimeIntervals) {
        Object object = this.fSyncObj;
        synchronized (object) {
            if (this.fRedrawBusy) {
                this.fRedrawPending = true;
                return;
            }
            this.fRedrawBusy = true;
        }
        final boolean reset = resetTimeIntervals;
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (TimeChartView.this.fViewer.getControl().isDisposed()) {
                    return;
                }
                if (reset) {
                    TimeChartView.this.fViewer.setTimeRange(TimeChartView.this.fTimeAnalysisEntries.toArray(new TimeChartAnalysisEntry[0]));
                    TimeChartView.this.fViewer.setTimeBounds();
                }
                TimeChartView.this.fViewer.getControl().redraw();
                TimeChartView.this.fViewer.getControl().update();
                Object object = TimeChartView.this.fSyncObj;
                synchronized (object) {
                    TimeChartView.this.fRedrawBusy = false;
                    if (TimeChartView.this.fRedrawPending) {
                        TimeChartView.this.fRedrawPending = false;
                        TimeChartView.this.redrawViewer(reset);
                    }
                }
            }
        });
    }

    private void itemize(long startTime, long stopTime) {
        int i = 0;
        while (i < this.fTimeAnalysisEntries.size()) {
            ItemizeThread thread = new ItemizeThread(this.fTimeAnalysisEntries.get(i), startTime, stopTime);
            thread.start();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redecorate() {
        ArrayList<DecorateThread> arrayList = this.fDecorateThreads;
        synchronized (arrayList) {
            for (DecorateThread thread : this.fDecorateThreads) {
                thread.cancel();
            }
            this.fDecorateThreads.clear();
            int i = 0;
            while (i < this.fTimeAnalysisEntries.size()) {
                DecorateThread thread = new DecorateThread(this.fTimeAnalysisEntries.get(i));
                thread.start();
                this.fDecorateThreads.add(thread);
                ++i;
            }
        }
    }

    @Override
    public void timeRangeUpdated(TimeGraphRangeUpdateEvent event) {
        this.fStartTime = event.getStartTime();
        this.fStopTime = event.getEndTime();
        this.itemize(this.fStartTime, this.fStopTime);
        TmfTimestamp startTimestamp = new TmfTimestamp(event.getStartTime(), -9);
        TmfTimestamp endTimestamp = new TmfTimestamp(event.getEndTime(), -9);
        TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)startTimestamp, (ITmfTimestamp)endTimestamp);
        this.broadcast((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range));
    }

    @Override
    public void selectionChanged(TimeGraphSelectionEvent event) {
        ITimeGraphEntry timeAnalysisEntry = null;
        if (event.getSelection() instanceof TimeChartAnalysisEntry) {
            timeAnalysisEntry = event.getSelection();
        } else if (event.getSelection() instanceof TimeChartEvent) {
            timeAnalysisEntry = ((TimeChartEvent)((Object)event.getSelection())).getEntry();
        }
        if (timeAnalysisEntry instanceof TimeChartAnalysisEntry) {
            this.broadcast((TmfSignal)new TmfTraceSelectedSignal((Object)this, ((TimeChartAnalysisEntry)timeAnalysisEntry).getTrace()));
        }
    }

    @Override
    public void timeSelected(TimeGraphTimeEvent event) {
        this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, (ITmfTimestamp)new TmfTimestamp(event.getBeginTime(), -9), (ITmfTimestamp)new TmfTimestamp(event.getEndTime(), -9)));
    }

    @Override
    public void colorSettingsChanged(ColorSetting[] colorSettings) {
        this.fViewer.setTimeGraphProvider(this.fPresentationProvider);
        this.redecorate();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] iMarkerDeltaArray = event.findMarkerDeltas("org.eclipse.core.resources.bookmark", false);
        int n = iMarkerDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            for (TimeChartDecorationProvider provider : this.fDecorationProviders.values()) {
                if (!delta.getResource().equals((Object)provider.getBookmarksFile())) continue;
                if (delta.getKind() == 4 && delta.getMarker().getAttribute("location", -1) != -1) {
                    provider.refreshBookmarks();
                    continue;
                }
                if (delta.getKind() != 2) continue;
                provider.refreshBookmarks();
            }
            ++n2;
        }
        this.redecorate();
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        ITmfTrace trace = signal.getTrace();
        IFile bookmarksFile = signal.getEditorFile();
        TimeChartAnalysisEntry timeAnalysisEntry = null;
        int i = 0;
        while (i < this.fTimeAnalysisEntries.size()) {
            if (this.fTimeAnalysisEntries.get(i).getTrace().equals(trace)) {
                timeAnalysisEntry = this.fTimeAnalysisEntries.get(i);
                break;
            }
            ++i;
        }
        if (timeAnalysisEntry == null) {
            timeAnalysisEntry = new TimeChartAnalysisEntry(trace, this.fDisplayWidth * 2);
            this.fTimeAnalysisEntries.add(timeAnalysisEntry);
            this.fDecorationProviders.put(trace, new TimeChartDecorationProvider(bookmarksFile));
            ProcessTraceThread thread = new ProcessTraceThread(timeAnalysisEntry);
            thread.start();
        }
        this.refreshViewer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        ITmfTrace trace = signal.getTrace();
        int i = 0;
        while (i < this.fTimeAnalysisEntries.size()) {
            if (this.fTimeAnalysisEntries.get(i).getTrace().equals(trace)) {
                this.fTimeAnalysisEntries.remove(i);
                this.fDecorationProviders.remove(trace);
                ArrayList<DecorateThread> arrayList = this.fDecorateThreads;
                synchronized (arrayList) {
                    for (DecorateThread thread : this.fDecorateThreads) {
                        if (thread.fTimeAnalysisEntry.getTrace() != trace) continue;
                        thread.cancel();
                        this.fDecorateThreads.remove(thread);
                        break;
                    }
                }
                this.refreshViewer();
                break;
            }
            ++i;
        }
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (signal.getSource() != this) {
            ITmfTrace trace = signal.getTrace();
            int i = 0;
            while (i < this.fTimeAnalysisEntries.size()) {
                if (this.fTimeAnalysisEntries.get(i).getTrace().equals(trace)) {
                    this.fViewer.setSelection(this.fTimeAnalysisEntries.get(i));
                    break;
                }
                ++i;
            }
            TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
            long beginTime = ctx.getSelectionRange().getStartTime().normalize(0L, -9).getValue();
            long endTime = ctx.getSelectionRange().getEndTime().normalize(0L, -9).getValue();
            this.fViewer.setSelectionRange(beginTime, endTime);
        }
    }

    @TmfSignalHandler
    public void traceUpdated(TmfTraceUpdatedSignal signal) {
        ITmfTrace trace = signal.getTrace();
        int i = 0;
        while (i < this.fTimeAnalysisEntries.size()) {
            TimeChartAnalysisEntry timeAnalysisEntry = this.fTimeAnalysisEntries.get(i);
            if (timeAnalysisEntry.getTrace().equals(trace)) {
                this.updateTraceEntry(timeAnalysisEntry, Long.MAX_VALUE, 0L, Long.MAX_VALUE);
                break;
            }
            ++i;
        }
    }

    @TmfSignalHandler
    public void selectionRangeUpdated(TmfSelectionRangeUpdatedSignal signal) {
        final long beginTime = signal.getBeginTime().normalize(0L, -9).getValue();
        final long endTime = signal.getEndTime().normalize(0L, -9).getValue();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (beginTime == endTime) {
                    TimeChartView.this.fViewer.setSelectedTime(beginTime, true);
                    if (TimeChartView.this.fStartTime != TimeChartView.this.fViewer.getTime0() || TimeChartView.this.fStopTime != TimeChartView.this.fViewer.getTime1()) {
                        TimeChartView.this.fStartTime = TimeChartView.this.fViewer.getTime0();
                        TimeChartView.this.fStopTime = TimeChartView.this.fViewer.getTime1();
                        TimeChartView.this.itemize(TimeChartView.this.fStartTime, TimeChartView.this.fStopTime);
                    }
                } else {
                    TimeChartView.this.fViewer.setSelectionRange(beginTime, endTime);
                }
            }
        });
    }

    @TmfSignalHandler
    public void windowRangeUpdated(TmfWindowRangeUpdatedSignal signal) {
        if (signal.getSource() == this) {
            return;
        }
        final long startTime = signal.getCurrentRange().getStartTime().normalize(0L, -9).getValue();
        final long endTime = signal.getCurrentRange().getEndTime().normalize(0L, -9).getValue();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TimeChartView.this.fStartTime = startTime;
                TimeChartView.this.fStopTime = endTime;
                TimeChartView.this.itemize(TimeChartView.this.fStartTime, TimeChartView.this.fStopTime);
                TimeChartView.this.fViewer.setStartFinishTime(startTime, endTime);
            }
        });
    }

    @TmfSignalHandler
    public void filterApplied(TmfEventFilterAppliedSignal signal) {
        TimeChartDecorationProvider decorationProvider = this.fDecorationProviders.get(signal.getTrace());
        if (decorationProvider == null) {
            return;
        }
        decorationProvider.filterApplied(signal.getEventFilter());
        this.redecorate();
    }

    @TmfSignalHandler
    public void searchApplied(TmfEventSearchAppliedSignal signal) {
        TimeChartDecorationProvider decorationProvider = this.fDecorationProviders.get(signal.getTrace());
        if (decorationProvider == null) {
            return;
        }
        decorationProvider.searchApplied(signal.getSearchFilter());
        this.redecorate();
    }

    @Override
    public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo() {
        if (this.fViewer == null) {
            return null;
        }
        return this.fViewer.getTimeViewAlignmentInfo();
    }

    @Override
    public int getAvailableWidth(int requestedOffset) {
        return this.fViewer.getAvailableWidth(requestedOffset);
    }

    @Override
    public void performAlign(int offset, int width) {
        this.fViewer.performAlign(offset, width);
    }

    private class DecorateThread
    extends Thread {
        private volatile boolean interrupted;
        private final TimeChartAnalysisEntry fTimeAnalysisEntry;
        private final TimeChartDecorationProvider fDecorationProvider;
        private ITmfContext fContext;
        private int fCount;

        private DecorateThread(TimeChartAnalysisEntry timeAnalysisEntry) {
            super("Decorate Thread:" + timeAnalysisEntry.getName());
            this.interrupted = false;
            this.fCount = 0;
            this.fTimeAnalysisEntry = timeAnalysisEntry;
            this.fDecorationProvider = (TimeChartDecorationProvider)TimeChartView.this.fDecorationProviders.get(timeAnalysisEntry.getTrace());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.resetTraceEntry(this.fTimeAnalysisEntry);
            TimeChartView.this.redrawViewer(false);
            this.decorateTraceEntry(this.fTimeAnalysisEntry, null);
            TimeChartView.this.redrawViewer(false);
            ArrayList arrayList = TimeChartView.this.fDecorateThreads;
            synchronized (arrayList) {
                TimeChartView.this.fDecorateThreads.remove(this);
            }
            if (this.fContext != null) {
                this.fContext.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetTraceEntry(TimeChartAnalysisEntry timeAnalysisEntry) {
            Iterator<ITimeEvent> iterator = timeAnalysisEntry.getTimeEventsIterator();
            TimeChartEvent event = null;
            boolean hasNext = true;
            while (!this.interrupted && hasNext) {
                TimeChartAnalysisEntry timeChartAnalysisEntry = timeAnalysisEntry;
                synchronized (timeChartAnalysisEntry) {
                    hasNext = iterator.hasNext();
                    if (hasNext) {
                        event = (TimeChartEvent)iterator.next();
                    }
                }
                if (!hasNext || event == null) continue;
                event.setColorSettingPriority(Integer.MAX_VALUE);
                if (event.getItemizedEntry() == null) continue;
                this.resetTraceEntry(event.getItemizedEntry());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decorateTraceEntry(TimeChartAnalysisEntry timeAnalysisEntry, TimeChartEvent parentEvent) {
            Iterator<ITimeEvent> iterator = timeAnalysisEntry.getTimeEventsIterator(0L, Long.MAX_VALUE, Long.MAX_VALUE);
            TimeChartEvent event = null;
            int entryPriority = Integer.MAX_VALUE;
            boolean entryIsBookmarked = false;
            boolean entryIsVisible = false;
            boolean entryIsSearchMatch = false;
            boolean hasNext = true;
            while (!this.interrupted && hasNext) {
                TimeChartAnalysisEntry timeChartAnalysisEntry = timeAnalysisEntry;
                synchronized (timeChartAnalysisEntry) {
                    hasNext = iterator.hasNext();
                    if (hasNext) {
                        event = (TimeChartEvent)iterator.next();
                    }
                }
                if (!hasNext || event == null) continue;
                if (event.getItemizedEntry() == null) {
                    this.decorateEvent(event);
                } else {
                    this.decorateTraceEntry(event.getItemizedEntry(), event);
                }
                entryPriority = Math.min(entryPriority, event.getColorSettingPriority());
                entryIsBookmarked |= event.isBookmarked();
                entryIsVisible |= event.isVisible();
                entryIsSearchMatch |= event.isSearchMatch();
                if (++this.fCount % timeAnalysisEntry.getTrace().getCacheSize() != 0) continue;
                TimeChartView.this.redrawViewer(false);
            }
            if (parentEvent != null) {
                parentEvent.setColorSettingPriority(entryPriority);
                parentEvent.setIsBookmarked(entryIsBookmarked);
                parentEvent.setIsVisible(entryIsVisible);
                parentEvent.setIsSearchMatch(entryIsSearchMatch);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decorateEvent(TimeChartEvent timeChartEvent) {
            TimeChartAnalysisEntry timeAnalysisEntry = (TimeChartAnalysisEntry)timeChartEvent.getEntry();
            ITmfTrace trace = timeAnalysisEntry.getTrace();
            int priority = Integer.MAX_VALUE;
            boolean isBookmarked = false;
            boolean isVisible = false;
            boolean isSearchMatch = false;
            TimeChartEvent.RankRangeList rankRangeList = timeChartEvent.getRankRangeList();
            synchronized (rankRangeList) {
                block3: for (TimeChartEvent.RankRange range : timeChartEvent.getRankRangeList()) {
                    if (this.interrupted) {
                        return;
                    }
                    if (this.fContext == null || this.fContext.getRank() != range.getFirstRank()) {
                        if (this.fContext != null) {
                            this.fContext.dispose();
                        }
                        this.fContext = trace.seekEvent(range.getFirstRank());
                        this.fContext.setRank(range.getFirstRank());
                    }
                    do {
                        if (this.interrupted) {
                            return;
                        }
                        long rank = this.fContext.getRank();
                        ITmfEvent event = trace.getNext(this.fContext);
                        if (event == null) continue block3;
                        long eventTime = event.getTimestamp().normalize(0L, -9).getValue();
                        if (eventTime >= timeChartEvent.getTime() && eventTime <= timeChartEvent.getTime() + timeChartEvent.getDuration()) {
                            priority = Math.min(priority, ColorSettingsManager.getColorSettingPriority(event));
                        }
                        isBookmarked |= this.fDecorationProvider.isBookmark(rank);
                        isVisible |= this.fDecorationProvider.isVisible(event);
                        isSearchMatch |= this.fDecorationProvider.isSearchMatch(event);
                    } while (this.fContext.getRank() <= range.getLastRank());
                }
            }
            timeChartEvent.setColorSettingPriority(priority);
            timeChartEvent.setIsBookmarked(isBookmarked);
            timeChartEvent.setIsVisible(isVisible);
            timeChartEvent.setIsSearchMatch(isSearchMatch);
        }

        public void cancel() {
            this.interrupted = true;
        }
    }

    private class ItemizeThread
    extends Thread {
        private final TimeChartAnalysisEntry fTimeAnalysisEntry;
        private final long startTime;
        private final long stopTime;
        private final long fMaxDuration;

        private ItemizeThread(TimeChartAnalysisEntry timeAnalysisEntry, long startTime, long stopTime) {
            super("Itemize Thread:" + timeAnalysisEntry.getName());
            this.fTimeAnalysisEntry = timeAnalysisEntry;
            this.startTime = startTime;
            this.stopTime = stopTime;
            this.fMaxDuration = 3L * (stopTime - startTime) / (long)TimeChartView.this.fDisplayWidth;
        }

        @Override
        public void run() {
            this.itemizeTraceEntry(this.fTimeAnalysisEntry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void itemizeTraceEntry(TimeChartAnalysisEntry timeAnalysisEntry) {
            Iterator<ITimeEvent> iterator = timeAnalysisEntry.getTimeEventsIterator();
            TimeChartEvent event = null;
            boolean hasNext = true;
            while (hasNext) {
                TimeChartAnalysisEntry timeChartAnalysisEntry = timeAnalysisEntry;
                synchronized (timeChartAnalysisEntry) {
                    while (hasNext = iterator.hasNext()) {
                        event = (TimeChartEvent)iterator.next();
                        if (event.getTime() + event.getDuration() > this.startTime && event.getTime() < this.stopTime && event.getDuration() > this.fMaxDuration && event.getNbEvents() > 1L) break;
                    }
                }
                if (!hasNext || event == null) continue;
                if (event.getItemizedEntry() == null) {
                    this.itemizeEvent(event);
                    continue;
                }
                this.itemizeTraceEntry(event.getItemizedEntry());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void itemizeEvent(TimeChartEvent event) {
            TimeChartEvent timeChartEvent = event;
            synchronized (timeChartEvent) {
                if (event.isItemizing()) {
                    return;
                }
                event.setItemizing(true);
            }
            TimeChartAnalysisEntry timeAnalysisEntry = new TimeChartAnalysisEntry(this.fTimeAnalysisEntry.getTrace(), (int)Math.min(event.getNbEvents() + 1L, (long)(TimeChartView.this.fDisplayWidth * 2)));
            Object object = event.getRankRangeList();
            synchronized (object) {
                for (TimeChartEvent.RankRange range : event.getRankRangeList()) {
                    timeAnalysisEntry.setLastRank(range.getFirstRank());
                    TimeChartView.this.updateTraceEntry(timeAnalysisEntry, range.getLastRank() + 1L, event.getTime(), event.getTime() + event.getDuration());
                }
            }
            event.setItemizedEntry(timeAnalysisEntry);
            TimeChartView.this.redrawViewer(false);
            this.itemizeTraceEntry(timeAnalysisEntry);
            object = event;
            synchronized (object) {
                event.setItemizing(false);
            }
        }
    }

    private class ProcessTraceThread
    extends Thread {
        private final TimeChartAnalysisEntry fTimeAnalysisEntry;

        public ProcessTraceThread(TimeChartAnalysisEntry timeAnalysisEntry) {
            super("ProcessTraceJob:" + timeAnalysisEntry.getName());
            this.fTimeAnalysisEntry = timeAnalysisEntry;
        }

        @Override
        public void run() {
            TimeChartView.this.updateTraceEntry(this.fTimeAnalysisEntry, Long.MAX_VALUE, 0L, Long.MAX_VALUE);
        }
    }
}

