/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.ITimeDataProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.ITimeDataProviderConverter;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class TimeDataProviderCyclesConverter
implements ITimeDataProviderConverter {
    private static final long GIGAHERTZ = 1000000000L;
    @NonNull
    private final ITimeDataProvider fProvider;
    private final long fFreq;

    public TimeDataProviderCyclesConverter(@NonNull ITimeDataProvider provider, long clockFrequency) {
        this.fProvider = provider;
        this.fFreq = clockFrequency;
    }

    public long toCycles(long nanos) {
        return Math.round((double)nanos * ((double)this.fFreq / 1.0E9));
    }

    public long toNanos(long cycles) {
        return Math.round((double)cycles * (1.0E9 / (double)this.fFreq));
    }

    @Override
    public long convertTime(long time) {
        return this.toCycles(time);
    }

    @Override
    public void setSelectionRangeNotify(long beginTime, long endTime) {
        this.fProvider.setSelectionRangeNotify(this.toNanos(beginTime), this.toNanos(endTime));
    }

    @Override
    public void setSelectionRange(long beginTime, long endTime) {
        this.fProvider.setSelectionRange(this.toNanos(beginTime), this.toNanos(endTime));
    }

    @Override
    public long getSelectionBegin() {
        return this.toCycles(this.fProvider.getSelectionBegin());
    }

    @Override
    public long getSelectionEnd() {
        return this.toCycles(this.fProvider.getSelectionEnd());
    }

    @Override
    public long getBeginTime() {
        return this.toCycles(this.fProvider.getBeginTime());
    }

    @Override
    public long getEndTime() {
        return this.toCycles(this.fProvider.getEndTime());
    }

    @Override
    public long getMinTime() {
        return this.toCycles(this.fProvider.getMinTime());
    }

    @Override
    public long getMaxTime() {
        return this.toCycles(this.fProvider.getMaxTime());
    }

    @Override
    public long getTime0() {
        return this.toCycles(this.fProvider.getTime0());
    }

    @Override
    public long getTime1() {
        return this.toCycles(this.fProvider.getTime1());
    }

    @Override
    public long getMinTimeInterval() {
        return this.fProvider.getMinTimeInterval();
    }

    @Override
    public void setStartFinishTimeNotify(long time0, long time1) {
        this.fProvider.setStartFinishTimeNotify(this.toNanos(time0), this.toNanos(time1));
    }

    @Override
    public void setStartFinishTime(long time0, long time1) {
        this.fProvider.setStartFinishTime(this.toNanos(time0), this.toNanos(time1));
    }

    @Override
    public void notifyStartFinishTime() {
        this.fProvider.notifyStartFinishTime();
    }

    @Override
    public void setSelectedTimeNotify(long time, boolean ensureVisible) {
        this.fProvider.setSelectedTimeNotify(this.toNanos(time), ensureVisible);
    }

    @Override
    public void setSelectedTime(long time, boolean ensureVisible) {
        this.fProvider.setSelectedTime(this.toNanos(time), ensureVisible);
    }

    @Override
    public void resetStartFinishTime() {
        this.fProvider.resetStartFinishTime();
    }

    @Override
    public int getNameSpace() {
        return this.fProvider.getNameSpace();
    }

    @Override
    public void setNameSpace(int width) {
        this.fProvider.setNameSpace(width);
    }

    @Override
    public int getTimeSpace() {
        return this.fProvider.getTimeSpace();
    }

    @Override
    public Utils.TimeFormat getTimeFormat() {
        return this.fProvider.getTimeFormat();
    }
}

