/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class TimeGraphColorScheme {
    public static final int BLACK_STATE = 0;
    public static final int GREEN_STATE = 1;
    public static final int DARK_BLUE_STATE = 2;
    public static final int ORANGE_STATE = 3;
    public static final int GOLD_STATE = 4;
    public static final int RED_STATE = 5;
    public static final int GRAY_STATE = 6;
    public static final int DARK_GREEN_STATE = 7;
    public static final int DARK_YELLOW_STATE = 8;
    public static final int MAGENTA3_STATE = 9;
    public static final int PURPLE1_STATE = 10;
    public static final int PINK1_STATE = 11;
    public static final int AQUAMARINE_STATE = 12;
    public static final int LIGHT_BLUE_STATE = 13;
    public static final int CADET_BLUE_STATE = 14;
    public static final int OLIVE_STATE = 15;
    public static final int STATES0 = 0;
    public static final int STATES1 = 15;
    public static final int BLACK_STATE_SEL = 16;
    public static final int GREEN_STATE_SEL = 17;
    public static final int DARK_BLUE_STATE_SEL = 18;
    public static final int ORANGE_STATE_SEL = 19;
    public static final int GOLD_STATE_SEL = 20;
    public static final int RED_STATE_SEL = 21;
    public static final int GRAY_STATE_SEL = 22;
    public static final int DARK_GREEN_STATE_SEL = 23;
    public static final int DARK_YELLOW_STATE_SEL = 24;
    public static final int MAGENTA3_STATE_SEL = 25;
    public static final int PURPLE1_STATE_SEL = 26;
    public static final int PINK1_STATE_SEL = 27;
    public static final int AQUAMARINE_STATE_SEL = 28;
    public static final int LIGHT_BLUE_STATE_SEL = 29;
    public static final int CADET_BLUE_STATE_SEL = 30;
    public static final int OLIVE_STATE_SEL = 31;
    public static final int STATES_SEL0 = 16;
    public static final int STATES_SEL1 = 31;
    public static final int BACKGROUND = 32;
    public static final int FOREGROUND = 33;
    public static final int BACKGROUND_SEL = 34;
    public static final int FOREGROUND_SEL = 35;
    public static final int BACKGROUND_SEL_NOFOCUS = 36;
    public static final int FOREGROUND_SEL_NOFOCUS = 37;
    public static final int TOOL_BACKGROUND = 38;
    public static final int TOOL_FOREGROUND = 39;
    public static final int FIX_COLOR = 40;
    public static final int WHITE = 41;
    public static final int GRAY = 42;
    public static final int BLACK = 43;
    public static final int DARK_GRAY = 44;
    public static final int BLACK_BORDER = 45;
    public static final int GREEN_BORDER = 46;
    public static final int DARK_BLUE_BORDER = 47;
    public static final int ORANGE_BORDER = 48;
    public static final int GOLD_BORDER = 49;
    public static final int RED_BORDER = 50;
    public static final int GRAY_BORDER = 51;
    public static final int DARK_GREEN_BORDER1 = 52;
    public static final int DARK_YELLOW_BORDER1 = 53;
    public static final int MAGENTA3_BORDER1 = 54;
    public static final int PURPLE1_BORDER1 = 55;
    public static final int PINK1_BORDER1 = 56;
    public static final int AQUAMARINE_BORDER1 = 57;
    public static final int LIGHT_BLUE_BORDER1 = 58;
    public static final int CADET_BLUE_STATE_BORDER = 59;
    public static final int OLIVE_BORDER2 = 60;
    public static final int STATES_BORDER0 = 45;
    public static final int STATES_BORDER1 = 60;
    public static final int MID_LINE = 61;
    public static final int RED = 62;
    public static final int GREEN = 63;
    public static final int BLUE = 64;
    public static final int YELLOW = 65;
    public static final int CYAN = 66;
    public static final int MAGENTA = 67;
    public static final int SELECTED_TIME = 68;
    public static final int LEGEND_BACKGROUND = 69;
    public static final int LEGEND_FOREGROUND = 70;
    public static final int GR_BACKGROUND = 71;
    public static final int GR_FOREGROUND = 72;
    public static final int GR_BACKGROUND_SEL = 73;
    public static final int GR_FOREGROUND_SEL = 74;
    public static final int GR_BACKGROUND_SEL_NOFOCUS = 75;
    public static final int GR_FOREGROUND_SEL_NOFOCUS = 76;
    public static final int LIGHT_LINE = 77;
    public static final int BACKGROUND_NAME = 78;
    public static final int BACKGROUND_NAME_SEL = 79;
    public static final int BACKGROUND_NAME_SEL_NOFOCUS = 80;
    public static final int TI_START_THREAD = 43;
    public static final int TI_HANDOFF_LOCK = 64;
    public static final int TI_NOTIFY_ALL = 63;
    public static final int TI_NOTIFY = 63;
    public static final int TI_NOTIFY_JOINED = 44;
    public static final int TI_INTERRUPT = 62;
    public static final int TI_WAIT_EXCEEDED = 64;
    private static final IColorProvider[] PROVIDERS_MAP = new IColorProvider[]{new RGB(100, 100, 100), new RGB(174, 200, 124), new Mix(new SysCol(9), new SysCol(15), 1, 3), new RGB(210, 150, 60), new RGB(242, 225, 168), new Mix(new SysCol(3), new SysCol(15), 1, 3), new RGB(200, 200, 200), new RGB(35, 107, 42), new RGB(205, 205, 0), new RGB(205, 0, 205), new RGB(171, 130, 255), new RGB(255, 181, 197), new RGB(112, 219, 147), new RGB(198, 226, 255), new RGB(95, 158, 160), new RGB(107, 142, 35), new SysCol(1), new SysCol(5), new SysCol(9), new SysCol(13), new SysCol(7), new SysCol(3), new SysCol(16), new SysCol(1), new SysCol(5), new SysCol(9), new SysCol(13), new SysCol(7), new SysCol(3), new SysCol(16), new SysCol(1), new SysCol(5), new SysCol(25), new SysCol(24), new RGB(232, 242, 254), new SysCol(24), new SysCol(22), new SysCol(21), new SysCol(22), new SysCol(17), new SysCol(15), new SysCol(1), new SysCol(15), new SysCol(2), new SysCol(16), new SysCol(16), new RGB(75, 115, 120), new SysCol(10), new RGB(242, 225, 168), new RGB(210, 150, 60), new SysCol(4), new SysCol(2), new SysCol(16), new RGB(75, 115, 120), new SysCol(10), new RGB(242, 225, 168), new RGB(210, 150, 60), new SysCol(4), new SysCol(2), new SysCol(16), new RGB(75, 115, 120), new SysCol(15), new SysCol(3), new SysCol(5), new SysCol(9), new SysCol(7), new SysCol(13), new SysCol(11), new SysCol(9), new SysCol(22), new SysCol(17), new Mix(new RGB(150, 200, 240), new SysCol(25)), new RGB(0, 0, 50), new Mix(new RGB(150, 200, 240), new SysCol(1), 6, 1), new RGB(0, 0, 50), new Mix(new RGB(150, 200, 240), new SysCol(1), 6, 1), new RGB(0, 0, 50), new Mix(new SysCol(15), new SysCol(25), 1, 3), new Mix(new SysCol(15), new SysCol(25), 1, 6), new Mix(new SysCol(15), new RGB(232, 242, 254), 1, 6), new Mix(new SysCol(15), new SysCol(22), 1, 6)};
    private final Color[] fColors = new Color[PROVIDERS_MAP.length];

    public void dispose() {
        int i = 0;
        while (i < this.fColors.length) {
            Utils.dispose(this.fColors[i]);
            this.fColors[i] = null;
            ++i;
        }
    }

    public Color getColor(int idx) {
        if (this.fColors[idx] == null) {
            if (idx >= 16 && idx <= 31) {
                Color col1 = this.getColor(idx - 16);
                Color col2 = this.getColor(34);
                this.fColors[idx] = Utils.mixColors(col1, col2, 3, 1);
            } else {
                this.fColors[idx] = PROVIDERS_MAP[idx].get();
            }
        }
        return this.fColors[idx];
    }

    public Color getBkColor(boolean selected, boolean focused, boolean name) {
        if (name) {
            if (selected && focused) {
                return this.getColor(79);
            }
            if (selected) {
                return this.getColor(80);
            }
            return this.getColor(78);
        }
        if (selected && focused) {
            return this.getColor(34);
        }
        if (selected) {
            return this.getColor(36);
        }
        return this.getColor(32);
    }

    public Color getFgColor(boolean selected, boolean focused) {
        if (selected && focused) {
            return this.getColor(35);
        }
        if (selected) {
            return this.getColor(37);
        }
        return this.getColor(33);
    }

    public Color getBkColorGroup(boolean selected, boolean focused) {
        if (selected && focused) {
            return this.getColor(73);
        }
        if (selected) {
            return this.getColor(75);
        }
        return this.getColor(71);
    }

    public Color getFgColorGroup(boolean selected, boolean focused) {
        if (selected && focused) {
            return this.getColor(74);
        }
        if (selected) {
            return this.getColor(76);
        }
        return this.getColor(72);
    }

    static interface IColorProvider {
        public Color get();
    }

    static class Mix
    implements IColorProvider {
        private IColorProvider cp1;
        private IColorProvider cp2;
        private int w1;
        private int w2;

        Mix(IColorProvider cp1, IColorProvider cp2, int w1, int w2) {
            this.cp1 = cp1;
            this.cp2 = cp2;
            this.w1 = w1;
            this.w2 = w2;
        }

        Mix(IColorProvider cp1, IColorProvider cp2) {
            this.cp1 = cp1;
            this.cp2 = cp2;
            this.w1 = 1;
            this.w2 = 1;
        }

        @Override
        public Color get() {
            Color col1 = this.cp1.get();
            Color col2 = this.cp2.get();
            return Utils.mixColors(col1, col2, this.w1, this.w2);
        }
    }

    static class RGB
    implements IColorProvider {
        private int r;
        private int g;
        private int b;

        RGB(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        @Override
        public Color get() {
            return new Color(null, this.r, this.g, this.b);
        }
    }

    static class SysCol
    implements IColorProvider {
        private int syscol;

        SysCol(int syscol) {
            this.syscol = syscol;
        }

        @Override
        public Color get() {
            return Utils.getSysColor(this.syscol);
        }
    }
}

