/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.filters.SelectFiltersAction;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorViewerDescriptor;

public class FilterActionGroup
extends ActionGroup {
    private static final String FILTER_ACTION_GROUP = "filterActionGroup";
    private static final String FILTER_ACTION_GROUP_FILTERS_START = "filterActionGroupFilters-start";
    private static final String FILTER_ACTION_GROUP_FILTERS_END = "filterActionGroupFilters-end";
    private SelectFiltersAction selectFiltersAction;
    private CommonViewer commonViewer;
    private INavigatorViewerDescriptor viewerDescriptor;
    private final Set filterShortcutActions = new LinkedHashSet();

    public FilterActionGroup(CommonViewer aCommonViewer) {
        Assert.isNotNull((Object)((Object)aCommonViewer));
        this.commonViewer = aCommonViewer;
        this.viewerDescriptor = this.commonViewer.getNavigatorContentService().getViewerDescriptor();
        this.makeActions();
    }

    public void fillActionBars(IActionBars actionBars) {
        IMenuManager menu = actionBars.getMenuManager();
        menu.appendToGroup("additions", (IContributionItem)new Separator(FILTER_ACTION_GROUP));
        if (this.selectFiltersAction != null) {
            menu.appendToGroup(FILTER_ACTION_GROUP, (IAction)this.selectFiltersAction);
            menu.appendToGroup(FILTER_ACTION_GROUP, (IContributionItem)new GroupMarker(FILTER_ACTION_GROUP_FILTERS_START));
            menu.appendToGroup(FILTER_ACTION_GROUP_FILTERS_START, (IContributionItem)new Separator(FILTER_ACTION_GROUP_FILTERS_END));
            for (IAction action : this.filterShortcutActions) {
                menu.appendToGroup(FILTER_ACTION_GROUP_FILTERS_START, action);
            }
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
    }

    private void makeActions() {
        boolean hideAvailableCustomizationsDialog = this.viewerDescriptor.getBooleanConfigProperty("org.eclipse.ui.navigator.hideAvailableCustomizationsDialog");
        if (!hideAvailableCustomizationsDialog) {
            this.selectFiltersAction = new SelectFiltersAction(this.commonViewer, this);
            ImageDescriptor selectFiltersIcon = NavigatorPlugin.getImageDescriptor("icons/full/elcl16/filter_ps.gif");
            this.selectFiltersAction.setImageDescriptor(selectFiltersIcon);
            this.selectFiltersAction.setHoverImageDescriptor(selectFiltersIcon);
        }
    }

    protected void updateFilterShortcuts() {
    }
}

