/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.cpuusage;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.KernelCpuUsageAnalysis;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.Activator;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CpuUsageStateProviderTest {
    private static final String CPU_USAGE_FILE = "testfiles/cpu_analysis.xml";
    private ITmfTrace fTrace;
    private KernelCpuUsageAnalysis fModule;

    private static void deleteSuppFiles(ITmfTrace trace) {
        File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
        File[] fileArray = suppDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    @Before
    public void setUp() {
        TmfXmlTraceStub trace = new TmfXmlTraceStub();
        IPath filePath = Activator.getAbsoluteFilePath(CPU_USAGE_FILE);
        IStatus status = trace.validate(null, filePath.toOSString());
        if (!status.isOK()) {
            Assert.fail((String)status.getException().getMessage());
        }
        try {
            trace.initTrace(null, filePath.toOSString(), TmfEvent.class);
        }
        catch (TmfTraceException e) {
            Assert.fail((String)e.getMessage());
        }
        CpuUsageStateProviderTest.deleteSuppFiles((ITmfTrace)trace);
        ((TmfTrace)trace).traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        IAnalysisModule module = null;
        Iterator iterator = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, KernelAnalysisModule.class).iterator();
        while (iterator.hasNext()) {
            IAnalysisModule mod;
            module = mod = (IAnalysisModule)iterator.next();
        }
        Assert.assertNotNull(module);
        module.schedule();
        module.waitForCompletion();
        this.fModule = (KernelCpuUsageAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelCpuUsageAnalysis.class, (String)"org.eclipse.tracecompass.analysis.os.linux.cpuusage");
        Assert.assertNotNull((Object)this.fModule);
        this.fTrace = trace;
    }

    @After
    public void tearDown() {
        CpuUsageStateProviderTest.deleteSuppFiles(this.fTrace);
        this.fTrace.dispose();
    }

    @Test
    public void testAnalysisExecution() {
        Assert.assertNull((Object)this.fModule.getStateSystem());
        Assert.assertTrue((boolean)TmfTestHelper.executeAnalysis((IAnalysisModule)this.fModule));
        Assert.assertNotNull((Object)this.fModule.getStateSystem());
    }

    @Test
    public void testReturnedStateSystem() {
        this.fModule.schedule();
        this.fModule.waitForCompletion();
        ITmfStateSystem ss = this.fModule.getStateSystem();
        Assert.assertNotNull((Object)ss);
        Assert.assertEquals((long)1L, (long)ss.getStartTime());
        Assert.assertEquals((long)25L, (long)ss.getCurrentEndTime());
        try {
            int cpusQuark = ss.getQuarkAbsolute(new String[]{"CPUs"});
            List cpuQuarks = ss.getSubAttributes(cpusQuark, false);
            Assert.assertEquals((long)2L, (long)cpuQuarks.size());
            for (Integer cpuQuark : cpuQuarks) {
                Assert.assertEquals((long)3L, (long)ss.getSubAttributes(cpuQuark.intValue(), false).size());
            }
            int proc2Quark = ss.getQuarkAbsolute(new String[]{"CPUs", "0", "2"});
            ITmfStateInterval interval = ss.querySingleState(2L, proc2Quark);
            Assert.assertEquals((long)1L, (long)interval.getStartTime());
            Assert.assertEquals((long)19L, (long)interval.getEndTime());
            List state = ss.queryFullState(25L);
            int quark = ss.getQuarkAbsolute(new String[]{"CPUs", "0", "1"});
            Assert.assertEquals((long)0L, (long)((ITmfStateInterval)state.get(quark)).getStateValue().unboxLong());
            quark = ss.getQuarkAbsolute(new String[]{"CPUs", "0", "2"});
            Assert.assertEquals((long)19L, (long)((ITmfStateInterval)state.get(quark)).getStateValue().unboxLong());
            quark = ss.getQuarkAbsolute(new String[]{"CPUs", "0", "3"});
            Assert.assertEquals((long)5L, (long)((ITmfStateInterval)state.get(quark)).getStateValue().unboxLong());
            quark = ss.getQuarkAbsolute(new String[]{"CPUs", "1", "1"});
            Assert.assertEquals((long)5L, (long)((ITmfStateInterval)state.get(quark)).getStateValue().unboxLong());
            quark = ss.getQuarkAbsolute(new String[]{"CPUs", "1", "3"});
            Assert.assertEquals((long)6L, (long)((ITmfStateInterval)state.get(quark)).getStateValue().unboxLong());
            quark = ss.getQuarkAbsolute(new String[]{"CPUs", "1", "4"});
            Assert.assertEquals((long)8L, (long)((ITmfStateInterval)state.get(quark)).getStateValue().unboxLong());
        }
        catch (AttributeNotFoundException | StateSystemDisposedException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUsageInRange() {
        this.fModule.schedule();
        this.fModule.waitForCompletion();
        HashMap<String, Long> expected = new HashMap<String, Long>();
        expected.put("0/1", 0L);
        expected.put("0/2", 19L);
        expected.put("0/3", 5L);
        expected.put("1/1", 5L);
        expected.put("1/3", 6L);
        expected.put("1/4", 13L);
        expected.put("total", 48L);
        expected.put("total/1", 5L);
        expected.put("total/2", 19L);
        expected.put("total/3", 11L);
        expected.put("total/4", 13L);
        expected.put("0", 24L);
        expected.put("1", 24L);
        Map resultMap = this.fModule.getCpuUsageInRange(0L, 30L);
        Assert.assertEquals(expected, (Object)resultMap);
        expected.clear();
        expected.put("0/1", 0L);
        expected.put("0/2", 0L);
        expected.put("0/3", 3L);
        expected.put("1/1", 0L);
        expected.put("1/3", 0L);
        expected.put("1/4", 3L);
        expected.put("total", 6L);
        expected.put("total/1", 0L);
        expected.put("total/2", 0L);
        expected.put("total/3", 3L);
        expected.put("total/4", 3L);
        expected.put("0", 3L);
        expected.put("1", 3L);
        resultMap = this.fModule.getCpuUsageInRange(22L, 25L);
        Assert.assertEquals(expected, (Object)resultMap);
        expected.clear();
        expected.put("0/1", 0L);
        expected.put("0/2", 3L);
        expected.put("0/3", 0L);
        expected.put("1/1", 0L);
        expected.put("1/3", 1L);
        expected.put("1/4", 2L);
        expected.put("total", 6L);
        expected.put("total/1", 0L);
        expected.put("total/2", 3L);
        expected.put("total/3", 1L);
        expected.put("total/4", 2L);
        expected.put("0", 3L);
        expected.put("1", 3L);
        resultMap = this.fModule.getCpuUsageInRange(1L, 4L);
        Assert.assertEquals(expected, (Object)resultMap);
        expected.clear();
        expected.put("0/1", 0L);
        expected.put("0/2", 9L);
        expected.put("0/3", 0L);
        expected.put("1/1", 0L);
        expected.put("1/3", 5L);
        expected.put("1/4", 4L);
        expected.put("total", 18L);
        expected.put("total/1", 0L);
        expected.put("total/2", 9L);
        expected.put("total/3", 5L);
        expected.put("total/4", 4L);
        expected.put("0", 9L);
        expected.put("1", 9L);
        resultMap = this.fModule.getCpuUsageInRange(4L, 13L);
        Assert.assertEquals(expected, (Object)resultMap);
    }
}

