/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.kernelanalysis;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.KernelTidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.ThreadPriorityAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.Activator;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KernelTidAspectTest {
    @NonNull
    private static final String LTTNG_KERNEL_FILE = "testfiles/lttng_kernel_analysis.xml";
    private ITmfTrace fTrace;

    private static void deleteSuppFiles(ITmfTrace trace) {
        File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
        File[] fileArray = suppDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    @Before
    public void setUp() {
        TmfXmlTraceStubWithTidAspects trace = new TmfXmlTraceStubWithTidAspects();
        IPath filePath = Activator.getAbsoluteFilePath(LTTNG_KERNEL_FILE);
        IStatus status = trace.validate(null, filePath.toOSString());
        if (!status.isOK()) {
            Assert.fail((String)status.getException().getMessage());
        }
        try {
            trace.initTrace(null, filePath.toOSString(), TmfEvent.class);
        }
        catch (TmfTraceException e) {
            Assert.fail((String)e.getMessage());
        }
        KernelTidAspectTest.deleteSuppFiles((ITmfTrace)trace);
        ((TmfTrace)trace).traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        IAnalysisModule module = null;
        Iterator iterator = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, KernelAnalysisModule.class).iterator();
        while (iterator.hasNext()) {
            IAnalysisModule mod;
            module = mod = (IAnalysisModule)iterator.next();
        }
        Assert.assertNotNull(module);
        module.schedule();
        module.waitForCompletion();
        this.fTrace = trace;
    }

    @After
    public void tearDown() {
        this.fTrace.dispose();
    }

    private void resolveNextEvent(ITmfContext context, Integer tid) {
        ITmfTrace trace = this.fTrace;
        ITmfEvent event = trace.getNext(context);
        Assert.assertNotNull((Object)event);
        Object tidObj = TmfTraceUtils.resolveEventAspectOfClassForEvent((ITmfTrace)trace, KernelTidAspect.class, (ITmfEvent)event);
        if (tid == null) {
            Assert.assertNull((Object)tidObj);
        } else {
            Assert.assertNotNull((Object)tidObj);
            Assert.assertEquals((Object)tid, (Object)tidObj);
        }
    }

    @Test
    public void testResolveTidAspect() {
        ITmfContext context = this.fTrace.seekEvent(0L);
        this.resolveNextEvent(context, null);
        this.resolveNextEvent(context, null);
        this.resolveNextEvent(context, null);
        this.resolveNextEvent(context, 11);
        this.resolveNextEvent(context, null);
        this.resolveNextEvent(context, null);
        this.resolveNextEvent(context, 20);
        this.resolveNextEvent(context, 20);
        this.resolveNextEvent(context, 21);
        this.resolveNextEvent(context, 11);
        this.resolveNextEvent(context, 30);
        this.resolveNextEvent(context, 21);
        this.resolveNextEvent(context, 20);
    }

    private static class TmfXmlTraceStubWithTidAspects
    extends TmfXmlTraceStub {
        public Iterable<ITmfEventAspect> getEventAspects() {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.addAll(super.getEventAspects());
            builder.add((Object)KernelTidAspect.INSTANCE);
            builder.add((Object)ThreadPriorityAspect.INSTANCE);
            return (Iterable)NonNullUtils.checkNotNull((Object)builder.build());
        }
    }
}

