/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.event;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.AbstractArrayDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StringDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StringDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.internal.ctf.core.event.types.SequenceDeclaration;
import org.junit.Assert;
import org.junit.Test;

public class CTFEventFieldTest {
    @NonNull
    private static final String fieldName = "id";

    @Test
    public void testParseField_complex() throws CTFException {
        int len = 32;
        IntegerDeclaration id = IntegerDeclaration.createDeclaration((int)len, (boolean)false, (int)len, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)len);
        String lengthName = "LengthName";
        StructDeclaration structDec = new StructDeclaration(0L);
        structDec.addField(lengthName, (IDeclaration)id);
        StructDefinition structDef = new StructDefinition(structDec, null, lengthName, new Definition[]{new IntegerDefinition(id, null, lengthName, 32L)});
        SequenceDeclaration sd = new SequenceDeclaration(lengthName, (IDeclaration)id);
        ByteBuffer byb = CTFEventFieldTest.testMemory(ByteBuffer.allocate(1024));
        int i = 0;
        while (i < 1024) {
            byb.put((byte)i);
            ++i;
        }
        BitBuffer bb = new BitBuffer(byb);
        AbstractArrayDefinition fieldDef = sd.createDefinition((IDefinitionScope)structDef, "fff-fffield", bb);
        Assert.assertNotNull((Object)fieldDef);
    }

    @NonNull
    private static ByteBuffer testMemory(ByteBuffer buffer) {
        if (buffer == null) {
            throw new IllegalStateException("Failed to allocate memory");
        }
        return buffer;
    }

    @Test
    public void testParseField_simple() throws CTFException {
        StringDeclaration elemType = StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8);
        byte[] byArray = new byte[5];
        byArray[0] = 84;
        byArray[1] = 101;
        byArray[2] = 115;
        byArray[3] = 116;
        byte[] bytes = byArray;
        ByteBuffer bb = CTFEventFieldTest.testMemory(ByteBuffer.wrap(bytes));
        StringDefinition fieldDef = elemType.createDefinition(null, fieldName, new BitBuffer(bb));
        Assert.assertNotNull((Object)fieldDef);
    }

    @Test
    public void testParseField_simple2() {
        IntegerDefinition fieldDef = new IntegerDefinition(IntegerDeclaration.createDeclaration((int)1, (boolean)false, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)8L), null, fieldName, 1L);
        Assert.assertNotNull((Object)fieldDef);
    }

    @Test
    public void testParseField_simple3() {
        StringDefinition fieldDef = new StringDefinition(StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8), null, fieldName, "Hello World");
        String other = "\"Hello World\"";
        Assert.assertNotNull((Object)fieldDef);
        Assert.assertEquals((Object)fieldDef.toString(), (Object)other);
    }
}

