/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.io;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BitBufferIntTest {
    private BitBuffer fixture;

    @Before
    public void setUp() throws CTFException {
        ByteBuffer allocateDirect = ByteBuffer.allocateDirect(128);
        if (allocateDirect == null) {
            throw new IllegalStateException("Failed to allocate memory");
        }
        this.fixture = new BitBuffer(allocateDirect);
        this.fixture.setByteOrder(ByteOrder.BIG_ENDIAN);
        this.fixture = BitBufferIntTest.createBuffer();
    }

    private static BitBuffer createBuffer() throws CTFException {
        return BitBufferIntTest.createBuffer(16);
    }

    private static BitBuffer createBuffer(int j) throws CTFException {
        byte[] bytes = new byte[j];
        int i = 0;
        while (i < j) {
            bytes[i] = (byte)(i % 255);
            ++i;
        }
        ByteBuffer wrap = ByteBuffer.wrap(bytes);
        if (wrap == null) {
            throw new IllegalStateException("Failed to allocate memory");
        }
        BitBuffer fixture = new BitBuffer(wrap);
        fixture.position(1L);
        return fixture;
    }

    @Test
    public void testGetInt_base() throws CTFException {
        int result = this.fixture.getInt();
        Assert.assertEquals((long)132102L, (long)result);
    }

    @Test
    public void testGetInt_pos0() throws CTFException {
        this.fixture.position(0L);
        int result = this.fixture.getInt();
        Assert.assertEquals((long)66051L, (long)result);
    }

    @Test
    public void testGetInt_pos1() throws CTFException {
        this.fixture.position(1L);
        long result = this.fixture.get(1, true);
        Assert.assertEquals((long)0L, (long)result);
    }

    @Test
    public void testGetInt_pos2() throws CTFException {
        this.fixture.position(2L);
        long result = this.fixture.get(0, true);
        Assert.assertEquals((long)0L, (long)result);
    }

    @Test
    public void testGetInt_le2() throws CTFException {
        BitBuffer leFixture = BitBufferIntTest.createBuffer(128);
        leFixture.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        leFixture.position(0L);
        long result = leFixture.get(24, false);
        Assert.assertEquals((long)131328L, (long)result);
    }

    @Test
    public void testGetInt_le1() throws CTFException {
        BitBuffer leFixture = BitBufferIntTest.createBuffer(128);
        leFixture.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        leFixture.position(1L);
        long result = leFixture.get(24, false);
        Assert.assertEquals((long)0x810080L, (long)result);
    }

    @Test(expected=CTFException.class)
    public void testGetInt_invalid() throws CTFException {
        BitBuffer smallFixture = BitBufferIntTest.createBuffer(2);
        smallFixture.setByteOrder(ByteOrder.BIG_ENDIAN);
        smallFixture.position(10L);
        smallFixture.get(32, true);
    }

    @Test(expected=CTFException.class)
    public void testGetInt_invalid2() throws CTFException {
        BitBuffer smallFixture = BitBufferIntTest.createBuffer(2);
        smallFixture.setByteOrder(ByteOrder.BIG_ENDIAN);
        smallFixture.position(1L);
        smallFixture.get(64, true);
    }

    @Test
    public void testGetLong_pos0() throws CTFException {
        this.fixture.position(0L);
        long result = this.fixture.getLong();
        Assert.assertEquals((long)283686952306183L, (long)result);
    }

    @Test
    public void testGetLong_pos7() throws CTFException {
        this.fixture.position(7L);
        long result = this.fixture.getLong();
        Assert.assertEquals((long)36311929895191428L, (long)result);
    }

    @Test
    public void testGetLong_pos8() throws CTFException {
        this.fixture.position(8L);
        long result = this.fixture.getLong();
        Assert.assertEquals((long)72623859790382856L, (long)result);
    }

    @Test
    public void testGetLong_pos0LE() throws CTFException {
        this.fixture.position(0L);
        this.fixture.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        long result = this.fixture.getLong();
        Assert.assertEquals((long)506097522914230528L, (long)result);
    }

    @Test
    public void testGetLong_pos7LE() throws CTFException {
        this.fixture.position(7L);
        this.fixture.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        long result = this.fixture.getLong();
        Assert.assertEquals((long)1156875391504614402L, (long)result);
    }

    @Test
    public void testGetLong_pos8LE() throws CTFException {
        this.fixture.position(8L);
        this.fixture.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        long result = this.fixture.getLong();
        Assert.assertEquals((long)578437695752307201L, (long)result);
    }

    @Test
    public void testGet35_pos0BE() throws CTFException {
        this.fixture.position(0L);
        long result = this.fixture.get(35, false);
        Assert.assertEquals((long)528408L, (long)result);
    }

    @Test
    public void testGet35_pos8BE() throws CTFException {
        this.fixture.position(8L);
        long result = this.fixture.get(35, false);
        Assert.assertEquals((long)135272480L, (long)result);
    }

    @Test
    public void testGet35_pos0LE() throws CTFException {
        this.fixture.position(0L);
        this.fixture.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        long result = this.fixture.get(35, false);
        Assert.assertEquals((long)17230332160L, (long)result);
    }

    @Test
    public void testGetLong35_pos7LE() throws CTFException {
        this.fixture.position(7L);
        this.fixture.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        long result = this.fixture.get(35, false);
        Assert.assertEquals((long)8724546562L, (long)result);
    }

    @Test
    public void testGetLong35_pos8LE() throws CTFException {
        this.fixture.position(8L);
        this.fixture.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        long result = this.fixture.get(35, false);
        Assert.assertEquals((long)21542142465L, (long)result);
    }

    @Test
    public void testGetLong35s_pos0LE() throws CTFException {
        this.fixture.position(0L);
        this.fixture.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        long result = this.fixture.get(35, true);
        Assert.assertEquals((long)-17129406208L, (long)result);
    }

    @Test
    public void testGetLong35s_pos7LE() throws CTFException {
        this.fixture.position(7L);
        this.fixture.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        long result = this.fixture.get(35, true);
        Assert.assertEquals((long)8724546562L, (long)result);
    }

    @Test
    public void testGetLong35s_pos8LE() throws CTFException {
        this.fixture.position(8L);
        this.fixture.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        long result = this.fixture.get(35, true);
        Assert.assertEquals((long)-12817595903L, (long)result);
    }

    @Test
    public void testGetSigned() throws CTFException {
        this.fixture.position(0L);
        this.fixture.putInt(-1);
        this.fixture.putInt(-1);
        this.fixture.position(0L);
        this.fixture.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        long result = this.fixture.get(32, true);
        Assert.assertEquals((long)-1L, (long)result);
    }

    @Test
    public void testGetUnsigned() throws CTFException {
        this.fixture.position(0L);
        this.fixture.putInt(-1);
        this.fixture.putInt(-1);
        this.fixture.position(0L);
        this.fixture.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        long result = this.fixture.get(32, false);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)result);
    }

    @Test
    public void testGet24Signed() throws CTFException {
        this.fixture.position(0L);
        this.fixture.putInt(-1);
        this.fixture.putInt(-1);
        this.fixture.position(0L);
        this.fixture.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        long result = this.fixture.get(24, true);
        Assert.assertEquals((long)-1L, (long)result);
    }

    @Test
    public void testGet24Unsigned() throws CTFException {
        this.fixture.position(0L);
        this.fixture.putInt(-1);
        this.fixture.putInt(-1);
        this.fixture.position(0L);
        this.fixture.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        long result = this.fixture.get(24, false);
        Assert.assertEquals((long)0xFFFFFFL, (long)result);
    }

    @Test
    public void testPutInt() throws CTFException {
        this.fixture.position(1L);
        this.fixture.putInt(1);
    }

    @Test
    public void testPutInt_length1() throws CTFException {
        this.fixture.position(1L);
        this.fixture.putInt(1, 1);
    }

    @Test
    public void testPutInt_length0() throws CTFException {
        this.fixture.position(1L);
        this.fixture.putInt(0, 1);
    }

    @Test
    public void testPutIntLe() throws CTFException {
        this.fixture.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.fixture.position(1L);
        this.fixture.putInt(1);
    }

    @Test
    public void testPutIntLe_length1() throws CTFException {
        this.fixture.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.fixture.position(1L);
        this.fixture.putInt(1, 1);
    }

    @Test
    public void testPutIntLe_length0() throws CTFException {
        this.fixture.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.fixture.position(1L);
        this.fixture.putInt(0, 1);
    }

    @Test
    public void testPutInt_hex() throws CTFException {
        int value = 66051;
        int i = 0;
        while (i <= 32) {
            this.fixture.position((long)i);
            this.fixture.putInt(66051);
            this.fixture.position((long)i);
            int read = this.fixture.getInt();
            Assert.assertEquals((long)66051L, (long)read);
            ++i;
        }
    }

    @Test(expected=CTFException.class)
    public void testPutInt_invalid() throws CTFException {
        BitBuffer fixture2 = BitBufferIntTest.createBuffer(4);
        fixture2.setByteOrder(ByteOrder.BIG_ENDIAN);
        fixture2.position(1L);
        fixture2.putInt(32, 1);
    }
}

