/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.trace;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfTestTrace;
import org.eclipse.tracecompass.ctf.core.trace.CTFStream;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamInput;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class CTFStreamInputTest {
    private static final CtfTestTrace testTrace = CtfTestTrace.KERNEL;
    private CTFStreamInput fixture;
    CTFStreamInput s1;
    CTFStreamInput s2;

    @Before
    public void setUp() throws CTFException {
        Assume.assumeTrue((boolean)testTrace.exists());
        this.fixture = new CTFStreamInput(new CTFStream(testTrace.getTrace()), CTFStreamInputTest.createFile());
        this.fixture.setTimestampEnd(1L);
    }

    @NonNull
    private static File createFile() {
        File path = new File(testTrace.getPath());
        File[] listFiles = path.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains("hann");
            }
        });
        Assert.assertNotNull((Object)listFiles);
        File returnFile = listFiles[0];
        Assert.assertNotNull((Object)returnFile);
        return returnFile;
    }

    @Test
    public void testStreamInput() {
        Assert.assertNotNull((Object)this.fixture);
    }

    @Test
    public void testGetFilename() {
        String result = this.fixture.getFilename();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetPath() {
        String result = this.fixture.getScopePath().getPath();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetStream() {
        CTFStream result = this.fixture.getStream();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetTimestampEnd() {
        long result = this.fixture.getTimestampEnd();
        Assert.assertTrue((0L < result ? 1 : 0) != 0);
    }

    @Test
    public void testLookupDefinition() {
        Definition result = this.fixture.lookupDefinition("id");
        Assert.assertNull((Object)result);
    }

    @Test
    public void testSetTimestampEnd() {
        this.fixture.setTimestampEnd(1L);
        Assert.assertEquals((long)this.fixture.getTimestampEnd(), (long)1L);
    }

    @Test
    public void testEquals1() throws CTFException {
        this.s1 = new CTFStreamInput(new CTFStream(testTrace.getTrace()), CTFStreamInputTest.createFile());
        Assert.assertFalse((boolean)this.s1.equals(null));
    }

    @Test
    public void testEquals2() throws CTFException {
        this.s1 = new CTFStreamInput(new CTFStream(testTrace.getTrace()), CTFStreamInputTest.createFile());
        Assert.assertFalse((boolean)this.s1.equals((Object)new Long(23L)));
    }

    @Test
    public void testEquals3() throws CTFException {
        this.s1 = new CTFStreamInput(new CTFStream(testTrace.getTrace()), CTFStreamInputTest.createFile());
        Assert.assertEquals((Object)this.s1, (Object)this.s1);
    }

    @Test
    public void testEquals4() throws CTFException {
        this.s1 = new CTFStreamInput(new CTFStream(testTrace.getTrace()), CTFStreamInputTest.createFile());
        this.s2 = new CTFStreamInput(new CTFStream(testTrace.getTrace()), CTFStreamInputTest.createFile());
        Assert.assertEquals((Object)this.s1, (Object)this.s2);
    }
}

