/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ByteArrayDefinition;
import org.eclipse.tracecompass.internal.ctf.core.event.types.SequenceDeclaration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SequenceDefinition2Test {
    private ByteArrayDefinition fixture;
    private static final int seqLen = 15;

    @Before
    public void setUp() throws CTFException {
        this.fixture = SequenceDefinition2Test.initString();
    }

    private static ByteArrayDefinition initString() throws CTFException {
        int len = 8;
        IntegerDeclaration id = IntegerDeclaration.createDeclaration((int)len, (boolean)false, (int)len, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (Encoding)Encoding.UTF8, (String)"", (long)8L);
        String lengthName = "LengthName";
        StructDeclaration structDec = new StructDeclaration(0L);
        structDec.addField(lengthName, (IDeclaration)id);
        StructDefinition structDef = new StructDefinition(structDec, null, "x", new Definition[]{new IntegerDefinition(id, null, lengthName, 15L)});
        SequenceDeclaration sd = new SequenceDeclaration(lengthName, (IDeclaration)id);
        ByteBuffer allocateDirect = ByteBuffer.allocateDirect(15 * len);
        if (allocateDirect == null) {
            throw new IllegalStateException("Failed to allocate memory");
        }
        BitBuffer input = new BitBuffer(allocateDirect);
        int i = 0;
        while (i < 15) {
            input.putInt(i);
            ++i;
        }
        ByteArrayDefinition ret = (ByteArrayDefinition)sd.createDefinition((IDefinitionScope)structDef, "TestX", input);
        Assert.assertNotNull((Object)ret);
        return ret;
    }

    @Test
    public void testFixedStringDefinition() {
        Assert.assertNotNull((Object)this.fixture);
    }

    @Test
    public void testGetDeclaration() {
        SequenceDeclaration result = (SequenceDeclaration)this.fixture.getDeclaration();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetElem() {
        int i = 1;
        IDefinition result = (IDefinition)this.fixture.getDefinitions().get(i);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testToString() {
        String result = this.fixture.toString();
        Assert.assertNotNull((Object)result);
    }
}

