/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import java.nio.ByteBuffer;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.StringDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StringDefinition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringDeclarationTest {
    private StringDeclaration fixture;

    @Before
    public void setUp() {
        this.fixture = StringDeclaration.getStringDeclaration((Encoding)Encoding.ASCII);
    }

    @Test
    public void testStringDeclaration() {
        StringDeclaration result = StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8);
        Assert.assertNotNull((Object)result);
        String string = "[declaration] string[";
        Assert.assertEquals((Object)string, (Object)result.toString().substring(0, string.length()));
    }

    @Test
    public void testStringDeclaration_2() {
        Encoding encoding = Encoding.ASCII;
        StringDeclaration result = StringDeclaration.getStringDeclaration((Encoding)encoding);
        Assert.assertNotNull((Object)result);
        String string = "[declaration] string[";
        Assert.assertEquals((Object)string, (Object)result.toString().substring(0, string.length()));
    }

    @Test
    public void testCreateDefinition() throws CTFException {
        IDefinitionScope definitionScope = null;
        String fieldName = "id";
        ByteBuffer allocate = ByteBuffer.allocate(100);
        if (allocate == null) {
            throw new IllegalStateException("Failed to allocate memory");
        }
        BitBuffer bb = new BitBuffer(allocate);
        StringDefinition result = this.fixture.createDefinition(definitionScope, fieldName, bb);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetEncoding() {
        Encoding result = this.fixture.getEncoding();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"ASCII", (Object)result.name());
        Assert.assertEquals((Object)"ASCII", (Object)result.toString());
        Assert.assertEquals((long)1L, (long)result.ordinal());
    }

    @Test
    public void testToString() {
        String result = this.fixture.toString();
        String left = "[declaration] string[";
        String right = result.substring(0, left.length());
        Assert.assertEquals((Object)left, (Object)right);
    }

    @Test
    public void hashcodeTest() {
        Assert.assertEquals((long)32L, (long)this.fixture.hashCode());
        StringDeclaration a = StringDeclaration.getStringDeclaration((Encoding)Encoding.ASCII);
        StringDeclaration b = StringDeclaration.getStringDeclaration();
        StringDeclaration c = StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8);
        StringDeclaration d = StringDeclaration.getStringDeclaration((Encoding)Encoding.ASCII);
        Assert.assertEquals((long)b.hashCode(), (long)c.hashCode());
        Assert.assertEquals((long)a.hashCode(), (long)d.hashCode());
        Assert.assertEquals((long)a.hashCode(), (long)a.hashCode());
    }

    @Test
    public void equalsTest() {
        StringDeclaration a = StringDeclaration.getStringDeclaration((Encoding)Encoding.ASCII);
        StringDeclaration b = StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8);
        StringDeclaration c = StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8);
        StringDeclaration d = StringDeclaration.getStringDeclaration((Encoding)Encoding.ASCII);
        Assert.assertNotEquals((Object)a, null);
        Assert.assertNotEquals((Object)a, (Object)new Object());
        Assert.assertNotEquals((Object)a, (Object)b);
        Assert.assertNotEquals((Object)a, (Object)c);
        Assert.assertEquals((Object)a, (Object)d);
        Assert.assertNotEquals((Object)b, (Object)a);
        Assert.assertNotEquals((Object)c, (Object)a);
        Assert.assertEquals((Object)d, (Object)a);
        Assert.assertEquals((Object)a, (Object)a);
    }
}

