/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import java.nio.ByteBuffer;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.StringDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StringDefinition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringDefinitionTest {
    private StringDefinition fixture;
    private String testString;

    @Before
    public void setUp() throws CTFException {
        String name = "testString";
        StringDeclaration stringDec = StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8);
        ByteBuffer byteBuffer = ByteBuffer.allocate(100);
        if (byteBuffer == null) {
            throw new IllegalStateException("Failed to allocate memory");
        }
        BitBuffer bb = new BitBuffer(byteBuffer);
        byteBuffer.mark();
        this.testString = new String("testString");
        byteBuffer.put(this.testString.getBytes());
        byteBuffer.reset();
        this.fixture = stringDec.createDefinition(null, name, bb);
    }

    @Test
    public void testStringDefinition() {
        StringDeclaration declaration = StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8);
        IDefinitionScope definitionScope = null;
        String fieldName = "";
        StringDefinition result = new StringDefinition(declaration, definitionScope, fieldName, "");
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetDeclaration() {
        StringDeclaration result = this.fixture.getDeclaration();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetValue() {
        String result = this.fixture.getValue();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testSetValue() {
        String result = this.fixture.getValue();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"testString", (Object)result);
    }

    @Test
    public void testToString() {
        String result = this.fixture.toString();
        Assert.assertNotNull((Object)result);
    }
}

