/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import java.nio.ByteBuffer;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StringDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StructDeclarationTest {
    private StructDeclaration fixture;

    @Before
    public void setUp() {
        this.fixture = new StructDeclaration(1L);
    }

    @Test
    public void testStructDeclaration() {
        Assert.assertNotNull((Object)this.fixture);
        Assert.assertEquals((long)1L, (long)this.fixture.getMaxAlign());
        String regex = "^\\[declaration\\] struct\\[*.\\]$";
        Assert.assertTrue((boolean)this.fixture.toString().matches(regex));
    }

    @Test
    public void testAddField() {
        String name = "";
        StringDeclaration declaration = StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8);
        this.fixture.addField(name, (IDeclaration)declaration);
    }

    @Test
    public void testCreateDefinition() throws CTFException {
        String fieldName = "";
        ByteBuffer allocate = ByteBuffer.allocate(100);
        if (allocate == null) {
            throw new IllegalStateException("Failed to allocate memory");
        }
        BitBuffer bb = new BitBuffer(allocate);
        StructDefinition result = this.fixture.createDefinition(null, fieldName, bb);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetField() {
        IDeclaration result = this.fixture.getField("test");
        Assert.assertNull((Object)result);
    }

    @Test
    public void testGetFieldsList() {
        Iterable result = this.fixture.getFieldsList();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)false, (Object)result.iterator().hasNext());
    }

    @Test
    public void testGetMinAlign() {
        long result = this.fixture.getMaxAlign();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testHasField() {
        String name = "";
        boolean result = this.fixture.hasField(name);
        Assert.assertEquals((Object)false, (Object)result);
    }

    @Test
    public void testToString() {
        String result = this.fixture.toString();
        String trunc = result.substring(0, 21);
        Assert.assertEquals((Object)"[declaration] struct[", (Object)trunc);
    }

    @Test
    public void hashcodeTest() {
        Assert.assertEquals((long)32L, (long)this.fixture.hashCode());
        StructDeclaration a = new StructDeclaration(8L);
        this.fixture.addField("hello", (IDeclaration)a);
        a.addField("Time", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        StructDeclaration b = new StructDeclaration(8L);
        StructDeclaration c = new StructDeclaration(8L);
        b.addField("hello", (IDeclaration)c);
        c.addField("Time", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        Assert.assertEquals((long)b.hashCode(), (long)this.fixture.hashCode());
        c.addField("Space", (IDeclaration)IntegerDeclaration.INT_32L_DECL);
        Assert.assertNotEquals((long)b.hashCode(), (long)this.fixture.hashCode());
    }

    @Test
    public void equalsTest() {
        StructDeclaration a = new StructDeclaration(8L);
        StructDeclaration b = new StructDeclaration(16L);
        StructDeclaration c = new StructDeclaration(8L);
        StructDeclaration d = new StructDeclaration(8L);
        StructDeclaration e = new StructDeclaration(8L);
        StructDeclaration f = new StructDeclaration(8L);
        c.addField("hi", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        Assert.assertNotEquals((Object)a, null);
        Assert.assertNotEquals((Object)a, (Object)new Object());
        Assert.assertNotEquals((Object)a, (Object)b);
        Assert.assertNotEquals((Object)a, (Object)c);
        Assert.assertEquals((Object)a, (Object)d);
        Assert.assertNotEquals((Object)b, (Object)a);
        Assert.assertNotEquals((Object)c, (Object)a);
        Assert.assertEquals((Object)d, (Object)a);
        Assert.assertEquals((Object)a, (Object)a);
        a.addField("hi", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        f.addField("hi", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        e.addField("hello", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        Assert.assertEquals((Object)a, (Object)c);
        Assert.assertEquals((Object)c, (Object)a);
        Assert.assertNotEquals((Object)a, (Object)d);
        d.addField("hi", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        Assert.assertNotEquals((Object)a, (Object)d);
        a.addField("hello", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        e.addField("hi", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        f.addField("hello", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        Assert.assertNotEquals((Object)a, (Object)e);
        Assert.assertNotEquals((Object)a, (Object)f);
    }
}

