/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.types;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.AbstractArrayDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.CompoundDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;

@NonNullByDefault
public final class ArrayDefinition
extends AbstractArrayDefinition {
    private final List<Definition> fDefinitions;

    public ArrayDefinition(CompoundDeclaration declaration, @Nullable IDefinitionScope definitionScope, String fieldName, List<Definition> definitions) {
        super(declaration, definitionScope, fieldName);
        this.fDefinitions = (List)NonNullUtils.checkNotNull((Object)ImmutableList.copyOf(definitions));
    }

    @Override
    public List<Definition> getDefinitions() {
        return this.fDefinitions;
    }

    @Override
    public int getLength() {
        return this.fDefinitions.size();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('[');
        Joiner joiner = Joiner.on((String)", ").skipNulls();
        b.append(joiner.join(this.fDefinitions));
        b.append(']');
        return (String)NonNullUtils.checkNotNull((Object)b.toString());
    }
}

