/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.trace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.trace.ICTFPacketDescriptor;

public class StreamInputPacketIndex {
    private final List<ICTFPacketDescriptor> fEntries = new ArrayList<ICTFPacketDescriptor>();

    public int size() {
        return this.fEntries.size();
    }

    public boolean isEmpty() {
        return this.fEntries.isEmpty();
    }

    public void appendAll(Collection<ICTFPacketDescriptor> preParsedIndex) throws CTFException {
        for (ICTFPacketDescriptor sipie : preParsedIndex) {
            this.append((ICTFPacketDescriptor)NonNullUtils.checkNotNull((Object)sipie));
        }
    }

    public boolean append(@NonNull ICTFPacketDescriptor entry) throws CTFException {
        if (entry.getTimestampBegin() > entry.getTimestampEnd()) {
            throw new CTFException("Packet begin timestamp is after end timestamp");
        }
        if (!this.fEntries.isEmpty() && entry.getTimestampBegin() < this.lastElement().getTimestampBegin()) {
            throw new CTFException("Packets begin timestamp decreasing");
        }
        this.fEntries.add(entry);
        return true;
    }

    public ListIterator<ICTFPacketDescriptor> search(long timestamp) {
        int guessI;
        int max = this.fEntries.size() - 1;
        int min = 0;
        ICTFPacketDescriptor guessEntry = null;
        if (this.isEmpty()) {
            return this.fEntries.listIterator();
        }
        if (timestamp < 0L) {
            throw new IllegalArgumentException("timestamp is negative");
        }
        while (true) {
            guessI = min + (max - min) / 2;
            guessEntry = this.fEntries.get(guessI);
            if (min == max) break;
            if (timestamp <= guessEntry.getTimestampEnd()) {
                max = guessI;
                continue;
            }
            min = guessI + 1;
        }
        return this.fEntries.listIterator(guessI);
    }

    public ICTFPacketDescriptor lastElement() {
        return this.fEntries.get(this.fEntries.size() - 1);
    }

    public ICTFPacketDescriptor getElement(int index) {
        return this.fEntries.get(index);
    }

    public int indexOf(ICTFPacketDescriptor element) {
        int indexOf = -1;
        if (element != null) {
            indexOf = Collections.binarySearch(this.fEntries, element, new MonotonicComparator());
        }
        return indexOf < 0 ? -1 : indexOf;
    }

    private static class MonotonicComparator
    implements Comparator<ICTFPacketDescriptor>,
    Serializable {
        private static final long serialVersionUID = -5693064068367242076L;

        private MonotonicComparator() {
        }

        @Override
        public int compare(ICTFPacketDescriptor left, ICTFPacketDescriptor right) {
            if (left.getTimestampBegin() > right.getTimestampBegin()) {
                return 1;
            }
            if (left.getTimestampBegin() < right.getTimestampBegin()) {
                return -1;
            }
            if (left.getTimestampEnd() > right.getTimestampEnd()) {
                return 1;
            }
            if (left.getTimestampEnd() < right.getTimestampEnd()) {
                return -1;
            }
            return 0;
        }
    }
}

