/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.core.tests.model.impl;

import java.util.LinkedList;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceChannelOutputType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.BufferType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.ChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.EventInfo;
import org.eclipse.tracecompass.lttng2.control.core.tests.model.impl.ModelImplFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChannelInfoTest {
    private IChannelInfo fChannelInfo1 = null;
    private IChannelInfo fChannelInfo2 = null;

    @Before
    public void setUp() {
        ModelImplFactory factory = new ModelImplFactory();
        this.fChannelInfo1 = factory.getChannel1();
        this.fChannelInfo2 = factory.getChannel2();
    }

    @Test
    public void testChannelInfo() {
        ChannelInfo result = new ChannelInfo("test");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"test", (Object)result.getName());
        Assert.assertEquals((long)0L, (long)result.getNumberOfSubBuffers());
        Assert.assertEquals((Object)"unknown", (Object)result.getOutputType().getInName());
        Assert.assertEquals((Object)TraceChannelOutputType.UNKNOWN, (Object)result.getOutputType());
        Assert.assertEquals((Object)false, (Object)result.isOverwriteMode());
        Assert.assertEquals((long)0L, (long)result.getReadTimer());
        Assert.assertEquals((Object)"disabled", (Object)result.getState().getInName());
        Assert.assertEquals((long)0L, (long)result.getSubBufferSize());
        Assert.assertEquals((long)0L, (long)result.getSwitchTimer());
        Assert.assertEquals((long)0L, (long)result.getMaxSizeTraceFiles());
        Assert.assertEquals((long)0L, (long)result.getMaxNumberTraceFiles());
        Assert.assertEquals((Object)BufferType.BUFFER_TYPE_UNKNOWN, (Object)result.getBufferType());
    }

    @Test
    public void testChannelInfoCopy() {
        ChannelInfo channelInfo = new ChannelInfo((ChannelInfo)this.fChannelInfo1);
        Assert.assertEquals((Object)this.fChannelInfo1.getName(), (Object)channelInfo.getName());
        Assert.assertEquals((long)this.fChannelInfo1.getNumberOfSubBuffers(), (long)channelInfo.getNumberOfSubBuffers());
        Assert.assertEquals((Object)this.fChannelInfo1.getOutputType(), (Object)channelInfo.getOutputType());
        Assert.assertEquals((Object)this.fChannelInfo1.isOverwriteMode(), (Object)channelInfo.isOverwriteMode());
        Assert.assertEquals((long)this.fChannelInfo1.getReadTimer(), (long)channelInfo.getReadTimer());
        Assert.assertEquals((Object)this.fChannelInfo1.getState(), (Object)channelInfo.getState());
        Assert.assertEquals((long)this.fChannelInfo1.getSwitchTimer(), (long)channelInfo.getSwitchTimer());
        Assert.assertEquals((long)this.fChannelInfo1.getEvents().length, (long)channelInfo.getEvents().length);
        Assert.assertEquals((long)this.fChannelInfo1.getMaxSizeTraceFiles(), (long)channelInfo.getMaxSizeTraceFiles());
        Assert.assertEquals((long)this.fChannelInfo1.getMaxNumberTraceFiles(), (long)channelInfo.getMaxNumberTraceFiles());
        Assert.assertEquals((Object)this.fChannelInfo1.getBufferType(), (Object)channelInfo.getBufferType());
        IEventInfo[] orignalEvents = this.fChannelInfo1.getEvents();
        IEventInfo[] resultEvents = channelInfo.getEvents();
        int i = 0;
        while (i < orignalEvents.length) {
            Assert.assertEquals((Object)orignalEvents[i], (Object)resultEvents[i]);
            ++i;
        }
    }

    @Test
    public void testChannelCopy2() {
        try {
            ChannelInfo channel = null;
            new ChannelInfo(channel);
            Assert.fail((String)"null copy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddAndGetEvents_1() {
        ChannelInfo fixture = new ChannelInfo("test");
        fixture.setSwitchTimer(1L);
        fixture.setOverwriteMode(true);
        fixture.setReadTimer(1L);
        fixture.setState(TraceEnablement.DISABLED);
        fixture.setNumberOfSubBuffers(1);
        fixture.setOutputType("");
        fixture.setSubBufferSize(1L);
        EventInfo event = new EventInfo("event");
        fixture.addEvent((IEventInfo)event);
        IEventInfo[] result = fixture.getEvents();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.length);
        Assert.assertNotNull((Object)result[0]);
        Assert.assertTrue((boolean)event.equals(result[0]));
    }

    @Test
    public void testGetAndSetters() {
        ChannelInfo fixture = new ChannelInfo("test");
        fixture.setSwitchTimer(2L);
        fixture.setOverwriteMode(true);
        fixture.setReadTimer(3L);
        fixture.setState(TraceEnablement.DISABLED);
        fixture.setNumberOfSubBuffers(4);
        fixture.setOutputType("splice()");
        fixture.setSubBufferSize(1L);
        fixture.setMaxSizeTraceFiles(1024L);
        fixture.setMaxNumberTraceFiles(20);
        fixture.setBufferType(BufferType.BUFFER_PER_UID);
        fixture.addEvent((IEventInfo)new EventInfo("event"));
        long switchTimer = fixture.getSwitchTimer();
        Assert.assertEquals((long)2L, (long)switchTimer);
        boolean mode = fixture.isOverwriteMode();
        Assert.assertTrue((boolean)mode);
        long readTimer = fixture.getReadTimer();
        Assert.assertEquals((long)3L, (long)readTimer);
        TraceEnablement state = fixture.getState();
        Assert.assertEquals((Object)"disabled", (Object)state.getInName());
        long numSubBuffers = fixture.getNumberOfSubBuffers();
        Assert.assertEquals((long)4L, (long)numSubBuffers);
        String outputType = fixture.getOutputType().getInName();
        Assert.assertEquals((Object)"splice()", (Object)outputType);
        long subBufferSize = fixture.getSubBufferSize();
        Assert.assertEquals((long)1L, (long)subBufferSize);
        long maxSizeTraceFiles = fixture.getMaxSizeTraceFiles();
        Assert.assertEquals((long)1024L, (long)maxSizeTraceFiles);
        int maxNumberTraceFiles = fixture.getMaxNumberTraceFiles();
        Assert.assertEquals((long)20L, (long)maxNumberTraceFiles);
        BufferType bufferType = fixture.getBufferType();
        Assert.assertTrue((bufferType == BufferType.BUFFER_PER_UID ? 1 : 0) != 0);
        fixture.setSwitchTimer(5L);
        fixture.setOverwriteMode(false);
        fixture.setReadTimer(6L);
        fixture.setState(TraceEnablement.ENABLED);
        fixture.setNumberOfSubBuffers(7);
        fixture.setOutputType("mmap()");
        fixture.setSubBufferSize(8L);
        fixture.setMaxSizeTraceFiles(4096L);
        fixture.setMaxNumberTraceFiles(10);
        fixture.setBufferType(BufferType.BUFFER_PER_PID);
        switchTimer = fixture.getSwitchTimer();
        Assert.assertEquals((long)5L, (long)switchTimer);
        mode = fixture.isOverwriteMode();
        Assert.assertFalse((boolean)mode);
        readTimer = fixture.getReadTimer();
        Assert.assertEquals((long)6L, (long)readTimer);
        state = fixture.getState();
        Assert.assertEquals((Object)"enabled", (Object)state.getInName());
        numSubBuffers = fixture.getNumberOfSubBuffers();
        Assert.assertEquals((long)7L, (long)numSubBuffers);
        outputType = fixture.getOutputType().getInName();
        Assert.assertEquals((Object)"mmap()", (Object)outputType);
        subBufferSize = fixture.getSubBufferSize();
        Assert.assertEquals((long)8L, (long)subBufferSize);
        maxSizeTraceFiles = fixture.getMaxSizeTraceFiles();
        Assert.assertEquals((long)4096L, (long)maxSizeTraceFiles);
        maxNumberTraceFiles = fixture.getMaxNumberTraceFiles();
        Assert.assertEquals((long)10L, (long)maxNumberTraceFiles);
        bufferType = fixture.getBufferType();
        Assert.assertTrue((bufferType == BufferType.BUFFER_PER_PID ? 1 : 0) != 0);
    }

    @Test
    public void testSetEvents_1() {
        ChannelInfo fixture = new ChannelInfo("test");
        fixture.setSwitchTimer(1L);
        fixture.setOverwriteMode(true);
        fixture.setReadTimer(1L);
        fixture.setState(TraceEnablement.DISABLED);
        fixture.setNumberOfSubBuffers(1);
        fixture.setOutputType("");
        fixture.setSubBufferSize(1L);
        LinkedList<EventInfo> events = new LinkedList<EventInfo>();
        int i = 0;
        while (i < 2) {
            EventInfo info = new EventInfo("event" + i);
            info.setEventType("tracepoint");
            info.setState(i % 2 == 0 ? "enabled" : "disabled");
            events.add(info);
            ++i;
        }
        fixture.setEvents(events);
        IEventInfo[] infos = fixture.getEvents();
        Assert.assertEquals((long)events.size(), (long)infos.length);
        int i2 = 0;
        while (i2 < infos.length) {
            Assert.assertEquals(events.get(i2), (Object)infos[i2]);
            ++i2;
        }
    }

    @Test
    public void testToString_1() {
        ChannelInfo fixture = new ChannelInfo("channel");
        fixture.setSwitchTimer(1L);
        fixture.setOverwriteMode(true);
        fixture.setReadTimer(1L);
        fixture.setState(TraceEnablement.DISABLED);
        fixture.setNumberOfSubBuffers(1);
        fixture.setOutputType("splice()");
        fixture.setSubBufferSize(1L);
        String result = fixture.toString();
        Assert.assertEquals((Object)"[ChannelInfo([TraceInfo(Name=channel)],State=DISABLED,OverwriteMode=true,SubBuffersSize=1,NumberOfSubBuffers=1,SwitchTimer=1,ReadTimer=1,output=splice(),Events=None)]", (Object)result);
    }

    @Test
    public void testToString_2() {
        String result = this.fChannelInfo1.toString();
        Assert.assertEquals((Object)"[ChannelInfo([TraceInfo(Name=channel1)],State=DISABLED,OverwriteMode=true,SubBuffersSize=13,NumberOfSubBuffers=12,SwitchTimer=10,ReadTimer=11,output=splice(),Events=[EventInfo([BaseEventInfo([TraceInfo(Name=event1)],type=TRACEPOINT,level=TRACE_DEBUG)],State=ENABLED,levelType=LOGLEVEL_ONLY)])]", (Object)result);
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.fChannelInfo1.equals(this.fChannelInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fChannelInfo2.equals(this.fChannelInfo2));
        Assert.assertTrue((String)"equals", (!this.fChannelInfo1.equals(this.fChannelInfo2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fChannelInfo2.equals(this.fChannelInfo1) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        ChannelInfo event1 = new ChannelInfo((ChannelInfo)this.fChannelInfo1);
        ChannelInfo event2 = new ChannelInfo((ChannelInfo)this.fChannelInfo2);
        Assert.assertTrue((String)"equals", (boolean)event1.equals((Object)this.fChannelInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fChannelInfo1.equals(event1));
        Assert.assertTrue((String)"equals", (boolean)event2.equals((Object)this.fChannelInfo2));
        Assert.assertTrue((String)"equals", (boolean)this.fChannelInfo2.equals(event2));
    }

    @Test
    public void testEqualsTransivity() {
        ChannelInfo channel1 = new ChannelInfo((ChannelInfo)this.fChannelInfo1);
        ChannelInfo channel2 = new ChannelInfo((ChannelInfo)this.fChannelInfo1);
        ChannelInfo channel3 = new ChannelInfo((ChannelInfo)this.fChannelInfo1);
        Assert.assertTrue((String)"equals", (boolean)channel1.equals((Object)channel2));
        Assert.assertTrue((String)"equals", (boolean)channel2.equals((Object)channel3));
        Assert.assertTrue((String)"equals", (boolean)channel1.equals((Object)channel3));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertTrue((String)"equals", (!this.fChannelInfo1.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fChannelInfo2.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testHashCode() {
        ChannelInfo channel1 = new ChannelInfo((ChannelInfo)this.fChannelInfo1);
        ChannelInfo channel2 = new ChannelInfo((ChannelInfo)this.fChannelInfo2);
        Assert.assertTrue((String)"hashCode", (this.fChannelInfo1.hashCode() == channel1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fChannelInfo2.hashCode() == channel2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fChannelInfo1.hashCode() != channel2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fChannelInfo2.hashCode() != channel1.hashCode() ? 1 : 0) != 0);
    }
}

