/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.tests.model.component;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TargetNodeState;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.service.TestRemoteSystemProxy;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceProviderGroup;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionGroup;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.UstProviderComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.ILttngControlService;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LTTngControlService;
import org.eclipse.tracecompass.lttng2.control.ui.tests.model.component.TraceControlTestFacility;
import org.eclipse.tracecompass.tmf.remote.core.proxy.RemoteSystemProxy;
import org.eclipse.tracecompass.tmf.remote.core.proxy.TmfRemoteConnectionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TraceControlTreeModelNoProvidersTest {
    private static final String TEST_STREAM = "ListInfoTest.cfg";
    private static final String SCEN_LIST_INFO_TEST = "ListInfoTestNoKernel";
    private static final String TARGET_NODE_NAME = "myNode";
    private IRemoteConnection fHost = TmfRemoteConnectionFactory.getLocalConnection();
    @NonNull
    private TestRemoteSystemProxy fProxy = new TestRemoteSystemProxy(this.fHost);
    private String fTestFile;

    @Before
    public void setUp() throws Exception {
        URL location = FileLocator.find((Bundle)FrameworkUtil.getBundle(this.getClass()), (IPath)new Path("testfiles" + File.separator + TEST_STREAM), null);
        File testfile = new File(FileLocator.toFileURL((URL)location).toURI());
        this.fTestFile = testfile.getAbsolutePath();
    }

    @After
    public void tearDown() {
        TraceControlTestFacility.getInstance().waitForJobs();
    }

    @Test
    public void testTraceControlComponents() {
        this.fProxy.setTestFile(this.fTestFile);
        this.fProxy.setScenario(SCEN_LIST_INFO_TEST);
        ITraceControlComponent root = TraceControlTestFacility.getInstance().getControlView().getTraceControlRoot();
        TargetNodeComponent node = new TargetNodeComponent(TARGET_NODE_NAME, root, (RemoteSystemProxy)this.fProxy);
        root.addChild((ITraceControlComponent)node);
        node.connect();
        TraceControlTestFacility.getInstance().waitForConnect(node);
        TraceControlTestFacility.getInstance().waitForJobs();
        Assert.assertEquals((Object)"Local", (Object)node.getToolTip());
        Image connectedImage = node.getImage();
        Assert.assertNotNull((Object)connectedImage);
        Assert.assertEquals((Object)TargetNodeState.CONNECTED, (Object)node.getTargetNodeState());
        Assert.assertNotNull((Object)node.getControlService());
        ILttngControlService service = node.getControlService();
        Assert.assertTrue((boolean)(service instanceof LTTngControlService));
        node.setControlService(service);
        Assert.assertTrue((boolean)(node.getControlService() instanceof LTTngControlService));
        ITraceControlComponent[] groups = node.getChildren();
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)2L, (long)groups.length);
        Assert.assertTrue((boolean)(groups[0] instanceof TraceProviderGroup));
        Assert.assertTrue((boolean)(groups[1] instanceof TraceSessionGroup));
        TraceProviderGroup providerGroup = (TraceProviderGroup)groups[0];
        Assert.assertFalse((boolean)providerGroup.hasKernelProvider());
        Assert.assertEquals((Object)"Provider", (Object)providerGroup.getName());
        Assert.assertEquals((Object)"Sessions", (Object)groups[1].getName());
        ITraceControlComponent[] providers = groups[0].getChildren();
        Assert.assertNotNull((Object)providers);
        Assert.assertEquals((long)1L, (long)providers.length);
        Assert.assertTrue((boolean)(providers[0] instanceof UstProviderComponent));
        node.disconnect();
        Assert.assertEquals((Object)TargetNodeState.DISCONNECTED, (Object)node.getTargetNodeState());
        Assert.assertNotNull((Object)node.getImage());
        Assert.assertNotSame((Object)connectedImage, (Object)node.getImage());
        node.getParent().removeChild((ITraceControlComponent)node);
    }
}

