/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.tests.model.component;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TargetNodeState;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceChannelOutputType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.BufferType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.ChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.CreateSessionDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.DestroyConfirmDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.EnableChannelDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.EnableEventsDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.GetEventInfoDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.service.TestRemoteSystemProxy;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IConfirmDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.ICreateSessionDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IEnableChannelDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IEnableEventsDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IGetEventInfoDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.TraceControlDialogFactory;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceChannelComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceDomainComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.tracecompass.lttng2.control.ui.tests.model.component.TraceControlTestFacility;
import org.eclipse.tracecompass.tmf.remote.core.proxy.RemoteSystemProxy;
import org.eclipse.tracecompass.tmf.remote.core.proxy.TmfRemoteConnectionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TraceControlUstSessionTests {
    private static final String TEST_STREAM = "CreateTreeTest.cfg";
    private static final String SCEN_SCENARIO4_TEST = "Scenario4";
    private IRemoteConnection fHost = TmfRemoteConnectionFactory.getLocalConnection();
    private TraceControlTestFacility fFacility;
    @NonNull
    private TestRemoteSystemProxy fProxy = new TestRemoteSystemProxy(this.fHost);
    private String fTestFile;

    @Before
    public void setUp() throws Exception {
        this.fFacility = TraceControlTestFacility.getInstance();
        this.fFacility.init();
        URL location = FileLocator.find((Bundle)FrameworkUtil.getBundle(this.getClass()), (IPath)new Path("testfiles" + File.separator + TEST_STREAM), null);
        File testfile = new File(FileLocator.toFileURL((URL)location).toURI());
        this.fTestFile = testfile.getAbsolutePath();
    }

    @After
    public void tearDown() {
        this.fFacility.waitForJobs();
        this.fFacility.dispose();
    }

    @Test
    public void testTraceSessionTree() throws Exception {
        this.fProxy.setTestFile(this.fTestFile);
        this.fProxy.setScenario("Initialize");
        ITraceControlComponent root = this.fFacility.getControlView().getTraceControlRoot();
        TargetNodeComponent node = new TargetNodeComponent("myNode", root, (RemoteSystemProxy)this.fProxy);
        root.addChild((ITraceControlComponent)node);
        this.fFacility.waitForJobs();
        this.fFacility.executeCommand((ITraceControlComponent)node, "connect");
        int i = 0;
        while (i < 10 && node.getTargetNodeState() != TargetNodeState.CONNECTED) {
            ++i;
            this.fFacility.delay(500L);
        }
        ITraceControlComponent[] groups = node.getChildren();
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)2L, (long)groups.length);
        TraceControlDialogFactory.getInstance().setCreateSessionDialog((ICreateSessionDialog)new CreateSessionDialogStub());
        TraceControlDialogFactory.getInstance().setGetEventInfoDialog((IGetEventInfoDialog)new GetEventInfoDialogStub());
        TraceControlDialogFactory.getInstance().setConfirmDialog((IConfirmDialog)new DestroyConfirmDialogStub());
        this.fProxy.setScenario("SessionHandling");
        TraceSessionComponent session = this.fFacility.createSession(groups[1]);
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)"mysession", (Object)session.getName());
        Assert.assertEquals((Object)"/home/user/lttng-traces/mysession-20120314-132824", (Object)session.getSessionPath());
        Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)session.getSessionState());
        this.fProxy.setScenario(SCEN_SCENARIO4_TEST);
        EnableChannelDialogStub channelStub = new EnableChannelDialogStub();
        channelStub.setIsKernel(false);
        TraceControlDialogFactory.getInstance().setEnableChannelDialog((IEnableChannelDialog)channelStub);
        this.fFacility.executeCommand((ITraceControlComponent)session, "enableChannelOnSession");
        ITraceControlComponent[] domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        Assert.assertEquals((Object)"UST global", (Object)domains[0].getName());
        Assert.assertEquals((String)"Domain buffer Type", (Object)BufferType.BUFFER_TYPE_UNKNOWN, (Object)((TraceDomainComponent)domains[0]).getBufferType());
        ITraceControlComponent[] channels = domains[0].getChildren();
        Assert.assertNotNull((Object)channels);
        Assert.assertEquals((long)1L, (long)channels.length);
        Assert.assertTrue((boolean)(channels[0] instanceof TraceChannelComponent));
        TraceChannelComponent channel = (TraceChannelComponent)channels[0];
        Assert.assertEquals((Object)"mychannel", (Object)channel.getName());
        Assert.assertEquals((long)4L, (long)channel.getNumberOfSubBuffers());
        Assert.assertEquals((Object)"mmap()", (Object)channel.getOutputType().getInName());
        Assert.assertEquals((Object)TraceChannelOutputType.MMAP, (Object)channel.getOutputType());
        Assert.assertEquals((Object)true, (Object)channel.isOverwriteMode());
        Assert.assertEquals((long)200L, (long)channel.getReadTimer());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)channel.getState());
        Assert.assertEquals((long)16384L, (long)channel.getSubBufferSize());
        Assert.assertEquals((long)100L, (long)channel.getSwitchTimer());
        ChannelInfo info = (ChannelInfo)channelStub.getChannelInfo();
        info.setName("mychannel2");
        info.setOverwriteMode(false);
        info.setSubBufferSize(32768L);
        info.setNumberOfSubBuffers(2);
        info.setSwitchTimer(100L);
        info.setReadTimer(200L);
        channelStub.setChannelInfo(info);
        this.fFacility.executeCommand(domains[0], "enableChannelOnDomain");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        Assert.assertNotNull((Object)channels);
        Assert.assertEquals((long)2L, (long)channels.length);
        Assert.assertTrue((boolean)(channels[1] instanceof TraceChannelComponent));
        channel = (TraceChannelComponent)channels[1];
        Assert.assertEquals((Object)"mychannel2", (Object)channel.getName());
        Assert.assertEquals((long)2L, (long)channel.getNumberOfSubBuffers());
        Assert.assertEquals((Object)"mmap()", (Object)channel.getOutputType().getInName());
        Assert.assertEquals((Object)TraceChannelOutputType.MMAP, (Object)channel.getOutputType());
        Assert.assertEquals((Object)false, (Object)channel.isOverwriteMode());
        Assert.assertEquals((long)200L, (long)channel.getReadTimer());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)channel.getState());
        Assert.assertEquals((long)32768L, (long)channel.getSubBufferSize());
        Assert.assertEquals((long)100L, (long)channel.getSwitchTimer());
        EnableEventsDialogStub eventsDialogStub = new EnableEventsDialogStub();
        eventsDialogStub.setIsTracePoints(true);
        ArrayList<String> events = new ArrayList<String>();
        events.add("ust_tests_hello:tptest_sighandler");
        eventsDialogStub.setNames(events);
        eventsDialogStub.setIsKernel(false);
        TraceControlDialogFactory.getInstance().setEnableEventsDialog((IEnableEventsDialog)eventsDialogStub);
        this.fFacility.executeCommand((ITraceControlComponent)session, "enableEventOnSession");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        Assert.assertNotNull((Object)channels);
        Assert.assertEquals((long)3L, (long)channels.length);
        Assert.assertTrue((boolean)(channels[2] instanceof TraceChannelComponent));
        channel = (TraceChannelComponent)channels[2];
        Assert.assertEquals((Object)"channel0", (Object)channel.getName());
        ITraceControlComponent[] channel0Events = channel.getChildren();
        Assert.assertEquals((long)1L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceEventComponent));
        TraceEventComponent event = (TraceEventComponent)channel0Events[0];
        Assert.assertEquals((Object)"ust_tests_hello:tptest_sighandler", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.LEVEL_UNKNOWN, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        events.clear();
        events.add("ust_tests_hello:tptest");
        eventsDialogStub.setNames(events);
        this.fFacility.executeCommand(domains[0], "enableEventOnDomain");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        channel = (TraceChannelComponent)channels[2];
        channel0Events = channel.getChildren();
        Assert.assertEquals((long)2L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[1] instanceof TraceEventComponent));
        event = (TraceEventComponent)channel0Events[1];
        Assert.assertEquals((Object)"ust_tests_hello:tptest", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.LEVEL_UNKNOWN, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        events.clear();
        eventsDialogStub.setNames(events);
        eventsDialogStub.setIsAllTracePoints(true);
        this.fFacility.executeCommand(channels[1], "enableEventOnChannel");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        channel = (TraceChannelComponent)channels[1];
        channel = (TraceChannelComponent)channels[1];
        channel0Events = channel.getChildren();
        Assert.assertEquals((long)1L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceEventComponent));
        event = (TraceEventComponent)channel0Events[0];
        Assert.assertEquals((Object)"*", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.LEVEL_UNKNOWN, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        events.clear();
        eventsDialogStub.setIsTracePoints(false);
        eventsDialogStub.setIsAllTracePoints(false);
        eventsDialogStub.setIsWildcard(true);
        eventsDialogStub.setWildcard("ust*");
        this.fFacility.executeCommand(channels[0], "enableEventOnChannel");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        channel = (TraceChannelComponent)channels[0];
        channel0Events = channel.getChildren();
        Assert.assertEquals((long)1L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceEventComponent));
        event = (TraceEventComponent)channel0Events[0];
        Assert.assertEquals((Object)"ust*", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.LEVEL_UNKNOWN, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        events.clear();
        eventsDialogStub.setIsTracePoints(false);
        eventsDialogStub.setIsAllTracePoints(false);
        eventsDialogStub.setIsWildcard(true);
        eventsDialogStub.setWildcard("ust*");
        this.fFacility.executeCommand(domains[0], "enableEventOnDomain");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        channel = (TraceChannelComponent)channels[0];
        channel0Events = channel.getChildren();
        Assert.assertEquals((long)1L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceEventComponent));
        event = (TraceEventComponent)channel0Events[0];
        Assert.assertEquals((Object)"ust*", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.LEVEL_UNKNOWN, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        events.clear();
        eventsDialogStub.setIsTracePoints(false);
        eventsDialogStub.setIsAllTracePoints(false);
        eventsDialogStub.setIsWildcard(true);
        eventsDialogStub.setWildcard("ust*");
        this.fFacility.executeCommand(domains[0], "enableEventOnDomain");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        channel = (TraceChannelComponent)channels[2];
        channel0Events = channel.getChildren();
        Assert.assertEquals((long)4L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceEventComponent));
        event = (TraceEventComponent)channel0Events[0];
        Assert.assertEquals((Object)"u*", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.LEVEL_UNKNOWN, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        events.clear();
        eventsDialogStub.setIsWildcard(false);
        eventsDialogStub.setIsLogLevel(true);
        eventsDialogStub.setLogLevelEventName("myevent1");
        eventsDialogStub.setLogLevelType(LogLevelType.LOGLEVEL);
        eventsDialogStub.setLogLevel(TraceLogLevel.TRACE_WARNING);
        this.fFacility.executeCommand(domains[0], "enableEventOnDomain");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        channel = (TraceChannelComponent)channels[2];
        channel0Events = channel.getChildren();
        Assert.assertEquals((long)5L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceEventComponent));
        event = (TraceEventComponent)channel0Events[0];
        Assert.assertEquals((Object)"myevent1", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_WARNING, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        eventsDialogStub.setLogLevelEventName("myevent2");
        eventsDialogStub.setLogLevelType(LogLevelType.LOGLEVEL_ONLY);
        eventsDialogStub.setLogLevel(TraceLogLevel.TRACE_DEBUG_FUNCTION);
        this.fFacility.executeCommand((ITraceControlComponent)session, "enableEventOnSession");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        channel = (TraceChannelComponent)channels[2];
        channel0Events = channel.getChildren();
        Assert.assertEquals((long)6L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceEventComponent));
        event = (TraceEventComponent)channel0Events[0];
        Assert.assertEquals((Object)"myevent2", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_DEBUG_FUNCTION, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        eventsDialogStub.setLogLevelEventName("myevent0");
        eventsDialogStub.setLogLevelType(LogLevelType.LOGLEVEL_ONLY);
        eventsDialogStub.setLogLevel(TraceLogLevel.TRACE_DEBUG_FUNCTION);
        this.fFacility.executeCommand(channels[0], "enableEventOnChannel");
        domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)1L, (long)domains.length);
        channels = domains[0].getChildren();
        channel = (TraceChannelComponent)channels[0];
        channel0Events = channel.getChildren();
        Assert.assertEquals((long)2L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceEventComponent));
        event = (TraceEventComponent)channel0Events[0];
        Assert.assertEquals((Object)"myevent0", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_DEBUG_FUNCTION, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        this.fProxy.setScenario("SessionHandling");
        this.fFacility.destroySession(session);
        Assert.assertEquals((String)"Session components still exist.", (long)0L, (long)groups[1].getChildren().length);
        this.fFacility.executeCommand((ITraceControlComponent)node, "disconnect");
        Assert.assertEquals((Object)TargetNodeState.DISCONNECTED, (Object)node.getTargetNodeState());
        this.fFacility.executeCommand((ITraceControlComponent)node, "delete");
        Assert.assertEquals((String)"Node not deleted.", (long)0L, (long)this.fFacility.getControlView().getTraceControlRoot().getChildren().length);
    }
}

