/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.ControlView;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.INewConnectionDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.TraceControlDialogFactory;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.BaseControlViewHandler;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.tmf.remote.core.proxy.TmfRemoteConnectionFactory;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class NewConnectionHandler
extends BaseControlViewHandler {
    public static final String PARAMETER_REMOTE_SERVICES_ID = "org.eclipse.linuxtools.lttng2.control.ui.remoteServicesIdParameter";
    public static final String PARAMETER_CONNECTION_NAME = "org.eclipse.linuxtools.lttng2.control.ui.connectionNameParameter";
    private ITraceControlComponent fRoot = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        assert (this.fRoot != null);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IRemoteConnection connection = NewConnectionHandler.getConnection(event.getParameters());
        if (connection != null) {
            this.fLock.lock();
            try {
                TargetNodeComponent node = null;
                if (!this.fRoot.containsChild(connection.getName())) {
                    node = new TargetNodeComponent(connection.getName(), this.fRoot, connection);
                    this.fRoot.addChild(node);
                } else {
                    node = (TargetNodeComponent)this.fRoot.getChild(connection.getName());
                }
                node.connect();
            }
            finally {
                this.fLock.unlock();
            }
        }
        return null;
    }

    private static IRemoteConnection getConnection(Map<?, ?> parameters) {
        Object remoteServicesId = parameters.get(PARAMETER_REMOTE_SERVICES_ID);
        Object connectionName = parameters.get(PARAMETER_CONNECTION_NAME);
        if (remoteServicesId != null && connectionName != null) {
            return TmfRemoteConnectionFactory.getRemoteConnection((String)((String)NonNullUtils.checkNotNull((Object)remoteServicesId.toString())), (String)((String)NonNullUtils.checkNotNull((Object)connectionName.toString())));
        }
        INewConnectionDialog dialog = TraceControlDialogFactory.getInstance().getNewConnectionDialog();
        if (dialog.open() == 0) {
            return dialog.getConnection();
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        ITraceControlComponent root = null;
        IWorkbenchPart part = page.getActivePart();
        root = ((ControlView)part).getTraceControlRoot();
        boolean isEnabled = root != null;
        this.fLock.lock();
        try {
            this.fRoot = null;
            if (isEnabled) {
                this.fRoot = root;
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }
}

