/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ISessionInfo;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;

public class TraceSessionGroup
extends TraceControlComponent {
    public static final String TRACE_SESSIONS_ICON_FILE = "icons/obj16/sessions.gif";

    public TraceSessionGroup(String name, ITraceControlComponent parent) {
        super(name, parent);
        this.setImage(TRACE_SESSIONS_ICON_FILE);
    }

    public TargetNodeComponent getTargetNode() {
        return (TargetNodeComponent)this.getParent();
    }

    public boolean isNetworkStreamingSupported() {
        return this.getTargetNode().isNetworkStreamingSupported();
    }

    public boolean isSnapshotSupported() {
        return this.getTargetNode().isSnapshotSupported();
    }

    public boolean isLiveSupported() {
        return this.getTargetNode().isLiveSupported();
    }

    public void getSessionsFromNode() throws ExecutionException {
        this.getSessionsFromNode((IProgressMonitor)new NullProgressMonitor());
    }

    public void getSessionsFromNode(IProgressMonitor monitor) throws ExecutionException {
        List<String> sessionNames = this.getControlService().getSessionNames(monitor);
        for (String sessionName : sessionNames) {
            TraceSessionComponent session = new TraceSessionComponent(sessionName, (ITraceControlComponent)this);
            this.addChild(session);
            session.getConfigurationFromNode(monitor);
        }
    }

    public void createSession(ISessionInfo sessionInf, IProgressMonitor monitor) throws ExecutionException {
        ISessionInfo sessionInfo = this.getControlService().createSession(sessionInf, monitor);
        if (sessionInfo != null) {
            TraceSessionComponent session = new TraceSessionComponent(sessionInfo, (ITraceControlComponent)this);
            this.addChild(session);
            session.getConfigurationFromNode(monitor);
        }
    }

    public void executeCommands(IProgressMonitor monitor, List<String> commands) throws ExecutionException {
        this.getControlService().runCommands(monitor, commands);
        this.getTargetNode().refresh();
    }

    public void destroySession(TraceSessionComponent session, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().destroySession(session.getName(), monitor);
        session.removeAllChildren();
        this.removeChild(session);
    }
}

