/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IBaseEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IDomainInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IFieldInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ISessionInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ISnapshotInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IUstProviderInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.BaseEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.BufferType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.ChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.DomainInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.EventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.FieldInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.ProbeEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.SessionInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.SnapshotInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.UstProviderInfo;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.logging.ControlCommandLogger;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.preferences.ControlPreferences;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.ILttngControlService;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LTTngControlServiceConstants;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LttngVersion;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandInput;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandResult;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandShell;

public class LTTngControlService
implements ILttngControlService {
    @NonNull
    private final ICommandShell fCommandShell;
    @NonNull
    private LttngVersion fVersion = LttngVersion.NULL_VERSION;

    public LTTngControlService(@NonNull ICommandShell shell) {
        this.fCommandShell = shell;
    }

    @Override
    public String getVersionString() {
        return NonNullUtils.nullToEmptyString((Object)this.fVersion.toString());
    }

    @Override
    public LttngVersion getVersion() {
        return this.fVersion;
    }

    public void setVersion(@Nullable String version) {
        if (version != null) {
            this.fVersion = new LttngVersion(version);
        }
    }

    public void setVersion(LttngVersion version) {
        if (version != null) {
            this.fVersion = version;
        }
    }

    @Override
    public boolean isVersionSupported(String version) {
        LttngVersion tmp = new LttngVersion(version);
        return this.fVersion.compareTo(tmp) >= 0;
    }

    protected ICommandShell getCommandShell() {
        return this.fCommandShell;
    }

    @Override
    public List<String> getSessionNames(IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("list");
        ICommandResult result = this.executeCommand(command, monitor);
        ArrayList<String> retArray = new ArrayList<String>();
        for (String line : result.getOutput()) {
            Matcher matcher = LTTngControlServiceConstants.SESSION_PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            retArray.add(matcher.group(2).trim());
        }
        return retArray;
    }

    protected boolean ignoredPattern(List<String> input, Pattern pattern) {
        for (String line : input) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ISessionInfo getSession(String sessionName, IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("list", sessionName);
        ICommandResult result = this.executeCommand(command, monitor);
        int index = 0;
        SessionInfo sessionInfo = new SessionInfo(sessionName);
        while (index < result.getOutput().size()) {
            ArrayList<Object> channels;
            String line = (String)result.getOutput().get(index);
            Matcher matcher = LTTngControlServiceConstants.TRACE_SESSION_PATTERN.matcher(line);
            if (matcher.matches()) {
                sessionInfo.setSessionState(matcher.group(2));
                ++index;
                continue;
            }
            matcher = LTTngControlServiceConstants.TRACE_SNAPSHOT_SESSION_PATTERN.matcher(line);
            if (matcher.matches()) {
                sessionInfo.setSessionState(matcher.group(2));
                SnapshotInfo snapshotInfo = new SnapshotInfo("");
                sessionInfo.setSnapshotInfo((ISnapshotInfo)snapshotInfo);
                ++index;
                continue;
            }
            if (!sessionInfo.isSnapshotSession()) {
                matcher = LTTngControlServiceConstants.TRACE_NETWORK_PATH_PATTERN.matcher(line);
                if (matcher.matches()) {
                    sessionInfo.setStreamedTrace(true);
                }
                if ((matcher = LTTngControlServiceConstants.TRACE_SESSION_PATH_PATTERN.matcher(line)).matches()) {
                    sessionInfo.setSessionPath(matcher.group(1).trim());
                    ++index;
                    continue;
                }
            }
            if ((matcher = LTTngControlServiceConstants.DOMAIN_KERNEL_PATTERN.matcher(line)).matches()) {
                DomainInfo domainInfo = new DomainInfo(Messages.TraceControl_KernelDomainDisplayName);
                domainInfo.setIsKernel(true);
                channels = new ArrayList<IChannelInfo>();
                index = this.parseDomain(result.getOutput(), index, channels, (IDomainInfo)domainInfo);
                if (channels.size() <= 0) continue;
                sessionInfo.addDomain((IDomainInfo)domainInfo);
                domainInfo.setChannels(channels);
                continue;
            }
            matcher = LTTngControlServiceConstants.DOMAIN_UST_GLOBAL_PATTERN.matcher(line);
            if (matcher.matches()) {
                DomainInfo domainInfo = new DomainInfo(Messages.TraceControl_UstGlobalDomainDisplayName);
                domainInfo.setIsKernel(false);
                channels = new ArrayList();
                index = this.parseDomain(result.getOutput(), index, channels, (IDomainInfo)domainInfo);
                if (channels.size() <= 0) continue;
                sessionInfo.addDomain((IDomainInfo)domainInfo);
                domainInfo.setChannels(channels);
                continue;
            }
            matcher = LTTngControlServiceConstants.LIST_LIVE_TIMER_INTERVAL_PATTERN.matcher(line);
            if (matcher.matches()) {
                long liveDelay = Long.parseLong(matcher.group(1));
                if (liveDelay > 0L && liveDelay <= LTTngControlServiceConstants.MAX_LIVE_TIMER_INTERVAL) {
                    sessionInfo.setLive(true);
                    sessionInfo.setLiveUrl("net://127.0.0.1");
                    sessionInfo.setLivePort(Integer.valueOf(5344));
                    sessionInfo.setLiveDelay(liveDelay);
                }
                ++index;
                continue;
            }
            ++index;
        }
        if (sessionInfo.isSnapshotSession()) {
            ISnapshotInfo snapshot = this.getSnapshotInfo(sessionName, monitor);
            sessionInfo.setSnapshotInfo(snapshot);
        }
        return sessionInfo;
    }

    @Override
    public ISnapshotInfo getSnapshotInfo(String sessionName, IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("snapshot", "list-output", "-s", sessionName);
        ICommandResult result = this.executeCommand(command, monitor);
        int index = 0;
        SnapshotInfo snapshotInfo = new SnapshotInfo("");
        while (index < result.getOutput().size()) {
            String line = (String)result.getOutput().get(index);
            Matcher matcher = LTTngControlServiceConstants.LIST_SNAPSHOT_OUTPUT_PATTERN.matcher(line);
            if (matcher.matches()) {
                snapshotInfo.setId(Integer.valueOf(matcher.group(1)).intValue());
                snapshotInfo.setName(matcher.group(2));
                snapshotInfo.setSnapshotPath(matcher.group(3));
                Matcher matcher2 = LTTngControlServiceConstants.SNAPSHOT_NETWORK_PATH_PATTERN.matcher(snapshotInfo.getSnapshotPath());
                if (matcher2.matches()) {
                    snapshotInfo.setStreamedSnapshot(true);
                }
                ++index;
                break;
            }
            ++index;
        }
        return snapshotInfo;
    }

    @Override
    public List<IBaseEventInfo> getKernelProvider(IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("list", "-k");
        ICommandResult result = this.executeCommand(command, monitor, false);
        ArrayList<IBaseEventInfo> events = new ArrayList<IBaseEventInfo>();
        if (this.ignoredPattern(result.getErrorOutput(), LTTngControlServiceConstants.LIST_KERNEL_NO_KERNEL_PROVIDER_PATTERN)) {
            return events;
        }
        if (this.isError(result)) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command.toString() + "\n" + result.toString());
        }
        this.getProviderEventInfo(result.getOutput(), 0, events);
        return events;
    }

    @Override
    public List<IUstProviderInfo> getUstProvider() throws ExecutionException {
        return this.getUstProvider((IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public List<IUstProviderInfo> getUstProvider(IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("list", "-u");
        if (this.isVersionSupported("2.1.0")) {
            command.add("-f");
        }
        ICommandResult result = this.executeCommand(command, monitor, false);
        ArrayList<IUstProviderInfo> allProviders = new ArrayList<IUstProviderInfo>();
        if (!this.isVersionSupported("2.1.0") && result.getResult() != 0) {
            return allProviders;
        }
        if (this.ignoredPattern(result.getErrorOutput(), LTTngControlServiceConstants.LIST_UST_NO_UST_PROVIDER_PATTERN)) {
            return allProviders;
        }
        if (this.isError(result)) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command.toString() + "\n" + result.toString());
        }
        UstProviderInfo provider = null;
        int index = 0;
        while (index < result.getOutput().size()) {
            String line = (String)result.getOutput().get(index);
            Matcher matcher = LTTngControlServiceConstants.UST_PROVIDER_PATTERN.matcher(line);
            if (matcher.matches()) {
                provider = new UstProviderInfo(matcher.group(2).trim());
                provider.setPid(Integer.valueOf(matcher.group(1).trim()).intValue());
                ArrayList<IBaseEventInfo> events = new ArrayList<IBaseEventInfo>();
                ++index;
                index = this.getProviderEventInfo(result.getOutput(), index, events);
                provider.setEvents(events);
                allProviders.add((IUstProviderInfo)provider);
                continue;
            }
            ++index;
        }
        return allProviders;
    }

    @Override
    public ISessionInfo createSession(ISessionInfo sessionInfo, IProgressMonitor monitor) throws ExecutionException {
        if (sessionInfo.isStreamedTrace()) {
            return this.createStreamedSession(sessionInfo, monitor);
        }
        ICommandInput command = this.prepareSessionCreationCommand(sessionInfo);
        ICommandResult result = this.executeCommand(command, monitor);
        List output = result.getOutput();
        String name = null;
        String path = null;
        for (String line : output) {
            Matcher nameMatcher = LTTngControlServiceConstants.CREATE_SESSION_NAME_PATTERN.matcher(line);
            Matcher pathMatcher = LTTngControlServiceConstants.CREATE_SESSION_PATH_PATTERN.matcher(line);
            if (nameMatcher.matches()) {
                name = String.valueOf(nameMatcher.group(1).trim());
                continue;
            }
            if (!pathMatcher.matches()) continue;
            path = String.valueOf(pathMatcher.group(1).trim());
        }
        if (name == null || !"".equals(sessionInfo.getName()) && !name.equals(sessionInfo.getName())) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command.toString() + "\n" + Messages.TraceControl_UnexpectedNameError + ": " + name);
        }
        sessionInfo.setName(name);
        if (!sessionInfo.isSnapshotSession() && (path == null || sessionInfo.getSessionPath() != null && !path.contains(sessionInfo.getSessionPath()))) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command.toString() + "\n" + Messages.TraceControl_UnexpectedPathError + ": " + name);
        }
        if (sessionInfo.isSnapshotSession()) {
            sessionInfo.setSnapshotInfo((ISnapshotInfo)new SnapshotInfo(""));
        } else {
            sessionInfo.setSessionPath(path);
        }
        return sessionInfo;
    }

    @NonNull
    protected ICommandInput prepareSessionCreationCommand(ISessionInfo sessionInfo) {
        String newPath;
        ICommandInput command = this.createCommand("create");
        if (!sessionInfo.getName().isEmpty()) {
            command.add(sessionInfo.getName());
        }
        if ((newPath = sessionInfo.getSessionPath()) != null && !"".equals(newPath)) {
            command.add("-o");
            command.add(newPath);
        }
        if (sessionInfo.isSnapshotSession()) {
            command.add("--snapshot");
        }
        return command;
    }

    @NonNull
    private ISessionInfo createStreamedSession(ISessionInfo sessionInfo, IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.prepareStreamedSessionCreationCommand(sessionInfo);
        ICommandResult result = this.executeCommand(command, monitor);
        List output = result.getOutput();
        String name = null;
        String path = null;
        for (String line : output) {
            Matcher nameMatcher = LTTngControlServiceConstants.CREATE_SESSION_NAME_PATTERN.matcher(line);
            Matcher pathMatcher = LTTngControlServiceConstants.CREATE_SESSION_PATH_PATTERN.matcher(line);
            if (nameMatcher.matches()) {
                name = String.valueOf(nameMatcher.group(1).trim());
                continue;
            }
            if (!pathMatcher.matches() || sessionInfo.getNetworkUrl() == null) continue;
            path = String.valueOf(pathMatcher.group(1).trim());
        }
        if (name == null || !"".equals(sessionInfo.getName()) && !name.equals(sessionInfo.getName())) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command.toString() + "\n" + Messages.TraceControl_UnexpectedNameError + ": " + name);
        }
        sessionInfo.setName(name);
        sessionInfo.setStreamedTrace(true);
        if (sessionInfo.getNetworkUrl() != null) {
            if (!sessionInfo.isSnapshotSession() && path == null) {
                throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command.toString() + "\n" + Messages.TraceControl_UnexpectedPathError + ": " + name);
            }
            if (sessionInfo.isSnapshotSession()) {
                sessionInfo.setStreamedTrace(false);
            } else {
                sessionInfo.setSessionPath(path);
                Matcher matcher = LTTngControlServiceConstants.TRACE_FILE_PROTOCOL_PATTERN.matcher(path);
                if (matcher.matches()) {
                    sessionInfo.setStreamedTrace(false);
                }
            }
        }
        return sessionInfo;
    }

    @NonNull
    protected ICommandInput prepareStreamedSessionCreationCommand(ISessionInfo sessionInfo) {
        ICommandInput command = this.createCommand("create");
        if (!sessionInfo.getName().isEmpty()) {
            command.add(sessionInfo.getName());
        }
        if (sessionInfo.isSnapshotSession()) {
            command.add("--snapshot");
        } else if (sessionInfo.isLive()) {
            command.add("--live");
            if (sessionInfo.getLiveDelay() != -1L) {
                command.add(String.valueOf(sessionInfo.getLiveDelay()));
            }
        }
        if (sessionInfo.getNetworkUrl() != null) {
            command.add("-U");
            command.add(sessionInfo.getNetworkUrl());
        } else {
            command.add("-C");
            command.add(sessionInfo.getControlUrl());
            command.add("-D");
            command.add(sessionInfo.getDataUrl());
        }
        return command;
    }

    @Override
    public void destroySession(String sessionName, IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("destroy", sessionName);
        ICommandResult result = this.executeCommand(command, monitor, false);
        boolean isError = this.isError(result);
        if (isError && !this.ignoredPattern(result.getErrorOutput(), LTTngControlServiceConstants.SESSION_NOT_FOUND_ERROR_PATTERN)) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command.toString() + "\n" + result.toString());
        }
    }

    @Override
    public void startSession(String sessionName, IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("start", sessionName);
        this.executeCommand(command, monitor);
    }

    @Override
    public void stopSession(String sessionName, IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("stop", sessionName);
        this.executeCommand(command, monitor);
    }

    @Override
    public void enableChannels(String sessionName, List<String> channelNames, boolean isKernel, IChannelInfo info, IProgressMonitor monitor) throws ExecutionException {
        if (channelNames.isEmpty()) {
            return;
        }
        ICommandInput command = this.createCommand("enable-channel");
        command.add(this.toCsv(channelNames));
        if (isKernel) {
            command.add("-k");
        } else {
            command.add("-u");
        }
        command.add("-s");
        command.add(sessionName);
        if (info != null) {
            if (info.isOverwriteMode()) {
                command.add("--overwrite");
            }
            if (info.getSubBufferSize() != -1L) {
                command.add("--subbuf-size");
                command.add(String.valueOf(info.getSubBufferSize()));
            }
            if (info.getNumberOfSubBuffers() != -1) {
                command.add("--num-subbuf");
                command.add(String.valueOf(info.getNumberOfSubBuffers()));
            }
            if (info.getSwitchTimer() != -1L) {
                command.add("--switch-timer");
                command.add(String.valueOf(info.getSwitchTimer()));
            }
            if (info.getReadTimer() != -1L) {
                command.add("--read-timer");
                command.add(String.valueOf(info.getReadTimer()));
            }
            if (this.isVersionSupported("2.2.0")) {
                if (!isKernel) {
                    if (info.getBufferType() == BufferType.BUFFER_PER_PID) {
                        command.add("--buffers-pid");
                    } else if (info.getBufferType() == BufferType.BUFFER_PER_UID) {
                        command.add("--buffers-uid");
                    }
                }
                if (info.getMaxSizeTraceFiles() != -1L) {
                    command.add("-C");
                    command.add(String.valueOf(info.getMaxSizeTraceFiles()));
                }
                if (info.getMaxNumberTraceFiles() != -1) {
                    command.add("-W");
                    command.add(String.valueOf(info.getMaxNumberTraceFiles()));
                }
            }
        }
        this.executeCommand(command, monitor);
    }

    @Override
    public void disableChannels(String sessionName, List<String> channelNames, boolean isKernel, IProgressMonitor monitor) throws ExecutionException {
        if (channelNames.isEmpty()) {
            return;
        }
        ICommandInput command = this.createCommand("disable-channel");
        command.add(this.toCsv(channelNames));
        if (isKernel) {
            command.add("-k");
        } else {
            command.add("-u");
        }
        command.add("-s");
        command.add(sessionName);
        this.executeCommand(command, monitor);
    }

    @Override
    public void enableEvents(String sessionName, String channelName, List<String> eventNames, boolean isKernel, String filterExpression, IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("enable-event");
        if (eventNames == null || eventNames.isEmpty()) {
            command.add("-a");
        } else {
            command.add(this.toCsv(eventNames));
        }
        if (isKernel) {
            command.add("-k");
        } else {
            command.add("-u");
        }
        command.add("-s");
        command.add(sessionName);
        if (channelName != null) {
            command.add("-c");
            command.add(channelName);
        }
        command.add("--tracepoint");
        if (filterExpression != null) {
            command.add("--filter");
            command.add(filterExpression);
        }
        this.executeCommand(command, monitor);
    }

    @Override
    public void enableSyscalls(String sessionName, String channelName, IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("enable-event");
        command.add("-a");
        command.add("-k");
        command.add("-s");
        command.add(sessionName);
        if (channelName != null) {
            command.add("-c");
            command.add(channelName);
        }
        command.add("--syscall");
        this.executeCommand(command, monitor);
    }

    @Override
    public void enableProbe(String sessionName, String channelName, String eventName, boolean isFunction, String probe, IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("enable-event");
        command.add(eventName);
        command.add("-k");
        command.add("-s");
        command.add(sessionName);
        if (channelName != null) {
            command.add("-c");
            command.add(channelName);
        }
        if (isFunction) {
            command.add("--function");
        } else {
            command.add("--probe");
        }
        command.add(probe);
        this.executeCommand(command, monitor);
    }

    @Override
    public void enableLogLevel(String sessionName, String channelName, String eventName, LogLevelType logLevelType, TraceLogLevel level, String filterExpression, IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("enable-event");
        command.add(eventName);
        command.add("-u");
        command.add("-s");
        command.add(sessionName);
        if (channelName != null) {
            command.add("-c");
            command.add(channelName);
        }
        if (logLevelType == LogLevelType.LOGLEVEL) {
            command.add("--loglevel");
        } else if (logLevelType == LogLevelType.LOGLEVEL_ONLY) {
            command.add("--loglevel-only");
        } else {
            return;
        }
        command.add(level.getInName());
        this.executeCommand(command, monitor);
    }

    @Override
    public void disableEvent(String sessionName, String channelName, List<String> eventNames, boolean isKernel, IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("disable-event");
        if (eventNames == null) {
            command.add("-a");
        } else {
            if (eventNames.isEmpty()) {
                return;
            }
            StringBuffer eventNameParameter = new StringBuffer();
            Iterator<String> iterator = eventNames.iterator();
            while (iterator.hasNext()) {
                String event = iterator.next();
                eventNameParameter.append(event);
                if (!iterator.hasNext()) continue;
                eventNameParameter.append(',');
            }
            command.add(eventNameParameter.toString());
        }
        if (isKernel) {
            command.add("-k");
        } else {
            command.add("-u");
        }
        command.add("-s");
        command.add(sessionName);
        if (channelName != null) {
            command.add("-c");
            command.add(channelName);
        }
        this.executeCommand(command, monitor);
    }

    @Override
    public List<String> getContextList(IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("add-context", "-h");
        ICommandResult result = this.executeCommand(command, monitor);
        List output = result.getOutput();
        ArrayList<String> contexts = new ArrayList<String>(0);
        int index = 0;
        boolean inList = false;
        while (index < output.size()) {
            String line = (String)output.get(index);
            Matcher startMatcher = LTTngControlServiceConstants.ADD_CONTEXT_HELP_CONTEXTS_INTRO.matcher(line);
            Matcher endMatcher = LTTngControlServiceConstants.ADD_CONTEXT_HELP_CONTEXTS_END_LINE.matcher(line);
            if (startMatcher.matches()) {
                inList = true;
            } else {
                if (endMatcher.matches()) break;
                if (inList) {
                    String[] tmp = line.split(",");
                    int i = 0;
                    while (i < tmp.length) {
                        contexts.add(tmp[i].trim());
                        ++i;
                    }
                }
            }
            ++index;
        }
        return contexts;
    }

    @Override
    public void addContexts(String sessionName, String channelName, String eventName, boolean isKernel, List<String> contextNames, IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("add-context");
        command.add("-s");
        command.add(sessionName);
        if (channelName != null) {
            command.add("-c");
            command.add(channelName);
        }
        if (eventName != null) {
            command.add("-e");
            command.add(eventName);
        }
        if (isKernel) {
            command.add("-k");
        } else {
            command.add("-u");
        }
        for (String context : contextNames) {
            command.add("-t");
            command.add(context);
        }
        this.executeCommand(command, monitor);
    }

    @Override
    public void calibrate(boolean isKernel, IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("calibrate");
        if (isKernel) {
            command.add("-k");
        } else {
            command.add("-u");
        }
        command.add("--function");
        this.executeCommand(command, monitor);
    }

    @Override
    public void recordSnapshot(String sessionName, IProgressMonitor monitor) throws ExecutionException {
        ICommandInput command = this.createCommand("snapshot", "record");
        String newSessionName = sessionName;
        command.add("-s");
        command.add(newSessionName);
        this.executeCommand(command, monitor);
    }

    @Override
    public void runCommands(IProgressMonitor monitor, List<String> commandLines) throws ExecutionException {
        for (String commandLine : commandLines) {
            if (monitor.isCanceled()) {
                return;
            }
            if (commandLine.isEmpty() || commandLine.startsWith("#")) continue;
            String[] args = commandLine.split("\\s+");
            ICommandInput command = this.fCommandShell.createCommand();
            command.addAll((List)NonNullUtils.checkNotNull(Arrays.asList(args)));
            ICommandResult result = this.executeCommand(command, monitor);
            if (!this.isError(result)) continue;
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command.toString() + "\n" + result.toString());
        }
    }

    protected boolean isError(ICommandResult result) {
        if (result.getResult() != 0) {
            return true;
        }
        for (String line : result.getErrorOutput()) {
            Matcher matcher = LTTngControlServiceConstants.ERROR_PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    protected String toCsv(List<String> names) {
        StringBuilder csvString = new StringBuilder();
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            String name = iterator.next();
            csvString.append(name);
            if (!iterator.hasNext()) continue;
            csvString.append(',');
        }
        return csvString.toString();
    }

    protected int parseDomain(List<String> output, int currentIndex, List<IChannelInfo> channels, IDomainInfo domainInfo) {
        int index = currentIndex;
        if (domainInfo.isKernel()) {
            domainInfo.setBufferType(BufferType.BUFFER_SHARED);
        }
        while (index < output.size()) {
            String line = output.get(index);
            if (this.isVersionSupported("2.2.0")) {
                Matcher bufferTypeMatcher = LTTngControlServiceConstants.BUFFER_TYPE_PATTERN.matcher(line);
                if (bufferTypeMatcher.matches()) {
                    String bufferTypeString = this.getAttributeValue(line);
                    if (BufferType.BUFFER_PER_PID.getInName().equals(bufferTypeString)) {
                        domainInfo.setBufferType(BufferType.BUFFER_PER_PID);
                    } else if (BufferType.BUFFER_PER_UID.getInName().equals(bufferTypeString)) {
                        domainInfo.setBufferType(BufferType.BUFFER_PER_UID);
                    } else {
                        domainInfo.setBufferType(BufferType.BUFFER_TYPE_UNKNOWN);
                    }
                }
            } else {
                domainInfo.setBufferType(BufferType.BUFFER_TYPE_UNKNOWN);
            }
            Matcher outerMatcher = LTTngControlServiceConstants.CHANNELS_SECTION_PATTERN.matcher(line);
            Matcher noKernelChannelMatcher = LTTngControlServiceConstants.DOMAIN_NO_KERNEL_CHANNEL_PATTERN.matcher(line);
            Matcher noUstChannelMatcher = LTTngControlServiceConstants.DOMAIN_NO_UST_CHANNEL_PATTERN.matcher(line);
            if (outerMatcher.matches()) {
                ChannelInfo channelInfo = null;
                while (index < output.size()) {
                    String subLine = output.get(index);
                    Matcher innerMatcher = LTTngControlServiceConstants.CHANNEL_PATTERN.matcher(subLine);
                    if (innerMatcher.matches()) {
                        channelInfo = new ChannelInfo("");
                        channelInfo.setName(innerMatcher.group(1));
                        channelInfo.setState(innerMatcher.group(2));
                        channelInfo.setBufferType(domainInfo.getBufferType());
                        channels.add((IChannelInfo)channelInfo);
                    } else if (LTTngControlServiceConstants.OVERWRITE_MODE_ATTRIBUTE.matcher(subLine).matches()) {
                        String value = this.getAttributeValue(subLine);
                        if (channelInfo != null) {
                            channelInfo.setOverwriteMode(!"0".equals(value));
                        }
                    } else if (LTTngControlServiceConstants.SUBBUFFER_SIZE_ATTRIBUTE.matcher(subLine).matches()) {
                        if (channelInfo != null) {
                            channelInfo.setSubBufferSize(Long.valueOf(this.getAttributeValue(subLine)).longValue());
                        }
                    } else if (LTTngControlServiceConstants.NUM_SUBBUFFERS_ATTRIBUTE.matcher(subLine).matches()) {
                        if (channelInfo != null) {
                            channelInfo.setNumberOfSubBuffers(Integer.valueOf(this.getAttributeValue(subLine)).intValue());
                        }
                    } else if (LTTngControlServiceConstants.SWITCH_TIMER_ATTRIBUTE.matcher(subLine).matches()) {
                        if (channelInfo != null) {
                            channelInfo.setSwitchTimer(Long.valueOf(this.getAttributeValue(subLine)).longValue());
                        }
                    } else if (LTTngControlServiceConstants.READ_TIMER_ATTRIBUTE.matcher(subLine).matches()) {
                        if (channelInfo != null) {
                            channelInfo.setReadTimer(Long.valueOf(this.getAttributeValue(subLine)).longValue());
                        }
                    } else if (LTTngControlServiceConstants.OUTPUT_ATTRIBUTE.matcher(subLine).matches()) {
                        if (channelInfo != null) {
                            channelInfo.setOutputType(this.getAttributeValue(subLine));
                        }
                    } else if (LTTngControlServiceConstants.TRACE_FILE_COUNT_ATTRIBUTE.matcher(subLine).matches()) {
                        if (channelInfo != null) {
                            channelInfo.setMaxNumberTraceFiles(Integer.valueOf(this.getAttributeValue(subLine)).intValue());
                        }
                    } else if (LTTngControlServiceConstants.TRACE_FILE_SIZE_ATTRIBUTE.matcher(subLine).matches()) {
                        if (channelInfo != null) {
                            channelInfo.setMaxSizeTraceFiles(Long.valueOf(this.getAttributeValue(subLine)).longValue());
                        }
                    } else {
                        if (LTTngControlServiceConstants.EVENT_SECTION_PATTERN.matcher(subLine).matches()) {
                            ArrayList<IEventInfo> events = new ArrayList<IEventInfo>();
                            index = this.parseEvents(output, index, events);
                            if (channelInfo == null) continue;
                            channelInfo.setEvents(events);
                            continue;
                        }
                        if (LTTngControlServiceConstants.DOMAIN_KERNEL_PATTERN.matcher(subLine).matches()) {
                            return index;
                        }
                        if (LTTngControlServiceConstants.DOMAIN_UST_GLOBAL_PATTERN.matcher(subLine).matches()) {
                            return index;
                        }
                    }
                    ++index;
                }
            } else if (noKernelChannelMatcher.matches() || noUstChannelMatcher.matches()) {
                return ++index;
            }
            ++index;
        }
        return index;
    }

    protected int parseEvents(List<String> output, int currentIndex, List<IEventInfo> events) {
        int index = currentIndex;
        while (index < output.size()) {
            String filter;
            EventInfo eventInfo;
            String line = output.get(index);
            if (LTTngControlServiceConstants.CHANNEL_PATTERN.matcher(line).matches()) {
                return index;
            }
            if (LTTngControlServiceConstants.DOMAIN_KERNEL_PATTERN.matcher(line).matches()) {
                return index;
            }
            if (LTTngControlServiceConstants.DOMAIN_UST_GLOBAL_PATTERN.matcher(line).matches()) {
                return index;
            }
            Matcher matcher = LTTngControlServiceConstants.EVENT_PATTERN.matcher(line);
            Matcher matcher2 = LTTngControlServiceConstants.WILDCARD_EVENT_PATTERN.matcher(line);
            if (matcher.matches()) {
                eventInfo = new EventInfo(matcher.group(1).trim());
                eventInfo.setLogLevelType(matcher.group(2).trim());
                eventInfo.setLogLevel(matcher.group(3).trim());
                eventInfo.setEventType(matcher.group(4).trim());
                eventInfo.setState(matcher.group(5));
                filter = matcher.group(6);
                if (filter != null) {
                    filter = filter.substring(1, filter.length() - 1);
                    eventInfo.setFilterExpression(filter);
                }
                events.add((IEventInfo)eventInfo);
                ++index;
                continue;
            }
            if (matcher2.matches()) {
                eventInfo = new EventInfo(matcher2.group(1).trim());
                eventInfo.setLogLevel(TraceLogLevel.LEVEL_UNKNOWN);
                eventInfo.setEventType(matcher2.group(2).trim());
                eventInfo.setState(matcher2.group(3));
                filter = matcher2.group(4);
                if (filter != null) {
                    filter = filter.substring(1, filter.length() - 1);
                    eventInfo.setFilterExpression(filter);
                }
                if (eventInfo.getEventType() == TraceEventType.PROBE || eventInfo.getEventType() == TraceEventType.FUNCTION) {
                    ProbeEventInfo probeEvent = new ProbeEventInfo(eventInfo.getName());
                    probeEvent.setLogLevel(eventInfo.getLogLevel());
                    probeEvent.setEventType(eventInfo.getEventType());
                    probeEvent.setState(eventInfo.getState());
                    eventInfo = probeEvent;
                    ++index;
                    while (index < output.size()) {
                        String probeLine = output.get(index);
                        Matcher addrMatcher = LTTngControlServiceConstants.PROBE_ADDRESS_PATTERN.matcher(probeLine);
                        Matcher offsetMatcher = LTTngControlServiceConstants.PROBE_OFFSET_PATTERN.matcher(probeLine);
                        Matcher symbolMatcher = LTTngControlServiceConstants.PROBE_SYMBOL_PATTERN.matcher(probeLine);
                        if (addrMatcher.matches()) {
                            String addr = addrMatcher.group(2).trim();
                            probeEvent.setAddress(addr);
                        } else if (offsetMatcher.matches()) {
                            String offset = offsetMatcher.group(2).trim();
                            probeEvent.setOffset(offset);
                        } else if (symbolMatcher.matches()) {
                            String symbol = symbolMatcher.group(2).trim();
                            probeEvent.setSymbol(symbol);
                        } else if (LTTngControlServiceConstants.EVENT_PATTERN.matcher(probeLine).matches() || LTTngControlServiceConstants.WILDCARD_EVENT_PATTERN.matcher(probeLine).matches() || LTTngControlServiceConstants.CHANNEL_PATTERN.matcher(probeLine).matches() || LTTngControlServiceConstants.DOMAIN_KERNEL_PATTERN.matcher(probeLine).matches() || LTTngControlServiceConstants.DOMAIN_UST_GLOBAL_PATTERN.matcher(probeLine).matches()) break;
                        ++index;
                    }
                    events.add((IEventInfo)eventInfo);
                    continue;
                }
                events.add((IEventInfo)eventInfo);
                ++index;
                continue;
            }
            ++index;
        }
        return index;
    }

    protected String getAttributeValue(String line) {
        String[] temp = line.split("\\: ");
        return temp[1];
    }

    protected int getProviderEventInfo(List<String> output, int currentIndex, List<IBaseEventInfo> events) {
        int index = currentIndex;
        BaseEventInfo eventInfo = null;
        while (index < output.size()) {
            String line = output.get(index);
            Matcher matcher = LTTngControlServiceConstants.PROVIDER_EVENT_PATTERN.matcher(line);
            if (matcher.matches()) {
                eventInfo = new BaseEventInfo(matcher.group(1).trim());
                eventInfo.setLogLevel(matcher.group(2).trim());
                eventInfo.setEventType(matcher.group(3).trim());
                events.add((IBaseEventInfo)eventInfo);
                ++index;
                continue;
            }
            if (LTTngControlServiceConstants.EVENT_FIELD_PATTERN.matcher(line).matches()) {
                if (eventInfo != null) {
                    ArrayList<IFieldInfo> fields = new ArrayList<IFieldInfo>();
                    index = this.getFieldInfo(output, index, fields);
                    eventInfo.setFields(fields);
                    continue;
                }
                ++index;
                continue;
            }
            if (LTTngControlServiceConstants.UST_PROVIDER_PATTERN.matcher(line).matches()) {
                return index;
            }
            ++index;
        }
        return index;
    }

    protected int getFieldInfo(List<String> output, int currentIndex, List<IFieldInfo> fields) {
        int index = currentIndex;
        FieldInfo fieldInfo = null;
        while (index < output.size()) {
            String line = output.get(index);
            Matcher matcher = LTTngControlServiceConstants.EVENT_FIELD_PATTERN.matcher(line);
            if (matcher.matches()) {
                fieldInfo = new FieldInfo(matcher.group(2).trim());
                fieldInfo.setFieldType(matcher.group(3).trim());
                fields.add((IFieldInfo)fieldInfo);
            } else {
                if (LTTngControlServiceConstants.PROVIDER_EVENT_PATTERN.matcher(line).matches()) {
                    return index;
                }
                if (LTTngControlServiceConstants.UST_PROVIDER_PATTERN.matcher(line).matches()) {
                    return index;
                }
            }
            ++index;
        }
        return index;
    }

    @NonNull
    protected ICommandInput createCommand(String ... segments) {
        String verboseOption;
        ICommandInput command = this.fCommandShell.createCommand();
        command.add("lttng");
        List<String> groupOption = this.getTracingGroupOption();
        if (!groupOption.isEmpty()) {
            command.addAll(groupOption);
        }
        if (!(verboseOption = this.getVerboseOption()).isEmpty()) {
            command.add(verboseOption);
        }
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            command.add((String)NonNullUtils.checkNotNull((Object)string));
            ++n2;
        }
        return command;
    }

    @NonNull
    protected List<String> getTracingGroupOption() {
        ArrayList<String> groupOption = new ArrayList<String>();
        if (!ControlPreferences.getInstance().isDefaultTracingGroup() && !ControlPreferences.getInstance().getTracingGroup().equals("")) {
            groupOption.add("-g");
            groupOption.add(ControlPreferences.getInstance().getTracingGroup());
        }
        return groupOption;
    }

    protected String getVerboseOption() {
        if (ControlPreferences.getInstance().isLoggingEnabled()) {
            String level = ControlPreferences.getInstance().getVerboseLevel();
            if ("trace.control.verbose.level.v".equals(level)) {
                return "-v";
            }
            if ("trace.control.verbose.level.vv".equals(level)) {
                return "-vv";
            }
            if ("trace.control.verbose.level.vvv".equals(level)) {
                return "-vvv";
            }
        }
        return "";
    }

    protected ICommandResult executeCommand(@NonNull ICommandInput command, @Nullable IProgressMonitor monitor) throws ExecutionException {
        return this.executeCommand(command, monitor, true);
    }

    protected ICommandResult executeCommand(@NonNull ICommandInput command, @Nullable IProgressMonitor monitor, boolean checkForError) throws ExecutionException {
        if (ControlPreferences.getInstance().isLoggingEnabled()) {
            ControlCommandLogger.log(command.toString());
        }
        ICommandResult result = this.fCommandShell.executeCommand(command, monitor);
        if (ControlPreferences.getInstance().isLoggingEnabled()) {
            ControlCommandLogger.log(result.toString());
        }
        if (checkForError && this.isError(result)) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command.toString() + "\n" + result.toString());
        }
        return result;
    }
}

